const addressModel = require('../models/addressModel');

const city = async(req, res) =>{

    try{
        const cityDetails = await addressModel.city();
        var data = {
            "status": "1",
            "message":"city list",
            "data":cityDetails
            
            };
        res.status(200).json(data);
    }catch(error){
        console.error(error);
        res.status(500).json({ status: 0, message: 'city not found' });
    }

}

const society = async(req, res) =>{

    try{
        const appDetatils = req.body;   
        const societyDetails = await addressModel.society(appDetatils);
        var data = {
            "status": "1",
            "message":"Society list",
            "data":societyDetails
            
            };
        res.status(200).json(data);
    }catch(error){
        console.error(error);
        res.status(500).json({ status: 0, message: 'Society not found' });
    }

    
}

const add_address = async(req, res) =>{

    try{
        const appDetatils = req.body;   
        const addressDetails = await addressModel.addAddress(appDetatils);
        var data = {
            "status": "1",
            "message":"Address Saved",
          // "data": addressDetails
            
            };
        res.status(200).json(data);
    }catch(error){
        console.error(error);
        // res.status(500).json({ status: 0, message: 'something went wrong' });
        res.status(500).json({ status: 0, message: error.message  });
    }

}

const remove_address = async(req, res) =>{

    try{
        const appDetatils = req.body;   
        const addressDetails = await addressModel.removeAddress(appDetatils);
        var data = {
            "status": "1",
            "message":"Address Removed"
            
            };
        res.status(200).json(data);
    }catch(error){
        console.error(error);
        res.status(500).json({ status: 0, message: 'Try Again Later' });
    }

}

const show_address = async(req, res) =>{

    try{
        const appDetatils = req.body;   
        const addressDetails = await addressModel.showAddress(appDetatils);
        var data = {
            "status": "1",
            "message":"Address list",
            "data": addressDetails
            
            };
        res.status(200).json(data);
    }catch(error){
        console.error(error);
        res.status(500).json({ status: 0, message: 'something went wrong' });
    }

}

const edit_add = async(req, res) =>{

    try{
        const appDetatils = req.body;   
        const addressDetails = await addressModel.editAddress(appDetatils);
        var data = {
            "status": "1",
            "message":"Address Updated"
            
            };
        res.status(200).json(data);
    }catch(error){
        console.error(error);
        res.status(500).json({ status: 0, message: 'something went wrong' });
    }

}

module.exports = {
    add_address,
    show_address,
    remove_address,
    edit_add,
    city,
    society
  };