// controllers/userController.js
const userModel = require('../models/userModel');
const cityModel = require('../models/cityModel');
const sendsmsModel = require('../models/sendsmsModel');
const bcryptjs = require('bcryptjs');
const jwt = require('jsonwebtoken');
const multer = require('multer');
const path = require('path');
const axios = require('axios');
const fs = require('fs');



const send_otp = async(req,res) => {
  try{
    const appDetatils = req.body; 
    const userdetails = await userModel.sendOtp(appDetatils);

    if(userdetails){
    otpval = userdetails.otp_value;
    phoneNumber = userdetails.user_phone+userdetails.country_code;
    message="Your ultimate shopping experience begins in a few seconds! Your OTP to access your profile is "+otpval;
    response = await sendsmsModel.sendSMS(phoneNumber, message);
    }

    var userdata = {
      "status":1,
      "message":"User Details",
      "data":userdetails
      };
      res.status(200).json(userdata);
  }catch(error){
    if (error.message === 'Email address already registerd') {
      res.status(400).json({ message: 'Email address already registerd' });
    }else if(error.message === 'Mobile No already registerd'){
      res.status(400).json({ message: 'Mobile No already registerd' });
    }
    else {
      console.error(error);
      res.status(500).json({ message: 'User not found' });
    }
  }
  

};

const sendemail = async (req,res) => {
 
  try{
    const city = await userModel.getSendemail();
    res.status(200).json(city);
  } catch(error){
    res.status(500).json({ message: 'Internal Server Error' });
  }
};

const verify_otp_update = async(req,res) => {
  try{
    const appDetatils = req.body; 
    const userdetails = await userModel.verifyOtpupdate(appDetatils);

    if(userdetails == 1){
      msg = "Email updated successfully"
    }else{
      msg = "Mobile no updated successfully"
    }
    var userdata = {
      "status":1,
      "message":msg,
      //"data":userdetails
      };
      res.status(200).json(userdata);
  }catch(error){
    if (error.message === 'OTP is invalid') {
      res.status(400).json({ message: 'OTP is invalid' });
    }
    else {
      console.error(error);
      res.status(500).json({ message: 'User not found' });
    }
  }
  

}

const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, 'profile_image/');
    //cb(null, 'https://quickart.ae/adminDev/images/profile_image/');
  },
  filename: (req, file, cb) => {
    cb(null, Date.now() + path.extname(file.originalname));
  }
});

const upload = multer({ dest: 'profileimage/' }); // Temporary storage for uploaded files

const uploadImage = async (req, res) => {

    try {
        const file = req.file;
        const body = req.body; 
        if (!file) {
        res.status(500).json({ message: 'No file uploaded'});
        }

        const date = new Date().toISOString().slice(0, 10); // Format as YYYY-MM-DD
        const time = Date.now(); // Unique timestamp for filename
        const fileName = file.originalname; // Original file name

        // Construct file path
        const filePath = `images/profileimage/${date}/${time}_${fileName}`;
        const fileFullPath = `profileimage/${file.filename}`; // Path to the temporarily stored file

        // Upload the file to Bunny.net
        const url = `https://sg.storage.bunnycdn.com/quickart/${filePath}`;
        const response = await axios.put(url, fs.createReadStream(fileFullPath), {
            headers: {
                AccessKey:"d6822d0a-db42-4b2b-b926261b56b0-e522-4650",
                'Content-Type': 'application/octet-stream',
            },
        });


          // Initialize imageData with common fields
          const imageData = {
            user_id: body.user_id,
            user_name: body.user_name,
            country_code:body.country_code,
            user_phone:body.user_phone,
            device_id:body.device_id,
            path:filePath
          };
          const newImage = await userModel.createImage(imageData);
          res.status(201).json({ message: 'Data saved successfully'});

    } catch (error) {
        console.error('Error uploading file:', error);
        res.status(500).json({ message: 'An error occurred while uploading the file.'});
    }
};

const getCity = async (req,res) => {
 
    try{
      const city = await cityModel.getCity();
      res.status(200).json(city);
    } catch(error){
      res.status(500).json({ message: 'Internal Server Error' });
    }
};

const user_bank_details = async(req, res) =>{

  try{
      const appDetatils = req.body;   
      const bankDetails = await userModel.bankDetails(appDetatils);
      var data = {
          "status": "1",
          "message":"Account details fatch successfully",
          "data": bankDetails
          
          };
      res.status(200).json(data);
  }catch(error){
      console.error(error);
      res.status(500).json({ status: 0, message: 'Please add your card detail' });
  }

};

const login = async (req,res)=>{
  try{
    const userdata = await req.body;
      const user =  await userModel.findUser(userdata);
     const getuser = await userModel.getUsersforLogin(userdata);
     if(getuser.is_verified == 0){
      var userlist = {
        "message":"User not verified",
        "code":getuser.otp_value,
        "data":getuser,
        };
      res.status(400).json({ message: 'go to register details page' });
     }else{
      var userlist = {
        "message":"Verify OTP for Login",
        "code":getuser.otp_value,
        "data":getuser,
        };
      }
    //res.status(201).json({ message: 'User created successfully' });
   
    if(getuser.user_phone){
      otpval = getuser.otp_value;
      phoneNumber = getuser.country_code+getuser.user_phone;
      //phoneNumber = '971552474578';
     // return 333
      message="Your ultimate shopping experience begins in a few seconds! Your OTP to access your profile is "+otpval;
      response = await sendsmsModel.sendSMS(phoneNumber, message);
    }


    res.status(200).json(userlist);
  }catch(error){
    if (error.message === 'deactivate') {
      res.status(400).json({ message: 'Your account has been deleted with this phone number.Please enter new contact number' });
    }else if(error.message === 'Register'){
      res.status(400).json({ message: 'go to register details page' });
    }
    else {
      console.error(error);
    //   res.status(500).json({ message: 'Internal Server Error' });
    res.status(500).json({ status: 0, message: error.message  });
    }
  }
};

const resend_otp = async (req,res) => {
  try{
    const userdata = await req.body;
    const user =  await userModel.resendOtp(userdata);
    const getuser = await userModel.getUsersforLogin(userdata);
    var userlist = {
      "message":"OTP sent on register mobile number",
      "code":getuser.otp_value,
      };
      res.status(200).json(userlist);
  }catch(error){
   

    if (error.message === 'Otp Off') {
      res.status(400).json({ message: 'Otp Off' });
    } 
    if (error.message === 'User not found') {
      res.status(400).json({ message: 'User not found' });
    } else {
      
      res.status(500).json({ status: 0, message: error.message  });
    }


    
  }

};

const verify_otp = async (req,res) => {
  try{
    const userdata = await req.body;
    const user =  await userModel.verifyOtp(userdata);
    const getuser = await userModel.getUsersforLogin(userdata);
    const token = jwt.sign({
        email:getuser.email,
        userId:getuser.id

    },'secret',function(err,token){

        res.status(201).json({
            message: "Phone Verified! login successfully",
            data:getuser,
            otherdata:user,
            token:token
        });

    });

  } catch (error) {
    if (error.message === 'User not registered') {
      res.status(400).json({ message: 'User not registered' });
    }else if(error.message === 'Wrong OTP'){
      res.status(400).json({ message: 'Wrong OTP' });
    }
     else {
      //console.error(error);
      res.status(500).json({ message: 'Internal Server Error' });
    }
  }
};
const user_deactivate = async(req,res)=> {
  try{
    const userdata = await req.body;
    const user =  await userModel.userDeactivate(userdata);
    var userlist = {
      "message":"Account deleted successfully",
      };
      res.status(200).json(userlist);

  }catch(error){
 
      console.error(error);
      res.status(500).json({ message: 'Internal Server Error' });
    
  }
};

const register_details = async(req,res)=> {
    try{
      const userdata = await req.body;
      const user =  await userModel.register(userdata);
      const getuser = await userModel.getUsersforLogin(userdata);

      if(getuser.user_phone ){
        otpval = getuser.otp_value;
        phoneNumber = getuser.user_phone+getuser.country_code;
        message="Your ultimate shopping experience begins in a few seconds! Your OTP to access your profile is "+otpval;
        response = await sendsmsModel.sendSMS(phoneNumber, message);
      }
      
      var userlist = {
        "message":"Verify OTP",
        "data":getuser,
       // "data1":user
        };
        res.status(200).json(userlist);
    }catch(error){
      if (error.message === 'deactivate') {
        res.status(400).json({ message: 'Your account has been deleted with this phone number.Please enter new contact number' });
      }else if(error.message === 'Registered'){
        //res.status(400).json({ message: 'User Already Registered with this phone number' });
        res.status(500).json({ status: 0, message: error.message  });
      }
      else {
        //console.error(error);
        //res.status(500).json({ message: 'User Already Registered with this phone number' });
        res.status(500).json({ status: 0, message: error.message  });
      }
    }
};

const createUser = async (req, res) => {
    try {
      const user = req.body;
      await userModel.createUser(user);
      res.status(201).json({ message: 'User created successfully' });
    } catch (error) {
      if (error.message === 'Email already exists') {
        res.status(400).json({ message: 'Email already exists' });
      } else {
        console.error(error);
        res.status(500).json({ message: 'Internal Server Error' });
      }
    }
};
  
const getUsers = async (req, res) => {
  try {
    const users = await userModel.getUsers();
    res.status(200).json(users);
  } catch (error) {
    
    res.status(500).json({ message: 'Internal Server Error' });
  }
};

const updateUser = async (req, res) => {
  try {
    const { id } = req.params;
    const updatedUser = req.body;
    await userModel.updateUser(id, updatedUser);
    res.status(200).json({ message: 'User updated successfully' });
  } catch (error) {
   
    res.status(500).json({ message: 'Internal Server Error' });
  }
};

const deleteUser = async (req, res) => {
  try {
    const { id } = req.params;
    await userModel.deleteUser(id);
    res.status(200).json({ message: 'User deleted successfully' });
  } catch (error) {
   
    res.status(500).json({ message: 'Internal Server Error' });
  }
};

const myprofile = async(req,res) => {
  try{
    const appDetatils = req.body; 
    const userdetails = await userModel.myprofile(appDetatils);
    var userdata = {
      "status":1,
      "message":"User Details",
      "data":userdetails
      };
      res.status(200).json(userdata);
  }catch{
  
    res.status(500).json({ message: 'User not found' });
  }
};

const profile_edit = async(req,res) => {
  try{
    const appDetatils = req.body; 
    const userdetails = await userModel.editprofile(appDetatils);
    var userdata = {
      "status":1,
      "message":"Profile Updated",
      "data":userdetails
      };
      res.status(200).json(userdata);
  }catch{
  
    res.status(500).json({ message: 'User not found' });
  }
};

const faqslist = async(req,res) => {
  try{
    const appDetatils = req.body; 
    const faqslist = await userModel.getFaqsList(appDetatils);
    var userdata = {
      "status":1,
      "message":"FAQS List",
      "data":faqslist
      };
      res.status(200).json(userdata);
  }catch{
  
    res.status(500).json({ message: 'User not found' });
  }
};

const showprofile = async(req,res) => {
  try{
    const appDetatils = req.body; 
    const userlist = await userModel.getShowProfile(appDetatils);
    var userdata = {
      "status":1,
      "message":"User Details",
      "data":userlist
      };
      res.status(200).json(userdata);
  }catch{
  
    res.status(500).json({ message: 'User not found' });
  }
};

const verify_details = async(req,res)=> {
  try{
    const userdata = await req.body;
    const userDetails =  await userModel.verifyDetails(userdata);
    var userlist = {
      "message":"Transfer successfully",
      "data":userDetails
      };
      res.status(200).json(userlist);

  }catch(error){
 
      console.error(error);
      res.status(500).json({ message: 'Internal Server Error' });
    
  }
};

module.exports = {
  createUser,
  getUsers,
  updateUser,
  deleteUser,
  getCity,
  login,
  verify_otp,
  register_details,
  myprofile,
  resend_otp,
  profile_edit,
  user_deactivate,
  user_bank_details,
  upload,
  uploadImage,
  send_otp,
  sendemail,
  verify_otp_update,
  faqslist,
  showprofile,
  verify_details
};
