require('dotenv').config();

module.exports = {
    client: 'mysql',
    connection: {
      host: process.env.DB_HOST,
      port: process.env.DB_PORT,
      user: process.env.DB_USER,
      password: process.env.DB_PASSWORD,
      database: process.env.DB_DATABASE,
      connectionLimit: 10, // Adjust based on your needs
      charset: 'utf8mb4'  // Important for emoji support
    },
    migrations: {
      tableName: 'knex_migrations',
      directory: './migrations',
    },
    pool: {
      afterCreate: (conn, done) => {
        conn.query("SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode, 'ONLY_FULL_GROUP_BY', ''))", (err) => {
          if (err) {
            console.error('Error setting session SQL mode:', err);
          }
          done(err, conn);
        });
      },
    },
};
