const { application } = require('express');
const knex = require('../db'); // Import your Knex instance
const math = require('mathjs');  // If using a third-party math library
const { format } = require('date-fns');
const wordCount = require('word-count');
const moment = require('moment');
require('moment-timezone');
const uaeTime = moment.tz(new Date(), "Asia/Dubai");
const axios = require('axios');
const apiKey = 'AIzaSyADPEHze6hgRTG83JXfEJ6owhtNTmJJWwg'; // Replace with your Geolocation API key

const addtosubCart = async (appDetatils) => {
const {user_id,qty,store_id,varient_id,is_subscription,percentage,device_id,repeat_orders,time_slot,sub_totaldelivery,start_delivery_date}=appDetatils;

//Delete Quickart Items 
await knex('store_orders')
.where('varient_id',varient_id)
.where('order_cart_id', 'incart')
.where('store_approval', user_id)
.whereNull('subscription_flag')
.delete();

// Fetch product variant details
const productItems = await knex('product_varient')
.join('product','product.product_id','product_varient.product_id')
.where('varient_id', varient_id)
.where('product.availability','!=','quick')
.first();
if(productItems)
{
    if(user_id != "null" ){

    if(is_subscription == 1){
    let date_ob = new Date();
    const addsubscription = await knex('subscribe_product').insert({
    store_id: appDetatils.store_id,
    varient_id: appDetatils.varient_id,
    user_id: user_id,
    created_at:date_ob,
    updated_at:date_ob,
    percentage:0
    })
    }
    // Query the user information
    const user = await knex('users')
    .select('user_phone', 'wallet')
    .where('id', user_id)
    .first();

    // Check if the user is found
    if (!user) {
    return 'User not Found';
    }

    const product = await knex('store_products')
    .join('product_varient', 'store_products.varient_id', 'product_varient.varient_id')
    .join('product', 'product_varient.product_id', 'product.product_id')
    .where('store_products.varient_id', varient_id)
    .andWhere('store_products.store_id', store_id)
    .first(); // Retrieves the first matching record

    if (qty > product.max_ord_qty) {
    const p_name = `${product.product_name} (${product.quantity}${product.unit}) * ${qty}`;
    const message = `You have to order ${p_name} quantity between ${product.min_ord_qty} to ${product.max_ord_qty}.`;
    return message;
    }

    if (qty > product.stock) { // Check if the requested quantity exceeds the available stock
    const message = 'No more stock available.';
    return message;
    }

    // Check for current deal
    const now = new Date();
    const deal = await knex('deal_product')
    .where('varient_id', varient_id)
    .andWhere('store_id', store_id)
    .andWhere('valid_from', '<=', now.toISOString().split('T')[0])
    .andWhere('valid_to', '>', now.toISOString().split('T')[0])
    .first(); // Retrieves the first matching deal

    let price;
    if (deal) {
    price = parseFloat(deal.deal_price).toFixed(2);
    } else {
    price = parseFloat(product.price).toFixed(2);
    }

    let created_at= new Date();
    // Calculate repeat orders days
    let repeat_orders_days = repeat_orders ? wordCount(repeat_orders) : 1;
    const final_sub_totaldelivery = (sub_totaldelivery && sub_totaldelivery != 0) ? sub_totaldelivery : 1;
    // Calculate price5
    const price5 = product.mrp * qty * repeat_orders_days * final_sub_totaldelivery;
    // Calculate price2
    const price2= price*qty*repeat_orders_days*final_sub_totaldelivery;

    // Check if the order already exists in the cart
    const existingOrder = await knex('store_orders')
    .where('store_approval', user_id)
    .where('varient_id', varient_id)
    .where('order_cart_id', 'incart')
    .where('subscription_flag',1)
    .first();
    
        // Calculate discounts based on product, subcategory, or category
        const productVarient = await knex('product_varient').where('varient_id', varient_id).first();
        const product_id = productVarient.product_id;

        const productDetails = await knex('product').where('product_id', product_id).first();
        const cat_id = productDetails.cat_id;
        const percentages = productDetails.percentage;

        const subCategoryDetails = await knex('categories').where('cat_id', cat_id).first();
        const percentageSubCat = subCategoryDetails.discount_per;
        const parentCategoryId = subCategoryDetails.parent;

        const parentCategoryDetails = await knex('categories').where('cat_id', parentCategoryId).first();
        const percentageCat = parentCategoryDetails.discount_per;
        let percentageStore=0;

        let PriceNew;
        if (percentages > 0) {
        PriceNew = (price5 - (price5 * percentages) / 100).toFixed(2);
        percentageStore=percentages;
        } else if (percentageSubCat > 0) {
        PriceNew = (price5 - (price5 * percentageSubCat) / 100).toFixed(2);
        percentageStore=percentageSubCat;
        } else if (percentageCat > 0) {
        PriceNew = (price5 - (price5 * percentageCat) / 100).toFixed(2);
        percentageStore=percentageCat;
        } else {
        PriceNew = price2;
        }

        if(repeat_orders_days == 1)
        {
        repeat_orders_days=""; 
        }

        // Define order data
        const orderData = {
        store_id: store_id,
        varient_id: varient_id,
        qty: qty,
        product_name:product.product_name,
        varient_image:product.product_image,
        quantity: product.quantity,
        unit: product.unit,
        store_approval: user_id,
        total_mrp: parseFloat(price5),
        order_cart_id: 'incart',
        order_date: created_at,
        repeat_orders: repeat_orders,
        price: parseFloat(PriceNew),
        description: product.description,
        tx_per: 0,
        price_without_tax: 0,
        tx_price: 0,
        tx_name: 'vat',
        type: product.type,
        repeated_order_cart:'',
        subscription_flag:1,
        percentage:percentageStore,
        sub_time_slot:time_slot,
        sub_total_delivery:final_sub_totaldelivery,
        sub_delivery_date:start_delivery_date
        };
        
        if (!existingOrder) {
            // Insert new order if no existing order is found
            if(qty != 0){
            await knex('store_orders').insert(orderData);    
            }
          } else {
            // Delete existing order and insert new one
            await knex('store_orders')
              .where('store_approval', user_id)
              .where('varient_id', varient_id)
              .where('order_cart_id', 'incart')
              .where('subscription_flag',1)
              .delete();
            if(qty != 0){
            await knex('store_orders').insert(orderData);
            }
          }
            const sum = await knex('store_orders')
            .join('store_products', 'store_orders.varient_id','=','store_products.varient_id')
            .join('product_varient','store_products.varient_id','=','product_varient.varient_id')
            .join('product','product_varient.product_id','=','product.product_id')
            .where('store_products.store_id',store_id)
            .where('store_orders.store_approval',user_id)
            .where('store_orders.order_cart_id', 'incart')
            .where('subscription_flag',1)
            .select(knex.raw('SUM(store_orders.total_mrp) as Totalmrp'),knex.raw('SUM(store_orders.price) as Totalprice'),knex.raw('COUNT(store_orders.store_order_id) as count'))
            .first();
// Handle cases where the result might be null
const customizedProduct = {
  saving_price: (sum.Totalmrp || 0) - (sum.Totalprice || 0),
  total_price: sum.Totalprice || 0,
  total_items: sum.count || 0,
};
return customizedProduct;  

    }
    else
    {
    return 'User ID is invalid.';
    }
}else
{
return 'No more product available.';  
}
}

const showsubCart =  async(appDetatils) =>
{
const {user_id,device_id}=appDetatils;
    const cartItems = await knex('store_orders')
    .where('store_approval', user_id)
    .where('order_cart_id', 'incart')
    .where('subscription_flag',1); // Correctly checking for NULL values

    const sum = await knex('store_orders')
    // .join('store_products', 'store_orders.varient_id','=','store_products.varient_id')
    // .join('product_varient','store_products.varient_id','=','product_varient.varient_id')
    // .join('product','product_varient.product_id','=','product.product_id')
    .where('store_orders.store_approval',user_id)
    .where('store_orders.order_cart_id', 'incart')
    .where('store_orders.subscription_flag',1) // Corrected null condition
    .select(knex.raw('SUM(store_orders.total_mrp) as Totalmrp'),knex.raw('SUM(store_orders.price) as Totalprice'),knex.raw('COUNT(store_orders.store_order_id) as count'))
    .first();

    const baseurl =  process.env.BUNNY_NET_IMAGE;
    const cartItems1 = await knex('store_orders')
    .join('store_products', 'store_orders.varient_id','=','store_products.varient_id')
    .join('product_varient','store_products.varient_id','=','product_varient.varient_id')
    .join('product','product_varient.product_id','=','product.product_id')
    .select('product.percentage','store_orders.sub_time_slot','store_orders.sub_total_delivery','store_orders.sub_delivery_date','store_orders.repeated_order_cart','store_orders.product_name',knex.raw(`CONCAT('${baseurl}', store_orders.varient_image) as varient_image`),'store_orders.quantity','store_orders.unit','store_orders.total_mrp','store_products.price', 'store_products.mrp','store_orders.qty as cart_qty','store_orders.total_mrp','store_orders.order_cart_id','store_orders.order_date','store_orders.store_approval','store_orders.store_id','store_orders.varient_id','product.product_id', 'store_products.stock','store_orders.tx_per','store_orders.price_without_tax','store_orders.tx_price','store_orders.tx_name',knex.raw(`CONCAT('${baseurl}', product.product_image) as product_image`),knex.raw(`CONCAT('${baseurl}', product.thumbnail) as thumbnail`),'product.available_days','product_varient.description','product.type','store_orders.price as ord_price' ,'store_orders.sub_total_delivery','store_orders.repeat_orders as repeat_orders')
    .groupBy('store_orders.varient_id')
    .where('store_orders.store_approval',user_id)
    .where('store_orders.subscription_flag',1) // Corrected null condition
    .where('store_orders.order_cart_id', 'incart')
    .where('store_products.stock','>',0)
    .where('store_orders.qty','>',0);

    let walletamt = 0;
    // Check if user_id is valid and fetch wallet balance
    if (user_id !== "null") { 
    const walletBalance = await knex('users')
    .select('wallet')
    .where('id', user_id)
    .first();
    if (walletBalance) {
    walletamt = walletBalance.wallet;
    } else {
    walletamt = 0;
    }
    } else {
    walletamt = 0;
    }


    // Calculate total reserve amount from subscription orders
    const reserveAmounts = await knex('orders')
    .innerJoin('subscription_order', 'subscription_order.cart_id', '=', 'orders.cart_id')
    .select('orders.reserve_amount')
    .where('orders.is_subscription', 1)
    .where('orders.user_id', user_id)
    .groupBy('orders.order_id');

    let total_reserve_amt = 0;
    for (const amount of reserveAmounts) {
    total_reserve_amt += parseFloat(amount.reserve_amount);
    }
    // Calculate remaining wallet amount
    const total_wallet = walletamt - total_reserve_amt;

    // Fetch the English city names
    const cityNamesResult = await knex('city')
    .where('status', 1)
    .select(knex.raw('GROUP_CONCAT(city_name) as cityName'));
    const cityNameList = cityNamesResult[0].cityName.split(',');

    // Fetch the Arabic city names
    const cityNamesAResult = await knex('city')
    .where('status', 1)
    .select(knex.raw('GROUP_CONCAT(CONVERT(arabic_name USING utf8mb4)) as cityName'));
    const cityNameListA = cityNamesAResult[0].cityName.split(',');


if (cartItems.length > 0) {
    // Process or return cart items

    // Fetch the latest order for the user
    const orderlist = await knex('orders')
    .where('user_id', user_id)
    .orderBy('order_id', 'DESC')
    .select('address_id', 'si_sub_ref_no')
    .first();
    let lastAddress=[];
    let users_acc_details;
    if (orderlist) {
    // Check if the address from the latest order exists
    const lastAdd = await knex('address')
    .select('address_id', 'type', 'house_no', 'landmark', 'lat', 'lng')
    .where('address_id', orderlist.address_id)
    .where('select_status','!=',2)
    .first(); // .first() to retrieve a single address
    
    // Step 3: Check if the address's city name exists in the city lists and validate using Geocoding API
    let updatedAddresses=[];
    if(lastAdd){
    updatedAddresses = await Promise.all(
    [lastAdd].map(async (address) => {
    let cityExists =
    cityNameList.includes(address.city) || cityNameListA.includes(address.city);

    if (!cityExists) {
    const formattedAddress = await getFormattedAddress(address.lat, address.lng);
    if (formattedAddress) {
    // Dynamically check if the formatted address contains any city from the dynamic city lists
    cityExists = cityNameList.concat(cityNameListA).some(city =>
    formattedAddress.includes(city)
    );
    }
    }

    return {
    ...address,
    cityExists // true or false based on both checks
    };
    })
    );
    }
    lastAddress=updatedAddresses;
    const orderlistSI = await knex('orders')
    .where('user_id', user_id)
    .whereNotNull('si_sub_ref_no')
    .orderBy('order_id', 'DESC')
    .select('address_id', 'si_sub_ref_no')
    .first();
    if(orderlistSI){
    users_acc_details =  await knex('tbl_user_bank_details')
    .select('id','user_id','si_sub_ref_no','card_no')
    .where('user_id', user_id)
    .where('si_sub_ref_no',orderlistSI.si_sub_ref_no)
    .where('bank_type','totalpay')
    .where('is_delete','!=','1')
    .first();
    if(!users_acc_details)
      {
      users_acc_details =  await knex('tbl_user_bank_details')
      .select('id','user_id','si_sub_ref_no','card_no')
      .where('user_id', user_id)
      .where('bank_type','totalpay')
      .where('is_delete','!=','1')
      .first(); 
      }
    }else
    {
      users_acc_details =  await knex('tbl_user_bank_details')
      .select('id','user_id','si_sub_ref_no','card_no')
      .where('user_id', user_id)
      .where('bank_type','totalpay')
      .where('is_delete','!=','1')
      .first(); 
    }

     } else {
    lastAddress=[];
    users_acc_details =  await knex('tbl_user_bank_details')
    .select('id','user_id','si_sub_ref_no','card_no')
    .where('user_id', user_id)
    .where('bank_type','totalpay')
    .where('is_delete','!=','1')
    .first(); 
    }
    let totalSubscriptionPrice = 0;
    let finalPriceSubFinal = 0;

    for (const ProductList of cartItems1) {
    const { varient_id, store_id, cart_qty: qty } = ProductList;

    const currentDate = new Date();
    const deal = await knex('deal_product')
    .where('varient_id', varient_id)
    .where('store_id', store_id)
    .where('deal_product.valid_from', '<=', currentDate)
    .where('deal_product.valid_to', '>', currentDate)
    .first();

    const p = await knex('store_products')
    .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
    .join('product', 'product_varient.product_id', '=', 'product.product_id')
    .where('store_products.varient_id', varient_id)
    .where('store_products.store_id', store_id)
    .first();

    let price = deal ? deal.deal_price : p.price;
    let mrpprice = deal ? deal.mrp : p.mrp;
    let mrppriceTotal = mrpprice * qty;

    const repeatOrders = ProductList.repeat_orders;
    const subTotalDelivery = ProductList.sub_total_delivery || 1;
    const repeatOrdersDays = repeatOrders ? wordCount(repeatOrders) : 1;
    const priceWithTax = price * qty * repeatOrdersDays * subTotalDelivery;
    let finalPrice = priceWithTax;

    // Handle category, sub-category, and product-level discounts
    const productVarient = await knex('product_varient').where('varient_id', varient_id).first();
    const productDetails = await knex('product').where('product_id', productVarient.product_id).first();
    const cat_id = productDetails.cat_id;
    const percentage = productDetails.percentage;

    const categoriesSubDetails = await knex('categories').where('cat_id', cat_id).first();
    const percentageSubCat = categoriesSubDetails.discount_per;
    const parent = categoriesSubDetails.parent;

    const categoriesParentDetails = await knex('categories').where('cat_id', parent).first();
    const percentageCat = categoriesParentDetails.discount_per;

    let priceAfterDiscount;
    let appliedPercentage;

    if (percentage > 0) {
    priceAfterDiscount = ((mrppriceTotal - (mrppriceTotal * percentage) / 100) * repeatOrdersDays * subTotalDelivery).toFixed(2);
    appliedPercentage = percentage;
    } else if (percentageSubCat > 0) {
    priceAfterDiscount = ((mrppriceTotal - (mrppriceTotal * percentageSubCat) / 100) * repeatOrdersDays * subTotalDelivery).toFixed(2);
    appliedPercentage = percentageSubCat;
    } else if (percentageCat > 0) {
    priceAfterDiscount = ((mrppriceTotal - (mrppriceTotal * percentageCat) / 100) * repeatOrdersDays * subTotalDelivery).toFixed(2);
    appliedPercentage = percentageCat;
    } else {
    priceAfterDiscount = finalPrice.toFixed(2);
    appliedPercentage = 0;
    }

    // Update order price
    await knex('store_orders')
    .where('varient_id', varient_id)
    .where('store_approval', user_id)
    .where('store_orders.subscription_flag', 1)
    .where('order_cart_id', "incart")
    .update({ 'price': priceAfterDiscount });

    // Handle wishlist, notify me, and cart quantity
    let isFavourite = 'false';
    let notifyMe = 'false';
    let cartQty = 0;

    if (user_id !== "null") {
    const wishList = await knex('wishlist')
    .select('*')
    .where('varient_id', varient_id)
    .where('user_id', user_id);

    isFavourite = wishList.length > 0 ? 'true' : 'false';

    const CartQtyList = await knex('store_orders')
    .where('varient_id', varient_id)
    .where('store_approval', user_id)
    .where('order_cart_id', 'incart')
    .where('store_id', store_id)
    .first();

    cartQty = CartQtyList ? CartQtyList.qty : 0;

    const notifyMeList = await knex('product_notify_me')
    .where('varient_id', varient_id)
    .where('user_id', user_id);

    notifyMe = notifyMeList.length > 0 ? 'true' : 'false';
    }

    // Calculate discount percentage and savings
    const discountPercentage = ProductList.total_mrp
    ? 100 - ((ProductList.price * ProductList.cart_qty * 100) / ProductList.total_mrp)
    : 0;

    const savings = ProductList.mrp > ProductList.price
    ? ProductList.mrp - ProductList.price
    : 0;

    const sub_price = (ProductList.total_mrp * appliedPercentage) / 100;
    const finalSubPrice = (ProductList.total_mrp - sub_price).toFixed(2);
    const items = ProductList.repeat_orders.split(',').map(item => item.trim());
    const length = items.length;

    const finalSubPriceNew = ((finalSubPrice / ProductList.sub_total_delivery) / length);
    finalPriceSubFinal += (finalSubPriceNew * length) * ProductList.sub_total_delivery;

    ProductList.subscription_price = sub_price
    ? (finalSubPriceNew / qty).toFixed(2)
    : parseFloat(price).toFixed(2);

    totalSubscriptionPrice += parseFloat(ProductList.subscription_price);

    // Update the product list details
    ProductList.isSubscription = "True";
    ProductList.percentage = ProductList.percentage;
    ProductList.timeSlot = ProductList.sub_time_slot;
    ProductList.no_of_week = ProductList.sub_total_delivery;
    ProductList.delivery_date = ProductList.sub_delivery_date;
    ProductList.discountper = discountPercentage;
    ProductList.save_on = savings;
    }


    const freegiftlist = [];
    const mighthavemissed = [];
    const customizedProduct  = {
    lastadd:lastAddress || [],
    lastcarddetails: users_acc_details || {}, 
    wallet_balance:total_wallet,
    discountonmrp:"0.00",
    total_price:sum.Totalprice,
    total_mrp:sum.Totalmrp,
    saving_price:(sum.Totalmrp-sum.Totalprice).toFixed(2),
    total_items:sum.count,
    free_delivery:"0.00",
    total_tax:"0.00",
    avg_tax:"0.00", 
    delivery_charge:"0.00",
    subscription_fee:"0.00",
    vat:"0.00",
    data:cartItems1,
    free_gift_list: freegiftlist,
    might_have_missed : mighthavemissed
    }
    return customizedProduct;

}else
{
// Handle the case where no items are found
return 2;
}

}

const addtoCart = async (appDetatils) => {
const {user_id,qty,store_id,varient_id,device_id}=appDetatils;
const productItems = await knex('product_varient')
.where('varient_id', varient_id)
.first(); // Retrieves the first record

 if(productItems)
 {
  
    // Query the user information
    const user = await knex('users')
    .select('user_phone', 'wallet')
    .where('id', user_id)
    .first();

    // Check if the user is found
    if (!user) {
    return 'User not Found';
    }

    // Extract the user phone
    const userPhone = user.user_phone;

    const product = await knex('store_products')
    .join('product_varient', 'store_products.varient_id', 'product_varient.varient_id')
    .join('product', 'product_varient.product_id', 'product.product_id')
    .where('store_products.varient_id', varient_id)
    .andWhere('store_products.store_id', store_id)
    .first(); // Retrieves the first matching record

    if (qty > product.max_ord_qty) {
    const p_name = `${product.product_name} (${product.quantity}${product.unit}) * ${qty}`;
    const message = `You have to order ${p_name} quantity between ${product.min_ord_qty} to ${product.max_ord_qty}.`;
    return message;
    }

    if (qty > product.stock) { // Check if the requested quantity exceeds the available stock
    const message = 'No more stock available.';
    return message;
    }

    // Check for current deal
    const now = new Date();
    const deal = await knex('deal_product')
      .where('varient_id', varient_id)
      .andWhere('store_id', store_id)
      .andWhere('valid_from', '<=', now.toISOString().split('T')[0])
      .andWhere('valid_to', '>', now.toISOString().split('T')[0])
      .first(); // Retrieves the first matching deal

    let price;
    if (deal) {
      price = parseFloat(deal.deal_price);
    } else {
      price = parseFloat(product.price);
    }

    let price2= price*qty;
    let price5=product.mrp*qty;
    let created_at= new Date();
    
    // Check if the order already exists in the cart
    const existingOrder = await knex('store_orders')
    .where('store_approval', user_id)
    .andWhere('varient_id', varient_id)
    .andWhere('order_cart_id', 'incart')
    .whereNull('subscription_flag')
    .first();
    
    // Check if the product/subcategory/category discount percentage
        const  productVarient= await knex('product_varient')
        .where('varient_id',varient_id)
        .first();
        var product_id=productVarient.product_id;

        const  productDeatils= await knex('product')
        .where('product_id',product_id)
        .first();
        var cat_id=productDeatils.cat_id;
        var percentage=productDeatils.percentage;
        var availability=productDeatils.availability;
        const categoriesSubDeatils= await knex('categories')
        .where('cat_id',cat_id)
        .first();
        var percentageSubCat=categoriesSubDeatils.discount_per;
        var parent=categoriesSubDeatils.parent;

        const categoriesParentDeatils= await knex('categories')
        .where('cat_id',parent)
        .first();
        var PriceNew=price2; 
        /*
          if(availability == 'quick'){
          var percentageCat=categoriesParentDeatils.discount_per;
          if(percentage > 0)
          {
          PriceNew=((price5-((price5*percentage)/100))).toFixed(2);
          }
          else if(percentageSubCat > 0)
          {
          PriceNew=((price5-((price5*percentageSubCat)/100))).toFixed(2);
          }
          else if(percentageCat > 0)
          {
          PriceNew=((price5-((price5*percentageCat)/100))).toFixed(2);
          }else
          {
          PriceNew=price2;
          }
          }else
          {
          PriceNew=price2; 
          }
        */  

     // Define order data
     const orderData = {
        store_id: store_id,
        varient_id: varient_id,
        qty: qty,
        product_name:product.product_name,
        varient_image: product.product_image,
        quantity: product.quantity,
        unit: product.unit,
        store_approval: user_id,
        total_mrp: parseFloat(price5),
        order_cart_id: 'incart',
        order_date: created_at,
        repeat_orders: 1,
        price: parseFloat(PriceNew),
        description: product.description,
        tx_per: 0,
        price_without_tax: 0,
        tx_price: 0,
        tx_name: 'vat',
        type: product.type,
        repeated_order_cart:''
      };

      if (!existingOrder) {
        // Insert new order if no existing order is found
        if(qty != 0){
        await knex('store_orders').insert(orderData);    
        }
      } else {
        // Delete existing order and insert new one
        await knex('store_orders')
          .where('store_approval', user_id)
          .where('varient_id', varient_id)
          .where('order_cart_id', 'incart')
          .whereNull('subscription_flag')
          .delete();
        if(qty != 0){
        await knex('store_orders').insert(orderData);
        }
      }


        const sum = await knex('store_orders')
        .join('store_products', 'store_orders.varient_id','=','store_products.varient_id')
        .join('product_varient','store_products.varient_id','=','product_varient.varient_id')
        .join('product','product_varient.product_id','=','product.product_id')
        .where('store_products.store_id',store_id)
        .where('store_orders.store_approval',user_id)
        .where('store_orders.order_cart_id', 'incart')
        .whereNull('subscription_flag')
        .select(knex.raw('SUM(store_orders.total_mrp) as Totalmrp'),knex.raw('SUM(store_orders.price) as Totalprice'),knex.raw('COUNT(store_orders.store_order_id) as count'))
        .first();
// Handle cases where the result might be null
const customizedProduct = {
  saving_price: (sum.Totalmrp || 0) - (sum.Totalprice || 0),
  total_price: sum.Totalprice || 0,
  total_items: sum.count || 0,
};
return customizedProduct;  

        


 }else
 {
  return 'No more product available.';
 }

}

const showCart = async(appDetatils) =>{
const {user_id,device_id}=appDetatils;

    const cartItems = await knex('store_orders')
    .where('store_approval', user_id)
    .where('order_cart_id', 'incart')
    .whereNull('subscription_flag'); // Correctly checking for NULL values

    const sum = await knex('store_orders')
    // .join('store_products', 'store_orders.varient_id','=','store_products.varient_id')
    // .join('product_varient','store_products.varient_id','=','product_varient.varient_id')
    // .join('product','product_varient.product_id','=','product.product_id')
    .where('store_orders.store_approval',user_id)
    .where('store_orders.order_cart_id', 'incart')
    .whereNull('subscription_flag')
    .select(knex.raw('SUM(store_orders.total_mrp) as Totalmrp'),knex.raw('SUM(store_orders.price) as Totalprice'),knex.raw('COUNT(store_orders.store_order_id) as count'))
    .first();

    const baseurl =  process.env.BUNNY_NET_IMAGE;
    const cartItems1 = await knex('store_orders')
    .join('store_products', 'store_orders.varient_id','=','store_products.varient_id')
    .join('product_varient','store_products.varient_id','=','product_varient.varient_id')
    .join('product','product_varient.product_id','=','product.product_id')
    .select(
    'product.availability',
    'product.percentage',
    'store_orders.repeated_order_cart',
    'store_orders.product_name',
    knex.raw(`CONCAT('${baseurl}', store_orders.varient_image) as varient_image`),
    'store_orders.quantity',
    'store_orders.unit',
    'store_orders.total_mrp',
    // 'store_orders.price',
    knex.raw('ROUND((store_orders.price / store_orders.qty), 2) as price'),
    'store_products.mrp',
    'store_orders.qty as cart_qty',
    'store_orders.total_mrp',
    'store_orders.order_cart_id',
    'store_orders.order_date',
    'store_orders.store_approval',
    'store_orders.store_id',
    'store_orders.varient_id',
    'product.product_id', 
    'store_products.stock',
    'store_orders.tx_per',
    'store_orders.price_without_tax',
    'store_orders.tx_price',
    'store_orders.tx_name',knex.raw(`CONCAT('${baseurl}', product.product_image) as product_image`),knex.raw(`CONCAT('${baseurl}', product.thumbnail) as thumbnail`),'product.available_days','product_varient.description','product.type','store_orders.price as ord_price' ,'store_orders.repeat_orders as repeat_orders')
    .groupBy('store_orders.varient_id')
    .where('store_orders.store_approval',user_id)
    .whereNull('store_orders.subscription_flag') // Corrected null condition
    .where('store_orders.order_cart_id', 'incart')
    .where('store_products.stock','>',0)
    .where('store_orders.qty','>',0);

    let walletamt = 0;
    // Check if user_id is valid and fetch wallet balance
    if (user_id !== "null") { 
    const walletBalance = await knex('users')
    .select('wallet')
    .where('id', user_id)
    .first();
    if (walletBalance) {
    walletamt = walletBalance.wallet;
    } else {
    walletamt = 0;
    }
    } else {
    walletamt = 0;
    }

    // Calculate total reserve amount from subscription orders
    const reserveAmounts = await knex('orders')
    .innerJoin('subscription_order', 'subscription_order.cart_id', '=', 'orders.cart_id')
    .select('orders.reserve_amount')
    .where('orders.is_subscription', 1)
    .where('orders.user_id', user_id)
    .groupBy('orders.order_id');

    let total_reserve_amt = 0;
    for (const amount of reserveAmounts) {
    total_reserve_amt += parseFloat(amount.reserve_amount);
    }
    // Calculate remaining wallet amount
    const total_wallet = walletamt - total_reserve_amt;

    
    // Fetch the English city names
    const cityNamesResult = await knex('city')
    .where('status', 1)
    .select(knex.raw('GROUP_CONCAT(city_name) as cityName'));
    const cityNameList = cityNamesResult[0].cityName.split(',');

    // Fetch the Arabic city names
    const cityNamesAResult = await knex('city')
    .where('status', 1)
    .select(knex.raw('GROUP_CONCAT(CONVERT(arabic_name USING utf8mb4)) as cityName'));
    const cityNameListA = cityNamesAResult[0].cityName.split(',');
        
    if (cartItems.length > 0) {
    // Process or return cart items

    // Fetch the latest order for the user
    const orderlist = await knex('orders')
    .where('user_id', user_id)
    .orderBy('order_id', 'DESC')
    .select('address_id', 'si_sub_ref_no')
    .first();
    let lastAddress=[];
    let users_acc_details;
    if (orderlist) {
    // Check if the address from the latest order exists
    const lastAdd = await knex('address')
    .select('address_id', 'type', 'house_no', 'landmark', 'lat', 'lng')
    .where('address_id', orderlist.address_id)
    .where('select_status','!=',2)
    .first(); // .first() to retrieve a single address

    // Step 3: Check if the address's city name exists in the city lists and validate using Geocoding API
    let updatedAddresses=[];
    if(lastAdd){
    updatedAddresses = await Promise.all(
    [lastAdd].map(async (address) => {
    let cityExists =
    cityNameList.includes(address.city) || cityNameListA.includes(address.city);

    if (!cityExists) {
    const formattedAddress = await getFormattedAddress(address.lat, address.lng);
    if (formattedAddress) {
    // Dynamically check if the formatted address contains any city from the dynamic city lists
    cityExists = cityNameList.concat(cityNameListA).some(city =>
    formattedAddress.includes(city)
    );
    }
    }
    return {
    ...address,
    cityExists // true or false based on both checks
    };
    })
    );
   }

   
   
    lastAddress=updatedAddresses;

    const orderlistSI = await knex('orders')
    .where('user_id', user_id)
    .whereNotNull('si_sub_ref_no')
    .orderBy('order_id', 'DESC')
    .select('address_id', 'si_sub_ref_no')
    .first();
    if(orderlistSI){
    users_acc_details =  await knex('tbl_user_bank_details')
    .select('id','user_id','si_sub_ref_no','card_no')
    .where('user_id', user_id)
    .where('si_sub_ref_no',orderlistSI.si_sub_ref_no)
    .where('bank_type','totalpay')
    .where('is_delete','!=','1')
    .first();
    if(!users_acc_details)
      {
      users_acc_details =  await knex('tbl_user_bank_details')
      .select('id','user_id','si_sub_ref_no','card_no')
      .where('user_id', user_id)
      .where('bank_type','totalpay')
      .where('is_delete','!=','1')
      .first(); 
      }
    }else
    {
    users_acc_details =  await knex('tbl_user_bank_details')
    .select('id','user_id','si_sub_ref_no','card_no')
    .where('user_id', user_id)
    .where('bank_type','totalpay')
    .where('is_delete','!=','1')
    .first(); 
    }

     } else {
    lastAddress=[];
    users_acc_details =  await knex('tbl_user_bank_details')
    .select('id','user_id','si_sub_ref_no','card_no')
    .where('user_id', user_id)
    .where('bank_type','totalpay')
    .where('is_delete','!=','1')
    .first(); 
    }

    //Time slot 
    const dates = [];
    const currentDate = moment().tz('Asia/Dubai');
    const currentTime = new Date();
    
    // Generate the next 5 days' dates in Dubai time
    for (let i = 0; i <= 4; i++) {
        dates.push(currentDate.clone().add(i, 'days').format('YYYY-MM-DD'));
    }

    const dateList = dates;
    const today = currentDate.format('YYYY-MM-DD');
    const customizedProductData1 = [];

    // Get current time in HH:mm format
    const hours = String(currentTime.getHours()).padStart(2, '0');
    const minutes = String(currentTime.getMinutes()).padStart(2, '0');
    const currentTimeStr = `${hours}:${minutes}`;
    // Get the current date and time in Dubai time zone (UTC+4)
    const currentDateTime = moment().tz("Asia/Dubai");
    // Extract hours and minutes for current time in Dubai
    const currentTimes = currentDateTime.format("HH:mm");


    // Determine tomorrow's date
    const tomorrow = new Date();
    tomorrow.setDate(tomorrow.getDate() + 1);
    const formattedTomorrow = tomorrow.toISOString().slice(0, 10);

    for (let m = 0; m < dateList.length; m++) {
    const selectedDate = dateList[m];
    let timeslots = [];

    if (today === selectedDate) {
    // Handle today's slots based on current time
    if (currentTimes < "12:00") {
    timeslots = await knex('tbl_time_slots')
    .where('status', 0)
    .where('id', 2) // Modify as per your requirement
    .select('time_slots')
    .orderBy('seq', 'ASC');
    }
    } 

  // Handle tomorrow's slots (only fetch time slots with IDs 2 and 3)
  else if (formattedTomorrow === selectedDate  && currentTimes >= "18:00") {
    
  timeslots = await knex('tbl_time_slots')
  .where('status', 0)
  .whereIn('id', [2, 3]) // Fetch only time slots 2 and 3
  .select('time_slots')
  .orderBy('seq', 'ASC');
  }else{
    // Handle future dates
    timeslots = await knex('tbl_time_slots')
    .where('status', 0)
    .select('time_slots')
    .orderBy('seq', 'ASC');
    }

    // Add date and timeslots to the result if there are timeslots
    if (timeslots.length > 0) {
    customizedProductData1.push({
    date: selectedDate,
    timeslots: timeslots
    });
    }
    }


    for (const ProductList of cartItems1) {
      const { varient_id} = ProductList;
  
      // Handle wishlist, notify me, and cart quantity
      let isSubscriptions = 'false';

      if (user_id !== "null") {
      const StoresDetails = await knex('store_orders')
      .where('varient_id', varient_id)
      .where('store_approval', user_id)
      .where('order_cart_id', 'incart')
      .where('store_orders.subscription_flag',1)
      .first();
  
      isSubscriptions = StoresDetails ? 'true' : 'false';
      }
  
      // Update the product list details
      ProductList.isSubscription = isSubscriptions;
      }
    



    // Remove empty objects and limit to 4 results
    const filteredTimeSlots = customizedProductData1.slice(0, 4);


    const freegiftlist = [];
    const mighthavemissed = [];
    const customizedProduct  = {
    timeslotsdata: filteredTimeSlots,
    lastadd:lastAddress || [],
    lastcarddetails: users_acc_details || {},
    wallet_balance:total_wallet,
    discountonmrp:0.00,
    total_price:sum.Totalprice,
    total_mrp:sum.Totalmrp,
    saving_price:(sum.Totalmrp-sum.Totalprice).toFixed(2),
    total_items:sum.count,
    free_delivery:"0.00",
    total_tax:"0.00",
    avg_tax:"0.00", 
    delivery_charge:"0.00",
    subscription_fee:"0.00",
    vat:"0.00",
    data:cartItems1,
    free_gift_list: freegiftlist,
    might_have_missed : mighthavemissed
    }
    return customizedProduct;

    } else {
    // Handle the case where no items are found
    return 2;
    }
};

// Function to fetch address details using Google Maps API
const getFormattedAddress = async (lat, lng) => {
const url = `https://maps.googleapis.com/maps/api/geocode/json?latlng=${lat},${lng}&key=${apiKey}`;
try {
const response = await axios.get(url);
const data = response.data;
if (data.results.length > 0) {
return data.results[0].formatted_address;
}
return null;
} catch (error) {
console.error('Error fetching the geolocation:', error);
return null;
}
};

const showspcatCart = async(appDetatils) =>{
  const {user_id,device_id,selected_date,selected_time}=appDetatils;  

      const currentDate = new Date().toISOString().split('T')[0]; // Get the current date in YYYY-MM-DD format
      const updateData = await knex('store_orders')
      .whereNull('subscription_flag')
      .where('store_approval', user_id)
      .andWhere('order_cart_id', 'incart')
      .andWhere('sub_delivery_date', '<', currentDate)
      .update({
      sub_delivery_date: null,
      sub_time_slot: null,
      });
      
      const cartItemsList = await knex('store_orders')
      .where('store_approval', user_id)
      .where('order_cart_id', 'incart')
      .whereNotNull('sub_delivery_date')
      .whereNull('subscription_flag'); // Correctly checking for NULL values

      for (const cartItm of cartItemsList) {       

      // Get today's date and current time in Dubai timezone
      const dubaiTime = moment.tz("Asia/Dubai");
      const todayDubai = dubaiTime.format("YYYY-MM-DD");
      const isAfter6PM = dubaiTime.hour() > 17;
      const isAfter12PM = dubaiTime.hour() > 11;
      const delivery_date=cartItm.sub_delivery_date;
      const time_slot=cartItm.sub_time_slot;

      // Condition 1: Check if any order has a sub_delivery_date of today
      if (delivery_date === todayDubai && isAfter12PM) {
      const updateData = await knex('store_orders')
      .whereNull('subscription_flag')
      .where('store_approval', user_id)
      .andWhere('order_cart_id', 'incart')
      .update({
      sub_delivery_date: null,
      sub_time_slot: null,
      });
      }

      // Condition 2: If it's after 6 PM in Dubai, prevent placing orders for tomorrow with "06:00 am - 10:00 am" time slot
      if (isAfter6PM) {
      const tomorrowDubai = dubaiTime.add(1, 'day').format("YYYY-MM-DD"); // Get tomorrow's date in Dubai time
      if (delivery_date == tomorrowDubai && time_slot == "06:00 am - 10:00 am") {
      const updateData = await knex('store_orders')
      .whereNull('subscription_flag')
      .where('store_approval', user_id)
      .andWhere('order_cart_id', 'incart')
      .update({
      sub_delivery_date: null,
      sub_time_slot: null,
      });
      }
      }

      // Condition 3: Check if any order has a sub_delivery_date of today
      if (delivery_date === todayDubai && (time_slot == "06:00 am - 10:00 am" || time_slot == "02:00 pm - 05:00 pm")) {
        const updateData = await knex('store_orders')
        .whereNull('subscription_flag')
        .where('store_approval', user_id)
        .andWhere('order_cart_id', 'incart')
        .update({
        sub_delivery_date: null,
        sub_time_slot: null,
        });
      }

    }



      const cartItems = await knex('store_orders')
      .where('store_approval', user_id)
      .where('order_cart_id', 'incart')
      .whereNull('subscription_flag'); // Correctly checking for NULL values

      
      const sum = await knex('store_orders')
      .where('store_orders.store_approval',user_id)
      .where('store_orders.order_cart_id', 'incart')
      .whereNull('subscription_flag')
      .select('store_orders.sub_time_slot','store_orders.sub_delivery_date',knex.raw('SUM(store_orders.total_mrp) as Totalmrp'),knex.raw('SUM(store_orders.price) as Totalprice'),knex.raw('COUNT(store_orders.store_order_id) as count'))
      .first();

      if(selected_date == "null"){
         selected_datevaltemp = sum.sub_delivery_date;
         selected_timevaltemp = sum.sub_time_slot;
      }else{
        selected_datevaltemp = selected_date;
        selected_timevaltemp = selected_time;

      }
      
      
      const baseurl =  process.env.BUNNY_NET_IMAGE;
      const cartItems1 = await knex('store_orders')
      .join('store_products', 'store_orders.varient_id','=','store_products.varient_id')
      .join('product_varient','store_products.varient_id','=','product_varient.varient_id')
      .join('product','product_varient.product_id','=','product.product_id')
      .join('categories','categories.cat_id','=','product.cat_id')
      .select(
      'categories.cat_type',
      'product.availability',
      'product.percentage',
      'store_orders.repeated_order_cart',
      'store_orders.product_name',
      knex.raw(`CONCAT('${baseurl}', store_orders.varient_image) as varient_image`),
      'store_orders.quantity',
      'store_orders.unit',
      'store_orders.total_mrp',
      // 'store_orders.price',
      knex.raw('ROUND((store_orders.price / store_orders.qty), 2) as price'),
      'store_products.mrp',
      'store_orders.qty as cart_qty',
      'store_orders.total_mrp',
      'store_orders.order_cart_id',
      'store_orders.order_date',
      'store_orders.store_approval',
      'store_orders.store_id',
      'store_orders.varient_id',
      'product.product_id', 
      'product.cat_id',
      'store_products.stock',
      'store_orders.tx_per',
      'store_orders.price_without_tax',
      'store_orders.tx_price',
      'store_orders.store_order_id',
      'store_orders.tx_name',knex.raw(`CONCAT('${baseurl}', product.product_image) as product_image`),knex.raw(`CONCAT('${baseurl}', product.thumbnail) as thumbnail`),'product.available_days','product_varient.description','product.type','store_orders.price as ord_price' ,'store_orders.repeat_orders as repeat_orders')
      .groupBy('store_orders.varient_id')
      .where('store_orders.store_approval',user_id)
      .whereNull('store_orders.subscription_flag') // Corrected null condition
      .where('store_orders.order_cart_id', 'incart')
      // .where('store_products.stock','>',0)
      .where('store_orders.qty','>',0);
  
      let walletamt = 0;
      // Check if user_id is valid and fetch wallet balance
      if (user_id !== "null") { 
      const walletBalance = await knex('users')
      .select('wallet')
      .where('id', user_id)
      .first();
      if (walletBalance) {
      walletamt = walletBalance.wallet;
      } else {
      walletamt = 0;
      }
      } else {
      walletamt = 0;
      }
  
      // Calculate total reserve amount from subscription orders
      const reserveAmounts = await knex('orders')
      .innerJoin('subscription_order', 'subscription_order.cart_id', '=', 'orders.cart_id')
      .select('orders.reserve_amount')
      .where('orders.is_subscription', 1)
      .where('orders.user_id', user_id)
      .groupBy('orders.order_id');
  
      let total_reserve_amt = 0;
      for (const amount of reserveAmounts) {
      total_reserve_amt += parseFloat(amount.reserve_amount);
      }
      // Calculate remaining wallet amount
      const total_wallet = walletamt - total_reserve_amt;
  
      
      // Fetch the English city names
      const cityNamesResult = await knex('city')
      .where('status', 1)
      .select(knex.raw('GROUP_CONCAT(city_name) as cityName'));
      const cityNameList = cityNamesResult[0].cityName.split(',');
  
      // Fetch the Arabic city names
      const cityNamesAResult = await knex('city')
      .where('status', 1)
      .select(knex.raw('GROUP_CONCAT(CONVERT(arabic_name USING utf8mb4)) as cityName'));
      const cityNameListA = cityNamesAResult[0].cityName.split(',');
          
      if (cartItems.length > 0) {
      // Process or return cart items
  
      // Fetch the latest order for the user
      const orderlist = await knex('orders')
      .where('user_id', user_id)
      .orderBy('order_id', 'DESC')
      .select('address_id', 'si_sub_ref_no')
      .first();
      let lastAddress=[];
      let users_acc_details;
      if (orderlist) {
      // Check if the address from the latest order exists
      const lastAdd = await knex('address')
      .select('address_id', 'type', 'house_no', 'landmark', 'lat', 'lng')
      .where('address_id', orderlist.address_id)
      .where('select_status','!=',2)
      .first(); // .first() to retrieve a single address
  
      // Step 3: Check if the address's city name exists in the city lists and validate using Geocoding API
      let updatedAddresses=[];
      if(lastAdd){
      updatedAddresses = await Promise.all(
      [lastAdd].map(async (address) => {
      let cityExists =
      cityNameList.includes(address.city) || cityNameListA.includes(address.city);
  
      if (!cityExists) {
      const formattedAddress = await getFormattedAddress(address.lat, address.lng);
      if (formattedAddress) {
      // Dynamically check if the formatted address contains any city from the dynamic city lists
      cityExists = cityNameList.concat(cityNameListA).some(city =>
      formattedAddress.includes(city)
      );
      }
      }
      return {
      ...address,
      cityExists // true or false based on both checks
      };
      })
      );
     }
  
      lastAddress=updatedAddresses;
  
      const orderlistSI = await knex('orders')
      .where('user_id', user_id)
      .whereNotNull('si_sub_ref_no')
      .orderBy('order_id', 'DESC')
      .select('address_id', 'si_sub_ref_no')
      .first();
      if(orderlistSI){
      users_acc_details =  await knex('tbl_user_bank_details')
      .select('id','user_id','si_sub_ref_no','card_no')
      .where('user_id', user_id)
      .where('si_sub_ref_no',orderlistSI.si_sub_ref_no)
      .where('bank_type','totalpay')
      .where('is_delete','!=','1')
      .first();
      if(!users_acc_details)
      {
      users_acc_details =  await knex('tbl_user_bank_details')
      .select('id','user_id','si_sub_ref_no','card_no')
      .where('user_id', user_id)
      .where('bank_type','totalpay')
      .where('is_delete','!=','1')
      .first(); 
      }
      }else
      {
      users_acc_details =  await knex('tbl_user_bank_details')
      .select('id','user_id','si_sub_ref_no','card_no')
      .where('user_id', user_id)
      .where('bank_type','totalpay')
      .where('is_delete','!=','1')
      .first(); 
      }

  
       } else {
      lastAddress=[];
      users_acc_details =  await knex('tbl_user_bank_details')
      .select('id','user_id','si_sub_ref_no','card_no')
      .where('user_id', user_id)
      .where('bank_type','totalpay')
      .where('is_delete','!=','1')
      .first(); 
      }
  
      //Time slot 
      const dates = [];
      const currentDate = moment().tz('Asia/Dubai');
      const currentTime = new Date();
      
      // Generate the next 5 days' dates in Dubai time
      for (let i = 0; i <= 4; i++) {
          dates.push(currentDate.clone().add(i, 'days').format('YYYY-MM-DD'));
      }
  
      const dateList = dates;
      const today = currentDate.format('YYYY-MM-DD');
      const customizedProductData1 = [];
      const customizedProductData2 = [];
  
      // Get current time in HH:mm format
      const hours = String(currentTime.getHours()).padStart(2, '0');
      const minutes = String(currentTime.getMinutes()).padStart(2, '0');
      const currentTimeStr = `${hours}:${minutes}`;
      // Get the current date and time in Dubai time zone (UTC+4)
      const currentDateTime = moment().tz("Asia/Dubai");
      // Extract hours and minutes for current time in Dubai
      const currentTimes = currentDateTime.format("HH:mm");
  
  
      // Determine tomorrow's date
      const tomorrow = new Date();
      tomorrow.setDate(tomorrow.getDate() + 1);
      const formattedTomorrow = tomorrow.toISOString().slice(0, 10);
  
      for (let m = 0; m < dateList.length; m++) {
      const selectedDate = dateList[m];
      let timeslots = [];
  
      if (today === selectedDate) {
      // Handle today's slots based on current time
      if (currentTimes < "12:00") {
      timeslots = await knex('tbl_time_slots')
      .where('status', 0)
      .where('id', 2) // Modify as per your requirement
      .select('time_slots')
      .orderBy('seq', 'ASC');
      }
      } 
  
    // Handle tomorrow's slots (only fetch time slots with IDs 2 and 3)
    else if (formattedTomorrow === selectedDate  && currentTimes >= "18:00") {
      
    timeslots = await knex('tbl_time_slots')
    .where('status', 0)
    .whereIn('id', [2, 3]) // Fetch only time slots 2 and 3
    .select('time_slots')
    .orderBy('seq', 'ASC');
    }else{
      // Handle future dates
      timeslots = await knex('tbl_time_slots')
      .where('status', 0)
      .select('time_slots')
      .orderBy('seq', 'ASC');
      }
  
      // Add date and timeslots to the result if there are timeslots
      if (timeslots.length > 0) {
      customizedProductData1.push({
      date: selectedDate,
      timeslots: timeslots
      });
      }
      }
  
       // Remove empty objects and limit to 4 results
       const filteredTimeSlots = customizedProductData1.slice(0, 4);

      for (const ProductList of cartItems1) {
        const { varient_id} = ProductList;
    
        // Handle wishlist, notify me, and cart quantity
        let isSubscriptions = 'false';
  
        if (user_id !== "null") {
        const StoresDetails = await knex('store_orders')
        .where('varient_id', varient_id)
        .where('store_approval', user_id)
        .where('order_cart_id', 'incart')
        .where('store_orders.subscription_flag',1)
        .first();
    
        isSubscriptions = StoresDetails ? 'true' : 'false';
        }
    
        // Update the product list details
        ProductList.isSubscription = isSubscriptions;
        }
      
   // Group by cat_type instead of cat_id
   const groupedByCatType = await cartItems1.reduce(async (accPromise, item) => {
    const acc = await accPromise;

    const catDetails = await knex('categories')
        .where('cat_id', item.cat_id)
        .select('parent')
        .first();

    // Fetch the category details to determine `cat_type`
    const categoryDetails = await knex('categories')
        .where('cat_id', catDetails.parent)
        .select('cat_type', 'title', 'cat_id')
        .first();

    const catType = categoryDetails?.cat_type || 'default';
    const catIdVal = categoryDetails?.cat_id || '';
    const catNameVal = categoryDetails?.title || '';

    if (!acc[catType]) {
        acc[catType] = [];
    }

    acc[catType].push({
        item,
        catIdVal,
        catNameVal,
    });
    return acc;
}, Promise.resolve({}));


// Count all categories except 'special' before Promise.all
let nonSpecialCategoryCount = 0;
Object.keys(groupedByCatType).forEach((catType) => {
    if (catType !== 'special') {
        nonSpecialCategoryCount += groupedByCatType[catType].length;
    }
});

// Assign timeslots to each category type
const specialcatdata = await Promise.all(
    Object.keys(groupedByCatType).map(async (catType) => {
        const productsWithCatId = groupedByCatType[catType];
        
        if (catType === 'special') {
          
         

            // Group products by `cat_id` for the special category
            const groupedByCatId = productsWithCatId.reduce((acc, { item, catIdVal, catNameVal }) => {
                if (!acc[catIdVal]) {
                    acc[catIdVal] = {
                        cat_id: catIdVal,
                        cat_name: catNameVal,
                        products: [],
                    };
                }
                acc[catIdVal].products.push(item);
                return acc;
            }, {});

            // Process timeslots for each unique `cat_id`
            const result = await Promise.all(
                Object.values(groupedByCatId).map(async ({ cat_id, cat_name, products }) => {

                
                    const parentTimeslots = await knex('categories')
                        .where('cat_id', cat_id)
                        .select('timeslots')
                        .first();

                        const catarray1 = await knex('categories') 
                        .where('parent', cat_id)
                        .pluck('cat_id'); 
                
                // Update the timeslots for all products with the specified cat_id
                            const vararray1 = await knex('product')
                                            .join('product_varient', 'product.product_id', '=', 'product_varient.product_id')
                                            .whereIn('product.cat_id', catarray1)
                                            .pluck('product_varient.varient_id');
                          
                              
            
                            const  storeorderlist1 = await knex('store_orders') 
                              .where('store_approval',user_id)
                              .whereIn('varient_id', vararray1)
                              .where('order_cart_id', 'incart')
                              .whereNull('store_orders.subscription_flag') // Corrected null condition
                              .whereNotNull('sub_time_slot')
                              .select('sub_delivery_date','sub_time_slot')
                              .first()
            
                          let  spselected_dateval = null;
                          let  spselected_timeval = null;
                           if (storeorderlist1) {
                                spselected_dateval = storeorderlist1.sub_delivery_date;
                                spselected_timeval = storeorderlist1.sub_time_slot;
                          }else{
                            spselected_dateval = null;
                            spselected_timeval = null;
                          }
                    let timeslots = [];
                    if(nonSpecialCategoryCount != 0){
                   
                    if (parentTimeslots && parentTimeslots.timeslots) {
                        const timeslotIds = JSON.parse(parentTimeslots.timeslots);

                        const customizedProductData2 = [];
                        for (const selectedDate1 of dates) {
                            let currentTimeslots = [];
                            //if (today === selectedDate1 && currentTimes < "12:00") {
                              if (today === selectedDate1) {
                                // Handle today's slots based on current time
                                if (currentTimes < "12:00") {
                                const commonElements = [2].filter(value =>
                                    timeslotIds.map(Number).includes(value)
                                );
                                currentTimeslots = await knex('tbl_time_slots')
                                    .where('status', 0)
                                    .whereIn('id', commonElements)
                                    .select('time_slots')
                                    .orderBy('seq', 'ASC');
                              }
                            } else if (formattedTomorrow === selectedDate1 && currentTimes >= "18:00") {
                                const commonElements = [2, 3].filter(value =>
                                    timeslotIds.map(Number).includes(value)
                                );
                                currentTimeslots = await knex('tbl_time_slots')
                                    .where('status', 0)
                                    .whereIn('id', commonElements)
                                    .select('time_slots')
                                    .orderBy('seq', 'ASC');
                            } else {
                                currentTimeslots = await knex('tbl_time_slots')
                                    .where('status', 0)
                                    .whereIn('id', timeslotIds)
                                    .select('time_slots')
                                    .orderBy('seq', 'ASC');
                            }
                            if (currentTimeslots.length > 0) {
                              if(selected_datevaltemp != null){
                                   if(selected_datevaltemp == selectedDate1){
                                      customizedProductData2.push({
                                        selected_date:spselected_dateval,
                                          date: selectedDate1,
                                          timeslots: currentTimeslots,
                                      });
                                    }
                                }else
                                if(selected_datevaltemp == null){
                                  customizedProductData2.push({
                                    date: selectedDate1,
                                    timeslots: currentTimeslots,
                                  });
                                }
                            }
                        }

                        timeslots = customizedProductData2.slice(0, 4);
                    }
                    }else
                    {
                      const timeslotIds = JSON.parse(parentTimeslots.timeslots);
                      const customizedProductData3 = [];
                      for (let m = 0; m < dateList.length; m++) {
                        const selectedDate = dateList[m];                    
                        if (today === selectedDate) {
                        // Handle today's slots based on current time
                        if (currentTimes < "12:00") {
                        const commonElements = [2].filter(value =>
                        timeslotIds.map(Number).includes(value)
                        );
                        currentTimeslots = await knex('tbl_time_slots')
                        .where('status', 0)
                        .whereIn('id', commonElements)
                        .select('time_slots')
                        .orderBy('seq', 'ASC');
                        // Add date and timeslots to the result if there are timeslots
                        if (currentTimeslots.length > 0) {
                          customizedProductData3.push({
                          date: selectedDate,
                          timeslots: currentTimeslots
                          });
                          }
                        }
                        } 
                      // Handle tomorrow's slots (only fetch time slots with IDs 2 and 3)
                      else if (formattedTomorrow === selectedDate  && currentTimes >= "18:00") {
                      const commonElements = [2, 3].filter(value =>
                      timeslotIds.map(Number).includes(value)
                      );
                      currentTimeslots = await knex('tbl_time_slots')
                      .where('status', 0)
                      .whereIn('id', commonElements)
                      .select('time_slots')
                      .orderBy('seq', 'ASC');
                      // Add date and timeslots to the result if there are timeslots
                      if (currentTimeslots.length > 0) {
                        customizedProductData3.push({
                        date: selectedDate,
                        timeslots: currentTimeslots
                        });
                        }

                      }else{
                        // Handle future dates
                        currentTimeslots = await knex('tbl_time_slots')
                        .where('status', 0)
                        .whereIn('id', timeslotIds)
                        .select('time_slots')
                        .orderBy('seq', 'ASC');

                        // Add date and timeslots to the result if there are timeslots
                        if (currentTimeslots.length > 0) {
                          customizedProductData3.push({
                          date: selectedDate,
                          timeslots: currentTimeslots
                          });
                          }

                        }
                    
                        
                        }
                        timeslots = customizedProductData3.slice(0, 4);
                    }

                    return {
                        cat_id,
                        cat_name,
                        cat_type: catType,
                        selectedDate:(spselected_dateval && spselected_timeval)?spselected_dateval:null,
                        selectedTime:(spselected_dateval && spselected_timeval)?spselected_timeval:null,
                        // selectedDate:selected_dateval,
                        // selectedTime:spselected_timeval,
                        timeslotsdata: timeslots,
                        products,
                    };
                })
            );

            return result; // Add all objects for this `special` category
        } else {
            // Default handling for other categories


            const categories  = await knex('categories')  
            .where('cat_type', 'like', '%special%')
            .pluck('cat_id');

            const subcategories  = await knex('categories')  
            .whereIn('parent', categories)
            .pluck('cat_id');

            const vararray = await knex('product')
            .join('product_varient', 'product.product_id', '=', 'product_varient.product_id')
            .whereIn('product.cat_id', subcategories)
            .pluck('product_varient.varient_id');

            const  storeorderlist = await knex('store_orders') 
            .where('store_approval',user_id)
            .whereNotIn('varient_id', vararray)
            .where('order_cart_id', 'incart')
            .whereNull('store_orders.subscription_flag') // Corrected null condition
            .select('sub_delivery_date','sub_time_slot')
            .first()


            if(selected_date == "null"){
              selected_dateval = storeorderlist.sub_delivery_date;
              selected_timeval = storeorderlist.sub_time_slot;
           }else{
             selected_dateval = selected_date;
             selected_timeval = selected_time;
   
           }
            return {
                cat_id:0,
                cat_name:"Other Category",
                cat_type: catType,
                selectedDate:(selected_dateval && selected_timeval)?selected_dateval:null,
                selectedTime:(selected_dateval && selected_timeval)?selected_timeval:null,
                timeslotsdata:filteredTimeSlots,
                products: productsWithCatId.map(({ item }) => item),
            };
        }
    })
);

// Flatten the result array for `special` categories
const finalData = specialcatdata.flat();

const generalCategory = finalData.filter(item => item.cat_type === 'default');
const otherCategories = finalData.filter(item => item.cat_type !== 'default');

if(generalCategory){
// Step 1: Extract store_order_id values
const storeOrderIds = generalCategory.flatMap(category =>category.products.map(product => product.store_order_id));
// Extracting store_order_id and creating an array of data
// Step 2: Query the store_orders table for rows with not NULL sub_time_slot and sub_delivery_date
const rowToUse = await knex('store_orders')
  .whereIn('store_order_id', storeOrderIds)
  .whereNull('store_orders.subscription_flag') // Corrected null condition
  .whereNotNull('sub_time_slot')
  .whereNotNull('sub_delivery_date')
  .first(); // Fetch the first row to use its values

if (rowToUse) {
  // Step 3: Update the rows in store_orders for the extracted store_order_id values
  const updatedRows = await knex('store_orders')
    .whereIn('store_order_id', storeOrderIds)
    .update({
      sub_time_slot: rowToUse.sub_time_slot, // Use the time slot from the first matching row
      sub_delivery_date: rowToUse.sub_delivery_date // Use the delivery date from the first matching row
    });
}
}

if(otherCategories){
// Step 1: Extract store_order_id values
const storeOrderIdsOther = otherCategories.flatMap(category =>category.products.map(product => product.store_order_id));
// Step 2: Query the store_orders table for rows with not NULL sub_time_slot and sub_delivery_date
const rowToUseOther = await knex('store_orders')
.whereIn('store_order_id', storeOrderIdsOther)
.whereNull('store_orders.subscription_flag') // Corrected null condition
.whereNotNull('sub_time_slot')
.whereNotNull('sub_delivery_date')
.first(); // Fetch the first row to use its values

if (rowToUseOther) {
  // Step 3: Update the rows in store_orders for the extracted store_order_id values
  const updatedRowsOther = await knex('store_orders')
    .whereIn('store_order_id', storeOrderIdsOther)
    .update({
      sub_time_slot:rowToUseOther.sub_time_slot, // Use the time slot from the first matching row
      sub_delivery_date:rowToUseOther.sub_delivery_date // Use the delivery date from the first matching row
    });
}
}


// Combine them, placing the general category first
const reorderedData = [...generalCategory, ...otherCategories];

      const freegiftlist = [];
      const mighthavemissed = [];
      const customizedProduct  = {
      //timeslotsdata: filteredTimeSlots,
      lastadd:lastAddress || [],
      lastcarddetails: users_acc_details || {},
      wallet_balance:total_wallet,
      discountonmrp:0.00,
      total_price:sum.Totalprice,
      total_mrp:sum.Totalmrp,
      saving_price:(sum.Totalmrp-sum.Totalprice).toFixed(2),
      total_items:sum.count,
      free_delivery:"0.00",
      total_tax:"0.00",
      avg_tax:"0.00", 
      delivery_charge:"0.00",
      subscription_fee:"0.00",
      vat:"0.00",
     // data:specialcatdata,
      data:reorderedData,
      free_gift_list: freegiftlist,
      might_have_missed : mighthavemissed
      }
      return customizedProduct;
  
      } else {
      // Handle the case where no items are found
      return 2;
      }
}

module.exports = {
addtoCart,
addtosubCart,
showCart,
showsubCart,
showspcatCart
};