const { application } = require('express');
const knex = require('../db'); // Import your Knex instance
const math = require('mathjs');  // If using a third-party math library

const addGuestDetails = async (appDetails) => {
    const { actual_device_id, device_id, uuid } = appDetails;

    // Check if uuid is defined and non-null
    if (uuid) {
        // Check if an unverified user with the same uuid already exists
        const existingUser = await knex('users')
            .where({ uuid })
            .whereNot('is_verified', 1)
            .first();

        if (existingUser) {
            return existingUser; // Return existing user data if found
        }
    }

    // Insert a new guest record if no matching user was found
    const [insertedId] = await knex('users')
        .insert({
            name: 'Guest',
            actual_device_id,
            device_id,
            user_type: 'guest',
            reg_date: new Date(),
            uuid: knex.raw('UUID()'),
        })
        .returning('id');
    // Fetch and return the newly inserted user's details
    return await knex('users').where({ id: insertedId }).first();
};


module.exports = {
addGuestDetails,
};