// models/homeappModel.js
const { application } = require('express');
const knex = require('../db'); // Import your Knex instance
const math = require('mathjs');  // If using a third-party math library

const getorderList = async (appDetatils) => {
  const { store_id } = appDetatils;
  const baseurl = process.env.BUNNY_NET_IMAGE;
  const user_id = appDetatils.user_id !== "null" ? appDetatils.user_id : appDetatils.device_id;

  // Fetch all orders
  const orders = await knex('orders')
    .select('orders.cart_id', 'orders.group_id', 'orders.is_subscription')
    .where('orders.user_id', user_id)
    .whereNotNull('orders.payment_method')
    .whereNot('orders.order_status', null)
    .orderBy('orders.order_id', 'desc')
    .groupBy('orders.group_id')
    .limit(8);

  if (orders.length === 0) {
    return []; // Return an empty array if no orders are found
  }

  // Extract all group_ids
  const groupIds = orders.map(order => order.group_id);
  const orderData = await knex('orders')
    .whereIn('group_id', groupIds)
    .select('cart_id', 'group_id'); // Fetch cart_id and group_id

  if (orderData.length === 0) {
    return orders.map(order => ({
      cart_id: order.cart_id,
      group_id: order.group_id,
      type: order.is_subscription === 1 ? 'Subscription' : 'Quick',
      is_subscription: order.is_subscription,
      prodList: [] // Empty product list if no data
    }));
  }

  // Fetch all store orders in one query
  const cartIds = orderData.map(data => data.cart_id);
  const storeOrders = await knex('store_orders')
    .whereIn('order_cart_id', cartIds)
    .where('store_id', store_id)
    .select('order_cart_id', 'product_name', knex.raw(`CONCAT('${baseurl}', varient_image) as varient_image`));

  // Group store orders by cart_id for easy lookup
  const storeOrderMap = {};
  storeOrders.forEach(order => {
    if (!storeOrderMap[order.order_cart_id]) {
      storeOrderMap[order.order_cart_id] = [];
    }
    storeOrderMap[order.order_cart_id].push(order);
  });

  // Create the final customized product data
  const customizedProductData = orders.map(order => {
    const typeval = order.is_subscription === 1 ? 'Subscription' : 'Quick';
    const orderCartIds = orderData
      .filter(data => data.group_id === order.group_id)
      .map(data => data.cart_id);

    // Get the list of products for the current order's cart_ids
    const prodList = orderCartIds
      .flatMap(cart_id => storeOrderMap[cart_id] || []); // Use || [] to avoid undefined

    return {
      cart_id: order.cart_id,
      group_id: order.group_id,
      type: typeval,
      is_subscription: order.is_subscription,
      prodList: prodList
    };
  });

  return customizedProductData;
};

const getBanner = async (appDetatils) => {
   const { store_id, user_id, is_subscription } = appDetatils;
   const baseurl =  process.env.BUNNY_NET_IMAGE;
    const banners = await knex('store_banner')
    .select('banner_id', 'banner_name', knex.raw(`CONCAT('${baseurl}', banner_image) as banner_image`))
    .where('store_id', store_id)
    .where('is_delete','!=',1)
    .orderBy('store_banner.sequence', 'asc')
    .limit(8);

    // Append ?width=500&height=500&quality=100 to each banner image URL
    return banners.map(banner => ({
    ...banner,
    banner_image: `${banner.banner_image}?width=700&height=700&quality=100`
    }));

};  

const getBrand = async (appDetatils) => {
    const { store_id, user_id, is_subscription } = appDetatils;
    const baseurl =  process.env.BUNNY_NET_IMAGE;
     return brand = await knex('brands')
     .select('cat_id','title',  knex.raw(`CONCAT('${baseurl}', image) as image`))
     .orderBy('cat_id', 'asc')
     .limit(8);
 
};

const getBrandlist = async () => {
    const baseurl =  process.env.BUNNY_NET_IMAGE;
     return brand = await knex('brands')
     .select('brands.cat_id','brands.title',  knex.raw(`CONCAT('${baseurl}', brands.image) as image`))
     .join('product','product.brand_id','brands.cat_id')
     .groupBy('product.brand_id')
     .orderBy('brands.cat_id', 'asc');
};

const getaboutData = async () => {
       return about = await knex('aboutuspage')
       .first();
   
};

const gettermsData = async () => {
       return terms = await knex('termspage')
       .first();
   
};

const getTopCat = async (appDetatils) => {
  const {store_id,user_id,is_subscription}=appDetatils;
  const baseurl =  process.env.BUNNY_NET_IMAGE;
//   return await knex('categories')
//   .select('title','cat_id','description',knex.raw(`CONCAT('${baseurl}', image) as image`) )
//   .where('level',0)
//   .orderBy('sequence_list','ASC')
//   .limit(18);

      return await knex('categories')
          .join('categories as cat', 'categories.cat_id', 'cat.parent')
          .join('product', 'cat.cat_id', 'product.cat_id')
          .join('product_varient', 'product.product_id', 'product_varient.product_id')
          .join('store_products', 'product_varient.varient_id', 'store_products.varient_id')
          .select('categories.title', 'categories.cat_id', knex.raw(`CONCAT('${baseurl}', categories.image) as image`), 'categories.description')
          .groupBy('categories.cat_id')
          .where('categories.level', 0)
          .where('categories.is_delete', 0)
          .orderBy('categories.sequence_list', 'ASC')
          .limit(18);
  
};

const getWhatsNew = async (appDetatils) => {
    const {store_id,is_subscription} =appDetatils;
    if(appDetatils.user_id != "null" ){
      user_id = appDetatils.user_id
    }else{
        user_id = appDetatils.device_id
    }
    const storeId = store_id;
    const categoryId = 37;
    
    
    const productDetails = await knex('store_products')
      .select(
        'store_products.store_id',
        'product.cat_id',
        'store_products.stock',
        'product_varient.varient_id',
        'product.product_id',
        'product.product_name',
        'product.product_image',
        'product.thumbnail',
        'product_varient.description',
        'store_products.price',
        'store_products.mrp',
        'product_varient.varient_image',
        'product_varient.unit',
        'product_varient.quantity',
        'product.type',
        'product.country_id',
        'tbl_country.country_icon',
        'product.percentage',
        'product.availability',
        knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper')
      )
      .innerJoin('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
      .innerJoin('product', 'product_varient.product_id', '=', 'product.product_id')
      .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
      .whereNotNull('store_products.price')
      .where('store_products.store_id', storeId)
      .where('product.is_subscription', 1)
      .where('product.hide', 0)
      .where('product.is_delete', 0)
      //.where('product.cat_id', categoryId)
      .orderBy('product.product_name', 'desc')
      .limit(8);
      const baseurl =  process.env.BUNNY_NET_IMAGE;
      const customizedProductData = [];
      for (let i = 0; i < productDetails.length; i++) {
        const ProductList = productDetails[i];
  
        var cartQty=0;
        if(user_id){ 
          // Wishlist check 
           // Wishlist check 
           var isFavourite='';
            var notifyMe='';
            var cartQty=0;
           const wishList = await knex('wishlist')
          .select('*')
          .where('varient_id',ProductList.varient_id)
          .where('user_id',user_id);
  
          isFavourite = wishList.length > 0 ? 'true' : 'false';
   
          // cart qty check 
          const CartQtyList = await knex('store_orders')
          .where('varient_id',ProductList.varient_id)
          .where('store_approval',user_id)
          .where('order_cart_id','incart')
          .whereNull('subscription_flag')
          .where('store_id',store_id)
          .first();
          cartQty = CartQtyList ? CartQtyList.qty : 0;

            try {
            const cnotify_me = await knex('product_notify_me')
            .where('varient_id', ProductList.varient_id)
            .where('user_id', user_id);

            notifyMe = cnotify_me.length > 0 ? 'true' : 'false';

            if (cnotify_me.length === 0) {
            notifyMe = cnotify_me.length > 0 ? 'true' : 'false';
            } else {
            notifyMe='false';
            }
            } catch (error) {
            notifyMe='false';
            }

           const subprod = await knex('store_orders')
           .select('store_orders.percentage')
           .where('store_orders.varient_id',ProductList.varient_id)
           .where('store_approval',user_id)
           .where('store_orders.subscription_flag',1)
           .where('store_orders.order_cart_id', "incart")
           .first();
   
           if(subprod){
             isSubscription = 'true'
           }else{
             isSubscription = 'false'
             
           }
  
  
          }else{
           notifyMe='false';
           isFavourite='false';
           cartQty=0;
           isSubscription = 'false';

          }
          
          const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
          const finalsubprice =  ProductList.mrp - sub_price;
          const subscription_price = parseFloat(finalsubprice.toFixed(2));
          
          if(ProductList.country_icon == null){
              countryicon = null
           }else{
              countryicon =  baseurl + ProductList.country_icon
           }
          
          const customizedProduct={
          store_id:ProductList.store_id,
         // is_subscription:ProductList.is_subscription,
          stock: ProductList.stock,      
          varient_id: ProductList.varient_id,
          product_id: ProductList.product_id,  
          product_name: ProductList.product_name,
          product_image:baseurl + ProductList.product_image+"?width=200&height=200&quality=100",
          thumbnail: baseurl + ProductList.thumbnail,
          price: ProductList.price,
          mrp: ProductList.mrp,
          unit: ProductList.unit,
          quantity: ProductList.quantity,
          type: ProductList.type,  
         // discountper: ProductList.discountper, 
          discountper:0,
          country_icon : countryicon,   
          percentage: ProductList.percentage,
          isSubscription:isSubscription,
          subscription_price:subscription_price, 
          availability:ProductList.availability,
          cart_qty: cartQty,
          avgrating:0,
          notify_me: notifyMe,
          isFavourite: isFavourite
          // Add or modify properties as needed
          };
        customizedProductData.push(customizedProduct);  
      }
      
      return customizedProductData;
};

const getdealProduct = async (appDetatils) => {
    const {store_id,is_subscription} =appDetatils;
    const storeId = store_id;
    const currentDate = new Date().toISOString().split('T')[0];

    if(appDetatils.user_id != "null" ){
      user_id = appDetatils.user_id
  }else{
      user_id = appDetatils.device_id
  }
 const deal_pssss = await knex('deal_product')
  .join('store_products', 'deal_product.varient_id', '=', 'store_products.varient_id')
  .join('product_varient', 'deal_product.varient_id', '=', 'product_varient.varient_id')
  .join('product', 'product_varient.product_id', '=', 'product.product_id')
  .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
  .select(
    'store_products.stock',
    'deal_product.deal_price as price',
    'product_varient.quantity',
    'product_varient.unit',
    'store_products.mrp',
    'product.product_name',
    'product.product_image',
    'product.thumbnail',
    'product_varient.varient_id',
    'product.product_id',
    'deal_product.valid_to',
    'deal_product.valid_from',
    'product.type',
    'tbl_country.country_icon',
    'product.percentage',
    'product.availability',
  )
  .groupBy(
    'store_products.store_id',
    'store_products.stock',
    'deal_product.deal_price',
    'product_varient.varient_image',
    'product_varient.quantity',
    'product_varient.unit',
    'store_products.mrp',
    'product_varient.description',
    'product.product_name',
    'product.product_image',
    'product_varient.varient_id',
    'product.product_id',
    'deal_product.valid_to',
    'deal_product.valid_from',
    'product.type'
  )
  .where('deal_product.valid_from', '<=', currentDate)
  .where('deal_product.valid_to', '>', currentDate)
  .whereNotNull('store_products.price')
  .where('product.hide', 0)
  .where('product.is_delete', 0)
  .where('deal_product.store_id', storeId)
 // .where('product.is_subscription', is_subscription)
  .orderBy('product.product_name', 'asc')
  .limit(8);
  const baseurl =  process.env.BUNNY_NET_IMAGE;
  const productDetailss = deal_pssss.filter((product, index, self) => {
    return index === self.findIndex((p) => p.product_id === product.product_id);
    });
    const customizedProductData = [];
    for (let i = 0; i < productDetailss.length; i++) {
      const ProductList = productDetailss[i];

      var cartQty=0;
      if(user_id && ProductList){ 
        const CartQtyList = await knex('store_orders')
        .where('varient_id',ProductList.varient_id)
        .where('store_approval',user_id)
        .where('order_cart_id','incart')
        .whereNull('subscription_flag')
        .where('store_id',store_id)
        .first();
        cartQty = CartQtyList ? CartQtyList.qty : 0;

        const subprod = await knex('store_orders')
        .select('store_orders.percentage')
        .where('store_orders.varient_id',ProductList.varient_id)
        .where('store_approval',user_id)
        .where('store_orders.subscription_flag',1)
        .where('store_orders.order_cart_id', "incart")
        .first();

        if(subprod){
          isSubscription = 'true'
        }else{
          isSubscription = 'false'
          
        }

       }else{
          isSubscription = 'false'
       }

       const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
       const finalsubprice =  ProductList.mrp - sub_price;
       const subscription_price = parseFloat(finalsubprice.toFixed(2));
       
       if(ProductList.country_icon == null){
              countryicon = null
           }else{
              countryicon =  baseurl + ProductList.country_icon
           }

        const customizedProduct={
        stock: ProductList.stock,        
        price: ProductList.price,
        quantity: ProductList.quantity,
        unit: ProductList.unit,
        mrp: ProductList.mrp,
        product_name: ProductList.product_name,
        product_image:baseurl + ProductList.product_image+"?width=200&height=200&quality=100",
        thumbnail: ProductList.thumbnail,
        varient_id: ProductList.varient_id,
        product_id: ProductList.product_id,
        valid_to: ProductList.valid_to,
        valid_from: ProductList.valid_from,
        type: ProductList.type,
        cart_qty: cartQty,
        country_icon : countryicon, 
        percentage: ProductList.percentage,
        isSubscription:isSubscription,
        subscription_price:subscription_price,
        availability:ProductList.availability,  
        // Add or modify properties as needed
        };
      customizedProductData.push(customizedProduct);  
    }

    
     
   return customizedProductData; 
};

const getsecondBanner = async (appDetatils) => {
  const {store_id,user_id,is_subscription} = appDetatils;
  const baseurl =  process.env.BUNNY_NET_IMAGE;
  return await knex('sec_banner')
  .where('sec_banner.store_id', store_id)
  .where('sec_banner.is_delete',0)
  .select('sec_banner.banner_id','sec_banner.brand_id', 'sec_banner.banner_name',knex.raw(`CONCAT('${baseurl}', banner_image) as banner_image`))
  .orderBy('sec_banner.seq', 'ASC')
  .limit(6);
};

const sneakyOfferBanner = async (appDetatils) => {
    const {store_id,user_id,is_subscription} = appDetatils;
    const baseurl =  process.env.BUNNY_NET_IMAGE;
     return await knex('sneaky_banner')
     .select('banner_id','banner_name', knex.raw(`CONCAT('${baseurl}', banner_image) as banner_image`))
     .where('store_id',store_id)
     .orderBy('banner_id','DESC')
     .first(); 
};

const specialOfferBanner = async (appDetatils) => {
      const {store_id,user_id,is_subscription} = appDetatils;
      const baseurl =  process.env.BUNNY_NET_IMAGE;
       return await knex('special_offers_banner')
       .select('banner_id','banner_name', knex.raw(`CONCAT('${baseurl}', banner_image) as banner_image`))
       .where('store_id',store_id)
       .orderBy('banner_id','DESC')
       .limit(6); 
};

const similarProds = async(appDetatils,catId) => {
    const cat_id = catId
    
    //const is_subscription = appDetatils.is_subscription
    const store_id = appDetatils.store_id
    const prod = await knex('store_products')
    .select(
        'store_products.store_id',
        'product.cat_id',
        'store_products.stock',
        'product_varient.varient_id',
        'product.product_id',
        'product.product_name',
        'product.product_image',
        'product.thumbnail',
        'product_varient.description',
        'store_products.price',
        'store_products.mrp',
        'product_varient.varient_image',
        'product_varient.unit',
        'product_varient.quantity',
        'product.type',
        'product.country_id',
        'tbl_country.country_icon',
        'product.percentage',
        'product.availability',
        knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper')
      )
    .join ('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
    .join ('product', 'product_varient.product_id', '=', 'product.product_id')
    .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
    .where('product.cat_id', cat_id)
   // .where('product.is_subscription', is_subscription)
    .where('store_products.store_id', store_id)
    .whereNotNull('store_products.price')
    .where('product.hide',0)
    .where('product.is_delete', 0)
    .where('product.approved',1)
    .limit(5)

    if(appDetatils.user_id != "null" ){
      user_id = appDetatils.user_id
    }else{
        user_id = appDetatils.device_id
    }

    //return prod;
    const customizedProductData = [];
    for (let i = 0; i < prod.length; i++) {
     
       const ProductList = prod[i];
       const currentDate = new Date();
       const deal = await knex('deal_product')
       .where('varient_id', ProductList.varient_id)
       .where('store_id', appDetatils.store_id)
       .where('deal_product.valid_from', '<=', currentDate)
       .where('deal_product.valid_to', '>', currentDate)
       .first();
     
       
       if (deal) {
         price = deal.deal_price;
       } else {
       const sp = await knex('store_products')
       .where('varient_id', ProductList.varient_id)
       .where('store_id', appDetatils.store_id)
       .first();
       price = sp.price;
       }

       if(user_id){ 
         // Wishlist check 
          var isFavourite='';
         var notifyMe='';
         var cartQty=0;
          const wishList = await knex('wishlist')
         .select('*')
         .where('varient_id',ProductList.varient_id)
         .where('user_id',user_id);
 
         isFavourite = wishList.length > 0 ? 'true' : 'false';
  
         // cart qty check 
         const CartQtyList = await knex('store_orders')
         .where('varient_id',ProductList.varient_id)
         .where('store_approval',user_id)
         .where('order_cart_id','incart')
         .whereNull('subscription_flag')
         .where('store_id',appDetatils.store_id)
         .first();
         cartQty = CartQtyList ? CartQtyList.qty : 0;
         
 
         try {
         const cnotify_me = await knex('product_notify_me')
         .where('varient_id', ProductList.varient_id)
         .where('user_id', user_id);

         notifyMe = cnotify_me.length > 0 ? 'true' : 'false';

         if (cnotify_me.length === 0) {
         notifyMe = cnotify_me.length > 0 ? 'true' : 'false';
         } else {
         notifyMe='false';
         }
         } catch (error) {
         notifyMe='false';
         }

         const subprod = await knex('store_orders')
         .select('store_orders.percentage')
         .where('store_orders.varient_id',ProductList.varient_id)
         .where('store_approval',user_id)
         .where('store_orders.subscription_flag',1)
         .where('store_orders.order_cart_id', "incart")
         .first();
 
         if(subprod){
           isSubscription = 'true'
         }else{
           isSubscription = 'false'
           
         }
 
 
 
         }else{
           notifyMe='false';
           isFavourite='false';
           cartQty=0;
           isSubscription = 'false';
         }
         
         const baseurl =  process.env.BUNNY_NET_IMAGE;

         const tag = await knex('tags') 
         .where('product_id', ProductList.product_id);
          tags = tag;  

        const images =  await knex('product_images') 
        .select(knex.raw(`CONCAT('${baseurl}', image) as image`))
         .where('product_id', ProductList.product_id)
          .orderBy('type','DESC')
         if(images){
          imageslist = images;
            
         }else{
          const images =  await knex('product')
          .select(`CONCAT('${baseurl}', product_image)  as image`)    
          .where('product_id', ProductList.product_id)
          
          imageslist = images;
         }

         const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
         const finalsubprice =  ProductList.mrp - sub_price;
         const subscription_price = parseFloat(finalsubprice.toFixed(2));
         
           if(ProductList.country_icon == null){
                countryicon = null
             }else{
                countryicon =  baseurl + ProductList.country_icon
             }

         const customizedProduct = {
           stock: ProductList.stock,        
           varient_id: ProductList.varient_id,
           product_id: ProductList.product_id,
           product_name: ProductList.product_name,
           product_image: baseurl + ProductList.product_image+"?width=200&height=200&quality=100",
           country_icon : countryicon,  
           thumbnail: ProductList.thumbnail,
           description:ProductList.description,
           price:ProductList.price,
           mrp:ProductList.mrp,
           unit:ProductList.unit,
           quantity:ProductList.quantity,
           type:ProductList.type,
           percentage:ProductList.percentage,
           isSubscription:isSubscription,
           subscription_price:subscription_price,
            availability:ProductList.availability,
           //discountper: ProductList.discountper,
           discountper:0,
           avgrating:0,
           notify_me: notifyMe,
           isFavourite: isFavourite,
           cart_qty: cartQty,
           countrating:0,
           tags:tags,
           images:imageslist,
           varients:null
           // Add or modify properties as needed
           };
       
         customizedProductData.push(customizedProduct);  
    }
    //prod.varient =  customizedProductData;

    //return prod;
    return customizedProductData;

};

const prodDetails = async(appDetatils) => {
    //const prod =

    
    if(appDetatils.user_id != "null" ){
      user_id = appDetatils.user_id
    }else{
        user_id = appDetatils.device_id
    }
    
    let prod = await knex('store_products')
    .select(
      'store_products.store_id',
      'store_products.stock',
      'product_varient.varient_id',
      'product.product_id',
      'product.product_name',
      'product.product_image',
      'product.thumbnail',
      'store_products.price',
      'store_products.mrp',
      'product_varient.unit',
      'product_varient.quantity',
      'product.type',
      'product.available_days',
      'tbl_country.country_icon',
      'tbl_country.country_name as country_of_origin',
      'product.shelf_life',
      'product.percentage',
      'product.availability',
      knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper')
    )
    .innerJoin('product_varient', 'store_products.varient_id', 'product_varient.varient_id')
    .innerJoin('product', 'product_varient.product_id', 'product.product_id')
    .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
    .where('store_products.store_id', appDetatils.store_id)
    //.where('product.is_subscription', appDetatils.is_subscription)
    .where('product.hide', 0)
    .where('product.is_delete', 0)
    .where('product.product_id',appDetatils.product_id)
    .where('product.approved', 1)
    .whereNotNull('store_products.price')
    .orderByRaw('RAND()')
    .first();
   
    

    const baseurl =  process.env.BUNNY_NET_IMAGE;
    prod.product_image = baseurl + prod.product_image+"?width=200&height=200&quality=100";
    
    if(prod.country_icon == null){
        countryicon = null
     }else{
        countryicon =  baseurl + prod.country_icon
     }
    prod.country_icon =  countryicon;
    
       
   
    const currentDate = new Date();
    const deal = await knex('deal_product')
    .where('varient_id',prod.varient_id)
    .where('store_id',appDetatils.store_id)
    .where('deal_product.valid_from', '<=', currentDate)
    .where('deal_product.valid_to', '>', currentDate)
    .first();
   
  
      if (deal) {
        prod.price = deal.deal_price;
      } else {
      const sp = await knex('store_products')
      .where('varient_id', prod.varient_id)
      .where('store_id', appDetatils.store_id)
      .first();
        prod.price = sp.price;
      }
   
       
      if(user_id){ 
       




        // Wishlist check 
         // Wishlist check 
         var isFavourite='';
        var notifyMe='';
        var cartQty=0;
        var percentage = prod.percentage
        var isSubscription = '';
        if (user_id) {
         const wishList = await knex('wishlist')
        .select('*')
        .where('varient_id',prod.varient_id)
        .where('user_id',user_id);

        prod.isFavourite = wishList.length > 0 ? 'true' : 'false';
        }else
        {
        prod.isFavourite ='false';
        }

        // const subprod = await knex('subscribe_product')
        // .select('percentage')
        // .where('varient_id',prod.varient_id)
        // .where('user_id',appDetatils.user_id)
        // .first();

       
        const subprod = await knex('store_orders')
        .select('store_orders.percentage')
        .where('store_orders.varient_id',prod.varient_id)
        .where('store_approval',user_id)
        .where('store_orders.subscription_flag',1)
        .where('store_orders.order_cart_id', "incart")
        .first();

        if(subprod){
          prod.isSubscription = 'true'
        }else{
          prod.isSubscription = 'false'
          
        }
 
        // cart qty check 
        const CartQtyList = await knex('store_orders')
        .where('varient_id',prod.varient_id)
        .where('store_approval',user_id)
        .where('order_cart_id','incart')
        .whereNull('subscription_flag')
        .where('store_id',appDetatils.store_id)
        .first();
        prod.cartQty = CartQtyList ? CartQtyList.qty : 0;

        const cnotify_me = await knex('product_notify_me')
        .where('varient_id', prod.varient_id)
        .where('user_id', user_id)
        .first();
        prod.notifyMe = (cnotify_me) ? 'true' : 'false';
        }else{
          prod.notifyMe='false';
          prod.isFavourite='false';
          prod.cartQty=0;
          prod.isSubscription = 'false'
        }

        const getrating = await knex('product_rating') 
        .where('varient_id', prod.varient_id)
        .where('store_id',appDetatils.store_id);
        prod.avgrating= 0;   
        if(getrating) {
        const countrating = await knex('product_rating') 
        .where('varient_id', prod.varient_id)
        .where('store_id',appDetatils.store_id)
        .count('rate_id as totalCount'); 

        const rating = await knex('product_rating') 
        .where('varient_id', prod.varient_id)
        .where('store_id',appDetatils.store_id)
        .avg('rating as averageRating');
        if(rating[0].averageRating == null){
        prod.avgrating= 0;
        }else{
        prod.avgrating=(rating[0].averageRating).toFixed(2); 
        }
        prod.countrating=countrating[0].totalCount;
        } 
        else{
        prod.avgrating=0; 
        prod.countrating=0;
        }  
        //return prod;
         
   
      const tag = await knex('tags') 
                 .where('product_id', prod.product_id);
      prod.tags = tag;  

      
                  const images =  await knex('product_images') 
                  .select(knex.raw(`CONCAT('${baseurl}', image) as image`))
                  .where('product_id', prod.product_id)
                  .orderBy('type','DESC');
                  if(images.length > 0){
                  prod.images=images;
                  }else{
                  const images =  await knex('product')
                  .select(knex.raw(`CONCAT('${baseurl}', product_image) as image`))   
                  .where('product_id', prod.product_id);
                  prod.images=images;
                  }

                let app =   await knex('store_products')
                 .join ('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
                 .select('store_products.store_id','store_products.stock','product_varient.varient_id', 'product_varient.description', 'store_products.price', 'store_products.mrp', 'product_varient.varient_image','product_varient.unit','product_varient.quantity')
                 .where('store_products.store_id', appDetatils.store_id)
                 .where('product_varient.product_id', prod.product_id)
                 .whereNotNull('store_products.price')
                 .where('product_varient.approved',1)

                 //prod.varient = app;
                 const customizedProductData = [];
                 for (let i = 0; i < app.length; i++) {
                   // prod.varient.dummy = 5678;
                    const ProductList = app[i];
                    const currentDate = new Date();
                    const deal = await knex('deal_product')
                    .where('varient_id', ProductList.varient_id)
                    .where('store_id', appDetatils.store_id)
                    .where('deal_product.valid_from', '<=', currentDate)
                    .where('deal_product.valid_to', '>', currentDate)
                    .first();
                  
                    
                    if (deal) {
                      price = deal.deal_price;
                    } else {
                    const sp = await knex('store_products')
                    .where('varient_id', ProductList.varient_id)
                    .where('store_id', appDetatils.store_id)
                    .first();
                    price = sp.price;
                    }

                    if(appDetatils.user_id){ 
                      // Wishlist check 
                       var isFavourite='';
                      var notifyMe='';
                      var cartQty=0;
                       const wishList = await knex('wishlist')
                      .select('*')
                      .where('varient_id',ProductList.varient_id)
                      .where('user_id',user_id);
              
                      isFavourite = wishList.length > 0 ? 'true' : 'false';
               
                      // cart qty check 
                      const CartQtyList = await knex('store_orders')
                      .where('varient_id',ProductList.varient_id)
                      .where('store_approval',user_id)
                      .where('order_cart_id','incart')
                      .whereNull('subscription_flag')
                      .where('store_id',appDetatils.store_id)
                      .first();
                      cartQty = CartQtyList ? CartQtyList.qty : 0;
                      
                      const cnotify_me = await knex('product_notify_me')
                      .where('varient_id', ProductList.varient_id)
                      .where('user_id', user_id)
                      .first();

                      notifyMe = (cnotify_me) ? 'true' : 'false';

                      }else{
                        notifyMe='false';
                        isFavourite='false';
                        cartQty=0;
                      }
                      const baseurl =  process.env.BUNNY_NET_IMAGE;

                      const sub_price = (prod.mrp * prod.percentage) / 100;
                      const finalsubprice =  prod.mrp - sub_price;
                       prod.subscription_price = parseFloat(finalsubprice.toFixed(2));
                       prod.availability =  prod.availability
                       prod.percentage = prod.percentage
                
                      const customizedProduct = {
                        stock: ProductList.stock,        
                        varient_id: ProductList.varient_id,
                        product_id: ProductList.product_id,
                        product_name: ProductList.product_name,
                        product_image: baseurl + ProductList.product_image+"?width=200&height=200&quality=100",
                        thumbnail: baseurl + ProductList.thumbnail,
                        description:ProductList.description,
                        price: price,
                        mrp: ProductList.mrp,
                        unit: ProductList.unit,
                        quantity: ProductList.quantity,
                        type: ProductList.type,
                        //discountper: ProductList.discountper,
                        discountper:0,
                        // avgrating:0,
                        notify_me: notifyMe,
                        isFavourite: isFavourite,
                        cart_qty: cartQty, 
                        // countrating:0
                        // Add or modify properties as needed
                        };
                    
                      customizedProductData.push(customizedProduct);  
                 }
                 prod.varient =  customizedProductData;
      return prod;
    
    
};

const getcatProduct = async (appDetatils) => {
  await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))');
  const {
    cat_id,
    sub_cat_id: subcatid,
    store_id,
    byname: filter1,
    sort: issort,
    sortprice,
    sortname,
    user_id: rawUserId,
    min_price: minPrice,
    max_price: maxPrice,
    min_discount: minDiscount,
    max_discount: maxDiscount,
    page: pageFilter,
    perpage: perPage
  } = appDetatils;

  const user_id = rawUserId !== "null" ? rawUserId : appDetatils.device_id;
  const minprice = parseFloat(minPrice);
  const maxprice = parseFloat(maxPrice);
  const mindiscount = parseFloat(minDiscount);
  const maxdiscount = parseFloat(maxDiscount);
  const offset = (pageFilter - 1) * perPage;

  // Build base query
  let topsellingsQuery = knex('store_products')
    .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
    .join('product', 'product_varient.product_id', '=', 'product.product_id')
    .leftJoin('deal_product', 'product_varient.varient_id', '=', 'deal_product.varient_id')
    .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
    .select(
      'store_products.stock',
      'product_varient.varient_id',
      'product_varient.description',
      'product.product_id',
      'product.product_name',
      'product.product_image',
      'product.thumbnail',
      'store_products.price',
      'store_products.mrp',
      'product_varient.unit',
      'product_varient.quantity',
      'product.type',
      'tbl_country.country_icon',
      'product.percentage',
      'product.availability',
      knex.raw('100 - (store_products.price * 100 / store_products.mrp) as discountper'),
      knex.raw('100 - (deal_product.deal_price * 100 / store_products.mrp) as discountper1')
    )
    .where('store_products.store_id', store_id)
    .where('product.hide', 0)
    .where('product.is_delete', 0)
    .where('product.approved', 1)
    .whereNotNull('store_products.price');

  // Apply category filters
  if (cat_id !== "null") {
    const categoryarray = await knex('categories').where('parent', cat_id).pluck('cat_id');
    topsellingsQuery.whereIn('product.cat_id', categoryarray);
  }

  if (subcatid !== "null") {
    topsellingsQuery.where('product.cat_id', subcatid);
  }

  // Apply price and discount filters
  if (minprice && maxprice) {
    topsellingsQuery.whereBetween('store_products.price', [minprice, maxprice]);
  }

  if (mindiscount && maxdiscount) {
    topsellingsQuery.havingRaw('(discountper BETWEEN ? AND ?) OR (discountper1 BETWEEN ? AND ?)', [mindiscount, maxdiscount, mindiscount, maxdiscount]);
  }

  // Apply sorting
  if (sortprice === 'ltoh') {
    topsellingsQuery.orderBy('store_products.price', 'ASC');
  }

  if (sortprice === 'htol') {
    topsellingsQuery.orderBy('store_products.price', 'DESC');
  }

  if (sortname === 'atoz') {
    topsellingsQuery.orderBy('product.product_name', 'ASC');
  }

  if (sortname === 'ztoa') {
    topsellingsQuery.orderBy('product.product_name', 'DESC');
  }

  // Fetch paginated products
  const productDetails = await topsellingsQuery.offset(offset).limit(perPage);

  // Collect variant IDs for batch queries
  const variantIds = productDetails.map(p => p.varient_id);

  // Fetch related data in parallel
  const [wishList, cartItems, notifyMeList, subscriptionProducts] = await Promise.all([
    knex('wishlist').where('user_id', user_id).whereIn('varient_id', variantIds),
    knex('store_orders').whereIn('varient_id', variantIds).where('store_approval', user_id).where('order_cart_id', 'incart').whereNull('subscription_flag').where('store_id', store_id),
    knex('product_notify_me').whereIn('varient_id', variantIds).where('user_id', user_id),
    knex('store_orders').select('varient_id').whereIn('varient_id', variantIds).where('store_approval', user_id).where('subscription_flag', 1)
  ]);

  // Process product details
  const customizedProductData = await Promise.all(productDetails.map(async (product) => {
    const isFavourite = wishList.some(w => w.varient_id === product.varient_id) ? 'true' : 'false';
    const cartItem = cartItems.find(c => c.varient_id === product.varient_id);
    const cartQty = cartItem ? cartItem.qty : 0;
    const notifyMe = notifyMeList.some(n => n.varient_id === product.varient_id) ? 'true' : 'false';
    const isSubscription = subscriptionProducts.some(s => s.varient_id === product.varient_id) ? 'true' : 'false';

    const sub_price = (product.mrp * product.percentage) / 100;
    const finalsubprice = product.mrp - sub_price;
    const subscription_price = parseFloat(finalsubprice.toFixed(2));
    const baseurl = process.env.BUNNY_NET_IMAGE;
    const countryicon = product.country_icon ? baseurl + product.country_icon : null;

    // Determine the price (either from deal or regular price)
    const price = await knex('deal_product')
      .where('varient_id', product.varient_id)
      .where('store_id', store_id)
      .where('deal_product.valid_from', '<=', new Date())
      .where('deal_product.valid_to', '>', new Date())
      .first()
      .then(deal => deal ? deal.deal_price : product.price);
  
    if (Number.isInteger(price)) {
    priceval = price + '.001'
    }else{
    priceval = price
    }
    if (Number.isInteger(product.mrp)) {
    mrpval = product.mrp + '.001'
    }else{
    mrpval = product.mrp
    }

    return {
      stock: product.stock,
      varient_id: product.varient_id,
      product_id: product.product_id,
      product_name: product.product_name,
      product_image: baseurl + product.product_image+"?width=200&height=200&quality=100",
      thumbnail: product.thumbnail,
      description: product.description,
      price: parseFloat(priceval),
      mrp: parseFloat(mrpval),
      unit: product.unit,
      quantity: product.quantity,
      type: product.type,
      percentage: product.percentage,
      isSubscription,
      subscription_price,
      availability: product.availability,
      discountper: product.discountper || 0,
      avgrating: 0, // Placeholder for ratings
      notify_me: notifyMe,
      isFavourite,
      cart_qty: cartQty,
      countrating: 0, // Placeholder for country ratings
      country_icon: countryicon,
      varients: null
    };
  }));

  return customizedProductData;
};

 const getrecentSelling = async (appDetatils) => {
  const { store_id, is_subscription } = appDetatils;
  const storeId = store_id;
  const user_id = appDetatils.user_id !== "null" ? appDetatils.user_id : appDetatils.device_id;
  const baseurl = process.env.BUNNY_NET_IMAGE;

  // Fetch products in bulk
  const productDetails = await knex('store_products')
      .select(
          'store_products.store_id',
          'store_products.stock',
          'product_varient.varient_id',
          'product.product_id',
          'product.product_name',
          'product.product_image',
          'product.thumbnail',
          'store_products.price',
          'store_products.mrp',
          'product_varient.unit',
          'product_varient.quantity',
          'product.type',
          'tbl_country.country_icon',
          'product.percentage',
          'product.availability',
          knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper')
      )
      .innerJoin('product_varient', 'store_products.varient_id', 'product_varient.varient_id')
      .innerJoin('product', 'product_varient.product_id', 'product.product_id')
      .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
      .where('store_products.store_id', storeId)
      .where('product.hide', 0)
      .where('product.is_delete', 0)
      .whereNotNull('store_products.price')
      .orderBy('store_products.p_id', 'asc')
      .limit(8);

  const productVarientIds = productDetails.map(product => product.varient_id);

  // Fetch user-related data in parallel
  const [wishList, cartItems, notifyMeList, subscriptionProducts] = await Promise.all([
      knex('wishlist').whereIn('varient_id', productVarientIds).where('user_id', user_id),
      knex('store_orders')
          .whereIn('varient_id', productVarientIds)
          .where('store_approval', user_id)
          .where('order_cart_id', 'incart')
          .whereNull('subscription_flag')
          .where('store_id', storeId),
      knex('product_notify_me').whereIn('varient_id', productVarientIds).where('user_id', user_id),
      knex('store_orders')
          .select('store_orders.percentage', 'store_orders.varient_id')
          .whereIn('store_orders.varient_id', productVarientIds)
          .where('store_approval', user_id)
          .where('store_orders.subscription_flag', 1)
          .where('store_orders.order_cart_id', "incart")
  ]);

  // Mapping the fetched data to make it easy to access
  const wishlistMap = wishList.reduce((acc, item) => ({ ...acc, [item.varient_id]: true }), {});
  const cartMap = cartItems.reduce((acc, item) => ({ ...acc, [item.varient_id]: item.qty }), {});
  const notifyMeMap = notifyMeList.reduce((acc, item) => ({ ...acc, [item.varient_id]: true }), {});
  const subscriptionMap = subscriptionProducts.reduce((acc, item) => ({ ...acc, [item.varient_id]: item.percentage }), {});

  // Build final product data
  const customizedProductData = productDetails.map(product => {
      const isFavourite = wishlistMap[product.varient_id] ? 'true' : 'false';
      const cartQty = cartMap[product.varient_id] || 0;
      const notifyMe = notifyMeMap[product.varient_id] ? 'true' : 'false';
      const isSubscription = subscriptionMap[product.varient_id] ? 'true' : 'false';

      const sub_price = (product.mrp * product.percentage) / 100;
      const finalsubprice = product.mrp - sub_price;
      const subscription_price = parseFloat(finalsubprice.toFixed(2));
     
      if (Number.isInteger(product.price)) {
      priceval = product.price + '.001'
      }else{
      priceval = product.price
      }
      if (Number.isInteger(product.mrp)) {
      mrpval = product.mrp + '.001'
      }else{
      mrpval = product.mrp
      }

      return {
          store_id: product.store_id,
          stock: product.stock,
          varient_id: product.varient_id,
          product_id: product.product_id,
          product_name: product.product_name,
          product_image: baseurl + product.product_image+"?width=200&height=200&quality=100",
          thumbnail: baseurl + product.thumbnail,
          price: parseFloat(priceval),
          mrp: parseFloat(mrpval),
          unit: product.unit,
          quantity: product.quantity,
          type: product.type,
          discountper: 0,  // Modify if needed
          country_icon: product.country_icon ? baseurl + product.country_icon : null,
          cart_qty: cartQty,
          avgrating: 0,  // Placeholder for average rating
          notify_me: notifyMe,
          percentage: product.percentage,
          isSubscription: isSubscription,
          subscription_price: subscription_price,
          availability: product.availability,
          isFavourite: isFavourite
      };
  });

  return customizedProductData;
};

const gettopSelling = async (appDetatils) => {
  const { store_id, is_subscription } = appDetatils;
  const user_id = appDetatils.user_id !== "null" ? appDetatils.user_id : appDetatils.device_id;
  const pageFilter = appDetatils.page;
  const perPage = appDetatils.perpage;
  const baseurl = process.env.BUNNY_NET_IMAGE;

  let categoryList = await knex('categories').where('parent', 121).pluck('cat_id');

  // Fetch all products in one go
  const productDetail = await knex('store_products')
      .select(
          'store_products.*',
          knex.raw(`CONCAT('${baseurl}', product_image) as product_image`),
          knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
          'tbl_country.country_icon',
          'product_varient.unit as prdunit',
          'product_varient.varient_id',
          'product_varient.quantity',
          'product.product_id',
          'product.product_name',
          'product.thumbnail',
          'product.type',
          'product.percentage',
          'product.availability',
          'product_varient.description',
          'product_varient.varient_image',
          'product_varient.ean',
          'product_varient.approved',
          'product.cat_id',
          'product.brand_id',
          'product.hide',
          'product.added_by'
      )
      .innerJoin('product_varient', 'store_products.varient_id', 'product_varient.varient_id')
      .innerJoin('product', 'product_varient.product_id', 'product.product_id')
      .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
      .where('store_products.store_id', store_id)
      .whereNotNull('store_products.price')
      .where('product.hide', 0)
      .whereIn('product.cat_id', categoryList)
      .where('product.is_delete', 0)
      .where('product.approved', 1)
      .limit(8);

  // Extract variant IDs for bulk queries
  const variantIds = productDetail.map(product => product.varient_id);

  // Batch fetch wishlist, cart, notify me, and subscription data in parallel
  const [wishList, cartItems, notifyMeList, subscriptionProducts, deals] = await Promise.all([
      knex('wishlist').whereIn('varient_id', variantIds).where('user_id', user_id),
      knex('store_orders').whereIn('varient_id', variantIds).where('store_approval', user_id).where('order_cart_id', 'incart').whereNull('subscription_flag').where('store_id', store_id),
      knex('product_notify_me').whereIn('varient_id', variantIds).where('user_id', user_id),
      knex('store_orders').select('varient_id').whereIn('varient_id', variantIds).where('store_approval', user_id).where('subscription_flag', 1).where('order_cart_id', 'incart'),
      knex('deal_product').whereIn('varient_id', variantIds).where('store_id', store_id).where('deal_product.valid_from', '<=', new Date()).where('deal_product.valid_to', '>', new Date())
  ]);

  // Preprocess deal prices
  const dealMap = {};
  deals.forEach(deal => {
      dealMap[deal.varient_id] = deal.deal_price;
  });

  // Preprocess subscription data
  const subscriptionMap = {};
  subscriptionProducts.forEach(sub => {
      subscriptionMap[sub.varient_id] = true;
  });

  // Preprocess wishlist data
  const wishListMap = {};
  wishList.forEach(item => {
      wishListMap[item.varient_id] = true;
  });

  // Preprocess cart items
  const cartMap = {};
  cartItems.forEach(item => {
      cartMap[item.varient_id] = item.qty;
  });

  // Preprocess notify me data
  const notifyMeMap = {};
  notifyMeList.forEach(item => {
      notifyMeMap[item.varient_id] = true;
  });

  // Process products and construct response
  const customizedProductData = productDetail.map(product => {
      const isFavourite = wishListMap[product.varient_id] ? 'true' : 'false';
      const cartQty = cartMap[product.varient_id] || 0;
      const notifyMe = notifyMeMap[product.varient_id] ? 'true' : 'false';
      const isSubscription = subscriptionMap[product.varient_id] ? 'true' : 'false';
      const dealPrice = dealMap[product.varient_id];
      const price = dealPrice || product.price;
      
      const sub_price = (product.mrp * product.percentage) / 100;
      const subscription_price = parseFloat((product.mrp - sub_price).toFixed(2));

      const country_icon = product.country_icon ? baseurl + product.country_icon : null;

      if (Number.isInteger(price)) {
      priceval = price + '.001'
      }else{
      priceval = price
      }
      if (Number.isInteger(product.mrp)) {
      mrpval = product.mrp + '.001'
      }else{
      mrpval = product.mrp
      }

      return {
          p_id: product.p_id,
          varient_id: product.varient_id,
          stock: product.stock,
          store_id: product.store_id,
          price: parseFloat(priceval),
          mrp: parseFloat(mrpval),
          min_ord_qty: product.min_ord_qty,
          max_ord_qty: product.max_ord_qty,
          buyingprice:product.buyingprice,
          product_code: product.product_code,
          partner_id: product.partner_id,
          product_id: product.product_id,
          quantity: product.quantity,
          unit: product.prdunit,
          description: product.description,
          varient_image: product.varient_image,
          ean: product.ean,
          approved: product.approved,
          added_by:product.added_by,
          cat_id: product.cat_id,
          brand_id: product.brand_id,
          product_name: product.product_name,
          product_image: product.product_image+"?width=200&height=200&quality=100",
          type: product.type,
          hide:product.hide,
          percentage: product.percentage,
          isSubscription: isSubscription,
          subscription_price: subscription_price,
          availability: product.availability,
          discountper: product.discountper || 0,
          country_icon: country_icon,
          avgrating: 0, // Placeholder for ratings
          notify_me: notifyMe,
          isFavourite: isFavourite,
          cart_qty: cartQty,
          countrating: 0
      };
  });

  return customizedProductData;
};

const getsubscriptonDetails = async (appDetatils) => {
   const {store_id,is_subscription} = appDetatils;
   
   
   if(appDetatils.user_id != "null" ){
    user_id = appDetatils.user_id
  }else{
      user_id = appDetatils.device_id
  }
   const subdetails = await knex('users')
   .where('id',user_id)
   .where('noti_popup',1);

   if(subdetails.length > 0)
   {
    return subscripton_details = {
    'is_subscription':1,
    'message':''
    };
   }else
   {
    return subscripton_details = {
      'is_subscription':1,
      'message':''
      };
   }

};

const getadditionalCategory = async (appDetatils) => {
  const { store_id, is_subscription } = appDetatils;
  const user_id = appDetatils.user_id !== "null" ? appDetatils.user_id : appDetatils.device_id;
  const baseurl = process.env.BUNNY_NET_IMAGE;

  // Fetch all categories
  const results = await knex('additional_category').whereNot('id', 12).orderBy('main_order', 'asc');
  
  if (results.length === 0) {
    return [];
  }

  // Prepare a list to return
  const customizedData = [];

  // Fetch all wishlist, cart, notify me, and subscription data for user in one go
  const [wishList, cartItems, notifyMeList, subscriptionProducts] = await Promise.all([
    knex('wishlist').where('user_id', user_id),
    knex('store_orders').where('store_approval', user_id).where('store_id', store_id).where('order_cart_id', 'incart').whereNull('subscription_flag'),
    knex('product_notify_me').where('user_id', user_id),
    knex('store_orders').select('varient_id').where('store_approval', user_id).where('subscription_flag', 1)
  ]);

  // Process each category
  for (const item of results) {
    const categoryProductIds = item.product_id.split(',');
    
    // Fetch product details for current category
    const productDetail = await knex('product')
      .select(
        'store_products.store_id',
        'store_products.stock',
        'product_varient.varient_image',
        'product_varient.quantity',
        'product_varient.unit',
        'store_products.price',
        'store_products.mrp',
        'product_varient.description',
        'product.product_name',
        'product.product_image',
        'product.thumbnail',
        'product_varient.varient_id',
        'product.product_id',
        'product.type',
        'tbl_country.country_icon',
        'product.percentage',
        'product.availability',
        knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper')
      )
      .from('product')
      .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
      .innerJoin('product_varient', 'product.product_id', 'product_varient.product_id')
      .innerJoin('store_products', 'product_varient.varient_id', 'store_products.varient_id')
      .whereIn('product.product_id', categoryProductIds)
      .andWhere('product.hide', '=', 0)
      .andWhere('product.is_delete', '=', 0);

    // Deduplicate products
    const productDetails = productDetail.filter((product, index, self) => 
      index === self.findIndex((p) => p.product_id === product.product_id)
    ).slice(0, 6);

    // Process product details and add additional info (wishlist, cart qty, subscription, etc.)
    const customizedProductData = productDetails.map(product => {
      const isFavourite = wishList.some(w => w.varient_id === product.varient_id) ? 'true' : 'false';
      const cartItem = cartItems.find(c => c.varient_id === product.varient_id);
      const cartQty = cartItem ? cartItem.qty : 0;
      const notifyMe = notifyMeList.some(n => n.varient_id === product.varient_id) ? 'true' : 'false';
      const isSubscription = subscriptionProducts.some(s => s.varient_id === product.varient_id) ? 'true' : 'false'; // Check if it's in subscription

      const sub_price = (product.mrp * product.percentage) / 100;
      const finalsubprice = product.mrp - sub_price;
      const subscription_price = parseFloat(finalsubprice.toFixed(2));
      if (Number.isInteger(product.price)) {
      priceval = product.price + '.001'
      }else{
      priceval = product.price
      }
      if (Number.isInteger(product.mrp)) {
      mrpval = product.mrp + '.001'
      }else{
      mrpval = product.mrp
      }

      return {
        store_id: product.store_id,
        stock: product.stock,
        varient_id: product.varient_id,
        product_id: product.product_id,
        product_name: product.product_name,
        product_image: baseurl + product.product_image+"?width=200&height=200&quality=100",
        thumbnail: product.thumbnail,
        price: parseFloat(priceval),
        mrp: parseFloat(mrpval),
        unit: product.unit,
        quantity: product.quantity,
        type: product.type,
        discountper: product.discountper || 0,
        country_icon: product.country_icon ? baseurl + product.country_icon : null,
        cart_qty: cartQty,
        avgrating: 0, // Placeholder for ratings
        notify_me: notifyMe,
        isFavourite: isFavourite,
        percentage: product.percentage,
        isSubscription: isSubscription,
        subscription_price: subscription_price,
        availability: product.availability,
      };
    });

    // Add category with its specific product details
    customizedData.push({
      id: item.id,
      title: item.title,
      sub_title: item.sub_title,
      color1: item.color1,
      color2: item.color2,
      product_details: customizedProductData
    });
  }

  return customizedData;
};

const getcategoryList =async (appDetatils) => {
    const {store_id} = appDetatils;
    const storeId = store_id;
    
    const cats = await knex('categories')
  .join('categories as cat', 'categories.cat_id', '=', 'cat.parent')
  .join('product', 'cat.cat_id', '=', 'product.cat_id')
  .join('product_varient', 'product.product_id', '=', 'product_varient.product_id')
  .join('store_products', 'product_varient.varient_id', '=', 'store_products.varient_id')
  .select(
    'categories.order_list',
    'categories.title',
    'categories.cat_id',
    'categories.image',
    'store_products.store_id',
    'categories.description',
    knex.raw('MIN(store_products.price) as stfrom'),
    knex.raw('COUNT(cat.cat_id) as subcat_count')
  )
  .groupBy(
    'categories.order_list',
    'categories.title',
    'categories.cat_id',
    'categories.image',
    'store_products.store_id',
    'categories.description'
  )
  .where('categories.level', 0)
  .where('categories.is_delete', 0)
  .where('store_products.store_id', storeId)
  .orderBy('categories.cat_id', 'asc');
  const catss = cats.filter((categories, index, self) => {
    return index === self.findIndex((p) => p.cat_id === categories.cat_id);
    });
    const customizedCategoryData = [];
      for (let j = 0; j < catss.length; j++) {
        const cats = catss[j];

        const subCategory = await knex('categories')
        .join('product', 'categories.cat_id', '=', 'product.cat_id')
        .join('product_varient', 'product.product_id', '=', 'product_varient.product_id')
        .join('store_products', 'product_varient.varient_id', '=', 'store_products.varient_id')
        .select(
        'categories.title',
        'categories.cat_id',
        'categories.image',
        'store_products.store_id',
        'categories.description',
        knex.raw('MIN(store_products.price) as stfrom')
        )
        .groupBy(
        'categories.title',
        'categories.cat_id',
        'categories.image',
        'store_products.store_id',
        'categories.description'
        )
        .where('categories.parent', cats.cat_id)
        .where('categories.level', 1)
        .where('categories.is_delete', 0)
        .orderBy('categories.order_list', 'asc');
        
        const subCategorys = subCategory.filter((categories, index, self) => {
          return index === self.findIndex((p) => p.cat_id === categories.cat_id);
          });
        const baseurl =  process.env.BUNNY_NET_IMAGE;
        
        const customizedcategory = {
          order_list: cats.order_list,
          title: cats.title,
          cat_id: cats.cat_id,
          image: baseurl + cats.image,
          store_id: cats.store_id,
          description: cats.description,
          stfrom: cats.stfrom,
          subcat_count: cats.subcat_count,
          subcategory:subCategorys
          // Add or modify properties as needed
          };
          customizedCategoryData.push(customizedcategory);
      }
  return customizedCategoryData;
};
 
const getsubcategoryList = async (appDetatils) => {
  await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))');

  const storeId = appDetatils.store_id;
  const catId = appDetatils.cat_id;
  const sortprice = appDetatils.sortprice;
  const sortname = appDetatils.sortname;
  const user_id = appDetatils.user_id !== "null" ? appDetatils.user_id : appDetatils.device_id;
  const baseurl = process.env.BUNNY_NET_IMAGE;

  // Define sorting order for price and name
  const priceOrder = sortprice === 'asc' ? 'asc' : 'desc';
  const nameOrder = sortname === 'asc' ? 'asc' : 'desc';

  // Fetch categories with pagination
  const page = appDetatils.page || 1;
  const perPage = appDetatils.perpage || 10;
  const offset = (page - 1) * perPage;

  const cats = await knex('categories')
    .select(
      'categories.status',
      'categories.order_list',
      'categories.order',
      'categories.title',
      'categories.cat_id',
      knex.raw(`CONCAT('${baseurl}', categories.image) as image`),
      'categories.description'
    )
    .leftJoin('product', 'categories.cat_id', 'product.cat_id')
    .leftJoin('product_varient', 'product.product_id', 'product_varient.product_id')
    .leftJoin('store_products', 'product_varient.varient_id', 'store_products.varient_id')
    .where('store_products.store_id', storeId)
    .where('categories.parent', catId)
    .where('categories.status', 1)
    .groupBy('categories.status', 'categories.order_list', 'categories.order', 'categories.title', 'categories.cat_id', 'categories.image', 'categories.description')
    .orderBy('categories.order', 'asc');
  if (cats.length === 0) {
    throw new Error('Products not found');
  }

  return cats.map(cat => ({
    status: cat.status,
    order_list: cat.order_list,
    order: cat.order,
    title: cat.title,
    cat_id: cat.cat_id,
    image: cat.image,
    description: cat.description,
  }));
};


const getoccasionalCategory = async (appDetatils) => {
  const { store_id, is_subscription } = appDetatils;
  const user_id = appDetatils.user_id !== "null" ? appDetatils.user_id : appDetatils.device_id;
  const baseurl = process.env.BUNNY_NET_IMAGE;
  const currentDate = new Date().toISOString().split('T')[0];
  // Fetch all categories
  const results = await knex('occasional_category')
  .orderBy('main_order', 'asc')
  .where('hide', 1)
  .where('from_date', '<=', currentDate)
  .andWhere('to_date', '>=', currentDate);
  if (results.length === 0) {
    return [];
  }
  // Prepare a list to return
  const customizedData = [];
  // Fetch all wishlist, cart, notify me, and subscription data for user in one go
  const [wishList, cartItems, notifyMeList, subscriptionProducts] = await Promise.all([
    knex('wishlist').where('user_id', user_id),
    knex('store_orders').where('store_approval', user_id).where('store_id', store_id).where('order_cart_id', 'incart').whereNull('subscription_flag'),
    knex('product_notify_me').where('user_id', user_id),
    knex('store_orders').select('varient_id').where('store_approval', user_id).where('subscription_flag', 1)
  ]);
  // Process each category
  for (const item of results) {
    const categoryProductIds = item.product_id.split(',');
    // Fetch product details for current category
    const productDetail = await knex('product')
      .select(
        'store_products.store_id',
        'store_products.stock',
        'product_varient.varient_image',
        'product_varient.quantity',
        'product_varient.unit',
        'store_products.price',
        'store_products.mrp',
        'product_varient.description',
        'product.product_name',
        'product.product_image',
        'product.thumbnail',
        'product_varient.varient_id',
        'product.product_id',
        'product.type',
        'tbl_country.country_icon',
        'product.percentage',
        'product.availability',
        knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper')
      )
      .from('product')
      .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
      .innerJoin('product_varient', 'product.product_id', 'product_varient.product_id')
      .innerJoin('store_products', 'product_varient.varient_id', 'store_products.varient_id')
      .leftJoin('add_occproduct_order', 'add_occproduct_order.product_id', '=', 'product.product_id')
      .whereIn('product.product_id', categoryProductIds)
      .andWhere('product.hide', '=', 0)
      .andWhere('product.is_delete', '=', 0)
      .orderBy('add_occproduct_order.orders', 'asc');
    // Deduplicate products
    const productDetails = productDetail.filter((product, index, self) =>
      index === self.findIndex((p) => p.product_id === product.product_id)
    ).slice(0, 6);
    // Process product details and add additional info (wishlist, cart qty, subscription, etc.)
    const customizedProductData = productDetails.map(product => {
      const isFavourite = wishList.some(w => w.varient_id === product.varient_id) ? 'true' : 'false';
      const cartItem = cartItems.find(c => c.varient_id === product.varient_id);
      const cartQty = cartItem ? cartItem.qty : 0;
      const notifyMe = notifyMeList.some(n => n.varient_id === product.varient_id) ? 'true' : 'false';
      const isSubscription = subscriptionProducts.some(s => s.varient_id === product.varient_id) ? 'true' : 'false'; // Check if it's in subscription
      const sub_price = (product.mrp * product.percentage) / 100;
      const finalsubprice = product.mrp - sub_price;
      const subscription_price = parseFloat(finalsubprice.toFixed(2));
      return {
        store_id: product.store_id,
        stock: product.stock,
        varient_id: product.varient_id,
        product_id: product.product_id,
        product_name: product.product_name,
        product_image: baseurl + product.product_image+"?width=200&height=200&quality=100",
        thumbnail: product.thumbnail,
        price: product.price,
        mrp: product.mrp,
        unit: product.unit,
        quantity: product.quantity,
        type: product.type,
        discountper: product.discountper || 0,
        country_icon: product.country_icon ? baseurl + product.country_icon : null,
        cart_qty: cartQty,
        avgrating: 0, // Placeholder for ratings
        notify_me: notifyMe,
        isFavourite: isFavourite,
        percentage: product.percentage,
        isSubscription: isSubscription,
        subscription_price: subscription_price,
        availability: product.availability,
      };
    });
    // Add category with its specific product details
    customizedData.push({
      id: item.id,
      title: item.title,
      sub_title: item.sub_title,
      color1: item.color1,
      color2: item.color2,
      from_date :item.from_date,
      to_date:item.to_date,
      product_details: customizedProductData
    });
  }
  return customizedData;
};

module.exports = {
  getBanner,
  getTopCat,
  getWhatsNew,
  getdealProduct,
  getsecondBanner,
  getrecentSelling,
  gettopSelling,
  getsubscriptonDetails,
  getadditionalCategory,
  getcategoryList,
  getsubcategoryList,
  prodDetails,
  similarProds,
  getcatProduct,
  getorderList,
  getBrand,
  getBrandlist,
  specialOfferBanner,
  sneakyOfferBanner,
  getaboutData,
  gettermsData,
  getoccasionalCategory
  };