const { application } = require('express');
const knex = require('../db'); // Import your Knex instance
const math = require('mathjs');  // If using a third-party math library
const axios = require('axios');



const showNotifyMe = async (appDetatils) => {
    const { store_id, is_subscription,user_id } = appDetatils;
    const baseurl = process.env.BUNNY_NET_IMAGE;
  
    // Fetch all products in one go
    const productDetail = await knex('store_products')
        .select(
            'store_products.*',
            knex.raw(`CONCAT('${baseurl}', product_image) as product_image`),
            knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
            'tbl_country.country_icon',
            'product_varient.unit as prdunit',
            'product_varient.varient_id',
            'product_varient.quantity',
            'product.product_id',
            'product.product_name',
            'product.thumbnail',
            'product.type',
            'product.percentage',
            'product.availability',
            'product_varient.description',
            'product_varient.varient_image',
            'product_varient.ean',
            'product_varient.approved',
            'product.cat_id',
            'product.brand_id',
            'product.hide',
            'product.added_by'
        )
        .join('product_notify_me','product_notify_me.varient_id','store_products.varient_id')
        .innerJoin('product_varient', 'store_products.varient_id', 'product_varient.varient_id')
        .innerJoin('product', 'product_varient.product_id', 'product.product_id')
        .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
        .whereNotNull('store_products.price')
        .where('product.hide', 0)
        .where('product.is_delete', 0)
        .where('product_notify_me.user_id',user_id)
        .where('product.approved', 1);

    // Extract variant IDs for bulk queries
    const variantIds = productDetail.map(product => product.varient_id);
  
    // Batch fetch wishlist, cart, notify me, and subscription data in parallel
    const [wishList, cartItems, notifyMeList, subscriptionProducts, deals] = await Promise.all([
        knex('wishlist').whereIn('varient_id', variantIds).where('user_id', user_id),
        knex('store_orders').whereIn('varient_id', variantIds).where('store_approval', user_id).where('order_cart_id', 'incart').whereNull('subscription_flag').where('store_id', store_id),
        knex('product_notify_me').whereIn('varient_id', variantIds).where('user_id', user_id),
        knex('store_orders').select('varient_id').whereIn('varient_id', variantIds).where('store_approval', user_id).where('subscription_flag', 1).where('order_cart_id', 'incart'),
        knex('deal_product').whereIn('varient_id', variantIds).where('store_id', store_id).where('deal_product.valid_from', '<=', new Date()).where('deal_product.valid_to', '>', new Date())
    ]);
  
    // Preprocess deal prices
    const dealMap = {};
    deals.forEach(deal => {
        dealMap[deal.varient_id] = deal.deal_price;
    });
  
    // Preprocess subscription data
    const subscriptionMap = {};
    subscriptionProducts.forEach(sub => {
        subscriptionMap[sub.varient_id] = true;
    });
  
    // Preprocess wishlist data
    const wishListMap = {};
    wishList.forEach(item => {
        wishListMap[item.varient_id] = true;
    });
  
    // Preprocess cart items
    const cartMap = {};
    cartItems.forEach(item => {
        cartMap[item.varient_id] = item.qty;
    });
  
    // Preprocess notify me data
    const notifyMeMap = {};
    notifyMeList.forEach(item => {
        notifyMeMap[item.varient_id] = true;
    });
  
    // Process products and construct response
    const customizedProductData = productDetail.map(product => {
        const isFavourite = wishListMap[product.varient_id] ? 'true' : 'false';
        const cartQty = cartMap[product.varient_id] || 0;
        const notifyMe = notifyMeMap[product.varient_id] ? 'true' : 'false';
        const isSubscription = subscriptionMap[product.varient_id] ? 'true' : 'false';
        const dealPrice = dealMap[product.varient_id];
        const price = dealPrice || product.price;
        
        const sub_price = (product.mrp * product.percentage) / 100;
        const subscription_price = parseFloat((product.mrp - sub_price).toFixed(2));
  
        const country_icon = product.country_icon ? baseurl + product.country_icon : null;

        if (Number.isInteger(price)) {
        priceval = price + '.001'
        }else{
        priceval = price
        }
        if (Number.isInteger(product.mrp)) {
        mrpval = product.mrp + '.001'
        }else{
        mrpval = product.mrp
        }
   
        return {
            p_id: product.p_id,
            varient_id: product.varient_id,
            stock: product.stock,
            store_id: product.store_id,
            price: parseFloat(priceval),
            mrp: parseFloat(mrpval),
            min_ord_qty: product.min_ord_qty,
            max_ord_qty: product.max_ord_qty,
            buyingprice:product.buyingprice,
            product_code: product.product_code,
            partner_id: product.partner_id,
            product_id: product.product_id,
            quantity: product.quantity,
            unit: product.prdunit,
            description: product.description,
            varient_image: product.varient_image,
            ean: product.ean,
            approved: product.approved,
            added_by:product.added_by,
            cat_id: product.cat_id,
            brand_id: product.brand_id,
            product_name: product.product_name,
            product_image: product.product_image+"?width=200&height=200&quality=100",
            type: product.type,
            hide:product.hide,
            percentage: product.percentage,
            isSubscription: isSubscription,
            subscription_price: subscription_price,
            availability: product.availability,
            discountper: product.discountper || 0,
            country_icon: country_icon,
            avgrating: 0, // Placeholder for ratings
            notify_me: notifyMe,
            isFavourite: isFavourite,
            cart_qty: cartQty,
            countrating: 0
        };
    });
  
    return customizedProductData;
};

const addNotifyMe = async (appDetatils) => {
// Destructure the necessary fields directly
const { product_id, varient_id, user_id, platform, fcmtoken } = appDetatils;
// Use the destructured variables directly in the insert query

// Check for existing record with same user_id, product_id, and varient_id
const existingEntry = await knex('product_notify_me')
.where({ user_id,varient_id})
.first();

if (existingEntry) {
// If a duplicate is found, return a message or handle it appropriately
throw new Error(`Notification already exists.`);
}

const insertNotifyMe = await knex('product_notify_me').insert({
user_id,
product_id,
varient_id,
platform,
fcmtoken,
});
return insertNotifyMe; // Return the result (e.g., insert ID or affected rows)
};


const deleteNotifyMe = async (appDetatils) => {
// Destructure the necessary fields directly
const { product_id, varient_id, user_id, platform, fcmtoken } = appDetatils;
// Use the destructured variables directly in the insert query
const deleteNotify = await knex('product_notify_me')
.where('varient_id',varient_id)
.where('user_id',user_id)
.delete();
return deleteNotify; // Return the result (e.g., insert ID or affected rows)
};
    

module.exports = {
showNotifyMe,
addNotifyMe,
deleteNotifyMe
};