// models/orderModel.js
const { application } = require('express');
const knex = require('../db'); // Import your Knex instance
const math = require('mathjs');  // If using a third-party math library
const { format } = require('date-fns');
const moment = require('moment');
const { cancelorderMail } = require('../sendGridService');
const { pauseorderMail } = require('../sendGridService');
const { resumeorderMail } = require('../sendGridService');
const { NULL } = require('mysql/lib/protocol/constants/types');

const totaldeliveries = async () => {
  
  return   ongoing =await knex('tbl_total_deliveries')
  .where('status','=',0)
  .orderBy('total_deliveries', 'ASC')

};
 
const grpordDetails = async (appDetatils) => {
   
    const { user_id ,group_id} = appDetatils;
    const ongoing  = await knex('orders')
    .join('users', 'orders.user_id', '=', 'users.id')
    .join('address', 'orders.address_id', '=', 'address.address_id')
    .where('orders.group_id', group_id)
    .orderBy('orders.order_id', 'desc');
    const customizedOrderData = [];
    for (let i = 0; i < ongoing.length; i++) {
          const ProductList = ongoing[i];
          const ordersss = await knex('store_orders')
          .where('order_cart_id', ProductList.cart_id)
          .select();

          const subscriptionOrderList = await knex('subscription_order')
          .where('cart_id', ProductList.cart_id)
          .where('order_status', 'Pending')
          .orderBy('delivery_date', 'asc')
          .first();
       
           const startDeliveryDate = subscriptionOrderList ? subscriptionOrderList.delivery_date : null;
        
          let total_price = 0;
        
          for (const store of ordersss) {
            if(store.repeat_orders){
            const repeat_orderss = store.repeat_orders.split(',').map(order => order.trim());
            total_delivery_week = repeat_orderss.length * ProductList.total_delivery;
            }else{
              const repeat_orderss = 1
              total_delivery_week = repeat_orderss * ProductList.total_delivery;
            }
            
            total_price += store.price * total_delivery_week;
          }


          const productDetails = await knex
          .select(
            'store_order_id',
            'product_name',
            'varient_image',
            'quantity',
            'unit',
            'varient_id',
            'qty',
            knex.raw('(price/qty) as price'),
            'total_mrp',
            'order_cart_id',
            'order_date',
            'repeat_orders',
            'type'
          )
          .from('store_orders')
          .where('order_cart_id', ProductList.cart_id);
           
          const customizedProductData = [];
              for (let j = 0; j < productDetails.length; j++) {
              const itemProduct = productDetails[j];
        
              const dataasss = await knex('product_varient')
              .select('*')
              .join('product', 'product.product_id', '=', 'product_varient.product_id')
              .where('product_varient.varient_id', '=', itemProduct.varient_id)
              .first();
        
                const currentDate = new Date();
                let next_delivery_date ='';
                const subscription_order_o = await knex('subscription_order')
                .where('store_order_id', itemProduct.store_order_id)
                .where('delivery_date', '>=', currentDate)
                .where('order_status', 'Pending')
                .first();
        
                next_delivery_date = subscription_order_o ? subscription_order_o.delivery_date : undefined;
        
                let orderStatusDelivery;
        
                if (next_delivery_date) {
                  next_delivery_date = format(next_delivery_date, 'yyyy-MM-dd');
                orderStatusDelivery = 'Active';
                } else {
                const subscription_order_completed = await knex('subscription_order')
                .where('store_order_id', itemProduct.store_order_id)
                .where('order_status', 'Completed')
                .select('*');
        
                const subscription_order_pending = await knex('subscription_order')
                .where('store_order_id', itemProduct.store_order_id)
                .where('order_status', 'Pending')
                .select('*');
        
                if (subscription_order_completed.length > 0 || subscription_order_pending.length > 0) {
                orderStatusDelivery = 'Completed';
                } else {
                
                const subscription_order_cancelled = await knex('subscription_order')
                .where('store_order_id', itemProduct.store_order_id)
                .where('order_status', 'Cancelled')
                .select('*');   
                
                if (subscription_order_cancelled.length > 0 ){
               // orderStatusDelivery = 'Cancelled';
                 orderStatusDelivery = '';
                }else
                {
                orderStatusDelivery = 'Pending';    
                }
                
                }
                next_delivery_date='';
                }
              //  return ongoing.order_status
                if(ongoing.order_status == 'Cancelled'){
                  orderStatusDelivery = 'Cancelled'
                }
        
                const baseurl =  process.env.BUNNY_NET_IMAGE;
              const customizedProduct = {
                store_order_id: itemProduct.store_order_id,
                product_name: itemProduct.product_name,        
                varient_image: baseurl + itemProduct.varient_image,
                thumbnail: baseurl + dataasss.thumbnail,
                unit: itemProduct.unit,
                varient_id: itemProduct.orderStatusDeliveryvarient_id,
                qty: itemProduct.qty,
                price: itemProduct.price,
                total_mrp: itemProduct.total_mrp,
                order_date: itemProduct.order_date,
                repeat_orders: itemProduct.repeat_orders,
                type: itemProduct.type,
                order_status_delivery:orderStatusDelivery,
                next_delivery_date:next_delivery_date,
                // Add or modify properties as needed
                };
                
        
        
              customizedProductData.push(customizedProduct);  
              }

              let startDeliveryDates = startDeliveryDate ? format(startDeliveryDate, 'yyyy-MM-dd') : "null";
              let order_date = format(ProductList.order_date, 'yyyy-MM-dd');
          const customizedProduct = {
            address_name : ProductList.receiver_name,
             delivery_address: ProductList.building_villa+","+ProductList.street+","+ProductList.society+","+ProductList.city,
             order_status: ProductList.order_status,
             delivery_date:startDeliveryDates,
             time_slot: ProductList.time_slot,
             payment_method: ProductList.si_order == 'no' ? 'Wallet' : 'Card Payment',
             cart_id: ProductList.cart_id,
             total_price:total_price,
             delivery_charge: ProductList.delivery_charge,
             coupon_discount: ProductList.coupon_discount,
             price_without_delivery:total_price,
             user_id: ProductList.user_id,
             total_products_mrp:total_price,
             cancelling_reason: ProductList.cancelling_reason,
             order_date: order_date,
             coupon_id: ProductList.coupon_id,
             is_subscription: ProductList.is_subscription,
             total_delivery: ProductList.total_delivery,
             repeat_orders: ProductList.repeat_orders,
             si_order: ProductList.si_order,
             data:customizedProductData,
            };

         
            customizedOrderData.push(customizedProduct);  

    }

    return customizedOrderData



};
 
const getCancelquickOrderProd  = async (appDetatils) => {
  const user_id = appDetatils.user_id
  const cart_id =appDetatils.cart_id
  const cancel_reason=appDetatils.cancel_reason;

  if(cart_id && user_id ){

  // Check if there are any orders that are not already cancelled
  const existingOrders = await knex('orders')
  .where('cart_id', cart_id)
  .where('order_status', 'Cancelled')
  .first();
  // If there are no orders to cancel, return a message
  if (existingOrders) {
  throw new Error('Order are already cancelled.');
  }


  subcription_data = await knex('subscription_order')
  .where('cart_id', cart_id)
  .where('order_status', 'Pending')
  // .where('si_payment_flag', 'no')
  // .where('processing_product','!=','1')
  .update({'cancel_reason':cancel_reason,
  'order_status':"Cancelled"});
    
  order_data = await knex('orders')
  .where('cart_id', cart_id)
  //.where('group_id', group_id)
  .where('order_status', 'Pending')
  // .where('payment_status','!=','success')
  .update({'order_status':"Cancelled"});

  //After cancelled order wallet amount save 
  const orderDetail = await knex('orders')
  .where('cart_id', cart_id)
  .select('payment_method','user_id','group_id','coupon_code')
  .first(); 
  const groupID=orderDetail.group_id;
  const couponCode=orderDetail.coupon_code;
  const userId =appDetatils.user_id;

  const orderDetails = await knex('orders')
  .select('*')
  .where('group_id', groupID);


  
  const storeDetailsAmtAll = await knex('orders')
  .where('group_id', groupID)
  .select(knex.raw('SUM(orders.cod_charges) as codCharges'),knex.raw('SUM(orders.del_partner_tip) as delPartnerTip'),knex.raw('SUM(orders.paid_by_wallet) as paid_by_wallet'),'payment_method')
  .first();
  const paidByWallet=parseFloat(storeDetailsAmtAll.paid_by_wallet).toFixed(2);
   let WalletAddtoUserAccount=0;
   let FinalWalletAmountUse=0;
   for (const orders of orderDetails) {
     const cartID=orders.cart_id;
    if(orders.payment_method == 'COD')
    {
        //COD Code Write
        const storeOrderDetails = await knex('store_orders')
        .where('order_cart_id', cartID)
        .select('*')
        .first(); 

        const storeDetailsAmt = await knex('store_orders')
        .join('orders','orders.cart_id','store_orders.order_cart_id')
        .where('group_id', groupID)
        .whereNot('orders.order_status', 'Cancelled')
        .select(knex.raw('SUM(store_orders.total_mrp) as Totalmrp'),knex.raw('SUM(store_orders.price) as Totalprice'))
        .first(); 
        
        
        const TotalpriceStore=storeDetailsAmt.Totalprice;
        const TotalmrpStore=storeDetailsAmt.Totalmrp;

        const CouponDis = await knex('store_orders')
        .join('orders','orders.cart_id','store_orders.order_cart_id')
        .sum({ total_price: 'price' })
        .where('price', '=', knex.ref('total_mrp'))
        .where('group_id', groupID)
        .whereNot('orders.order_status', 'Cancelled')
        .first();
        
        if(orders.order_status == 'Cancelled')
        {
          const totalPrice=storeOrderDetails.price;
          await knex('orders')
          .where('cart_id',cartID)
          .update({
          'total_price':parseFloat(totalPrice).toFixed(2),
          'price_without_delivery':parseFloat(totalPrice).toFixed(2),
          'total_products_mrp':parseFloat(totalPrice).toFixed(2)
          }); 

        }else
        {

          const totalPrice=storeOrderDetails.price;
          const totalMRP=storeOrderDetails.total_mrp;
          const codCharges=Math.round(storeDetailsAmtAll.codCharges);
          const delPartnerTip=Math.round(storeDetailsAmtAll.delPartnerTip);
          
          
          let couponDiscount=0;
          let couponDiscounts=0;
          if(couponCode){
          const couponDetails = await knex('coupon')
          .where('coupon_code', couponCode)
          .select('*')
          .first();
          couponDiscount=(parseFloat(totalPrice) == parseFloat(totalMRP)) ? ((totalPrice*couponDetails.amount)/100) : 0;
          couponDiscounts=(parseFloat(CouponDis.total_price) > 0 ) ? ((parseFloat(CouponDis.total_price)*couponDetails.amount)/100) : 0;
          }

          const TotalPriceOrders=((parseFloat(TotalpriceStore)-couponDiscounts)+parseFloat(codCharges)+parseFloat(delPartnerTip));
          const WalletDiscount=parseFloat(TotalPriceOrders)*50/100;
          WalletAddtoUserAccount=(paidByWallet > WalletDiscount) ? (paidByWallet-WalletDiscount):0;
          const WalletUseOrder=(WalletAddtoUserAccount == 0 && paidByWallet) ? (paidByWallet):(paidByWallet-WalletDiscount);
          const codorderamt = codCharges ? (totalPrice * codCharges / TotalpriceStore) : 0;
          const delPartnerTipAmt = delPartnerTip ? (totalPrice * delPartnerTip / TotalpriceStore) : 0;
          const totalPriceAmt=(parseFloat(totalPrice)-parseFloat(couponDiscount))+parseFloat(codorderamt)+parseFloat(delPartnerTipAmt);
          if(paidByWallet > 0){
          FinalWalletAmountUse=(WalletAddtoUserAccount > 0) ? ((((parseFloat(totalPrice)-parseFloat(couponDiscount))+parseFloat(codorderamt)+parseFloat(delPartnerTipAmt)) * 50) / 100) : (((parseFloat(totalPrice)-parseFloat(couponDiscount))+parseFloat(codorderamt)+parseFloat(delPartnerTipAmt)) * parseFloat(paidByWallet) / parseFloat(TotalpriceStore));
          }

           
          await knex('orders')
          .where('cart_id',cartID)
          .update({
          'total_price':parseFloat(totalPriceAmt).toFixed(2),
          'price_without_delivery':parseFloat(totalPriceAmt).toFixed(2),
          'total_products_mrp':parseFloat(totalPriceAmt).toFixed(2),
          'paid_by_wallet':parseFloat(FinalWalletAmountUse).toFixed(2),
          'rem_price':(parseFloat(totalPriceAmt)-parseFloat(FinalWalletAmountUse)).toFixed(2),
          'coupon_discount':parseFloat(couponDiscount).toFixed(2),
          'cod_charges':parseFloat(codorderamt).toFixed(2),
          'del_partner_tip':parseFloat(delPartnerTipAmt).toFixed(2),
          });

        }

    }else
    {
      
      //CARD Code Write
      const storeOrderDetails = await knex('store_orders')
      .where('order_cart_id', cartID)
      .select('*')
      .first(); 

      const storeDetailsAmt = await knex('store_orders')
      .join('orders','orders.cart_id','store_orders.order_cart_id')
      .where('group_id', groupID)
      .whereNot('orders.order_status', 'Cancelled')
      .select(knex.raw('SUM(store_orders.total_mrp) as Totalmrp'),knex.raw('SUM(store_orders.price) as Totalprice'))
      .first(); 
      
      const TotalpriceStore=storeDetailsAmt.Totalprice;
      const TotalmrpStore=storeDetailsAmt.Totalmrp;
     
      const CouponDis = await knex('store_orders')
        .join('orders','orders.cart_id','store_orders.order_cart_id')
        .sum({ total_price: 'price' })
        .where('price', '=', knex.ref('total_mrp'))
        .where('group_id', groupID)
        .whereNot('orders.order_status', 'Cancelled')
        .first();
      
      

      if(orders.order_status == 'Cancelled')
      {
        const totalPrice=storeOrderDetails.price;
        const totalMrp=storeOrderDetails.total_mrp;
        await knex('orders')
        .where('cart_id',cartID)
        .update({
        'total_price':totalPrice,
        'price_without_delivery':totalPrice,
        'total_products_mrp':totalPrice
        }); 


        let couponDiscount=0;
        let couponDiscounts=0;
        if(couponCode){
        const couponDetails = await knex('coupon')
        .where('coupon_code', couponCode)
        .select('*')
        .first();
        // couponDiscount=(totalPrice*couponDetails.amount)/100;
        couponDiscount=(parseFloat(totalPrice) == parseFloat(totalMrp)) ? ((totalPrice*couponDetails.amount)/100) : 0;

        }
        
        if(cartID == cart_id){
          let deliveryPT=0;
          const result = await knex('orders')
          .where('group_id',groupID)
          .where('order_status','Cancelled')
          .count({ cancelled_count: 'order_id' });
          
          const cancelledCount=result[0].cancelled_count;
       
          const resultAll = await knex('orders')
          .where('group_id',groupID)
          .count({ all_count: 'order_id' });
          
          const allCount=resultAll[0].all_count;

        const OrdersDetailsAmt = await knex('orders')
        .where('group_id', groupID)
        .select(knex.raw('SUM(orders.del_partner_tip) as delPartnerTip'))
        .first(); 
          
          if(cancelledCount == allCount)
          {
           deliveryPT=OrdersDetailsAmt.delPartnerTip;
          }  
        const TotalPriceOrdersAmt=((parseFloat(totalPrice)-parseFloat(couponDiscount)))+parseFloat(deliveryPT);
        const user = await knex('users')
        .select('user_phone', 'wallet')
        .where('id', userId)
        .first();
        let actualWallet=user.wallet+TotalPriceOrdersAmt;
    
        await knex('users')
        .where('id', userId)
        .update({
        'wallet':actualWallet,
        }); 
    
        await knex('wallet_history').insert({
        user_id: userId,
        amount: TotalPriceOrdersAmt.toFixed(2),
        resource: 'order_refund_cancelled',
        type:'Add',
        group_id:groupID,
        cart_id:cartID,
        });
      }

      }else
      {
        const storeDetailsAmt = await knex('orders')
        .where('group_id', groupID)
        .select(knex.raw('SUM(orders.cod_charges) as codCharges'),knex.raw('SUM(orders.del_partner_tip) as delPartnerTip'),knex.raw('SUM(orders.paid_by_wallet) as paid_by_wallet'))
        .first();

        const totalPrice=storeOrderDetails.price;
        const totalMRP=storeOrderDetails.total_mrp;
        const codCharges=Math.round(storeDetailsAmt.codCharges);
        const delPartnerTip=Math.round(storeDetailsAmt.delPartnerTip);
        const paidByWallet=Math.round(storeDetailsAmt.paid_by_wallet);
        
        let couponDiscount=0;
        let couponDiscounts=0;
        if(couponCode){
        const couponDetails = await knex('coupon')
        .where('coupon_code', couponCode)
        .select('*')
        .first();
        couponDiscount=(parseFloat(totalPrice) == parseFloat(totalMRP)) ? ((totalPrice*couponDetails.amount)/100) : 0;
        couponDiscounts=(parseFloat(CouponDis.total_price) > 0 ) ? ((parseFloat(CouponDis.total_price)*couponDetails.amount)/100) : 0;
      }
        let FinalWalletAmountUse=0;
        const TotalPriceOrders=((parseFloat(TotalpriceStore)-couponDiscounts)+parseFloat(codCharges)+parseFloat(delPartnerTip));
        const WalletDiscount=parseFloat(TotalPriceOrders)*50/100;
        WalletAddtoUserAccount=(paidByWallet > WalletDiscount) ? (paidByWallet-WalletDiscount):0;
        const WalletUseOrder=(WalletAddtoUserAccount == 0 && paidByWallet) ? (paidByWallet):(paidByWallet-WalletDiscount);
        const codorderamt = codCharges ? (totalPrice * codCharges / TotalpriceStore) : 0;
        const delPartnerTipAmt = delPartnerTip ? (totalPrice * delPartnerTip / TotalpriceStore) : 0;
        const totalPriceAmt=(parseFloat(totalPrice)-parseFloat(couponDiscount))+parseFloat(codorderamt)+parseFloat(delPartnerTipAmt);
        if(paidByWallet > 0){
          FinalWalletAmountUse=(WalletAddtoUserAccount > 0) ? ((((parseFloat(totalPrice)-parseFloat(couponDiscount))+parseFloat(codorderamt)+parseFloat(delPartnerTipAmt)) * 50) / 100) : (((parseFloat(totalPrice)-parseFloat(couponDiscount))+parseFloat(codorderamt)+parseFloat(delPartnerTipAmt)) * parseFloat(paidByWallet) / parseFloat(TotalpriceStore));
        }

        await knex('orders')
        .where('cart_id',cartID)
        .update({
        'total_price':totalPriceAmt,
        'price_without_delivery':totalPriceAmt,
        'total_products_mrp':totalPriceAmt,
        'paid_by_wallet':FinalWalletAmountUse,
        'rem_price':0,
        'coupon_discount':couponDiscount,
        'cod_charges':codorderamt,
        'del_partner_tip':delPartnerTipAmt,
        }); 
      }


    }

   }

   const result = await knex('orders')
   .where('group_id',groupID)
   .where('order_status','Cancelled')
   .count({ cancelled_count: 'order_id' });
   
   const cancelledCount=result[0].cancelled_count;

   const resultAll = await knex('orders')
   .where('group_id',groupID)
   .count({ all_count: 'order_id' });
   
   const allCount=resultAll[0].all_count;
   
   if(cancelledCount == allCount)
   {
    WalletAddtoUserAccount=paidByWallet;
   }

  if(WalletAddtoUserAccount > 0 && storeDetailsAmtAll.payment_method == 'COD'){  
    const user = await knex('users')
    .select('user_phone', 'wallet')
    .where('id', userId)
    .first();
    let actualWallet=parseFloat(user.wallet)+parseFloat(WalletAddtoUserAccount);

    await knex('users')
    .where('id', userId)
    .update({
    'wallet':actualWallet,
    }); 

    await knex('wallet_history').insert({
    user_id: userId,
    amount: parseFloat(WalletAddtoUserAccount).toFixed(2),
    resource: 'order_refund_cancelled',
    type:'Add',
    group_id:groupID,
    cart_id:'',
    });
  }

  await knex('orders')
  .where('group_id',groupID)
  .where('order_status','Cancelled')
  .update({
  'del_partner_tip':0,
  'coupon_discount':0,
  'cod_charges':0,
  'reserve_amount':0,
  'paid_by_wallet':0,
  'rem_price':0
  }); 
  

}


//Email Code
storeOrders = await knex('store_orders')
.select('store_orders.*','orders.group_id','orders.time_slot')
.join('orders', 'orders.cart_id', '=', 'store_orders.order_cart_id')
.where('store_orders.order_cart_id', cart_id)

// Fetch user phone and wallet
const user = await knex('users')
.select('name','email')
.where('id', user_id)
.first();
let userName=user.name;
let userEmail=user.email;


const orderDetail = await knex('orders')
.where('cart_id', cart_id)
.select('group_id')
.first(); 
const group_id=orderDetail.group_id;

const logo = await knex('tbl_web_setting').first();
const appName = logo ? logo.name : null;
// Fetching the first record from the 'currency' table
const currency = await knex('currency').first();
const currencySign = currency ? currency.currency_sign : null;
const templateData = {
baseurl: process.env.base_url,
user_name:userName,
user_email:userEmail,
store_orderss:storeOrders,
final_amount:"",
app_name:appName,
currency_sign:currencySign,
cart_id:group_id
};
const subject = 'Delivery Order Cancelled'
// Trigger the email after order is placed
sendCancelledEmail = await cancelorderMail(userEmail, templateData,subject);

};

const getSubresumeorder = async (appDetatils) => {
  // cart_id=appDetatils.cart_id;
   subscription_id=appDetatils.subscription_id;
   cart_id=appDetatils.cart_id;
    // time_slot = appDetatils.time_slot;
   delivery_date = appDetatils.delivery_date;
   today_date= new Date();

   const pausecount = await knex('subscription_order')
                      .where('cart_id',cart_id)
                      .where('id',subscription_id)
                      .where('order_status','Pause');

    const subscriptionOrdersDetails = await knex('subscription_order')
    .where('cart_id',cart_id)
    .first();

    if(pausecount.length > 0){
         // const oldsData = await knex('subscription_order')
          //.where('subscription_id',subscription_id)
          //.where('cart_id', cart_id)
          //.where('order_status','Pending')
          //.delete();

          const Pending_Orders = await knex('subscription_order')
          .where('cart_id',cart_id)
          .where('id',subscription_id)
          .where('order_status','Pause')
          .update({
            'order_status': "Pending",
            'delivery_date':delivery_date,
            'time_slot':subscriptionOrdersDetails.time_slot
          });

        //Email Code
        const groupID = (subscriptionOrdersDetails.group_id) ? subscriptionOrdersDetails.group_id :subscriptionOrdersDetails.cart_id;
        const date = new Date(delivery_date);
        // Format the date to keep only the date part (Day, Month, Date, Year)
        const resumeformattedDate = date.toDateString();
        const resumedayOfWeek = date.toLocaleDateString('en-US', { weekday: 'short' });
        const storeOrders = await knex('store_orders')
        .select('store_orders.*','orders.group_id','orders.time_slot')
        .join('orders', 'orders.cart_id', '=', 'store_orders.order_cart_id')
        .where('orders.cart_id', cart_id)
        
        let userName="Store";
        let userEmail='store1@quickart.ae';
        const logo = await knex('tbl_web_setting').first();
        const appName = logo ? logo.name : null;
        // Fetching the first record from the 'currency' table
        const currency = await knex('currency').first();
        const currencySign = currency ? currency.currency_sign : null;
        const templateData = {
        baseurl: process.env.base_url,
        user_name:userName,
        user_email:userEmail,
        store_orderss:storeOrders,
        final_amount:"",
        app_name:appName,
        currency_sign:currencySign,
        cart_id:groupID,
        resume_data_deliveryss:resumeformattedDate,
        resumedayOfWeek :resumedayOfWeek
        };
        const subject = 'Order Resumed'
        // Trigger the email after order is placed
        sendPausedEmail = await resumeorderMail(userEmail, templateData,subject);
        return 1
    }else{
      throw new Error('No Orders Pause Yet');
    }
};

const getCancelquickOrder  = async (appDetatils) => {
const user_id = appDetatils.user_id
// cart_id =appDetatils.cart_id
const  group_id =appDetatils.group_id
const cancel_reason=appDetatils.cancel_reason;
const groupID =appDetatils.group_id


  //After cancelled order wallet amount save 
  const orderDetails = await knex('orders')
  .where('group_id', group_id)
  .where('order_status', 'Pending')
  .select(knex.raw('SUM(orders.total_products_mrp) as total_products_mrp'),knex.raw('SUM(orders.paid_by_wallet) as paid_by_wallet'),'payment_method','user_id')
  .first(); 
  const paymentMethod=orderDetails.payment_method;
  const userId=orderDetails.user_id;
  const totalProductsMrp=orderDetails.total_products_mrp;
  const paidByWallet=orderDetails.paid_by_wallet;

  if(group_id && user_id ){
   
  // Check if there are any orders that are not already cancelled
  const existingOrders = await knex('orders')
  .where('group_id', group_id)
  .whereNot('order_status', 'Cancelled')
  .pluck('order_id');

  // If there are no orders to cancel, return a message
  if (existingOrders.length === 0) {
  throw new Error('All orders are already cancelled.');
  }

   
    order_data = await knex('orders')
              .where('group_id', group_id)
              .pluck('order_id');

    subcription_data = await knex('subscription_order')
    //.where('cart_id', cart_id)
    .whereIn('order_id',order_data)
    .where('order_status', 'Pending')
    // .where('si_payment_flag', 'no')
    // .where('processing_product','!=','1')
    .update({'cancel_reason':cancel_reason,
              'order_status':"Cancelled"});
    
   order_data = await knex('orders')
              //.where('cart_id', cart_id)
              .where('group_id', group_id)
              .where('order_status', 'Pending')
             // .where('payment_status','!=','success')
              .update({'order_status':"Cancelled"});

  
  // return paymentMethod;
  if(paymentMethod != 'COD')
  {
    
    const user = await knex('users')
    .select('user_phone', 'wallet')
    .where('id', userId)
    .first();
    let actualWallet=user.wallet+totalProductsMrp;

    await knex('users')
    .where('id', userId)
    .update({
    'wallet':actualWallet,
    }); 

    await knex('wallet_history').insert({
    user_id: userId,
    amount: totalProductsMrp.toFixed(2),
    resource: 'order_refund_cancelled',
    type:'Add',
    group_id:group_id,
    cart_id:''
    });
  }else
  {
    if(paidByWallet > 0){
    const user = await knex('users')
    .select('user_phone', 'wallet')
    .where('id', userId)
    .first();
    let actualWallet=parseFloat(user.wallet)+parseFloat(paidByWallet);

    await knex('users')
    .where('id', userId)
    .update({
    'wallet':actualWallet,
    }); 

    await knex('wallet_history').insert({
    user_id: userId,
    amount: paidByWallet.toFixed(2),
    resource: 'order_refund_cancelled',
    type:'Add',
    group_id:group_id,
    cart_id:''
    });
  }
  }

  }

  await knex('orders')
  .where('group_id',groupID)
  .where('order_status','Cancelled')
  .update({
  'paid_by_wallet':0,
  'rem_price':0
  }); 


//Email Code
storeOrders = await knex('store_orders')
.select('store_orders.*','orders.group_id','orders.time_slot')
.join('orders', 'orders.cart_id', '=', 'store_orders.order_cart_id')
.where('orders.group_id', group_id)

// Fetch user phone and wallet
const user = await knex('users')
.select('name','email')
.where('id', user_id)
.first();
let userName=user.name;
let userEmail=user.email;

const logo = await knex('tbl_web_setting').first();
const appName = logo ? logo.name : null;
// Fetching the first record from the 'currency' table
const currency = await knex('currency').first();
const currencySign = currency ? currency.currency_sign : null;
const templateData = {
baseurl: process.env.base_url,
user_name:userName,
user_email:userEmail,
store_orderss:storeOrders,
final_amount:"",
app_name:appName,
currency_sign:currencySign,
cart_id:group_id
};
const subject = 'Delivery Order Cancelled'
// Trigger the email after order is placed
sendCancelledEmail = await cancelorderMail(userEmail, templateData,subject);

};
 
const getMydailyOrder = async (appDetatils) => {
  await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
    const { user_id ,page,perpage} = appDetatils;
    const pageFilter = page; // You can adjust the page number dynamically
    const perPage = perpage;

    let ongoing = await knex('orders')
    .select('orders.group_id','orders.time_slot',knex.raw('DATE_FORMAT(orders.delivery_date, "%Y-%m-%d") as delivery_date'),'orders.cart_id',knex.raw('DATE_FORMAT(orders.order_date, "%Y-%m-%d") as order_date'),'orders.coupon_discount','orders.total_products_mrp as price_without_delivery','orders.user_id','orders.is_subscription','orders.si_order','orders.bank_id','orders.order_status')
    .where('orders.user_id', user_id)
    .whereNot('orders.order_status', null)
    .where('orders.is_subscription', null)
   // .where('orders.group_id', null)
    .whereNotNull('orders.payment_method')
    .orderBy('orders.order_id', 'desc')
    .groupBy('orders.group_id')
    .offset((pageFilter - 1) * perPage)
    .limit(perPage);
    

 
    const customizedProductData = [];
    if(ongoing){
       for (let j = 0; j < ongoing.length; j++) {
        
              const prd = ongoing[j];
              let ordstatus;

            const orderDatailss = await knex('orders')
            .where('group_id', prd.group_id);
     
            for (const orders of orderDatailss) {
            if(orders.order_status == 'Completed' || orders.order_status == 'Confirmed' || orders.order_status == 'Out_For_Delivery' || orders.order_status == 'Pending'){
            if(orders.order_status == 'Completed'){
            ordstatus = 'Completed'
            } 
            if(orders.order_status == 'Confirmed'){
            ordstatus = 'Confirmed'
            }
            if(orders.order_status == 'Out_For_Delivery'){
            ordstatus = 'Out_For_Delivery'
            }
            if(orders.order_status == 'Pending'){
            ordstatus = 'In Progress'
            }
            break;
          }else
          {
            ordstatus = 'Cancelled'
          }
          }
    
         
         ongoinglist = await knex('orders')
         .where('group_id', prd.group_id)
        // .sum('total_products_mrp as total');
        .sum('total_products_mrp as total_products_mrp')
        .sum('rem_price as rem_price')
       .sum('paid_by_wallet as paid_by_wallet')
       .sum('cod_charges as cod_charges')
       .sum('coupon_discount as coupon_discount')
       .sum('del_partner_tip as del_partner_tip');
       
       
 
          //return ongoinglist
        // price_without_delivery = ongoinglist[0].rem_price + ongoinglist[0].paid_by_wallet + ongoinglist[0].cod_charges;

        //  price_without_delivery = ongoinglist[0].rem_price + ongoinglist[0].paid_by_wallet;
        price_without_delivery = ongoinglist[0].total_products_mrp;
        total_products_mrp = ongoinglist[0].total_products_mrp;

         famount =  parseFloat(price_without_delivery.toFixed(2));


         const productDetails = await knex('orders')
         .select(knex.raw(`GROUP_CONCAT(CONCAT(store_orders.product_name, ' X ', store_orders.qty)) as product_details`))
         .join('store_orders', 'orders.cart_id', 'store_orders.order_cart_id')
         .where('orders.group_id', prd.group_id)
         .first();


         const customizedData = {
           group_id:prd.group_id,
           cart_id: prd.cart_id,
           order_date: prd.order_date,        
           coupon_discount: prd.coupon_discount,
         //  price_without_delivery: prd.price_without_delivery,
          // price_without_delivery: ongoinglist[0].total.toFixed(2),
           price_without_delivery: famount,
           user_id: prd.user_id,
           is_subscription: prd.is_subscription,
           si_order: prd.si_order,
           bank_id: prd.bank_id,
           order_status: ordstatus,
           time_slot:prd.time_slot,
           delivery_date:prd.delivery_date,
           productname:productDetails.product_details
           
           };
           
   
   
         customizedProductData.push(customizedData);  
       }
    }
       return customizedProductData
     //return ongoing;
};

const getSubpauseorder = async (appDetatils) => {
 // cart_id=appDetatils.cart_id;
  let order_id;
  subscription_id=appDetatils.subscription_id;
  pause_reason=appDetatils.pause_reason;
  cart_id=appDetatils.cart_id;
  store_order_id=appDetatils.store_order_id;
  group_id = appDetatils.group_id;
  today_date= new Date();
  // Extract the date parts
const year = today_date.getFullYear();
const month = String(today_date.getMonth() + 1).padStart(2, '0'); // getMonth() is zero-based
const day = String(today_date.getDate()).padStart(2, '0');


const SubscriptionOrdersList = await knex('subscription_order')
.select('*')
.where('id',subscription_id)
.where('cart_id',cart_id)
.where('si_payment_flag','yes');


const OrdersList = await knex('orders')
.select('*')
.where('payment_method','Card')
.where('cart_id',cart_id)
.where('si_order','no');



// if(OrdersList.length > 0){
// return "Payment has already been made, This order should not be paused.";
// }

// if(SubscriptionOrdersList.length > 0){
// return "Payment has already been made, This order should not be paused.";
// }




// Format the date as 'YYYY-MM-DD'
const formattedDate = `${year}-${month}-${day}`;

  const oldsData = await knex('subscription_order')
  .select('id')
  .where({
    store_order_id: store_order_id,
    order_status: 'Pause'
  });

   // Step 2: Extract `id` values from the query result
   const subscriptionIdOlds = oldsData.map(row => row.id);
   

   // Step 3: Create comma-separated strings and arrays
   const subscriptionIdOld = subscriptionIdOlds.join(',');
   const subscriptionIdNew = subscription_id.split(',');

   // Step 4: Convert to arrays and sort
   let subscriptionIdOld1 = subscriptionIdOld.split(',');
   let subscriptionIdNew1 = subscription_id.split(',');

   subscriptionIdOld1.sort();
   subscriptionIdNew1.sort();

   // Optional: re-index arrays (sort already returns a re-indexed array in JavaScript)
   subscriptionIdOld1 = Array.from(subscriptionIdOld1);
   subscriptionIdNew1 = Array.from(subscriptionIdNew1);


       
    //Pause Order functionality  Start
    
    let new_arr_pause = [];
    for (let i = 0; i < subscriptionIdNew1.length; i++) {
      let subscriptionIdNew12 = '';
      for (let kj = 0; kj < subscriptionIdOld1.length; kj++) {
          if (subscriptionIdNew1[i].trim() === subscriptionIdOld1[kj].trim()) {
              subscriptionIdNew12 = subscriptionIdOld1[kj].trim();
              break;
          }
      }
      if (subscriptionIdNew12 !== subscriptionIdNew1[i].trim()) {
        new_arr_pause.push(subscriptionIdNew1[i].trim());
      }
    }

    
    //Pause Order functionality  End 
    
    //Resume Order functionality  Start 
    
    
    new_arr_resume=[];
    for(let ii=0; ii < subscriptionIdOld1.length ; ii++)
    {
      //return subscriptionIdNew1
      subscription_id_new122='';
      for(let kjj=0;kjj<subscriptionIdNew1.length;kjj++){
      if(subscriptionIdOld1[ii].trim() == subscriptionIdNew1[kjj].trim())
      {
      subscription_id_new122=subscriptionIdNew1[kjj].trim();
      }
      }
      if(subscription_id_new122 != subscriptionIdOld1[ii].trim()){
      new_arr_resume.push(subscriptionIdOld1[ii].trim());
      }
    }
    
    
    pause_data_deliveryss1=new_arr_pause;     
    resume_data_deliveryss1=new_arr_resume;   

  //  return resume_data_deliveryss1

   // return pause_data_deliveryss1;
    let resume_idss = resume_data_deliveryss1.join("','");
    let pause_idss = pause_data_deliveryss1.join("','");
    let resume_idsss = "'" + resume_idss + "'";
    let pause_idsss = "'" + pause_idss + "'";
   
    const pause_dataa = await knex('subscription_order')
    .select('delivery_date', 'time_slot', 'user_id')
    //.whereIn('id', pause_idsss.split(',').map(id => id.replace(/'/g, '')));
    .whereIn('id',pause_data_deliveryss1)
   
  // Process the results
  const pause_data_delivery = pause_dataa.map(row => moment(row.delivery_date).format('DD MMMM'));
   
  const  pause_data_deliveryss12=pause_data_delivery.join(' & ');

   // Query the database
   const resumeDataa = await knex('subscription_order')
   .select('delivery_date', 'time_slot', 'user_id')
   //.whereIn('id', resume_idsss);
   .whereIn('id',resume_data_deliveryss1)

    // Process the results
    const resume_data_delivery = resumeDataa.map(row => moment(row.delivery_date).format('DD MMMM'));

 // Join the formatted dates with " & "
 const resume_data_deliveryss12 = resume_data_delivery.join(' & ');
  
    
   
  //  Pending_Orders= await knex('subscription_order')
  //  .where('cart_id',cart_id)
  //  .where('store_order_id',store_order_id)
  //  //.where('delivery_date','>',today_date)
  //  .where('delivery_date','>',formattedDate)
  //  .where('order_status1','!=','Cancelled')
  //  .update({'order_status': "Pending",
  //  'pause_reason' :""});  
   
  //  const Pending_Orders = await knex('subscription_order')
  //   .where('cart_id',cart_id)
  //   .where('store_order_id',store_order_id)
  //   .where('delivery_date', '>', formattedDate)
  //   .where('order_status','!=','Cancelled')
  //   .update({
  //     'pause_reason': "abcd",
  //     'order_status': "Pending"
  //   });
   
  //  sub_order=subscription_id.split(',');
   
  //  for (let i = 0; i < sub_order.length; i++) 
  //  {
   
  //  sub_order_id=sub_order[i];
  //  pause_order= await knex('subscription_order')
  //  .where('id',sub_order_id)
  //  .where('delivery_date','>',today_date)
  //  .update({'pause_reason':pause_reason,
  //  'order_status':"Pause"});
  //  } 

   const sub_order = subscription_id.split(',').map(id => id.trim());

   for (let i = 0; i < sub_order.length; i++) {
    //return 567;
     const sub_order_id = sub_order[i];
    // return sub_order_id
     const pause_order = await knex('subscription_order')
       .where('id', sub_order_id)
       .where('delivery_date', '>', formattedDate)
       .update({
         'pause_reason': pause_reason,
         'order_status': "Pause"
       });
      }


    // Fetch ongoing orders
    const ongoings = await knex('orders')
      .join('store', 'orders.store_id', '=', 'store.id')
      .join('users', 'orders.user_id', '=', 'users.id')
      .join('address', 'orders.address_id', '=', 'address.address_id')
      .leftJoin('delivery_boy', 'orders.dboy_id', '=', 'delivery_boy.dboy_id')
      .where('orders.cart_id', cart_id)
      .whereNot('orders.order_status', 'NULL')
      .whereNotNull('orders.payment_method')
      .orderBy('orders.order_id', 'DESC')
      .first();

      //return ongoings

    // Fetch subscription orders
    const subscription_orders = await knex('subscription_order')
      .where('subscription_order.cart_id', cart_id)
      .where('store_order_id', store_order_id)
      .orderBy('subscription_order.id', 'DESC')
      .first();

    //  return subscription_orders

    // Fetch store details
    const store_details = await knex('store_orders')
      .where('store_order_id', store_order_id)
      .first();


      
    // Subscription Module
   // return sub_order
    order_id=ongoings.order_id;
    datess=subscription_orders.delivery_date;
    repeat_orders=store_details.repeat_orders;
  
    total_delivery=sub_order.length;
    is_subscription=1;
    created_at = today_date;
    
    // $pause_total = DB::table('subscription_order')
    // ->where('subscription_order.cart_id',$cart_id)
    // ->where('store_order_id',$store_order_id)
    // ->where(function ($query) {
    // $query->where('subscription_order.order_status','=','Pause')
    // ->orWhere('subscription_order.order_status','=','pause');
    // })            
    // ->get();

    const pause_total = await knex('subscription_order')
  .where('subscription_order.cart_id', cart_id)
  .andWhere('store_order_id', store_order_id)
  .andWhere(function() {
    this.where('subscription_order.order_status', '=', 'Pause')
      .orWhere('subscription_order.order_status', '=', 'pause');
  })
  .select();
    
   
    other_total =  await knex('subscription_order')
    .where('subscription_order.cart_id',cart_id)
    .where('store_order_id',store_order_id);
    
    orderssss = await knex('orders')
    .where('orders.cart_id',cart_id)
    .first();
    
     repeat_orderss = repeat_orders.split(",");
    repeat_tatal=repeat_orderss.length;
   // return repeat_tatal
    total_records=orderssss.total_delivery*repeat_tatal+pause_total.length;
    delete_recordss=other_total.length-total_records;
   // return total_records
    if(delete_recordss.length > 0){
      const recordsToDelete = await knex('subscription_order')
      .where('cart_id', cart_id)
      .andWhere('store_order_id', store_order_id)
      .orderBy('id', 'DESC')
      .limit(delete_recordss)
      .select('id');

      // Extract the ids of the records to delete
      const idsToDelete = recordsToDelete.map(record => record.id);
      //return idsToDelete
    //  return 888;
      // Delete the records with the selected ids
      //snehalon
      // await knex('subscription_order')
      //   .whereIn('id', idsToDelete)
      //   .delete();

    }


          if(is_subscription == 1){

         
      let k=0;
      for(let i=1;i<1000; i++){
            const addOneDay = (dateString) => {
              const date = new Date(dateString);
              date.setDate(date.getDate() + i);
              const year = date.getFullYear();
              const month = String(date.getMonth() + i).padStart(2, '0'); // Months are zero-based in JS
              const day = String(date.getDate()).padStart(2, '0');
              return `${year}-${month}-${day}`;
            };

            const givenDate = datess; // Example given date
            const delivery_dates = addOneDay(givenDate);

            repeat_orderss=repeat_orders.split(",");
           
            repeat_tatal=repeat_orderss.length;

          // return repeat_orderss.length

            for(let j=0; j<repeat_orderss.length;j++){
            

              //let delivery_dates = "2024-05-20"; // Example date
              let timestamp = new Date(delivery_dates).getTime();
              let day = moment(timestamp).format('ddd');
              let days_name = repeat_orderss[j].trim();

             
              // $timestamp = strtotime($delivery_dates);
              // $day=date('D', $timestamp);
              
              // $days_name=trim($repeat_orderss[$j]);
             
             //   if(days_name.toLowerCase() == day.toLowerCase()){
                 
              


                        const pause_total = await knex('subscription_order')
                                          .where('cart_id', cart_id)
                                          .andWhere('store_order_id', store_order_id)
                                          .andWhere(function() {
                                            this.where('order_status', 'Pause')
                                              .orWhere('order_status', 'pause');
                                          })
                                          .select();

                        
                        
                        other_total = await knex('subscription_order')
                        .where('subscription_order.cart_id',cart_id)
                        .where('subscription_order.store_order_id',store_order_id);
                        
                        orderssss = await knex('orders')
                        .where('orders.cart_id',cart_id)
                        .first();
                      
                        total_delivery=orderssss.total_delivery*repeat_tatal;
                    
                     //   return total_delivery
                        other_delivery=other_total.length-pause_total.length;   
                        
                        if(total_delivery > other_delivery)
                       {
                       
                                  //Pause order subscripion
                                  
                                  numbers =subscription_id.split(",");
                                  numbers.sort();
                                  arrlength = numbers.length;
                                  subscription_ids='';
                                  for(let xm = 0; xm<arrlength; xm++) {
                                  
                                        sub_order_id=numbers[xm].trim();
                                        get_total = await knex('subscription_order')
                                          .where('store_order_id', store_order_id)
                                          .andWhere(function() {
                                            this.where('order_status', 'Pending')
                                              .orWhere('order_status', 'Completed')
                                              .orWhere('order_status', 'Out_For_Delivery');;
                                          })
                                          .select();
                                     
                                        
                                        if(get_total.length ==  0)
                                        {
                                          gets_total = await knex('subscription_order')
                                          .where('id',sub_order_id)    
                                          .first();
                                          subscription_ids=gets_total.subscription_id;  
                                        }
                                  
                                  }  
                                  
                                

                                

                                  // subscription_order =  await knex('subscription_order')
                                  // .insert({
                                  //     cart_id:subscription_orders.cart_id,
                                  //     user_id:subscription_orders.user_id,
                                  //     order_id:subscription_orders.order_id,
                                  //     store_id:subscription_orders.store_id,
                                  //     delivery_date:delivery_dates,
                                  //     time_slot:subscription_orders.time_slot,
                                  //     created_date: created_at,
                                  //     order_status:'Pending',
                                  //     store_order_id:subscription_orders.store_order_id,
                                  //     subscription_id:subscription_ids,
                                  //     group_id:group_id
                                  // });

                                
                        }
                        k++;

                      //}
                    }
                    
                    if(k == total_delivery)
                    {
                    break;
                    }
                }
              }

      
              data_last= await knex('subscription_order')
              .select('*')
              .where('subscription_order.cart_id',cart_id)
              .where('subscription_order.store_order_id',store_order_id)
              .groupBy('subscription_id')
              .orderBy('subscription_id','desc')
              .first();
              
              last_id=data_last.id;
              
              const data= await knex('subscription_order')
              .select('*')
              .where('subscription_order.cart_id',cart_id)
              .where('subscription_order.store_order_id',store_order_id)
              .where('subscription_order.subscription_id',subscription_id)
              .groupBy('subscription_id')
              .orderBy('subscription_id','desc')
              .first();
              const pausedate = data.delivery_date;
              const date2 = new Date(pausedate);
              // Get the year, month, and day in the required format
              const year2 = date2.getFullYear();
              const month2 = String(date2.getMonth() + 1).padStart(2, '0'); // Months are zero-based, so add 1
              const day2 = String(date2.getDate()).padStart(2, '0');
              // Combine into the desired format
              const pauseformattedDate = `${year2}-${month2}-${day2}`;
              if(data_last.group_id){
              groupID = data_last.group_id;
              }else{
              groupID = data_last.cart_id;
              }
       


              data_second = await knex('subscription_order')
              .select('*')
              .where('id','>',last_id)
              .where('subscription_order.cart_id',cart_id)
              .where('store_order_id', store_order_id)
              .andWhere(function() {
                this.where('order_status', 'Pending')
                  .orWhere('order_status', 'Completed')
                  .orWhere('order_status', 'Out_For_Delivery');;
              })
              .select();

            //return subscription_id
              numbers =subscription_id.split(",");
              //return numbers
                for (let i = 0; i < data_second.length; i++) {
                   // let a = 0
                    const datasecond = data_second[i];
                    numbers = numbers.sort();
                    numbers = Array.from(numbers);
                    arrlength = numbers.length;
                   // sub_order_id=numbers[0].trim();
                   sub_order_id=numbers[0]
                  // return datasecond
                    if(arrlength != 0){
                    pause_order=await knex('subscription_order')
                    .where('id',datasecond.id)
                    .update({subscription_id:sub_order_id});
                    }
                    numbers.splice(0, 1)
              }
              
              data_last_delete=await knex('subscription_order')
              .select('*')
              .where('subscription_order.cart_id',cart_id)
              .where('subscription_order.store_order_id',store_order_id)
              .orderBy('id','desc')
             // return data_last_delete
              for (let l = 0; l < data_last_delete.length; l++) {

                const datalastdelete = data_last_delete[l];

                if(datalastdelete.order_status == 'Pause'){    
                 // return datalastdelete
                  //snehaloff
                  // delete_records =await knex('subscription_order')
                  // .where('id',datalastdelete.id)
                  // .delete();
                  }

              }

              let resume_data_deliveryss1s = [];
              for (let jkj = 0; jkj < pause_data_deliveryss1.length; jkj++) {
                let subscription_ordersssss = await knex('subscription_order')
                .select('delivery_date')
                .where('subscription_id', pause_data_deliveryss1[jkj])
                .where('order_status', 'Pending')
                .first();
        
                  if (subscription_ordersssss && subscription_ordersssss.delivery_date) {
                    let formattedDate = new Date(subscription_ordersssss.delivery_date).toLocaleDateString('en-GB', {
                      day: '2-digit',
                      month: 'long'
                    });
                    resume_data_deliveryss1s.push(formattedDate);
                  }
              }

              pause_data_deliveryss=pause_data_deliveryss12;
              let resume_data_deliveryss = (resume_data_deliveryss1s || []).join(' & ');
              resume_data_deliveryss_new_sms=resume_data_deliveryss12;

              pause_by="user"; 
            if(pause_data_deliveryss && resume_data_deliveryss){
              orders_detailss = await knex('orders')
              .select('time_slot','user_id')
              .where('cart_id',cart_id)
              .first(); 
              time_slot=orders_detailss.time_slot; 
              user_id=orders_detailss.user_id; 
              //Customer mail & sms
             // $this->subscription_order_pause_mail($cart_id, $store_order_id, $user_id, $pause_data_deliveryss, $resume_data_deliveryss,$time_slot,$pause_by);
             // $successmsg = $this->subsscription_order_pause_sms($cart_id,$store_order_id,$user_id,$pause_data_deliveryss,$resume_data_deliveryss,$time_slot,$pause_by);
              //Store Mail & sms
             // $this->subscription_order_pause_mailstore($cart_id, $store_order_id, $user_id, $pause_data_deliveryss, $resume_data_deliveryss,$time_slot,$pause_by);
             //$this->subsscription_order_pause_smsstore($cart_id,$store_order_id,$user_id,$pause_data_deliveryss,$resume_data_deliveryss,$time_slot,$pause_by);
              }


              
          if(resume_data_deliveryss_new_sms){
            orders_detailss = await knex('orders')
            .select('time_slot','user_id')
            .where('cart_id',cart_id)
            .first();    
            time_slot=orders_detailss.time_slot; 
            user_id=orders_detailss.user_id; 
            //Customer mail & sms
          //  $successmsg = $this->subsscription_order_resume_sms($cart_id,$store_order_id,$user_id,$pause_data_deliveryss,$resume_data_deliveryss_new_sms,$time_slot,$pause_by);
          //  $this->subscription_order_resume_mail($cart_id, $store_order_id, $user_id, $pause_data_deliveryss, $resume_data_deliveryss_new_sms,$time_slot,$pause_by);
            
            //Store Mail & sms
           // $this->subsscription_order_resume_smsstore($cart_id,$store_order_id,$user_id,$pause_data_deliveryss,$resume_data_deliveryss_new_sms,$time_slot,$pause_by);
           // $this->subscription_order_resume_mailstore($cart_id, $store_order_id, $user_id, $pause_data_deliveryss, $resume_data_deliveryss_new_sms,$time_slot,$pause_by);
            }

      //Email Code
      const storeOrders = await knex('store_orders')
      .select('store_orders.*','orders.group_id','orders.time_slot')
      .join('orders', 'orders.cart_id', '=', 'store_orders.order_cart_id')
      .where('orders.cart_id', cart_id)
      // Fetch user phone and wallet
      const user = await knex('users')
      .select('name','email')
      .where('id', user_id)
      .first();
      let userName=user.name;
      let userEmail='store1@quickart.ae';
      const logo = await knex('tbl_web_setting').first();
      const appName = logo ? logo.name : null;
      // Fetching the first record from the 'currency' table
      const currency = await knex('currency').first();
      const currencySign = currency ? currency.currency_sign : null;
      const templateData = {
      baseurl: process.env.base_url,
      user_name:userName,
      user_email:userEmail,
      store_orderss:storeOrders,
      final_amount:"",
      app_name:appName,
      currency_sign:currencySign,
      cart_id:groupID,
      pause_data_deliveryss:pauseformattedDate
      };
      const subject = 'Order Paused'
      // Trigger the email after order is placed
      sendPausedEmail = await pauseorderMail(userEmail,templateData,subject);
};
 
const getCancelprdOrder  = async (appDetatils) => {
  let userId = appDetatils.user_id
  cart_id =appDetatils.cart_id
  store_order_id=appDetatils.store_order_id;
  cancel_reason=appDetatils.cancel_reason;

  if(cart_id && userId && store_order_id){
   
  subcription_data = await knex('subscription_order')
  .where('store_order_id', store_order_id)
  .where('order_status', 'Pending')
  // .where('si_payment_flag', 'no')
  // .where('processing_product','!=','1')
  .update({'cancel_reason':cancel_reason,'order_status':"Cancelled"});
      
  order_data = await knex('orders')
  .where('cart_id', cart_id)
  .where('order_status', 'Pending')
  .update({'order_status':"Cancelled"});
}

const storeDetails = await knex('store_orders')
.where('store_order_id',store_order_id)
.first();

const OrdersDetails = await knex('orders')
.where('cart_id',cart_id)
.first();

const result = await knex('subscription_order')
.where('store_order_id', store_order_id)
.where('si_payment_flag', 'yes')
.where('order_status','Cancelled')
.count({ cancelled_count: 'id' });
const cancelledCount=result[0].cancelled_count;

const repeatOrders=storeDetails.repeat_orders;
const subTotalDelivery=storeDetails.sub_total_delivery;
const repeatOrderCount = repeatOrders.trim().split(',');
const totalDeliveryWeek=repeatOrderCount.length*subTotalDelivery;
const totalPrice=storeDetails.price/totalDeliveryWeek;
const reserveAmount=0;
const TotalPaidAmount=(cancelledCount) ? (cancelledCount*totalPrice) : 0;
const TotalPriceOrdersAmt=(parseFloat(reserveAmount)+parseFloat(TotalPaidAmount));
const user = await knex('users')
.select('user_phone', 'wallet','name','email')
.where('id', userId)
.first();
let actualWallet=user.wallet+TotalPriceOrdersAmt;

await knex('users')
.where('id', userId)
.update({
'wallet':actualWallet,
}); 

await knex('wallet_history').insert({
user_id: userId,
amount: TotalPriceOrdersAmt,
resource: 'order_refund_cancelled',
type:'Add',
group_id:"",
cart_id:cart_id,
});

await knex('orders')
.where('cart_id', cart_id)
.where('order_status','Cancelled')
.update({
'del_partner_tip':0,
'cod_charges':0,
'reserve_amount':0,
'paid_by_wallet':0,
'rem_price':0
}); 

//Email Code
storeOrders = await knex('store_orders')
.select('store_orders.*','orders.group_id','orders.time_slot')
.join('orders', 'orders.cart_id', '=', 'store_orders.order_cart_id')
.where('store_orders.order_cart_id', cart_id)

let userName=user.name;
let userEmail=user.email;

const logo = await knex('tbl_web_setting').first();
const appName = logo ? logo.name : null;
// Fetching the first record from the 'currency' table
const currency = await knex('currency').first();
const currencySign = currency ? currency.currency_sign : null;

const orderlist = await knex('orders')
.where('cart_id',cart_id)
.select('group_id')
.first();


const templateData = {
baseurl: process.env.base_url,
user_name:userName,
user_email:userEmail,
store_orderss:storeOrders,
final_amount:"",
app_name:appName,
currency_sign:currencySign,
cart_id: orderlist.group_id
};
const subject = 'Delivery Order Cancelled'
// Trigger the email after order is placed
sendCancelledEmail = await cancelorderMail(userEmail, templateData,subject);

};
 
const getCancelOrder = async (appDetatils) => {
        user_id = appDetatils.user_id
        ongoing = await knex('orders')
          .join('store','orders.store_id','=','store.id')
          .join('users','orders.user_id','=','users.id')
          .join('address','orders.address_id','=','address.address_id')
          .leftJoin('delivery_boy', 'orders.dboy_id', '=', 'delivery_boy.dboy_id')
          .where('orders.user_id',user_id)
          .whereNotNull('orders.order_status')
          .whereNotNull('orders.payment_method')
          .where('orders.order_status', 'Cancelled')
          .orderBy('orders.order_id', 'DESC')


          const customizedProductData = [];
          for (let i = 0; i < ongoing.length; i++) {
            const ProductList = ongoing[i];

            order = await knex('store_orders')
            .where('order_cart_id',ProductList.cart_id)


            const baseurl =  process.env.BUNNY_NET_IMAGE;
            const customizedProduct = {
                  user_name:ProductList.name,
                  delivery_address:ProductList.house_no+","+ ProductList.society+ ","+ ProductList.city+ ","+ ProductList.landmark+ ","+ ProductList.state+ ","+ ProductList.pincode,
                  store_name:ProductList.store_name,
                  store_owner:ProductList.employee_name,
                  store_phone:ProductList.phone_number, 
                  store_email:ProductList.email,
                  store_address:ProductList.address ,
                  order_status:ProductList.order_status,
                  delivery_date:ProductList.delivery_date,
                  time_slot:ProductList.time_slot,
                  payment_method:ProductList.payment_method,
                  payment_status:ProductList.payment_status,
                  paid_by_wallet:ProductList.paid_by_wallet,
                  cart_id:ProductList.cart_id ,
                  price:ProductList.total_price,
                  delivery_charge:ProductList.delivery_charge,
                  rem_price:ProductList.rem_price,
                  coupon_discount:ProductList.coupon_discount,
                  dboy_name:ProductList.boy_name,
                  dboy_phone:ProductList.boy_phone,
                  sub_total:ProductList.price_without_delivery,
                  avg_tax_per:ProductList.avg_tax_per,
                  total_tax_price:ProductList.total_tax_price,
                  data:order
                // Add or modify properties as needed
                };
            
                customizedProductData.push(customizedProduct);  
          }
          return customizedProductData

};
 
const getRepeatedplaceorder = async (appDetatils) => {
     
      groupID = appDetatils.cart_id
      user_id = appDetatils.user_id
      order_type =  appDetatils.order_type
      
      replace_status=appDetatils.replace_status
      //return replace_status

      if(user_id && (replace_status == 0 ||  replace_status == 1) ){
        
        ordersAll = await knex('orders')
        .where('group_id','=',groupID);
        
        for (let j = 0; j < ordersAll.length; j++) {
        const ordersList = ordersAll[j];
        const cart_id=ordersList.cart_id;
        orders_detailsss = await knex('store_orders')
        .where('repeated_order_cart','=',cart_id)
        .where('order_cart_id','=','incart');
      
        if(orders_detailsss.length == 0 ){
          orders_details = await knex('store_orders')
          .select('store_orders.*','product.availability')
          .join('store_products','store_products.varient_id','store_orders.varient_id')
          .join('product_varient','product_varient.varient_id','store_products.varient_id')
          .join('product','product.product_id','product_varient.product_id')
          .where('order_cart_id','=',cart_id);
          //$replace_status 0 : replace , 1 : update
          if(replace_status == 0)
          {
          deletere = await knex('store_orders')
          .where('store_approval',user_id)
          .where('order_cart_id', 'incart')
          .where('store_orders.subscription_flag',1)
          .delete();  
          }

          for (let i = 0; i < orders_details.length; i++) {
            const ordersdetails = orders_details[i];
            rec = await knex('store_orders')
            .where('store_approval',user_id)
            .where('varient_id',ordersdetails.varient_id)
            .where('order_cart_id', 'incart')
            if(rec.length > 0){
                deleterec = await knex('store_orders')
                .where('store_approval',user_id)
                .where('varient_id',ordersdetails.varient_id)
                .where('store_orders.subscription_flag',1)
                .where('order_cart_id', 'incart')
                .delete();
            }
            
            varient_details = await knex('store_products')
            .where('varient_id','=',ordersdetails.varient_id)
            .first();
       
            repeatOrders = ordersdetails.repeat_orders.trim().split(',');
            totalMrp = repeatOrders.length * (varient_details.price*ordersdetails.qty);
            const availability = (ordersdetails.availability === 'quick') ? null : 1;
            const currentDate = new Date();
            if(availability == 1){
            const storeOrderId = await knex('store_orders').insert({
              product_name: ordersdetails.product_name,
              varient_image: ordersdetails.varient_image,
              quantity: ordersdetails.quantity,
              unit: ordersdetails.unit,
              varient_id: ordersdetails.varient_id,
              qty: ordersdetails.qty,
              price:(ordersdetails.qty*varient_details.price),
              total_mrp: totalMrp,
              order_cart_id: 'incart',
              order_date: currentDate, // Uses the current date and time
              repeat_orders: ordersdetails.repeat_orders,
              store_approval: user_id,
              store_id: ordersdetails.store_id,
              description: ordersdetails.description,
              tx_per: ordersdetails.tx_per,
              price_without_tax: varient_details.price,
              tx_price: ordersdetails.tx_price,
              type: ordersdetails.type,
              repeated_order_cart: ordersdetails.order_cart_id,
              buying_price: ordersdetails.buying_price,
              base_mrp: ordersdetails.base_mrp,
              subscription_flag:ordersdetails.subscription_flag,
              sub_time_slot:ordersdetails.sub_time_slot,
              sub_total_delivery:ordersdetails.sub_total_delivery,
              percentage:ordersdetails.percentage,
              sub_delivery_date:ordersdetails.sub_delivery_date,
              subscription_flag:availability
            });
          }
          }

        }
    

        }
        return 1;
      }


};
 
const getcancelOrderres = async () => {
    return   cancel_reason = await knex('cancel_for')
    
};

const ordsubDetails = async (appDetatils) => {
  
  cart_id=appDetatils.cart_id;
  store_order_id=appDetatils.store_order_id;
  subscription_id = appDetatils.subscription_id;
  ongoing = await knex('orders')
        .join('store','orders.store_id','=','store.id')
        .join('users','orders.user_id','=','users.id')
        .join('address','orders.address_id','=','address.address_id')
        .leftJoin('delivery_boy', 'orders.dboy_id', '=', 'delivery_boy.dboy_id')
        //   .where('orders.user_id',$user_id)
        .where('orders.cart_id',cart_id)
        .whereNotNull('orders.order_status')
        .whereNotNull('orders.payment_method')
        .orderBy('orders.order_id', 'DESC')

        const pending_sub = await knex('subscription_order')
        .where('cart_id',cart_id)
        .where('order_status', 'Pending');

        const pause_sub =  await knex('subscription_order')
        .where('cart_id',cart_id)
        .where('order_status', 'Pause');

        const completed_sub =  await knex('subscription_order')
        .where('cart_id',cart_id)
        .where('order_status', 'Completed');

        const cancelled_sub =  await knex('subscription_order')
        .where('cart_id',cart_id)
        .where('order_status', 'Cancelled');

        ongoing_sub =  await knex('subscription_order')
          .leftJoin('delivery_boy', 'subscription_order.dboy_id', '=', 'delivery_boy.dboy_id')
          .where('cart_id',cart_id)
          .where('store_order_id',store_order_id)
          .select('*',knex.raw('DATE_FORMAT(subscription_order.delivery_date, "%Y-%m-%d") as delivery_date'))
         // .where('subscription_id',subscription_id)

          const onSubData = []; 
        for (let i = 0; i < ongoing_sub.length; i++) {
          const ProductList = ongoing_sub[i];
           
              const timestamp = new Date(ProductList.deliveryDate).getTime() / 1000; // Convert the date string to a UNIX timestamp in seconds
              const day = new Date(timestamp * 1000).toLocaleString('en-us', { weekday: 'short' });
              ongoing_subs={
                cart_id: ProductList.cart_id,
                  subscription_id:ProductList.id,
                  cart_id:ProductList.cart_id,
                  delivery_date:ProductList.delivery_date,
                  time_slot:ProductList.time_slot,
                  order_status:ProductList.order_status,
                  day:day,
                  store_order_id:ProductList.store_order_id,
                  processing_product:ProductList.processing_product
                  
              };
              onSubData.push(ongoing_subs);  
          }
          subdataorder = onSubData;
          
          if(ongoing){
           
            const customizedProductData = [];
            for (let i = 0; i < ongoing.length; i++) {
              const ProductList = ongoing[i];  
            
              ongoings =await knex('orders')
              .join('store','orders.store_id','=','store.id')
              .join('users','orders.user_id','=','users.id')
               .join('address','orders.address_id','=','address.address_id')
               .leftJoin('delivery_boy', 'orders.dboy_id', '=', 'delivery_boy.dboy_id')
                .where('orders.cart_id',cart_id)
                .whereNotNull('orders.order_status')
                .whereNotNull('orders.payment_method')
                .orderBy('orders.order_id', 'DESC')
                .first();
               
               
                const baseurl =  process.env.BUNNY_NET_IMAGE;

                const order = await knex('store_orders')
                .join('product_varient', 'store_orders.varient_id', 'product_varient.varient_id')
                .join('product', 'product.product_id', 'product_varient.product_id')
                // .join('store_products', 'store_products.varient_id', 'product_varient.varient_id')
                .where('store_orders.order_cart_id', '=', appDetatils.cart_id)
              //  .where('store_orders.store_order_id', '=', appDetatils.store_order_id)
                .select(
                  'store_orders.store_order_id',
                  'store_orders.product_name',
                  'product.product_id',
                  'store_orders.quantity',
                  'store_orders.unit',
                  'store_orders.varient_id',
                  'store_orders.qty',
                  // 'store_orders.price as price',
                 knex.raw('((store_orders.price / store_orders.qty)/store_orders.sub_total_delivery) as price'),
                  'store_orders.total_mrp',
                  'store_orders.order_cart_id',
                  'store_orders.order_date',
                  'store_orders.repeat_orders',
                  'store_orders.store_approval',
                  'store_orders.store_id',
                  'store_orders.description',
                  'store_orders.tx_per',
                  'store_orders.price_without_tax',
                  'store_orders.tx_price',
                  'store_orders.tx_name',
                  'store_orders.type',
                  knex.raw(`CONCAT('${baseurl}', product.product_image) as varient_image`),
                  'product.thumbnail',
                  knex.raw(`LENGTH(store_orders.repeat_orders) - LENGTH(REPLACE(store_orders.repeat_orders, ',', '')) + 1 as repeat_orders_count`)
                )
                .groupBy('store_orders.varient_id');
                
               
                ongoings.discountonmrp=ongoings.total_products_mrp - ongoings.price_without_delivery; 
                ongoings.total_items=order.length;
             
                const customizedOrdData = [];
              //  return order
    
                  for (let i = 0; i < order.length; i++) {
                   
                    const ordList = order[i];  
                  checkstore=  await knex('orders')
                        .where('cart_id',ProductList.cart_id)
                        .first();
                  getrating = await knex('product_rating')
                                 .where('varient_id',ordList.varient_id)
                                 .where('user_id',ProductList.user_id)
                                 .where('store_id',checkstore.store_id)
                                 .first(); 
                 
                          if(getrating) {
                             
                           rating=getrating.rating; 
                           rating_description=getrating.description;
                        } 
                        else{
                            rating="null"; 
                          rating_description="null";
                        }  
                   
                //  const trimmedString = ProductList.repeat_orders.trim();

          
                     
                  if(ProductList.repeat_orders != null){
                    repeat_orderss = ProductList.repeat_orders.split(',').map(s => s.trim());
                    total_delivery_week = repeat_orderss.length * order.total_delivery;
                    finalrepeat_orderss = repeat_orderss.length
                  }else{
                     repeat_orderss = '';
                     total_delivery_week = 1;
                      finalrepeat_orderss = null;
                  }
                
                }   
                
                
                const pendingResult = await knex('subscription_order')
                .where('cart_id',ProductList.cart_id)
                .where('order_status','Pending')
                .count({ pending_count: 'order_id' });

                const AllResult = await knex('subscription_order')
                .where('cart_id',ProductList.cart_id)
                .andWhere(function() {
                this.where('order_status', 'Pending')
                .orWhere('order_status', 'Completed')
                .orWhere('order_status', 'Confirmed')
                .orWhere('order_status', 'Out_For_Delivery');
                })
                .count({ all_count: 'order_id' });

                const pendingCount=pendingResult[0].pending_count;
                const allCount=AllResult[0].all_count;
                order_status=(pendingCount > 0) ? "Pending": "Completed";

                const cancelledResult = await knex('subscription_order')
                .where('cart_id',ProductList.cart_id)
                .where('order_status','Cancelled')
                .count({ cancelled_count: 'order_id' });
                const cancelledCount=cancelledResult[0].cancelled_count;
                if(cancelledCount > 0 && allCount <= 0){
                order_status="Cancelled";
                }

                const completedResult = await knex('subscription_order')
                .where('cart_id',ProductList.cart_id)
                .where('order_status','Completed')
                .count({ completed_count: 'order_id' });
                const completedCount=completedResult[0].completed_count;
                if(completedCount > 0 && pendingCount > 0){
                order_status="Inprogress";
                }

                const TotalOrderResult = await knex('subscription_order')
                .where('cart_id',ProductList.cart_id)
                .count({ total_count: 'order_id' });
                const totalOrderCount=TotalOrderResult[0].total_count;

             
                store_order_idwww= await knex('store_orders')
                .where('order_cart_id', appDetatils.cart_id)
                .first();
                pricess=store_order_idwww.price;
               // return finalrepeat_orderss;
                 finaltotal_price = pricess*finalrepeat_orderss*ProductList.total_delivery;
                 let ProductListOrderDate = (ProductList.order_date) ? format(ProductList.order_date, 'yyyy-MM-dd') : "null";
                const customizedProduct = {      
                  user_name:ProductList.name,
                  total_delivery:ProductList.total_delivery,
                 //delivery_address:ProductList.building_villa+','+ongoings.street+','+ongoings.society+','+ongoings.city,
                  delivery_address: ProductList.house_no,
                 store_name:ProductList.store_name,
                 store_owner:ProductList.employee_name, 
                 store_phone:ProductList.phone_number, 
                 store_address:ProductList.address ,
                 order_status:order_status, 
                 delivery_date:ProductList.delivery_date, 
                 time_slot:ProductList.time_slot,
                 payment_method:ProductList.payment_method,
                 payment_status:ProductList.payment_status,
                 paid_by_wallet:ProductList.paid_by_wallet, 
                 cart_id:ProductList.cart_id ,
                // total_price:finaltotal_price.toFixed(2),
                 total_price:ProductList.total_price.toFixed(2),
                 delivery_charge:ProductList.delivery_charge.toFixed(2),
                 rem_price:ProductList.rem_price.toFixed(2),
                 coupon_discount:ProductList.coupon_discount.toFixed(2),
                 dboy_name:ProductList.boy_name,
                 dboy_phone:ProductList.boy_phone,
                 price_without_delivery:ProductList.price_without_delivery.toFixed(2),
                 avg_tax_per:ProductList.avg_tax_per,
                 total_tax_price:ProductList.total_tax_price,
                 user_id:ProductList.user_id,
                 total_products_mrp:ProductList.total_products_mrp,
                 discountonmrp: ProductList.discountonmrp,
                 cancelling_reason:ProductList.cancelling_reason,
                 order_date:ProductListOrderDate,
                 dboy_id:ProductList.dboy_id,
                 user_signature:ProductList.user_signature,
                 coupon_id:ProductList.coupon_id,
                 dboy_incentive:ProductList.dboy_incentive,
                 total_items:ProductList.total_items,
                 is_subscription:ProductList.is_subscription,
                 pending_order:pending_sub.length,
                 pause_order:pause_sub.length,
                 completed_order:completed_sub.length,
                 cancelled_order:cancelled_sub.length,
                 //total_order:total_delivery_week, // need to change
                 total_order:totalOrderCount,
                 data:order,
                 //subscription_details:ongoing_subs
                 subscription_details:subdataorder
                }
           

                customizedProductData.push(customizedProduct);  
              }  

              return customizedProductData;
             
              }else{
                throw new Error('No Orders Yet');
              }
              
};

const ordsubDetailsold = async (appDetatils) => {
  
  cart_id=appDetatils.cart_id;
  store_order_id=appDetatils.store_order_id;
  subscription_id = appDetatils.subscription_id;
  ongoing = await knex('orders')
        .join('store','orders.store_id','=','store.id')
        .join('users','orders.user_id','=','users.id')
        .join('address','orders.address_id','=','address.address_id')
        .leftJoin('delivery_boy', 'orders.dboy_id', '=', 'delivery_boy.dboy_id')
        //   .where('orders.user_id',$user_id)
        .where('orders.cart_id',cart_id)
        .whereNotNull('orders.order_status')
        .whereNotNull('orders.payment_method')
        .orderBy('orders.order_id', 'DESC')
  

    
        const pending_sub = await knex('subscription_order')
        .where('subscription_id', subscription_id)
        .where(function() {
          this.where('order_status', 'Pending').orWhere('order_status', 'pending');
        })

        const pause_sub =  await knex('subscription_order')
        .where('subscription_id',subscription_id)
        .where(function() {
          this.where('order_status', 'Pause').orWhere('order_status', 'pause');
        })
        const completed_sub =  await knex('subscription_order')
        .where('subscription_id',subscription_id)
        .where(function() {
          this.where('order_status', 'Completed').orWhere('order_status', 'completed');
        })

        const cancelled_sub =  await knex('subscription_order')
        .where('subscription_id',subscription_id)
        .where(function() {
          this.where('order_status', 'Cancelled').orWhere('order_status', 'cancelled');
        })

        ongoing_sub =  await knex('subscription_order')
          .leftJoin('delivery_boy', 'subscription_order.dboy_id', '=', 'delivery_boy.dboy_id')
          .where('cart_id',cart_id)
         // .where('store_order_id',store_order_id)
          .where('subscription_id',subscription_id)

          const onSubData = []; 
        for (let i = 0; i < ongoing_sub.length; i++) {
          const ProductList = ongoing_sub[i];
           
              const timestamp = new Date(ProductList.deliveryDate).getTime() / 1000; // Convert the date string to a UNIX timestamp in seconds
              const day = new Date(timestamp * 1000).toLocaleString('en-us', { weekday: 'short' });
              ongoing_subs={
                cart_id: ProductList.cart_id,
                  subscription_id:ProductList.id,
                  cart_id:ProductList.cart_id,
                  delivery_date:ProductList.delivery_date,
                  time_slot:ProductList.time_slot,
                  order_status:ProductList.order_status,
                  day:day,
                  store_order_id:ProductList.store_order_id,
                  processing_product:ProductList.processing_product
                  
              };
              onSubData.push(ongoing_subs);  
          }
          subdataorder = onSubData;

          if(ongoing){
            const customizedProductData = [];
            for (let i = 0; i < ongoing.length; i++) {
              const ProductList = ongoing[i];  

              ongoings =await knex('orders')
              .join('store','orders.store_id','=','store.id')
              .join('users','orders.user_id','=','users.id')
               .join('address','orders.address_id','=','address.address_id')
               .leftJoin('delivery_boy', 'orders.dboy_id', '=', 'delivery_boy.dboy_id')
                .where('orders.cart_id',cart_id)
                .whereNotNull('orders.order_status')
                .whereNotNull('orders.payment_method')
                .orderBy('orders.order_id', 'DESC')
                .first();
                const baseurl =  process.env.BUNNY_NET_IMAGE;
                const order = await knex('store_orders')
                .select(
                  'store_orders.store_order_id',
                  'store_orders.product_name',
                  'store_orders.quantity',
                  'store_orders.unit',
                  'store_orders.varient_id',
                  'store_orders.qty',
                  knex.raw('(store_orders.price / store_orders.qty) as price'),
                  'store_orders.total_mrp',
                  'store_orders.order_cart_id',
                  'store_orders.order_date',
                  'store_orders.repeat_orders',
                  'store_orders.store_approval',
                  'store_orders.store_id',
                  'store_orders.description',
                  'store_orders.tx_per',
                  'store_orders.price_without_tax',
                  'store_orders.tx_price',
                  'store_orders.tx_name',
                  'store_orders.type',
                  knex.raw(`CONCAT('${baseurl}', product.product_image) as varient_image`),
                  'product.thumbnail'
                )
                .join('product_varient', 'store_orders.varient_id', 'product_varient.varient_id')
                .join('product', 'product.product_id', 'product_varient.product_id')
                .where('order_cart_id', '=', cart_id)
                .where('store_order_id', '=', store_order_id);
                  
                ongoings.discountonmrp=ongoings.total_products_mrp - ongoings.price_without_delivery; 
                ongoings.total_items=order.length;

                const customizedOrdData = [];
                
    
                  for (let i = 0; i < order.length; i++) {
                    const ordList = order[i];  
                  checkstore=  await knex('orders')
                        .where('cart_id',ProductList.cart_id)
                        .first();
                  getrating = await knex('product_rating')
                                 .where('varient_id',ordList.varient_id)
                                 .where('user_id',ProductList.user_id)
                                 .where('store_id',checkstore.store_id)
                                 .first(); 
                 
                          if(getrating) {
                             
                           rating=getrating.rating; 
                           rating_description=getrating.description;
                        } 
                        else{
                            rating="null"; 
                          rating_description="null";
                        }  
                   
                //  const trimmedString = ProductList.repeat_orders.trim();

              // Step 2: Split the trimmed string by commas to get an array of values
                  //  const repeat_orderss = trimmedString.split(',');
                   //repeat_orderss=explode(",",trim(ProductList.repeat_orders));
                  // total_delivery_week=repeat_orderss.length*order.total_delivery;
                        
                   const repeat_orderss = ProductList.repeat_orders.split(',').map(s => s.trim());
                   const total_delivery_week = repeat_orderss.length * order.total_delivery;
                
                }   

                store_order_idwww= await knex('store_orders')
                .where('store_order_id',store_order_id)
                .first();
                pricess=store_order_idwww.price;
                const customizedProduct = {      
                  user_name:ProductList.name,
                  total_delivery:ongoings.total_delivery,
                 delivery_address:ProductList.building_villa+','+ongoings.street+','+ongoings.society+','+ongoings.city,
                 store_name:ProductList.store_name,
                 store_owner:ProductList.employee_name, 
                 store_phone:ProductList.phone_number, 
                 store_address:ProductList.address ,
                 order_status:ProductList.order_status, 
                 delivery_date:ProductList.delivery_date, 
                 time_slot:ProductList.time_slot,
                 payment_method:ProductList.payment_method,
                 payment_status:ProductList.payment_status,
                 paid_by_wallet:ProductList.paid_by_wallet, 
                 cart_id:ProductList.cart_id ,
                 total_price:(pricess*total_delivery_week).toFixed(2),
                 delivery_charge:ProductList.delivery_charge.toFixed(2),
                 rem_price:ProductList.rem_price.toFixed(2),
                 coupon_discount:ProductList.coupon_discount.toFixed(2),
                 dboy_name:ProductList.boy_name,
                 dboy_phone:ProductList.boy_phone,
                 price_without_delivery:ProductList.price_without_delivery.toFixed(2),
                 avg_tax_per:ProductList.avg_tax_per,
                 total_tax_price:ProductList.total_tax_price,
                 user_id:ProductList.user_id,
                 total_products_mrp:ProductList.total_products_mrp,
                 discountonmrp: ProductList.discountonmrp,
                 cancelling_reason:ProductList.cancelling_reason,
                 order_date:ProductList.order_date,
                 dboy_id:ProductList.dboy_id,
                 user_signature:ProductList.user_signature,
                 coupon_id:ProductList.coupon_id,
                 dboy_incentive:ProductList.dboy_incentive,
                 total_items:ProductList.total_items,
                 is_subscription:ProductList.is_subscription,
                 pending_order:pending_sub.length,
                 pause_order:pause_sub.length,
                 completed_order:completed_sub.length,
                 cancelled_order:cancelled_sub.length,
                 total_order:total_delivery_week, // need to change
                 data:order,
                 //subscription_details:ongoing_subs
                 subscription_details:subdataorder
                }
           

                customizedProductData.push(customizedProduct);  
              }  

              return customizedProductData;
             
              }else{
                throw new Error('No Orders Yet');
              }
              
};

const getOngoingsub = async (appDetatils) => {
  await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))');

  const { user_id, store_id, page: pageFilter, perpage: perPage } = appDetatils;
  const offset = (pageFilter - 1) * perPage;

  // Base query for ongoing subscriptions
  const ongoingQuery = knex('orders')
    .select(
      knex.raw('SUM(orders.total_products_mrp) as totalProductsMrp'),
      'orders.group_id',
      'orders.cart_id',
      knex.raw('DATE_FORMAT(orders.delivery_date, "%Y-%m-%d") as delivery_date'),
      knex.raw('DATE_FORMAT(orders.order_date, "%Y-%m-%d") as order_date'),
      'orders.total_delivery',
      'store_orders.price',
      'store_orders.store_order_id',
      'store_orders.product_name',
      'store_orders.total_mrp',
      'store_orders.repeat_orders',
      'orders.order_status',
      'orders.si_order',
      'orders.si_sub_ref_no',
      'orders.pastorecentrder'
    )
    .join('store_orders', 'orders.cart_id', '=', 'store_orders.order_cart_id')
    .where('order_cart_id', '!=', 'incart')
    .where('orders.user_id', user_id)
    .where('orders.store_id', store_id)
    .whereNotNull('orders.order_status')
    .where('orders.is_subscription', 1)
    .whereNotNull('orders.payment_method')
    .groupBy('orders.group_id')
    .orderBy('orders.order_id', 'DESC')
    .limit(perPage)
    .offset(offset);

  const ongoing = await ongoingQuery;

  // Extract cart_ids for batch processing
  const cartIds = ongoing.map(o => o.cart_id);
  const storeOrderIds = ongoing.map(o => o.store_order_id);

  // Fetch subscription orders and order details in parallel
  const [subscriptionOrders, orderDetails,deliveryRatings] = await Promise.all([
  knex('subscription_order')
  .whereIn('cart_id', cartIds)
  .whereIn('store_order_id', storeOrderIds)
  .where('order_status', 'Pending')
  .orderBy('id', 'DESC')
  .select('cart_id', 'store_order_id', 'subscription_id', 'delivery_date'),
  knex('orders')
  .whereIn('cart_id', cartIds)
  .select('cart_id', 'total_products_mrp', 'pastorecentrder'),
  knex('delivery_rating')
  .whereIn('cart_id', cartIds)
  .select('cart_id', 'rating', 'description')
  ]);

  // Convert deliveryRatings array into a map for efficient lookup
  const deliveryRatingsMap = deliveryRatings.reduce((map, rating) => {
  map[rating.cart_id] = { rating: rating.rating, description: rating.description };
  return map;
  }, {});


  // Process ongoing subscriptions
  const customizedProductData = ongoing.map(product => {
    const subscriptionOrder = subscriptionOrders.find(o => o.cart_id === product.cart_id && o.store_order_id === product.store_order_id);
    const formattedDeliveryDate = subscriptionOrder ? format(new Date(subscriptionOrder.delivery_date), 'yyyy-MM-dd') : '';
    const orderDetail = orderDetails.find(o => o.cart_id === product.cart_id);
    const ratingData = deliveryRatingsMap[product.cart_id] || { rating: null, description: null };
    const totalProductsMrp = product.pastorecentrder === 'old' ? orderDetail.total_products_mrp : product.totalProductsMrp;
    const deliveryDate = new Date(product.delivery_date);
    const today = new Date();
    // let orderStatus = deliveryDate > today ? 'Active' : 'Inactive';
    let orderStatus = deliveryDate > today ? 'Pending' : 'Completed';
    if (product.order_status === 'Cancelled') orderStatus = 'Cancelled';

    const repeatOrders = product.repeat_orders.split(',').map(item => item.trim());
    const totalDeliveryWeek = repeatOrders.length * product.total_delivery;

    return {
      cart_id: product.group_id,
      order_date: product.order_date,
      total_mrp: parseFloat(totalProductsMrp).toFixed(2),
      subscription_id: subscriptionOrder ? subscriptionOrder.subscription_id : '',
      si_order: product.si_order,
      si_sub_ref_no: product.si_sub_ref_no,
      order_status: orderStatus,
      drating: ratingData.rating,
      dreview: ratingData.description
    };
  });

  return customizedProductData;
};

const getrepeatOrder = async (appDetatils) => {
  await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
  //user_id = appDetatils.user_id;
    if(appDetatils.user_id != "null" ){
        user_id = appDetatils.user_id
    }else{
        user_id = appDetatils.device_id
    }
  store_id = appDetatils.store_id;
  const baseurl =  process.env.BUNNY_NET_IMAGE;
  let CartQtyList = await knex('store_orders')
  .join('orders', 'orders.cart_id', '=', 'store_orders.order_cart_id')
  .join('product_varient','store_orders.varient_id','=','product_varient.varient_id')
  .join('product','product_varient.product_id','=','product.product_id')
  .join('store_products','store_products.varient_id','=','product_varient.varient_id')
  .where('orders.user_id',user_id)
  .where('product.hide',0)
  .where('product.is_delete',0)
  .where('orders.store_id',store_id)
  .groupBy([
    'store_orders.varient_id',
  ])
  .select('store_products.stock','product.available_days','product_varient.product_id','product.percentage', 'product.availability','store_orders.product_name',knex.raw(`CONCAT('${baseurl}', store_orders.varient_image) as varient_image`),'store_orders.varient_id','store_orders.price','store_orders.description','store_orders.type', knex.raw('count(store_orders.varient_id) as ordercount'),'store_orders.unit','store_orders.qty','store_orders.total_mrp')
  .orderBy('ordercount', 'desc')
  .limit(5)
  const customizedProductData = [];
  for (let i = 0; i < CartQtyList.length; i++) {
    const ProductList = CartQtyList[i];
    var notifyMe=0;
    if(appDetatils.user_id){ 
      // Wishlist check 
     
          var cartQty=0;
          // cart qty check 
          const CartQtyLists = await knex('store_orders')
          .where('varient_id',ProductList.varient_id)
          .where('store_approval',appDetatils.user_id)
          .where('order_cart_id','incart')
          .whereNull('subscription_flag')
          .where('store_id',appDetatils.store_id)
          .first();
          cartQty = CartQtyLists ? CartQtyLists.qty : 0
          
            const subprod = await knex('store_orders')
          .select('store_orders.percentage')
          .where('store_orders.varient_id',ProductList.varient_id)
          .where('store_approval',user_id)
          .where('store_orders.subscription_flag',1)
          .where('store_orders.order_cart_id', "incart")
          .first();

          const cnotify_me = await knex('product_notify_me')
          .where('varient_id', ProductList.varient_id)
          .where('user_id', user_id);
          notifyMe = cnotify_me.length > 0 ? 'true' : 'false';
  
          if(subprod){
            isSubscription = 'true'
          }else{
            isSubscription = 'false'
            
          }
          
      }else{
          cartQty=0;
          isSubscription = 'false'
          notifyMe='false';
      }

       const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
      const finalsubprice =  ProductList.mrp - sub_price;
      const subscription_price = parseFloat(finalsubprice.toFixed(2));

      if (Number.isInteger(ProductList.price)) {
      priceval = ProductList.price + '.001'
      }else{
      priceval = ProductList.price
      }
      
      
      const customizedProduct = {   
        percentage: ProductList.percentage,
        isSubscription:isSubscription,
        subscription_price:subscription_price,
        availability:ProductList.availability,
        discountper:0,
        product_name: ProductList.product_name,
        varient_image: ProductList.varient_image,
        varient_id: ProductList.varient_id,
        price: parseFloat(priceval),
        description:ProductList.description,
        type: ProductList.type,
        ordercount:ProductList.ordercount,
        unit: ProductList.unit,
        qty:  ProductList.qty,
        total_mrp:ProductList.total_mrp,
        cart_qty:cartQty,
        notify_me:notifyMe,
        product_id :ProductList.product_id,
        available_days:ProductList.available_days,
        stock:ProductList.stock
        // Add or modify properties as needed
        };
    
      customizedProductData.push(customizedProduct);  


  }
  return customizedProductData

};

const getMyOrder = async (appDetatils) => {
   const { user_id ,page} = appDetatils;
   const pageFilter = page; // You can adjust the page number dynamically
   const perPage = 50;

   let ongoing = await knex('orders')
   .select('orders.group_id','orders.cart_id',knex.raw('DATE_FORMAT(orders.order_date, "%Y-%m-%d") as order_date'),'orders.coupon_discount','orders.total_products_mrp as price_without_delivery','orders.user_id','orders.is_subscription','orders.si_order','orders.bank_id','orders.order_status')
   .where('orders.user_id', user_id)
   .whereNot('orders.group_id', null)
   .whereNot('orders.order_status', null)
   .whereNotNull('orders.payment_method')
   .orderBy('orders.order_id', 'desc')
   .offset((pageFilter - 1) * perPage)
   .limit(perPage);

   const customizedProductData = [];
      for (let j = 0; j < ongoing.length; j++) {
        const prd = ongoing[j];
        if(prd.order_status == 'Cancelled'){
            ordstatus = 'Cancelled'
        }else  
        if(prd.order_status == 'Completed'){
          ordstatus = 'Completed'
        }else{
          ordstatus = 'In Progress'
        }
        const customizedProduct = {
          cart_id: prd.cart_id,
          group_id:prd.group_id,
          order_date: prd.order_date,        
          coupon_discount: prd.coupon_discount,
          price_without_delivery: prd.price_without_delivery,
          user_id: prd.user_id,
          is_subscription: prd.is_subscription,
          si_order: prd.si_order,
          bank_id: prd.bank_id,
          //order_status: ordstatus,
          order_status:prd.order_status
          };
          
  
  
        customizedProductData.push(customizedProduct);  
      }
      return customizedProductData
    //return ongoing;
};

const ordersDetails = async (appDetatils) => {
   
    const { user_id  ,group_id} = appDetatils;
    const customizedProductData = [];
    const ongoing  = await knex('orders')
    .join('users', 'orders.user_id', '=', 'users.id')
    .join('address', 'orders.address_id', '=', 'address.address_id')
    .leftJoin('coupon', 'coupon.coupon_id', '=', 'orders.coupon_id')
   // .where('orders.cart_id', cart_id)
   .where('orders.group_id', group_id)
    .orderBy('orders.order_id', 'desc')
    .first();
    
    orderDate = format(ongoing.order_date, 'yyyy-MM-dd');

    ongoinglist = await knex('orders')
    .where('group_id', group_id)
    .sum('rem_price as rem_price')
   .sum('paid_by_wallet as paid_by_wallet')
   .sum('cod_charges as cod_charges');

    price_without_delivery = ongoinglist[0].rem_price + ongoinglist[0].paid_by_wallet + ongoinglist[0].cod_charges;
    
 

   const ongoing1  = await knex('orders')
   .join('users', 'orders.user_id', '=', 'users.id')
   .join('address', 'orders.address_id', '=', 'address.address_id')
   .where('orders.group_id', group_id)
   .orderBy('orders.order_id', 'desc');
   const customizedOrderData = [];
   let total_price = 0;
    let coupon_discount = 0;
   let startDeliveryDate = null;
   let orderStatus;
   for (let i = 0; i < ongoing1.length; i++) {
         const ProductList = ongoing1[i];
         if(ProductList.order_status != 'Cancelled')
         {
          orderStatus=ProductList.order_status;
         }

         const subscriptionOrderList = await knex('subscription_order')
         .where('cart_id', ProductList.cart_id)
         .where('order_status', 'Pending')
         .orderBy('delivery_date', 'asc')
         .first();
        
         startDeliveryDate = subscriptionOrderList ? subscriptionOrderList.delivery_date : null;
      
      
        const subOrdList =  await knex('subscription_order')
         .where('cart_id', ProductList.cart_id)
         .select('order_status')
         .first();
         
        const suborderstatus = subOrdList.order_status;
        
        
      
        const ordersss = await knex('store_orders')
        .where('order_cart_id', ProductList.cart_id)
        .select();
      
       
      
         for (const store of ordersss) {
          if(store.repeat_orders){
          const repeat_orderss = store.repeat_orders.split(',').map(order => order.trim());
           total_delivery_week = repeat_orderss.length * ProductList.total_delivery;
          }else{
            const repeat_orderss = 1
             total_delivery_week = repeat_orderss * ProductList.total_delivery;
          }
          
          total_price += store.price * total_delivery_week;
         }


          coupon_discount += ProductList.coupon_discount;


        const productDetails = await knex
        .select(
          'store_orders.store_order_id',
          'store_orders.product_name',
          'store_orders.varient_image',
          'store_orders.quantity',
          'store_orders.unit',
          'store_orders.varient_id',
          'store_orders.qty',
          knex.raw('(store_orders.price/store_orders.qty) as price'),
          'store_orders.total_mrp',
          'store_orders.order_cart_id',
          'store_orders.order_date',
          'store_orders.repeat_orders',
          'store_orders.type',
          'orders.order_status',
          'store_orders.sub_total_delivery',
          'store_orders.repeat_orders',
          'store_orders.subscription_flag',
          'subscription_order.order_status as prodorderstatus',
          'subscription_order.time_slot as prodwisetime_slot'
          )
        .from('store_orders')
        .join('orders','store_orders.order_cart_id','orders.cart_id')
        .join('subscription_order','store_orders.order_cart_id','subscription_order.cart_id')
        .where('order_cart_id', ProductList.cart_id);
   
      const customizedOrderData = [];
      for (let j = 0; j < productDetails.length; j++) {
      const itemProduct = productDetails[j];

      const dataasss = await knex('product_varient')
      .select('*')
      .join('product', 'product.product_id', '=', 'product_varient.product_id')
      .where('product_varient.varient_id', '=', itemProduct.varient_id)
      .first();

        const currentDate = new Date();
        let next_delivery_date ='';
        const subscription_order_o = await knex('subscription_order')
        .where('store_order_id', itemProduct.store_order_id)
        .where('delivery_date', '>=', currentDate)
        .where('order_status', 'Pending')
        .first();

        next_delivery_date = subscription_order_o ? subscription_order_o.delivery_date : undefined;

        let orderStatusDelivery;

        if (next_delivery_date) {
          next_delivery_date = format(next_delivery_date, 'yyyy-MM-dd');
        orderStatusDelivery = 'Active';
        } else {
        const subscription_order_completed = await knex('subscription_order')
        .where('store_order_id', itemProduct.store_order_id)
        .where('order_status', 'Completed')
        .select('*');

        const subscription_order_pending = await knex('subscription_order')
        .where('store_order_id', itemProduct.store_order_id)
        .where('order_status', 'Pending')
        .select('*');

        if (subscription_order_completed.length > 0 || subscription_order_pending.length > 0) {
        orderStatusDelivery = 'Completed';
        } else {
        
        const subscription_order_cancelled = await knex('subscription_order')
        .where('store_order_id', itemProduct.store_order_id)
        .where('order_status', 'Cancelled')
        .select('*');   
        
        if (subscription_order_cancelled.length > 0 ){
       // orderStatusDelivery = 'Cancelled';
         orderStatusDelivery = '';
        }else
        {
        orderStatusDelivery = 'Pending';    
        }
        
        }
        next_delivery_date='';
        }
      //  return ongoing.order_status
        if(ongoing.order_status == 'Cancelled'){
          orderStatusDelivery = 'Cancelled'
        }

        prodrating = await knex('product_rating')
        .where('user_id',user_id)
        .where('cart_id',ProductList.cart_id)
        .where('varient_id',itemProduct.varient_id)
        .select('description','rating')
        .first();
        const rating=(prodrating) ? prodrating.rating : null;
        const review=(prodrating) ? prodrating.description : null;
       
      const baseurl =  process.env.BUNNY_NET_IMAGE;
      const customizedProduct = {
        store_order_id: itemProduct.store_order_id,
        varient_id: itemProduct.varient_id,
        product_name: itemProduct.product_name,        
        varient_image: baseurl + itemProduct.varient_image,
        thumbnail: baseurl + dataasss.thumbnail,
        unit: itemProduct.unit,
        // varient_id: itemProduct.orderStatusDeliveryvarient_id,
        product_id:dataasss.product_id,
        qty: itemProduct.qty,
        price: itemProduct.price,
        total_mrp: itemProduct.total_mrp,
        order_date: itemProduct.order_date,
        repeat_orders: itemProduct.repeat_orders,
        type: itemProduct.type,
        rating:rating,
        review:review,
       // order_status_delivery:orderStatusDelivery,
        prodorder_status:itemProduct.prodorderstatus,
        prodwisetime_slot:itemProduct.prodwisetime_slot,
        order_status_delivery:itemProduct.order_status,
        order_cart_id:itemProduct.order_cart_id,
      //  next_delivery_date:next_delivery_date,
        // Add or modify properties as needed
        };
        


      customizedProductData.push(customizedProduct);  
      }

   }


   
    let startDeliveryDates = (ongoing.delivery_date) ? format(ongoing.delivery_date, 'yyyy-MM-dd') : "null";
     //let order_date = format(ongoing.order_date, 'yyyy-MM-dd');
     
      ongoinglistnew = await knex('orders')
     .where('group_id', group_id)
     //.sum('total_products_mrp as total');
     .sum('total_products_mrp as total_products_mrp')
     .sum('rem_price as rem_price')
    .sum('paid_by_wallet as paid_by_wallet')
    .sum('cod_charges as cod_charges')
    .sum('coupon_discount as coupon_discount')
    .sum('del_partner_tip as del_partner_tip');

    // price_without_delivery = ongoinglistnew[0].rem_price + ongoinglistnew[0].paid_by_wallet;
    price_without_delivery = ongoinglistnew[0].total_products_mrp;
    total_products_mrp = ongoinglistnew[0].total_products_mrp;
    cod_charges =  ongoinglistnew[0].cod_charges;
    del_partner_tip = ongoinglistnew[0].del_partner_tip;
    coupon_discounts =ongoinglistnew[0].coupon_discount;
    paid_by_wallets =ongoinglistnew[0].paid_by_wallet;
    
    
         const grouplistcancel = await knex('orders')
        .where('group_id', group_id)
        .where('order_status', 'Cancelled')
        .select('group_id'); 
        
   

     
    //   grouplisttotal = await knex('orders')
    //  .where('group_id', ongoing.group_id)
    //   .select('*'); 
         const grouplisttotal = await knex('orders')
      .where('group_id', group_id)
      .select('group_id');
       //const entryCount = grouplisttotal.length;
     //return entryCount;
     
      if(grouplistcancel.length == grouplisttotal.length){
      groupstatus = "Cancelled";
      }else if(orderStatus){
        groupstatus=orderStatus;
      }else{
      groupstatus = "Pending";
      }
      const cartIds = customizedProductData.map(o => o.order_cart_id); 
      const ratingData = await  knex('delivery_rating')
      .where('user_id', user_id)
      .whereIn('cart_id', cartIds)
      .select('cart_id', 'description', 'rating')
      .first();

     
    const customizedData = {
        group_id : ongoing.group_id,
       address_name : ongoing.receiver_name,
        //delivery_address: ongoing.building_villa+","+ongoing.street+","+ongoing.society+","+ongoing.city,
         delivery_address: ongoing.house_no,
         order_status: groupstatus,
        delivery_date:startDeliveryDates,
        time_slot: ongoing.time_slot,
       // payment_method: ongoing.si_order == 'no' ? 'Wallet' : 'Card Payment',
         payment_method: ongoing.payment_method,
        cart_id: ongoing.cart_id,
        total_price:(price_without_delivery+coupon_discounts).toFixed(2),
        delivery_charge: ongoing.delivery_charge,
        
       // price_without_delivery:total_price,
        price_without_delivery :price_without_delivery.toFixed(2),
        cod_charges:Math.round(cod_charges),
        del_partner_tip:Math.round(del_partner_tip),
        user_id: ongoing.user_id,
        total_products_mrp:total_price,
        cancelling_reason: ongoing.cancelling_reason,
        //order_date: order_date,
         order_date: orderDate,
        coupon_code:ongoing.coupon_code,
        coupon_discount: coupon_discounts.toFixed(2),
        paid_by_wallet:paid_by_wallets.toFixed(2),
        is_subscription: ongoing.is_subscription,
        total_delivery: ongoing.total_delivery,
        repeat_orders: ongoing.repeat_orders,
        si_order: ongoing.si_order,
        vat:'0.0',
        drating: (ratingData) ? ratingData.rating : 0,
        dreview: (ratingData) ? ratingData.description:'',
        data:customizedProductData,
       };
       customizedOrderData.push(customizedData);  
return customizedOrderData;
    
};

const ordersDetailsold = async (appDetatils) => {
   
    const { user_id ,cart_id} = appDetatils;
    const customizedProductData = [];
    const ongoing  = await knex('orders')
    .join('users', 'orders.user_id', '=', 'users.id')
    .join('address', 'orders.address_id', '=', 'address.address_id')
    .where('orders.cart_id', cart_id)
    .orderBy('orders.order_id', 'desc')
    .first();
    
   const subscriptionOrderList = await knex('subscription_order')
   .where('cart_id', cart_id)
   .where('order_status', 'Pending')
   .orderBy('delivery_date', 'asc')
   .first();

    const startDeliveryDate = subscriptionOrderList ? subscriptionOrderList.delivery_date : null;


  const ordersss = await knex('store_orders')
  .where('order_cart_id', cart_id)
  .select();

   let total_price = 0;

  for (const store of ordersss) {
    if(store.repeat_orders){
    const repeat_orderss = store.repeat_orders.split(',').map(order => order.trim());
     total_delivery_week = repeat_orderss.length * ongoing.total_delivery;
    }else{
      const repeat_orderss = 1
       total_delivery_week = repeat_orderss * ongoing.total_delivery;
    }
    
    total_price += store.price * total_delivery_week;
   }

   const productDetails = await knex
  .select(
    'store_order_id',
    'product_name',
    'varient_image',
    'quantity',
    'unit',
    'varient_id',
    'qty',
    knex.raw('(price/qty) as price'),
    'total_mrp',
    'order_cart_id',
    'order_date',
    'repeat_orders',
    'type'
  )
  .from('store_orders')
  .where('order_cart_id', ongoing.cart_id);
   
  const customizedOrderData = [];
      for (let j = 0; j < productDetails.length; j++) {
      const itemProduct = productDetails[j];

      const dataasss = await knex('product_varient')
      .select('*')
      .join('product', 'product.product_id', '=', 'product_varient.product_id')
      .where('product_varient.varient_id', '=', itemProduct.varient_id)
      .first();

        const currentDate = new Date();
        let next_delivery_date ='';
        const subscription_order_o = await knex('subscription_order')
        .where('store_order_id', itemProduct.store_order_id)
        .where('delivery_date', '>=', currentDate)
        .where('order_status', 'Pending')
        .first();

        next_delivery_date = subscription_order_o ? subscription_order_o.delivery_date : undefined;

        let orderStatusDelivery;

        if (next_delivery_date) {
          next_delivery_date = format(next_delivery_date, 'yyyy-MM-dd');
        orderStatusDelivery = 'Active';
        } else {
        const subscription_order_completed = await knex('subscription_order')
        .where('store_order_id', itemProduct.store_order_id)
        .where('order_status', 'Completed')
        .select('*');

        const subscription_order_pending = await knex('subscription_order')
        .where('store_order_id', itemProduct.store_order_id)
        .where('order_status', 'Pending')
        .select('*');

        if (subscription_order_completed.length > 0 || subscription_order_pending.length > 0) {
        orderStatusDelivery = 'Completed';
        } else {
        
        const subscription_order_cancelled = await knex('subscription_order')
        .where('store_order_id', itemProduct.store_order_id)
        .where('order_status', 'Cancelled')
        .select('*');   
        
        if (subscription_order_cancelled.length > 0 ){
        //orderStatusDelivery = 'Cancelled';
          orderStatusDelivery = '';
        }else
        {
        orderStatusDelivery = 'Pending';    
        }
        
        }
        next_delivery_date='';
        }
        
        if(ongoing.order_status == 'Cancelled'){
          orderStatusDelivery = 'Cancelled'
        }
        const baseurl =  process.env.BUNNY_NET_IMAGE;
      const customizedProduct = {
        store_order_id: itemProduct.store_order_id,
        product_name: itemProduct.product_name,        
        varient_image: baseurl + itemProduct.varient_image,
        thumbnail: baseurl + dataasss.thumbnail,
        unit: itemProduct.unit,
        varient_id: itemProduct.orderStatusDeliveryvarient_id,
        qty: itemProduct.qty,
        price: itemProduct.price,
        total_mrp: itemProduct.total_mrp,
        order_date: itemProduct.order_date,
        repeat_orders: itemProduct.repeat_orders,
        type: itemProduct.type,
        order_status_delivery:orderStatusDelivery,
        next_delivery_date:next_delivery_date,
        // Add or modify properties as needed
        };
        


      customizedProductData.push(customizedProduct);  
      }
   
     let startDeliveryDates = startDeliveryDate ? format(startDeliveryDate, 'yyyy-MM-dd') : "null";
     let order_date = format(ongoing.order_date, 'yyyy-MM-dd');
     
    const customizedData = {
        address_name : ongoing.receiver_name,
        delivery_address: ongoing.building_villa+","+ongoing.street+","+ongoing.society+","+ongoing.city,
        order_status: ongoing.order_status,
        delivery_date:startDeliveryDates,
        time_slot: ongoing.time_slot,
        payment_method: ongoing.si_order == 'no' ? 'Wallet' : 'Card Payment',
        cart_id: ongoing.cart_id,
        total_price:total_price,
        delivery_charge: ongoing.delivery_charge,
        coupon_discount: ongoing.coupon_discount,
        price_without_delivery:total_price,
        user_id: ongoing.user_id,
        total_products_mrp:total_price,
        cancelling_reason: ongoing.cancelling_reason,
        order_date: order_date,
        coupon_id: ongoing.coupon_id,
        is_subscription: ongoing.is_subscription,
        total_delivery: ongoing.total_delivery,
        repeat_orders: ongoing.repeat_orders,
        si_order: ongoing.si_order,
        data:customizedProductData,
       };
       customizedOrderData.push(customizedData);  
return customizedOrderData;
    
};

const getQuickRepeatedPlaceOrder = async (appDetails) => {
  // Destructuring variables from appDetails
  const { cart_id, user_id, order_type, replace_status } = appDetails;

  // Check if required parameters are present
  if (cart_id && user_id && (replace_status === 0 || replace_status === 1)) {
    // Fetch orders that have the cart_id as repeated_order_cart
    const orders_detailsss = await knex('store_orders')
      .where('repeated_order_cart', '=', cart_id)
      .where('order_cart_id', '=', 'incart');

    // If no existing repeated orders, proceed
    if (orders_detailsss.length === 0) {
      // Fetch orders with the current cart_id
     
      const ordersDetails = await knex('orders').where('cart_id', '=', cart_id).first();
      const groupID=ordersDetails.group_id;
      const orderData = await knex('orders').where('group_id', groupID).pluck('cart_id');
      const orders_details = await knex('store_orders').whereIn('order_cart_id', orderData);
      // If replace_status is 0, delete existing in-cart orders for the user
      if (replace_status === 0) {
        await knex('store_orders')
          .where('store_approval', user_id)
          .where('order_cart_id', '=', 'incart')
          .whereNull('subscription_flag')
          .delete();
      }

      // Iterate over each order detail to insert or update records
      for (const ordersdetails of orders_details) {
        // Check if the order with the same varient_id already exists
        const rec = await knex('store_orders')
          .where('store_approval', user_id)
          .where('varient_id', ordersdetails.varient_id)
          .where('order_cart_id', '=', 'incart');

        // If record exists, delete it to update with new values
        if (rec.length > 0) {
          await knex('store_orders')
            .where('store_approval', user_id)
            .where('varient_id', ordersdetails.varient_id)
            .where('order_cart_id', '=', 'incart')
            .whereNull('subscription_flag')
            .delete();
        }

        // Fetch variant details
        const varient_details = await knex('store_products')
          .where('varient_id', '=', ordersdetails.varient_id)
          .first();

        let totalMrp;
        // Calculate total MRP based on order type
        if (order_type === 'subscription') {
          const repeatOrders = ordersdetails.repeat_orders.trim().split(',');
          totalMrp = repeatOrders.length * (ordersdetails.qty*varient_details.price);
        } else if (order_type === 'quick') {
          totalMrp = (ordersdetails.qty*varient_details.price);
        }

        // Insert new order with current details
        await knex('store_orders').insert({
          product_name: ordersdetails.product_name,
          varient_image: ordersdetails.varient_image,
          quantity: ordersdetails.quantity,
          unit: ordersdetails.unit,
          varient_id: ordersdetails.varient_id,
          qty: ordersdetails.qty,
          price: (ordersdetails.qty*varient_details.price),
          total_mrp: totalMrp,
          order_cart_id: 'incart',
          order_date: new Date(), // Uses the current date and time
          repeat_orders: ordersdetails.repeat_orders,
          store_approval: user_id,
          store_id: ordersdetails.store_id,
          description: ordersdetails.description,
          tx_per: ordersdetails.tx_per,
          price_without_tax: varient_details.price,
          tx_price: ordersdetails.tx_price,
          type: ordersdetails.type,
          repeated_order_cart: ordersdetails.order_cart_id,
          buying_price: ordersdetails.buying_price,
          base_mrp: ordersdetails.base_mrp,
          subscription_flag: ordersdetails.subscription_flag,
          //sub_time_slot: ordersdetails.sub_time_slot,
          //sub_delivery_date: ordersdetails.sub_delivery_date,
          sub_total_delivery: ordersdetails.sub_total_delivery,
          sub_time_slot:null,
          sub_delivery_date: null,
          percentage: ordersdetails.percentage,
        });
      }

      return 1; // Success
    } else {
      throw new Error('Order already added.');
    }
  } else {
    throw new Error('Invalid parameters.');
  }
};

const getProductOngoingsub  = async (appDetatils) => {
  await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
  const user_id = appDetatils.user_id;
  const store_id = appDetatils.store_id;
  const groupID = appDetatils.group_id;
  ongoing = await knex('orders')
  .select('store_orders.varient_id','orders.cart_id',knex.raw('DATE_FORMAT(orders.delivery_date, "%Y-%m-%d") as delivery_date'),
  knex.raw('DATE_FORMAT(orders.order_date, "%Y-%m-%d") as order_date'),'orders.total_delivery',
  knex.raw('SUM(store_orders.price) as price'),'store_orders.store_order_id', 'store_orders.product_name', 'store_orders.total_mrp','store_orders.repeat_orders','orders.order_status','orders.si_order','orders.si_sub_ref_no','orders.pastorecentrder','store_orders.varient_image')
  .join('store_orders','orders.cart_id','=','store_orders.order_cart_id')
  .where('order_cart_id','!=','incart')
  .where('orders.user_id',user_id)
  .where('orders.store_id',store_id)
  .where('orders.group_id',groupID)
  .where('orders.order_status', '!=', 'NULL')
  .where('orders.is_subscription', '=',1)
  .where('orders.payment_method', '!=', 'NULL')
  .groupBy('orders.cart_id')
  .orderBy('orders.order_id', 'DESC')
  const customizedProductData = [];
  for (let i = 0; i < ongoing.length; i++) {
    const ProductList = ongoing[i];
    ordersssss = await knex('subscription_order')
    .where('cart_id',ProductList.cart_id)
    .where('store_order_id',ProductList.store_order_id)
    .where('order_status','Pending')
    .orderBy('id','DESC')
    .first();
     if(ordersssss){
      subscription_id = ordersssss.subscription_id
    }else{
      subscription_id = '';
    }

    const  subscriptionOrder= await knex('subscription_order')
    .where('cart_id',ProductList.cart_id)
    // .where('store_order_id',ProductList.store_order_id)
    .where('order_status','Pending')
    .orderBy('id','ASC')
    .first();

    //  const  deliveryDate = (subscriptionOrder) ? subscriptionOrder.delivery_date : '';
    const formattedDeliveryDate = subscriptionOrder ? format(new Date(subscriptionOrder.delivery_date), 'yyyy-MM-dd') : '';
  
  const pendingResult = await knex('subscription_order')
  .where('cart_id',ProductList.cart_id)
  .where('order_status','Pending')
  .count({ pending_count: 'order_id' });


    const AllResult = await knex('subscription_order')
    .where('cart_id',ProductList.cart_id)
    .andWhere(function() {
    this.where('order_status', 'Pending')
    .orWhere('order_status', 'Completed')
    .orWhere('order_status', 'Confirmed')
    .orWhere('order_status', 'Out_For_Delivery');
    })
    .count({ all_count: 'order_id' });


  const pendingCount=pendingResult[0].pending_count;
  const allCount=AllResult[0].all_count;
    
    delivery_date=ProductList.delivery_date;
    let today = new Date();
    
    if(pendingCount > 0)
    {
    order_status="Pending";
    }
    else
    {
    order_status="Completed";
    }

      const cancelledResult = await knex('subscription_order')
      .where('cart_id',ProductList.cart_id)
      .where('order_status','Cancelled')
      .count({ cancelled_count: 'order_id' });
      const cancelledCount=cancelledResult[0].cancelled_count;
    if(cancelledCount > 0 && allCount <= 0){
        order_status="Cancelled";
    }

      const completedResult = await knex('subscription_order')
      .where('cart_id',ProductList.cart_id)
      .where('order_status','Completed')
      .count({ completed_count: 'order_id' });
      const completedCount=completedResult[0].completed_count;
      if(completedCount > 0 && pendingCount > 0){
      order_status="Inprogress";
      }


        const pastorecentrder=ProductList.pastorecentrder;

        parentOrders = await knex('orders')
        .where('cart_id',ProductList.cart_id)
        .first();
        let totalMRP=(pastorecentrder == 'old') ? (parentOrders.total_products_mrp)  : ProductList.price;
        const baseurl =  process.env.BUNNY_NET_IMAGE;
        const prodrating = await knex('product_rating')
        .where('user_id',user_id)
        .where('cart_id',ProductList.cart_id)
        .where('varient_id',ProductList.varient_id)
        .select('description','rating')
        .first();
        if(prodrating){
        rating = prodrating.rating;
        review = prodrating.description;
        }else{
        rating = null;
        review = null;
        }

        prodvar = await knex('product_varient')
        .where('varient_id',ProductList.varient_id)
        .select('product_id')
        .first();
 
        const customizedProduct = {
          cart_id: ProductList.cart_id,        
          order_date: ProductList.order_date,
          delivery_date: formattedDeliveryDate,
          total_delivery: ProductList.total_delivery,
          product_name: ProductList.product_name,
          product_image:baseurl + ProductList.varient_image+"?width=200&height=200&quality=100",
          total_mrp: totalMRP,
          repeat_orders:ProductList.repeat_orders,
          order_status: order_status,
          store_order_id : ProductList.store_order_id,
          subscription_id : subscription_id,
          si_order:ProductList.si_order,
          si_sub_ref_no:ProductList.si_sub_ref_no,
          pastorecentrder:ProductList.pastorecentrder,
          review:review,
          rating:rating,
          product_id:prodvar.product_id,
          varient_id:ProductList.varient_id,
          // Add or modify properties as needed
          };
      
        customizedProductData.push(customizedProduct);  
  }
   return customizedProductData;
};

const getOngoingsublist = async (appDetails) => {
  await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))');
  const { user_id, store_id, page: pageFilter, perpage: perPage } = appDetails;
  const offset = (pageFilter - 1) * perPage;
  // Base query for ongoing subscriptions
  const ongoingQuery = knex('orders')
    .select(
      knex.raw('SUM(orders.total_products_mrp) as totalProductsMrp'),
      'orders.group_id',
      'orders.cart_id',
      knex.raw('DATE_FORMAT(orders.delivery_date, "%Y-%m-%d") as delivery_date'),
      knex.raw('DATE_FORMAT(orders.order_date, "%Y-%m-%d") as order_date'),
      'orders.total_delivery',
      'store_orders.price',
      'store_orders.store_order_id',
      'store_orders.product_name',
      'store_orders.total_mrp',
      'store_orders.repeat_orders',
      'orders.order_status',
      'orders.si_order',
      'orders.si_sub_ref_no',
      'orders.pastorecentrder'
    )
    .join('store_orders', 'orders.cart_id', '=', 'store_orders.order_cart_id')
    .where('order_cart_id', '!=', 'incart')
    .where('orders.user_id', user_id)
    .where('orders.store_id', store_id)
    .whereNotNull('orders.order_status')
    .where('orders.is_subscription', 1)
    .whereNotNull('orders.payment_method')
    .groupBy('orders.group_id')
    .orderBy('orders.order_id', 'DESC')
    .limit(perPage)
    .offset(offset);
  const ongoing = await ongoingQuery;
  // Extract cart_ids for batch processing
  const cartIds = ongoing.map(o => o.cart_id);
  const storeOrderIds = ongoing.map(o => o.store_order_id);
  // Fetch subscription orders, order details, and ratings in parallel
  const [subscriptionOrders, orderDetails, deliveryRatings] = await Promise.all([
    knex('subscription_order')
      .whereIn('cart_id', cartIds)
      .whereIn('store_order_id', storeOrderIds)
      .where('order_status', 'Pending')
      .orderBy('id', 'DESC')
      .select('cart_id', 'store_order_id', 'subscription_id', 'delivery_date', 'order_status'),
    knex('orders')
      .whereIn('cart_id', cartIds)
      .select('cart_id', 'total_products_mrp', 'pastorecentrder'),
    knex('delivery_rating')
      .where('user_id', user_id)
      .whereIn('cart_id', cartIds)
      .select('cart_id', 'description', 'rating')
  ]);
  // Create a map for delivery ratings by cart_id
  const deliveryRatingsMap = Object.fromEntries(
    deliveryRatings.map(rating => [rating.cart_id, { rating: rating.rating, description: rating.description }])
  );
  // Process ongoing subscriptions
  const customizedProductData = ongoing.map(product => {
    const subscriptionOrder = subscriptionOrders.find(o => o.cart_id === product.cart_id && o.store_order_id === product.store_order_id);
    const formattedDeliveryDate = subscriptionOrder ? format(new Date(subscriptionOrder.delivery_date), 'yyyy-MM-dd') : '';
    const orderDetail = orderDetails.find(o => o.cart_id === product.cart_id);
    const ratingData = deliveryRatingsMap[product.cart_id] || { rating: null, description: null };
    const totalProductsMrp = product.pastorecentrder === 'old' ? orderDetail.total_products_mrp : product.totalProductsMrp;
    const deliveryDate = new Date(product.delivery_date);
    const today = new Date();
    //let orderStatus = deliveryDate > today ? 'Active' : 'Inactive';
    let orderStatus = deliveryDate > today ? 'Pending' : 'Completed';
    if (product.order_status === 'Cancelled') orderStatus = 'Cancelled';
    return {
      group_id: product.group_id,
      cart_id:product.cart_id,
      order_date: product.order_date,
      total_mrp: parseFloat(totalProductsMrp).toFixed(2),
      subscription_id: subscriptionOrder ? subscriptionOrder.subscription_id : '',
      order_status: orderStatus,
      si_order: product.si_order,
      si_sub_ref_no: product.si_sub_ref_no,
      drating: ratingData.rating,
      dreview: ratingData.description
    };
  });
  return customizedProductData;
};


module.exports = {
getMyOrder,
ordersDetails,
getrepeatOrder,
getOngoingsub,
totaldeliveries,
ordsubDetails,
getcancelOrderres,
getRepeatedplaceorder,
getCancelOrder,
getCancelprdOrder,
getSubpauseorder,
getMydailyOrder,
getCancelquickOrder,
getCancelquickOrderProd,
getSubresumeorder,
grpordDetails,
getQuickRepeatedPlaceOrder,
getProductOngoingsub,
getOngoingsublist
};