const { application } = require('express');
const knex = require('../db'); // Import your Knex instance
const math = require('mathjs');  // If using a third-party math library
const crypto = require('crypto'); 


const preparePaymentData = async (appDetails) => {
  // Order Information
  const currencyval = 'AED';
    if(appDetails.user_id != "null" ){
    user_id = appDetails.user_id
  }else{
      user_id = appDetails.device_id
  }
  //const user_id = appDetails.user_id;
  const address_id = appDetails.address_id;
 // const discount_amount = appDetails.coupon_discount_amount;
  //const paid_by_wallet = appDetails.paid_by_wallet;
  const totalwalletamt = appDetails.totalwalletamt;
  const payment_method = appDetails.payment_method;
  const store_id = 7;
  
   const bank_id = 0;
  const si_sub_ref_no = appDetails.si_sub_ref_no;
  const wallet = appDetails.wallet;
  const payment_gateway = appDetails.payment_gateway;
  const payment_id = appDetails.payment_id;
  const coupon_id = appDetails.coupon_id;
  const coupon_code = appDetails.coupon_code;
   discount_amount =  appDetails.discount_amount;
  const delivery_date =  appDetails.delivery_date;
  const time_slot =  appDetails.time_slot;
  const del_partner_tip =  appDetails.del_partner_tip;
  const del_partner_instruction = appDetails.del_partner_instruction;
  const device_id = appDetails.device_id;
  const is_subscription = appDetails.is_subscription;
  const payment_status = appDetails.payment_status;

  const sum = await knex('store_orders')
    .join('store_products', 'store_orders.varient_id', '=', 'store_products.varient_id')
    .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
    .join('product', 'product_varient.product_id', '=', 'product.product_id')
    .where('store_products.store_id', store_id)
    .where('store_orders.store_approval', user_id)
    .where('store_orders.order_cart_id', 'incart')
    .where('store_orders.subscription_flag', null)
    .select(knex.raw('SUM(store_orders.price) as sum'))
    .first();


  if (!sum) {
    throw new Error('Cart is empty');
  }

  const price2 = parseFloat(sum.sum).toFixed(2);

  const deliveryFlag = await knex('app_settings')
    .where('store_id', store_id)
    .select('cod_charges')
    .first();

  const codCharges = (payment_method === 'COD' || payment_method === 'cod') ? deliveryFlag.cod_charges : 0;

  const deliveryChargeInfo = await knex('freedeliverycart')
    .where('store_id', store_id)
    .first();

  let charge = 0;
  if (deliveryChargeInfo) {
    charge = (deliveryChargeInfo.min_cart_value <= price2) ? 0 : deliveryChargeInfo.delivery_charge;
  }

  const rem_price = price2 + charge + codCharges;
  const fprice = parseFloat(rem_price).toFixed(2);
  //const finalrem_price = parseFloat(fprice) - parseFloat(paid_by_wallet);
  const finalrem_price = parseFloat(fprice) - parseFloat(totalwalletamt);
  
    if(coupon_code){
    coupon = await knex('coupon')
    .where('coupon_code', coupon_code)
    .first(); 

    am = coupon.amount;  
    type = coupon.type;
     total_delivery = 1;
     p =  total_delivery * price2;
    if(type=='%'||type=='Percentage'||type=='percentage'){
        per = (p*am)/100;  
      
      //  discount_amount = p-per;
      discount_amount=per
    }
    else{
       
        per = am;
        discount_amount = p-am; 
    }
  }else{
      discount_amount = 0;
  }
  
  //return discount_amount;
  
  const pay_amount = (discount_amount != 0) ? (finalrem_price - discount_amount).toFixed(2) : finalrem_price.toFixed(2);

  const minval = 10000;
  const maxval = 99999;

  // Generate random letters
  const chars1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
  let val1 = "";
  for (let i = 0; i < 6; i++) {
    val1 += chars1.charAt(Math.floor(Math.random() * chars1.length));
  }

  // Generate random digits
  const chars3 = "0123456789";
  let val3 = "";
  for (let i = 0; i < 2; i++) {
    val3 += chars3.charAt(Math.floor(Math.random() * chars3.length));
  }

  // Generate a random substring from md5 hash of current time
  const cr1 = crypto.createHash('md5').update(String(Date.now())).digest('hex').substr(Math.floor(Math.random() * 25), 2);

  // Combine all parts to form cart_id
  const randomNumber = val1 + val3 + cr1;
  const number = randomNumber;
  const description = 'Order description';
  const amount = pay_amount; // Ensure two decimal places
  const currency = currencyval;

  // TotalPay Credentials for Test/Live
  // const merchantKey = '7f066cba-36b4-11ee-86cb-eecb8191d36e';
  // const merchantpassword = '96bb03851c3553fd132339acc06ce060';
  // TotalPay Credentials for Live
  const merchantKey = '7f066f26-36b4-11ee-8433-eecb8191d36e';
  const merchantpassword = '96bb03851c3553fd132339acc06ce060';

  const hashData = `${number}${amount}${currency}${description}${merchantpassword}`;
  const hash = crypto.createHash('sha1').update(crypto.createHash('md5').update(hashData.toUpperCase()).digest('hex')).digest('hex');

  const userdetails = await knex('users')
    .where('id', user_id)
    .select('name', 'email')
    .first();

  // Customer Information
  const customerInfo = { name: userdetails.name, email: userdetails.email }; // Only include email as per comments

  const address = await knex('address')
  //  .join('city', 'address.city_id', '=', 'city.city_id')
    .where('address.address_id', address_id)
    .select('address.receiver_phone', 'address.house_no', 'address.state')
    .first();

  // Billing Information
  const billingAddress = {
    country: 'AE',
    state: 'Dubai',
    city: 'Dubai',
    address: address.house_no,
    phone: address.receiver_phone
  };
  
//return billingAddress;
const group_id = number;
 const ordertype = 'quick';

  const orderJson = { number, description, amount, currency };
   const custom_data = {ordertype,payment_status,group_id,user_id, address_id, bank_id,si_sub_ref_no,store_id,payment_method,wallet,payment_gateway,payment_id,coupon_id,coupon_code,discount_amount,delivery_date,time_slot,del_partner_tip,del_partner_instruction,device_id,totalwalletamt,is_subscription}
  

  const mainJson = {
    merchant_key: merchantKey,
    operation: 'purchase',
    methods: ['card'],
    success_url: 'https://quickart2.quickart.ae/nodejsapp/api/success',
    cancel_url: 'https://quickart2.quickart.ae/nodejsapp/api/failure',
    hash,
    order: orderJson,
    customer: customerInfo,
    billing_address: billingAddress,
    custom_data:custom_data
  };

  const jsonData = JSON.stringify(mainJson);
  const checkoutUrl = 'https://checkout.totalpay.global/api/v1/session';

  try {
    const fetch = (await import('node-fetch')).default;

    const response = await fetch(checkoutUrl, {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: jsonData,
    });

    if (!response.ok) {
      throw new Error(`HTTP error! Status: ${response.status}`);
    }

    return await response.json();
  } catch (error) {
    console.error('Error sending payment data:', error);
    throw error; // Re-throw for handling in the calling code
  }
};

const subPaymentData = async (appDetails) => {
  // Order Information
  const currencyval = 'AED';
    if(appDetails.user_id != "null" ){
    user_id = appDetails.user_id
  }else{
      user_id = appDetails.device_id
  }

    const is_subscription = appDetails.is_subscription;
  const address_id = appDetails.address_id;
  const bank_id = 0;
  const si_sub_ref_no = appDetails.si_sub_ref_no;
  const store_id = 7;
  const payment_method = appDetails.payment_method;
  const wallet = appDetails.wallet;
  const payment_id = appDetails.payment_id;
  const payment_gateway = appDetails.payment_gateway;
  const coupon_id = appDetails.coupon_id;
  const coupon_code = appDetails.coupon_code;
  discount_amount =  appDetails.discount_amount;
  const del_partner_instruction = appDetails.del_partner_instruction;
  device_id = appDetails.device_id;
  const payment_status = appDetails.payment_status;

  const sum = await knex('store_orders')
    .join('store_products', 'store_orders.varient_id', '=', 'store_products.varient_id')
    .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
    .join('product', 'product_varient.product_id', '=', 'product.product_id')
    .where('store_products.store_id', store_id)
    .where('store_orders.store_approval', user_id)
    .where('store_orders.order_cart_id', 'incart')
    .where('store_orders.subscription_flag', 1)
    .select(knex.raw('SUM(store_orders.price) as sum'))
    .first();


  if (!sum) {
    throw new Error('Cart is empty');
  }

  const price2 = parseFloat(sum.sum).toFixed(2);



  const deliveryChargeInfo = await knex('freedeliverycart')
    .where('store_id', store_id)
    .first();

  let charge = 0;
  if (deliveryChargeInfo) {
    charge = (deliveryChargeInfo.min_cart_value <= price2) ? 0 : deliveryChargeInfo.delivery_charge;
  }

  const rem_price = price2 + charge ;
  
  
   // reserve_amount = (total_price*50)/100;
  reserve_amount = (price2*50)/100;
                                              
  ph = await knex('users')
.select('name','user_phone','wallet')
.where('id',user_id)
.first();

if(ph){
   phwallet = ph.wallet;
}else{
   phwallet = 0;
}

if(phwallet >= reserve_amount){
   finalreserve_amount = reserve_amount;
}else{
   finalreserve_amount = phwallet;
}

  rem_price1= (rem_price - finalreserve_amount)
  
  const fprice = parseFloat(rem_price1).toFixed(2);
  //const finalrem_price = parseFloat(fprice) - parseFloat(paid_by_wallet);
  const finalrem_price = parseFloat(fprice);
  
    if(coupon_code){
    coupon = await knex('coupon')
    .where('coupon_code', coupon_code)
    .first(); 

    am = coupon.amount;  
    type = coupon.type;
     total_delivery = 1;
     p =  total_delivery * price2;
    if(type=='%'||type=='Percentage'||type=='percentage'){
        per = (p*am)/100;  
      
      //  discount_amount = p-per;
      discount_amount=per
    }
    else{
       
        per = am;
        discount_amount = p-am; 
    }
  }else{
      discount_amount = 0;
  }
  
  //return discount_amount;
  
  const pay_amount = (discount_amount != 0) ? (finalrem_price - discount_amount).toFixed(2) : finalrem_price.toFixed(2);

  const minval = 10000;
  const maxval = 99999;

  // Generate random letters
  const chars1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
  let val1 = "";
  for (let i = 0; i < 6; i++) {
    val1 += chars1.charAt(Math.floor(Math.random() * chars1.length));
  }

  // Generate random digits
  const chars3 = "0123456789";
  let val3 = "";
  for (let i = 0; i < 2; i++) {
    val3 += chars3.charAt(Math.floor(Math.random() * chars3.length));
  }

  // Generate a random substring from md5 hash of current time
  const cr1 = crypto.createHash('md5').update(String(Date.now())).digest('hex').substr(Math.floor(Math.random() * 25), 2);

  // Combine all parts to form cart_id
  const randomNumber = val1 + val3 + cr1;
  const number = randomNumber;
  const description = 'Order description';
  const amount = pay_amount; // Ensure two decimal places
  const currency = currencyval;

  // TotalPay Credentials for Test/Live
  const merchantKey = '';
  const merchantpassword = '96bb03851c3553fd132339acc06ce060';

  const hashData = `${number}${amount}${currency}${description}${merchantpassword}`;
  const hash = crypto.createHash('sha1').update(crypto.createHash('md5').update(hashData.toUpperCase()).digest('hex')).digest('hex');

  const userdetails = await knex('users')
    .where('id', user_id)
    .select('name', 'email')
    .first();

  // Customer Information
  const customerInfo = { name: userdetails.name, email: userdetails.email }; // Only include email as per comments

  const address = await knex('address')
  //  .join('city', 'address.city_id', '=', 'city.city_id')
    .where('address.address_id', address_id)
    .select('address.receiver_phone', 'address.house_no', 'address.state')
    .first();

  // Billing Information
  const billingAddress = {
    country: 'AE',
    state: 'Dubai',
    city: 'Dubai',
    address: address.house_no,
    phone: address.receiver_phone
  };
  
//return billingAddress;
const group_id = number;
 const ordertype = 'subscription';

  const orderJson = { number, description, amount, currency };
  const custom_data = {ordertype,payment_status,group_id,user_id, address_id, bank_id,si_sub_ref_no,store_id,payment_method,wallet,payment_gateway,payment_id,coupon_id,coupon_code,discount_amount,del_partner_instruction,device_id,is_subscription}

  const mainJson = {
    merchant_key: merchantKey,
    operation: 'purchase',
    methods: ['card'],
    success_url: 'https://quickart2.quickart.ae/nodejsapp/api/success',
    cancel_url: 'https://quickart2.quickart.ae/nodejsapp/api/failure',
    hash,
    order: orderJson,
    customer: customerInfo,
    billing_address: billingAddress,
    custom_data:custom_data
  };

  const jsonData = JSON.stringify(mainJson);
  const checkoutUrl = 'https://checkout.totalpay.global/api/v1/session';

  try {
    const fetch = (await import('node-fetch')).default;

    const response = await fetch(checkoutUrl, {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: jsonData,
    });

    if (!response.ok) {
      throw new Error(`HTTP error! Status: ${response.status}`);
    }

    return await response.json();
  } catch (error) {
    console.error('Error sending payment data:', error);
    throw error; // Re-throw for handling in the calling code
  }
};



module.exports = {
    preparePaymentData,
    subPaymentData
    };