// models/orderModel.js
const { application } = require('express');
const knex = require('../db'); // Import your Knex instance
const math = require('mathjs');  // If using a third-party math library
const moment = require('moment');
require('moment-timezone');
const uaeTime = moment.tz(new Date(), "Asia/Dubai");
const wordCount = require('word-count');


const getTopSelling = async (appDetatils) => {
   await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
   const {store_id,byname,min_price,max_price,stock, min_discount,max_discount,min_rating,max_rating,sort,sortname,sortprice,cat_id, sub_cat_id,page,perpage} = appDetatils;
   const pageFilter = page; // You can adjust the page number dynamically
   const perPage = perpage;
  
   if(appDetatils.user_id != "null" ){
    user_id = appDetatils.user_id
  }else{
      user_id = appDetatils.device_id
  }

    const minprice = parseFloat(min_price)
    const  maxprice = parseFloat(max_price)
    const  mindiscount = parseFloat(min_discount)
    const  maxdiscount = parseFloat(max_discount)
    const subcatid = sub_cat_id
   
   
    let categoryarray;
    if (cat_id !== "null") {
    categoryarray = await knex('categories').where('parent', cat_id).pluck('cat_id');
    }

    let categoryList = await knex('categories').where('parent', 121).pluck('cat_id');

     const topsellingsQuery = knex('store_products')
     .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
     .join('product', 'product_varient.product_id', '=', 'product.product_id')
     .leftJoin('deal_product', 'product_varient.varient_id', '=', 'deal_product.varient_id')
     .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
     .select(
       'store_products.stock',
       'product_varient.varient_id',
       'product_varient.description',
       'product.product_id',
       'product.product_name',
       'product.product_image',
       'product.thumbnail',
       'store_products.price',
       'store_products.mrp',
       'product_varient.unit',
       'product_varient.quantity',
       'product.type',
       'product.percentage',
       'product.availability',
       'product.country_id',
       'tbl_country.country_icon',
       knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
       knex.raw('100-((deal_product.deal_price*100)/store_products.mrp) as discountper1'),
      )
     .groupBy(
       'store_products.store_id',
       'product_varient.varient_id',
       'product.product_id'
     )
     .where('store_products.store_id', store_id)
     .where('product.hide', 0)
     .whereIn('product.cat_id', categoryList)
     .where('product.is_delete', 0);
 
   
    
 if (categoryarray)  {
  topsellingsQuery.whereIn('product.cat_id', categoryarray);
  }
 
  
  if (sub_cat_id !== "null")  {
    topsellingsQuery.where('product.cat_id', subcatid);
  }


  if ((minprice === 0 || minprice) && maxprice) {
    topsellingsQuery.whereBetween('store_products.price', [minprice, maxprice]);
    }
  
  if (mindiscount && maxdiscount) {
  topsellingsQuery.havingRaw('(discountper BETWEEN ? AND ?) OR (discountper1 BETWEEN ? AND ?)', [
    mindiscount,
    maxdiscount,
    mindiscount,
    maxdiscount,
  ]);
  }
 if (sortprice === 'ltoh') {
   topsellingsQuery.orderBy('store_products.price', 'ASC');
 }
 
 if (sortprice === 'htol') {
   topsellingsQuery.orderBy('store_products.price', 'DESC');
 }
 
 if (sortname === 'atoz') {
   topsellingsQuery.orderBy('product.product_name', 'ASC');
 }
 
 if (sortname === 'ztoa') {
   topsellingsQuery.orderBy('product.product_name', 'DESC');
 }
 
 const productDetail = await topsellingsQuery.offset((pageFilter - 1) * perPage)
 .limit(perPage);
 
     
    const customizedProductData = [];
      for (let i = 0; i < productDetail.length; i++) {
        const ProductList = productDetail[i];
        const currentDate = new Date();
        const deal = await knex('deal_product')
        .where('varient_id', ProductList.varient_id)
        .where('store_id', store_id)
        .where('deal_product.valid_from', '<=', currentDate)
        .where('deal_product.valid_to', '>', currentDate)
        .first();
       
        let price=0;
       if (deal) {
       price = deal.deal_price;
       } else {
       const sp = await knex('store_products')
       .where('varient_id', ProductList.varient_id)
       .where('store_id', store_id)
       .first();
       price = sp.price;
      }


      if(user_id){ 
        
        const subprod = await knex('store_orders')
        .select('store_orders.percentage')
        .where('store_orders.varient_id',ProductList.varient_id)
        .where('store_approval',user_id)
        .where('store_orders.subscription_flag',1)
        .where('store_orders.order_cart_id', "incart")
        .first();

        if(subprod){
          isSubscription = 'true'
        }else{
          isSubscription = 'false'
          
        }
        // Wishlist check 
         // Wishlist check 
         var isFavourite='';
   var notifyMe='';
   var cartQty=0;
         const wishList = await knex('wishlist')
        .select('*')
        .where('varient_id',ProductList.varient_id)
        .where('user_id',user_id);

        isFavourite = wishList.length > 0 ? 'true' : 'false';
 
        // cart qty check 
        const CartQtyList = await knex('store_orders')
        .where('varient_id',ProductList.varient_id)
        .where('store_approval',user_id)
        .where('order_cart_id','incart')
        .where('store_id',store_id)
        .whereNull('subscription_flag')
        .first();
        cartQty = CartQtyList ? CartQtyList.qty : 0;
        

        const cnotify_me = await knex('product_notify_me')
        .where('varient_id', ProductList.varient_id)
        .where('user_id', user_id);
         notifyMe = cnotify_me.length > 0 ? 'true' : 'false';


        }else{
         notifyMe='false';
         isFavourite='false';
         cartQty=0;
          isSubscription = 'false'
        }
        
        const baseurl =  process.env.BUNNY_NET_IMAGE;


        const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
        const finalsubprice =  ProductList.mrp - sub_price;
        const subscription_price = parseFloat(finalsubprice.toFixed(2));
          if(ProductList.country_icon == null){
              countryicon = null
           }else{
              countryicon =  baseurl + ProductList.country_icon
           }
          
          if (Number.isInteger(price)) {
          priceval = price + '.001'
          }else{
          priceval = price
          }
          if (Number.isInteger(ProductList.mrp)) {
          mrpval = ProductList.mrp + '.001'
          }else{
          mrpval = ProductList.mrp
          }
        const customizedProduct = {
            stock: ProductList.stock,        
            varient_id: ProductList.varient_id,
            product_id: ProductList.product_id,
            product_name: ProductList.product_name,
            product_image: baseurl + ProductList.product_image,
            thumbnail: baseurl + ProductList.thumbnail,
            description:ProductList.description,
            price: parseFloat(priceval),
            mrp: parseFloat(mrpval),
            unit: ProductList.unit,
            quantity: ProductList.quantity,
            type: ProductList.type,
            percentage: ProductList.percentage,
            isSubscription:isSubscription,
            subscription_price:subscription_price,
           // discountper: ProductList.discountper,
            discountper:0,
            avgrating:0,
            notify_me: notifyMe,
            isFavourite: isFavourite,
            cart_qty: cartQty,
            countrating:0,
            country_icon : countryicon,  
            availability:ProductList.availability,  
            varients:null
            // Add or modify properties as needed
            };
        
          customizedProductData.push(customizedProduct);  
    
      }

    return customizedProductData;
};

const getWhatsNew = async (appDetatils) => {
    await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
    const {store_id,byname,min_price,max_price,stock, min_discount,max_discount,min_rating,max_rating,sort,sortname,sortprice,cat_id, sub_cat_id,page,perpage} = appDetatils;
    const catId=1;
    const pageFilter = page; // You can adjust the page number dynamically
    const perPage = perpage;
    if(appDetatils.user_id != "null" ){
      user_id = appDetatils.user_id
  }else{
      user_id = appDetatils.device_id
  }
    const minprice = parseFloat(min_price)
    const  maxprice = parseFloat(max_price)
    const  mindiscount = parseFloat(min_discount)
    const  maxdiscount = parseFloat(max_discount)
    const subcatid = sub_cat_id
   
   
    let categoryarray;
    if (cat_id !== "null") {
    categoryarray = await knex('categories').where('parent', cat_id).pluck('cat_id');
    }
    
   
 
      const topsellingsQuery = knex('store_products')
      .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
      .join('product', 'product_varient.product_id', '=', 'product.product_id')
      .leftJoin('deal_product', 'product_varient.varient_id', '=', 'deal_product.varient_id')
      .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
      .select(
        'store_products.stock',
        'product_varient.varient_id',
        'product_varient.description',
        'product.product_id',
        'product.product_name',
        'product.product_image',
        'product.thumbnail',
        'store_products.price',
        'store_products.mrp',
        'product_varient.unit',
        'product_varient.quantity',
        'product.type',
        'product.percentage',
        'product.availability',
        'tbl_country.country_icon',
        knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
        knex.raw('100-((deal_product.deal_price*100)/store_products.mrp) as discountper1'),
       )
      .groupBy(
        'store_products.store_id',
        'product_varient.varient_id',
        'product.product_id'
      )
      .where('store_products.store_id', store_id)
      .where('product.hide', 0)
      .where('product.is_delete', 0);
   //  return topsellingsQuery
     
      //if (cat_id !== "null") {
      //if (categoryarray.length > 0)  {
      if (categoryarray)  {
      topsellingsQuery.whereIn('product.cat_id', categoryarray);
      }
     
      if (sub_cat_id !== "null") {
      topsellingsQuery.where('product.cat_id', subcatid);
      }
     // return topsellingsQuery
      if ((minprice === 0 || minprice) && maxprice) {
      topsellingsQuery.whereBetween('store_products.price', [minprice, maxprice]);
      }
     
  if (mindiscount && maxdiscount) {
    topsellingsQuery.havingRaw('(discountper BETWEEN ? AND ?) OR (discountper1 BETWEEN ? AND ?)', [
      mindiscount,
      maxdiscount,
      mindiscount,
      maxdiscount,
    ]);
  }
  
  if (sortprice === 'ltoh') {
    topsellingsQuery.orderBy('store_products.price', 'ASC');
  }
  
  if (sortprice === 'htol') {
    topsellingsQuery.orderBy('store_products.price', 'DESC');
  }
  
  if (sortname === 'atoz') {
    topsellingsQuery.orderBy('product.product_name', 'ASC');
  }
  
  if (sortname === 'ztoa') {
    topsellingsQuery.orderBy('product.product_name', 'DESC');
  }
  

  const productDetail = await topsellingsQuery.offset((pageFilter - 1) * perPage)
  .limit(perPage);
  
     
     const customizedProductData = [];
       for (let i = 0; i < productDetail.length; i++) {
         const ProductList = productDetail[i];
         const currentDate = new Date();
         const deal = await knex('deal_product')
         .where('varient_id', ProductList.varient_id)
         .where('store_id', store_id)
         .where('deal_product.valid_from', '<=', currentDate)
         .where('deal_product.valid_to', '>', currentDate)
         .first();
        
         let price=0;
        if (deal) {
        price = deal.deal_price;
        } else {
        const sp = await knex('store_products')
        .where('varient_id', ProductList.varient_id)
        .where('store_id', store_id)
        .first();
        price = sp.price;
       }
 
 
       if(user_id){ 
         // Wishlist check 
          // Wishlist check 
          var isFavourite='';
    var notifyMe='';
    var cartQty=0;
          const wishList = await knex('wishlist')
         .select('*')
         .where('varient_id',ProductList.varient_id)
         .where('user_id',user_id);

         isFavourite = wishList.length > 0 ? 'true' : 'false';
  
         // cart qty check 
         const CartQtyList = await knex('store_orders')
         .where('varient_id',ProductList.varient_id)
         .where('store_approval',user_id)
         .where('order_cart_id','incart')
         .where('store_id',store_id)
         .whereNull('subscription_flag')
         .first();
         cartQty = CartQtyList ? CartQtyList.qty : 0;
         
 
         const cnotify_me = await knex('product_notify_me')
         .where('varient_id', ProductList.varient_id)
         .where('user_id', user_id);
          notifyMe = cnotify_me.length > 0 ? 'true' : 'false';
        
          const subprod = await knex('store_orders')
          .select('store_orders.percentage')
          .where('store_orders.varient_id',ProductList.varient_id)
          .where('store_approval',user_id)
          .where('store_orders.subscription_flag',1)
          .where('store_orders.order_cart_id', "incart")
          .first();
  
          if(subprod){
            isSubscription = 'true'
          }else{
            isSubscription = 'false'
            
          }
 
         }else{
          notifyMe='false';
          isFavourite='false';
          cartQty=0;
          isSubscription = 'false'
         }

   
 
         const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
         const finalsubprice =  ProductList.mrp - sub_price;
         const subscription_price = parseFloat(finalsubprice.toFixed(2));


         const baseurl =  process.env.BUNNY_NET_IMAGE;
         
          if(ProductList.country_icon == null){
              countryicon = null
           }else{
              countryicon =  baseurl + ProductList.country_icon
           }
           
         const customizedProduct = {
             stock: ProductList.stock,        
             varient_id: ProductList.varient_id,
             product_id: ProductList.product_id,
             product_name: ProductList.product_name,
             product_image: baseurl + ProductList.product_image,
             thumbnail: ProductList.thumbnail,
             description:ProductList.description,
             price: price,
             mrp: ProductList.mrp,
             unit: ProductList.unit,
             quantity: ProductList.quantity,
             type: ProductList.type,
             percentage: ProductList.percentage,
             isSubscription:isSubscription,
             subscription_price:subscription_price,
             availability:ProductList.availability,
             //discountper: ProductList.discountper,
             discountper:0,
             avgrating:0,
             notify_me: notifyMe,
             isFavourite: isFavourite,
             cart_qty: cartQty,
             countrating:0,
             country_icon : countryicon,  
             varients:null
             // Add or modify properties as needed
             };
         
           customizedProductData.push(customizedProduct);  
     
       }
 
     return customizedProductData;
};

const getRecentSelling = async (appDetatils) => {
    await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
    const {store_id,byname,min_price,max_price,stock, min_discount,max_discount,min_rating,max_rating,sort,sortname,sortprice,cat_id, sub_cat_id,page,perpage} = appDetatils;
    const pageFilter = page; // You can adjust the page number dynamically
    const perPage = perpage;
    if(appDetatils.user_id != "null" ){
      user_id = appDetatils.user_id
    }else{
        user_id = appDetatils.device_id
    }
    const minprice = parseFloat(min_price)
    const  maxprice = parseFloat(max_price)
    const  mindiscount = parseFloat(min_discount)
    const  maxdiscount = parseFloat(max_discount)
    const subcatid = sub_cat_id
   
   
    let categoryarray;
    if (cat_id !== "null") {
    categoryarray = await knex('categories').where('parent', cat_id).pluck('cat_id');
    }

    
 
      const topsellingsQuery = knex('store_products')
      .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
      .join('product', 'product_varient.product_id', '=', 'product.product_id')
      .leftJoin('deal_product', 'product_varient.varient_id', '=', 'deal_product.varient_id')
      .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
      .select(
        'store_products.stock',
        'product_varient.varient_id',
        'product_varient.description',
        'product.product_id',
        'product.product_name',
        'product.product_image',
        'product.thumbnail',
        'store_products.price',
        'store_products.mrp',
        'product_varient.unit',
        'product_varient.quantity',
        'product.type',
        'tbl_country.country_icon',
        'product.percentage',
        'product.availability',
        knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
        knex.raw('100-((deal_product.deal_price*100)/store_products.mrp) as discountper1'),
       )
      .groupBy(
        'store_products.store_id',
        'product_varient.varient_id',
        'product.product_id'
      )
     // .orderByRaw('RAND()')
      .orderBy('store_products.p_id','asc')
      .where('store_products.store_id', store_id)
      .where('product.hide', 0)
      .where('product.is_delete', 0);
  
     
        if (categoryarray)  {
        topsellingsQuery.whereIn('product.cat_id', categoryarray);
        }
      
        if (sub_cat_id !== "null") {
        topsellingsQuery.where('product.cat_id', subcatid);
        }

        if ((minprice === 0 || minprice) && maxprice) {
          topsellingsQuery.whereBetween('store_products.price', [minprice, maxprice]);
          }
        
        if (mindiscount && maxdiscount) {
        topsellingsQuery.havingRaw('(discountper BETWEEN ? AND ?) OR (discountper1 BETWEEN ? AND ?)', [
          mindiscount,
          maxdiscount,
          mindiscount,
          maxdiscount,
        ]);
        }
  
  if (sortprice === 'ltoh') {
    topsellingsQuery.orderBy('store_products.price', 'ASC');
  }
  
  if (sortprice === 'htol') {
    topsellingsQuery.orderBy('store_products.price', 'DESC');
  }
  
  if (sortname === 'atoz') {
    topsellingsQuery.orderBy('product.product_name', 'ASC');
  }
  
  if (sortname === 'ztoa') {
    topsellingsQuery.orderBy('product.product_name', 'DESC');
  }
  
  const productDetail = await topsellingsQuery.offset((pageFilter - 1) * perPage)
  .limit(perPage);
  
      
     const customizedProductData = [];
       for (let i = 0; i < productDetail.length; i++) {
        var isFavourite='';
        var notifyMe='';
        var cartQty=0;
         const ProductList = productDetail[i];
         const currentDate = new Date();
         const deal = await knex('deal_product')
         .where('varient_id', ProductList.varient_id)
         .where('store_id', store_id)
         .where('deal_product.valid_from', '<=', currentDate)
         .where('deal_product.valid_to', '>', currentDate)
         .first();
        
         let price=0;
        if (deal) {
        price = deal.deal_price;
        } else {
        const sp = await knex('store_products')
        .where('varient_id', ProductList.varient_id)
        .where('store_id', store_id)
        .first();
        price = sp.price;
       }
 
 
       if(user_id){ 
         // Wishlist check 
          const wishList = await knex('wishlist')
         .select('*')
         .where('varient_id',ProductList.varient_id)
         .where('user_id',user_id);

         isFavourite = wishList.length > 0 ? 'true' : 'false';
  
         // cart qty check 
         const CartQtyList = await knex('store_orders')
         .where('varient_id',ProductList.varient_id)
         .where('store_approval',user_id)
         .where('order_cart_id','incart')
         .where('store_id',store_id)
         .whereNull('subscription_flag')
         .first();
         cartQty = CartQtyList ? CartQtyList.qty : 0;
         
 
         const cnotify_me = await knex('product_notify_me')
         .where('varient_id', ProductList.varient_id)
         .where('user_id', user_id);
          notifyMe = cnotify_me.length > 0 ? 'true' : 'false';

          const subprod = await knex('store_orders')
          .select('store_orders.percentage')
          .where('store_orders.varient_id',ProductList.varient_id)
          .where('store_approval',user_id)
          .where('store_orders.subscription_flag',1)
          .where('store_orders.order_cart_id', "incart")
          .first();
  
          if(subprod){
            isSubscription = 'true'
          }else{
            isSubscription = 'false'
            
          }
 
         }else{
          notifyMe='false';
          isFavourite='false';
          cartQty=0;
          isSubscription = 'false'
         }

         
        const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
        const finalsubprice =  ProductList.mrp - sub_price;
        const subscription_price = parseFloat(finalsubprice.toFixed(2));

         const baseurl =  process.env.BUNNY_NET_IMAGE;
         
         if(ProductList.country_icon == null){
              countryicon = null
           }else{
              countryicon =  baseurl + ProductList.country_icon
           }

          if (Number.isInteger(price)) {
          priceval = price + '.001'
          }else{
          priceval = price
          }
          if (Number.isInteger(ProductList.mrp)) {
          mrpval = ProductList.mrp + '.001'
          }else{
          mrpval = ProductList.mrp
          }
           
         const customizedProduct = {
             stock: ProductList.stock,        
             varient_id: ProductList.varient_id,
             product_id: ProductList.product_id,
             product_name: ProductList.product_name,
             product_image: baseurl + ProductList.product_image,
             thumbnail: baseurl + ProductList.thumbnail,
             description:ProductList.description,
             price: parseFloat(priceval),
             mrp: parseFloat(mrpval),
             unit: ProductList.unit,
             quantity: ProductList.quantity,
             type: ProductList.type,
             //discountper: ProductList.discountper,
             discountper:0,
             avgrating:0,
             notify_me: notifyMe,
             isFavourite: isFavourite,
             cart_qty: cartQty,
             countrating:0,
             percentage: ProductList.percentage,
             isSubscription:isSubscription,
             subscription_price:subscription_price,
             availability:ProductList.availability,
             country_icon : countryicon,   
             varients:null
             // Add or modify properties as needed
             };
         
           customizedProductData.push(customizedProduct);  
     
       }
 
     return customizedProductData;
};
 
const getDealProduct = async (appDetatils) => {
    await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
    const {store_id,byname,min_price,max_price,stock, min_discount,max_discount,min_rating,max_rating,sort,sortname,sortprice,cat_id, sub_cat_id,page,perpage} = appDetatils;
    const pageFilter = page; // You can adjust the page number dynamically
    const perPage = perpage;
    const currentDate = new Date();
    if(appDetatils.user_id != "null" ){
      user_id = appDetatils.user_id
  }else{
      user_id = appDetatils.device_id
  }
    let categoryarray;
    if (cat_id) {
    categoryarray = await knex('categories').where('parent', cat_id).pluck('cat_id');
    }

    const deal_pssss = knex('deal_product')
    .join('store_products', 'deal_product.varient_id', '=', 'store_products.varient_id')
    .join('product_varient', 'deal_product.varient_id', '=', 'product_varient.varient_id')
    .join('product', 'product_varient.product_id', '=', 'product.product_id')
    .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
    .select([
      'store_products.stock',
      'product_varient.varient_id',
      'product.product_id',
      'product.product_name',
      'product.product_image',
      'product.thumbnail',
      'product_varient.description',
      'deal_product.deal_price as price',
      'store_products.mrp',
      'product_varient.unit',
      'product_varient.quantity',
      'product.type',
      knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
      knex.raw('100-((deal_product.deal_price*100)/store_products.mrp) as discountper1'),
      'deal_product.valid_to',
      'deal_product.valid_from',
      'tbl_country.country_icon',
      'product.percentage',
      'product.availability'
    ])
    .groupBy([
      'store_products.store_id',
      'product_varient.varient_id',
      'product.product_id',
    ])
    .where('deal_product.valid_from', '<=', currentDate)
    .where('deal_product.valid_to', '>', currentDate)
    .whereNotNull('store_products.price')
    .where('product.hide', 0)
    .where('product.is_delete', 0)
    .where('deal_product.store_id', store_id);
  
    if (cat_id) {
      deal_pssss.whereIn('product.cat_id', categoryarray);
    }
    
    if (sub_cat_id) {
      deal_pssss.where('product.cat_id', sub_cat_id);
   }
  
  if ((min_price === 0 || min_price) && max_price) {
    deal_pssss.whereBetween('store_products.price', [min_price, max_price]);
  }
  
  if (min_discount && max_discount) {
    deal_pssss.havingRaw('(discountper BETWEEN ? AND ?) OR (discountper1 BETWEEN ? AND ?)', [
      min_discount,
      max_discount,
      min_discount,
      max_discount,
    ]);
  }
  
  if (sortprice === 'ltoh') {
    deal_pssss.orderBy('store_products.price', 'asc');
  }
  
  if (sortprice === 'htol') {
    deal_pssss.orderBy('store_products.price', 'desc');
  }
  
  if (sortname === 'atoz') {
    deal_pssss.orderBy('product.product_name', 'asc');
  }
  
  if (sortname === 'ztoa') {
    deal_pssss.orderBy('product.product_name', 'desc');
  }
  
  // Execute the query and get the results
  const results = await deal_pssss;
  
  let productDetails;
  
  // Check if results exist
  if (results.length > 0) {
    productDetails = await deal_pssss.offset((pageFilter - 1) * perPage).limit(perPage);
  } else {
    productDetails = results;
  }
  
  const productDetail = productDetails.filter((product, index, self) => {
    return index === self.findIndex((p) => p.product_id === product.product_id);
    });
    
      
     const customizedProductData = [];
       for (let i = 0; i < productDetail.length; i++) {
        var isFavourite='';
        var notifyMe='';
        var cartQty=0;
         const ProductList = productDetail[i];
         
         const deal = await knex('deal_product')
         .where('varient_id', ProductList.varient_id)
         .where('store_id', store_id)
         .where('deal_product.valid_from', '<=', currentDate)
         .where('deal_product.valid_to', '>', currentDate)
         .first();
        
         let price=0;
        if (deal) {
        price = deal.deal_price;
        } else {
        const sp = await knex('store_products')
        .where('varient_id', ProductList.varient_id)
        .where('store_id', store_id)
        .first();
        price = sp.price;
       }
 
 
       if(user_id){ 
         // Wishlist check 
          const wishList = await knex('wishlist')
         .select('*')
         .where('varient_id',ProductList.varient_id)
         .where('user_id',user_id);

         isFavourite = wishList.length > 0 ? 'true' : 'false';
  
         // cart qty check 
         const CartQtyList = await knex('store_orders')
         .where('varient_id',ProductList.varient_id)
         .where('store_approval',user_id)
         .where('order_cart_id','incart')
         .where('store_id',store_id)
         .whereNull('subscription_flag')
         .first();
         cartQty = CartQtyList ? CartQtyList.qty : 0;
         
 
         const cnotify_me = await knex('product_notify_me')
         .where('varient_id', ProductList.varient_id)
         .where('user_id', user_id);
          notifyMe = cnotify_me.length > 0 ? 'true' : 'false';

          const subprod = await knex('store_orders')
          .select('store_orders.percentage')
          .where('store_orders.varient_id',ProductList.varient_id)
          .where('store_approval',user_id)
          .where('store_orders.subscription_flag',1)
          .where('store_orders.order_cart_id', "incart")
          .first();
  
          if(subprod){
            isSubscription = 'true'
          }else{
            isSubscription = 'false'
            
          }
 
         }else{
          notifyMe='false';
          isFavourite='false';
          cartQty=0;
          isSubscription = 'false';
         }

         const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
         const finalsubprice =  ProductList.mrp - sub_price;
         const subscription_price = parseFloat(finalsubprice.toFixed(2));
        
        if(ProductList.country_icon == null){
              countryicon = null
           }else{
              countryicon =  baseurl + ProductList.country_icon
           }
 
         const customizedProduct = {
             stock: ProductList.stock,        
             varient_id: ProductList.varient_id,
             product_id: ProductList.product_id,
             product_name: ProductList.product_name,
             product_image: ProductList.product_image,
             thumbnail: ProductList.thumbnail,
             description:ProductList.description,
             price: price,
             mrp: ProductList.mrp,
             unit: ProductList.unit,
             quantity: ProductList.quantity,
             type: ProductList.type,
             //discountper: ProductList.discountper,
             discountper:0,
             avgrating:0,
             notify_me: notifyMe,
             isFavourite: isFavourite,
             cart_qty: cartQty,
             countrating:0,
             country_icon : countryicon,  
             percentage: ProductList.percentage,
             isSubscription:isSubscription,
             subscription_price:subscription_price,
             availability:ProductList.availability,
             varients:null
             // Add or modify properties as needed
             };
         
           customizedProductData.push(customizedProduct);  
     
       }
 
     return customizedProductData;
};

const getAdditionalCatSearch = async  (appDetatils) => {
await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
  const {store_id,byname,min_price,max_price,stock, min_discount,max_discount,min_rating,max_rating,sort,sortname,sortprice,cat_id, sub_cat_id,page,perpage,keyword} = appDetatils;
  const storeId = store_id;
  if(appDetatils.user_id != "null" ){
    user_id = appDetatils.user_id
}else{
    user_id = appDetatils.device_id
}
  const pageFilter = page; // You can adjust the page number dynamically
  const perPage = 200;
     //Varient Product variables
     var visFavourite='';
     var vnotifyMe='';
     var vcartQty=0;
     var vavgrating=0;
     var vcountrating=0
     var vdiscountper=0;
     var bynames = (byname.toLowerCase() == 'fresh food') ? "Fresh Picks" : byname;
     var bynames = (byname.toLowerCase() != 'fresh food' && byname.toLowerCase() =='') ? "DIWALI" : bynames;

     //return byname
    const additionalcat = knex('additional_category');
    //if (cat_id) {
    if (cat_id !== "null") {
    additionalcat.where('id', cat_id);
    }
    // if (keyword) {
    // additionalcat.where('title', keyword);
    // }

  
    if(bynames){
     // additionalcat.where('title', byname);
     additionalcat.where('title', 'like', `%${bynames}%`)
      //additionalcat.whereLike('title', byname);
    }
    
    const result = await additionalcat.select('*').orderBy('id'); // Replace 'id' with the actual column you want to order by

    const results = result;

    const customizedData = [];
    for (let i = 0; i < results.length; i++) {
      const item = results[i];
      const product_id=item.product_id;
      const product_ids = product_id.split(',');
      const productDetail_s =knex('product')
      .select(
        'store_products.stock',
        'product_varient.varient_image',
        'product_varient.quantity',
        'product_varient.unit',
        'store_products.price',
        'store_products.mrp',
        'product_varient.description',
        'product.product_name',
        'product.product_image',
        'product.thumbnail',
        'product_varient.varient_id',
        'product.product_id',
        'product.type',
        'tbl_country.country_icon',
        'product.percentage',
        'product.availability',
        knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper')
      )
      .from('product')
      .innerJoin('product_varient', 'product.product_id', 'product_varient.product_id')
      .innerJoin('store_products', 'product_varient.varient_id', 'store_products.varient_id')
      .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
      .whereIn('product.product_id', product_ids)
      .andWhere('product.hide', '=', 0)
      .where('product.is_delete', 0)
      .orderBy('product.product_name', 'asc');

    const productDetails = await productDetail_s.offset((pageFilter - 1) * perPage)
    .limit(perPage);

    const productDetail = productDetails.filter((product, index, self) => {
    return index === self.findIndex((p) => p.product_id === product.product_id);
    });
     
     const customizedProductData = [];
       for (let i = 0; i < productDetail.length; i++) {
        var isFavourite='';
        var notifyMe='';
        var cartQty=0;
         const ProductList = productDetail[i];
         const currentDate = new Date();
         const deal = await knex('deal_product')
         .where('varient_id', ProductList.varient_id)
         .where('store_id', store_id)
         .where('deal_product.valid_from', '<=', currentDate)
         .where('deal_product.valid_to', '>', currentDate)
         .first();
        
         let price=0;
        if (deal) {
        price = deal.deal_price;
        } else {
        const sp = await knex('store_products')
        .where('varient_id', ProductList.varient_id)
        .where('store_id', store_id)
        .first();
        price = sp.price;
       }
 
 
       if(user_id){ 
         // Wishlist check 
          const wishList = await knex('wishlist')
         .select('*')
         .where('varient_id',ProductList.varient_id)
         .where('user_id',user_id);

         isFavourite = wishList.length > 0 ? 'true' : 'false';
  
         // cart qty check 
         const CartQtyList = await knex('store_orders')
         .where('varient_id',ProductList.varient_id)
         .where('store_approval',user_id)
         .where('order_cart_id','incart')
         .where('store_id',store_id)
         .whereNull('subscription_flag')
         .first();
         cartQty = CartQtyList ? CartQtyList.qty : 0;
         
 
         const cnotify_me = await knex('product_notify_me')
         .where('varient_id', ProductList.varient_id)
         .where('user_id', user_id);
          notifyMe = cnotify_me.length > 0 ? 'true' : 'false';

          const subprod = await knex('store_orders')
          .select('store_orders.percentage')
          .where('store_orders.varient_id',ProductList.varient_id)
          .where('store_approval',user_id)
          .where('store_orders.subscription_flag',1)
          .where('store_orders.order_cart_id', "incart")
          .first();
  
          if(subprod){
            isSubscription = 'true'
          }else{
            isSubscription = 'false'
            
          }
 
         }else{
          notifyMe='false';
          isFavourite='false';
          cartQty=0;
          isSubscription = 'false'
         }

         const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
         const finalsubprice =  ProductList.mrp - sub_price;
         const subscription_price = parseFloat(finalsubprice.toFixed(2));
 
         const baseurl =  process.env.BUNNY_NET_IMAGE;
         
           if(ProductList.country_icon == null){
              countryicon = null
           }else{
              countryicon =  baseurl + ProductList.country_icon
           }
                
          if (Number.isInteger(price)) {
          priceval = price + '.001'
          }else{
          priceval = price
          }
          if (Number.isInteger(ProductList.mrp)) {
          mrpval = ProductList.mrp + '.001'
          }else{
          mrpval = ProductList.mrp
          }

         const customizedProduct = {
             stock: ProductList.stock,        
             varient_id: ProductList.varient_id,
             product_id: ProductList.product_id,
             product_name: ProductList.product_name,
             product_image: baseurl + ProductList.product_image,
             thumbnail: baseurl + ProductList.thumbnail,
             description:ProductList.description,
             price: parseFloat(priceval),
             mrp: parseFloat(mrpval),
             unit: ProductList.unit,
             quantity: ProductList.quantity,
             type: ProductList.type,
             percentage: ProductList.percentage,
             isSubscription:isSubscription,
             subscription_price:subscription_price,
              availability:ProductList.availability,
 
            // discountper: ProductList.discountper,
             discountper:0,
             avgrating:0,
             notify_me: notifyMe,
             isFavourite: isFavourite,
             cart_qty: cartQty,
             countrating:0,
             country_icon : countryicon,   
             varients:null
             // Add or modify properties as needed
             };
         
           customizedProductData.push(customizedProduct);  
     
       }
    
       return customizedProductData
    const customizedItem = {
    id: item.id,
    title: item.title,
    sub_title: item.sub_title,
    color1: item.color1,
    color2: item.color2,
    product_details:customizedProductData
    // Add or modify properties as needed
    };
    customizedData.push(customizedItem);
    }

    
  return customizedData;

};

const appinformation = async (appDetails) => {
  const store_id = appDetails.store_id;
  const user_id = appDetails.user_id !== "null" ? appDetails.user_id : appDetails.device_id;
  const date_ob = new Date();

  // Update device_id
  await knex('users')
      .where('id', user_id)
      .update({ device_id: appDetails.device_id });

  // Fetch user details and reserve amount in parallel
  const [userDetails, reserveAmt, appVersioning, deliveryFlag, cityNames, cityNamesA] = await Promise.all([
      knex('users')
          .select('wallet', 'activate_deactivate_status', 'referral_code')
          .where('id', user_id)
          .first(),
      
      knex('orders')
          .where('orders.is_subscription', 1)
          .where('orders.user_id', user_id)
          .sum('orders.reserve_amount as totalReserveAmt')
          .first(),
      
      knex('app_versioning')
          .where('platform', appDetails.platform)
          .where('app_name', appDetails.app_name)
          .first(),
      
      knex('app_settings')
          .where('store_id', 7)
          .select('cod_charges', 'wallet_deduction_percentage')
          .first(),

      knex('city')
          .where('status', 1)
          .select(knex.raw('GROUP_CONCAT(city_name) as cityName'))
          .first(),

      knex('city')
          .where('status', 1)
          .select(knex.raw('GROUP_CONCAT(CONVERT(arabic_name USING utf8mb4)) as cityName'))
          .first()
  ]);

  // Handle cases where no user is found
  const wallet = userDetails ? userDetails.wallet : 0;
  const userStatus = userDetails ? userDetails.activate_deactivate_status : null;
  const referralCode = userDetails ? userDetails.referral_code : null;

  // Process wallet balance
  const totalWallet = (wallet - (reserveAmt.totalReserveAmt || 0)).toFixed(2);

  // Determine calendar time value
  const currentTime = `${String(uaeTime.hours()).padStart(2, '0')}:${String(uaeTime.minutes()).padStart(2, '0')}`;
  const calendarTValue = currentTime < "12:00" ? 1 : 1;

  // Check app version and status
  const appDbVersion = appDetails.version;
  const appCurVersion = appDetails.app_cur_version;
  let appVersionStatus = 100;
  let appVersionMessage = "Already updated version";

  if (appDbVersion > appCurVersion) {
      appVersionStatus = (appDbVersion - 1 === appCurVersion && appVersioning.forcefully_update === 1) ? 300 : 200;
      appVersionMessage = "New update available.\nPlease download the updated app.";
  }

  const customizedProduct = {
      status: 1,
      message: "App Name & Logo",
      wallet_deduction_percentage: deliveryFlag.wallet_deduction_percentage,
      userwallet: totalWallet,
      calendar_t_value: calendarTValue,
      app_link: appVersioning.app_link,
      version: appVersioning.version,
      platform: appVersioning.platform,
      forcefully_update: appVersioning.forcefully_update,
      app_version_status: appVersionStatus,
      app_version_message: appVersionMessage,
      popupdata_home: "",
      whatsapp_link: "97142390322",
      store_id: 7,
      userstatus: userStatus,
      share_link: "https://www.quickart.ae/share_app.php",
      referral_code: referralCode,
      codcharges: deliveryFlag.cod_charges,
      country_list: `${cityNames.cityName},${cityNamesA.cityName}`
  };

  return customizedProduct;
};

const UpdateproductDetails = async (appDetails) => {
const {user_id}=appDetails;

  // Fetch Daily Product details
  const DailyProduct = await knex('store_orders')
  .where('store_orders.store_approval', user_id)
  .where('store_orders.order_cart_id', 'incart')
  .whereNull('subscription_flag');

  // Iterate over the fetched products and update each one
  for (const product of DailyProduct) {
  const ProductStore = await knex('store_products')
  .where('store_products.varient_id', product.varient_id)
  .first();

  // Assuming you want to update a field based on some logic
  let totalPrice=ProductStore.price * product.qty;
  let totalMrp=ProductStore.mrp * product.qty;
  await knex('store_orders')
  .where('store_order_id', product.store_order_id)
  .where('store_orders.order_cart_id', 'incart')
  .whereNull('subscription_flag')
  .update({
  price: totalPrice, // Ensure this is a number
  total_mrp:totalMrp, // Ensure this is a number
  });
  }
 
  // Fetch Subscription Product details
  const SubscriptionProduct = await knex('store_orders')
  .where('store_orders.store_approval', user_id)
  .where('store_orders.order_cart_id', 'incart')
  .where('subscription_flag', 1);

// Iterate over the fetched products and update each one
for (const products of SubscriptionProduct) {
  const ProductStore = await knex('store_products')
    .where('store_products.varient_id', products.varient_id)
    .first();

  let mrppriceTotal = ProductStore.mrp * products.qty;
  let priceTotal = ProductStore.price * products.qty;
  let repeatOrders = products.repeat_orders;
  const subTotalDelivery = products.sub_total_delivery || 1;
  const repeatOrdersDays = repeatOrders ? wordCount(repeatOrders) : 1;

  // Handle category, sub-category, and product-level discounts
  const productVarient = await knex('product_varient').where('varient_id', products.varient_id).first();
  const productDetails = await knex('product').where('product_id', productVarient.product_id).first();
  const cat_id = productDetails.cat_id;
  const percentage = productDetails.percentage;

  const categoriesSubDetails = await knex('categories').where('cat_id', cat_id).first();
  const percentageSubCat = categoriesSubDetails.discount_per;
  const parent = categoriesSubDetails.parent;

  const categoriesParentDetails = await knex('categories').where('cat_id', parent).first();
  const percentageCat = categoriesParentDetails.discount_per;

  let priceAfterDiscount;
  let appliedPercentage;

  if (percentage > 0) {
    priceAfterDiscount = ((mrppriceTotal - (mrppriceTotal * percentage) / 100) * repeatOrdersDays * subTotalDelivery).toFixed(2);
    appliedPercentage = percentage;
  } else if (percentageSubCat > 0) {
    priceAfterDiscount = ((mrppriceTotal - (mrppriceTotal * percentageSubCat) / 100) * repeatOrdersDays * subTotalDelivery).toFixed(2);
    appliedPercentage = percentageSubCat;
  } else if (percentageCat > 0) {
    priceAfterDiscount = ((mrppriceTotal - (mrppriceTotal * percentageCat) / 100) * repeatOrdersDays * subTotalDelivery).toFixed(2);
    appliedPercentage = percentageCat;
  } else {
    priceAfterDiscount = (priceTotal  * repeatOrdersDays * subTotalDelivery).toFixed(2);
    appliedPercentage = 0;
  }

  let finalmrppriceTotal=(mrppriceTotal  * repeatOrdersDays * subTotalDelivery).toFixed(2);
  await knex('store_orders')
    .where('store_order_id', products.store_order_id)
    .where('store_orders.order_cart_id', 'incart')
    .where('subscription_flag', 1)
    .update({
      price: priceAfterDiscount, // Example: update price
      total_mrp: finalmrppriceTotal, // Example: update mrp
    });
}

// Daily Product Amount & Cart Count
const sumDaily = await knex('store_orders')
  .join('store_products', 'store_orders.varient_id', '=', 'store_products.varient_id')
  .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
  .join('product', 'product_varient.product_id', '=', 'product.product_id')
  .where('store_orders.store_approval', user_id)
  .where('store_orders.order_cart_id', 'incart')
  .whereNull('subscription_flag')
  .select(
    knex.raw('SUM(store_orders.total_mrp) as mrp'),
    knex.raw('SUM(store_orders.price) as sum'),
    knex.raw('COUNT(store_orders.store_order_id) as count'),
    knex.raw('SUM(store_orders.tx_price) as sum_tax'),
    knex.raw('SUM(store_orders.tx_per) as sum_per')
  )
  .first();

const cartItemsDaily = await knex('store_orders')
  .join('store_products', 'store_orders.varient_id', '=', 'store_products.varient_id')
  .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
  .join('product', 'product_varient.product_id', '=', 'product.product_id')
  .select(
    'store_orders.percentage',
    'store_orders.product_name',
    'store_orders.varient_image',
    'store_orders.quantity',
    'store_orders.unit',
    'store_orders.total_mrp',
    'store_products.price',
    'store_orders.qty as cart_qty',
    'store_orders.total_mrp',
    'store_orders.order_cart_id',
    'store_orders.order_date',
    'store_orders.store_approval',
    'store_orders.store_id',
    'store_orders.varient_id',
    'product.product_id',
    'store_products.stock',
    'store_orders.tx_per',
    'store_orders.price_without_tax',
    'store_orders.tx_price',
    'store_orders.tx_name',
    'product.product_image',
    'product_varient.description',
    'product.type',
    'store_orders.price as ord_price'
  )
  .where('store_orders.store_approval', user_id)
  .where('store_orders.order_cart_id', 'incart')
  .where('store_products.store_id',7)
  .whereNull('subscription_flag')
  .orderBy('store_orders.store_order_id', 'ASC');

let dailysum1 = 0;
let dailymrppp = 0;
let dailycartCount = 0;
let dailydiscountOnMrp = 0;

if (cartItemsDaily.length > 0) {
  dailysum1 = sumDaily.sum.toFixed(2);
  dailymrppp = sumDaily.mrp.toFixed(2);
  dailydiscountOnMrp = (dailymrppp - dailysum1).toFixed(2);
  dailycartCount = cartItemsDaily.length;
}

// Subscription Product Amount & Cart Count
const sumSubscription = await knex('store_orders')
  .join('store_products', 'store_orders.varient_id', '=', 'store_products.varient_id')
  .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
  .join('product', 'product_varient.product_id', '=', 'product.product_id')
  .where('store_orders.store_approval', user_id)
  .where('store_orders.order_cart_id', 'incart')
  .where('subscription_flag', 1)
  .select(
    knex.raw('SUM(store_orders.total_mrp) as mrp'),
    knex.raw('SUM(store_orders.price) as sum'),
    knex.raw('COUNT(store_orders.store_order_id) as count'),
    knex.raw('SUM(store_orders.tx_price) as sum_tax'),
    knex.raw('SUM(store_orders.tx_per) as sum_per')
  )
  .first();

const cartItemsSubscription = await knex('store_orders')
  .join('store_products', 'store_orders.varient_id', '=', 'store_products.varient_id')
  .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
  .join('product', 'product_varient.product_id', '=', 'product.product_id')
  .select(
    'store_orders.percentage',
    'store_orders.product_name',
    'store_orders.varient_image',
    'store_orders.quantity',
    'store_orders.unit',
    'store_orders.total_mrp',
    'store_products.price',
    'store_orders.qty as cart_qty',
    'store_orders.total_mrp',
    'store_orders.order_cart_id',
    'store_orders.order_date',
    'store_orders.store_approval',
    'store_orders.store_id',
    'store_orders.varient_id',
    'product.product_id',
    'store_products.stock',
    'store_orders.tx_per',
    'store_orders.price_without_tax',
    'store_orders.tx_price',
    'store_orders.tx_name',
    'product.product_image',
    'product_varient.description',
    'product.type',
    'store_orders.price as ord_price'
  )
  .where('store_orders.store_approval', user_id)
  .where('store_orders.order_cart_id', 'incart')
  .where('subscription_flag', 1)
  .where('store_products.store_id',7)
  .orderBy('store_orders.store_order_id', 'ASC');

let subscriptionsum1 = 0;
let subscriptionmrppp = 0;
let subscriptioncartCount = 0;
let subscriptiondiscountOnMrp = 0;

if (cartItemsSubscription.length > 0) {
  subscriptionsum1 = sumSubscription.sum.toFixed(2);
  subscriptionmrppp = sumSubscription.mrp.toFixed(2);
  subscriptiondiscountOnMrp = (subscriptionmrppp - subscriptionsum1).toFixed(2);
  subscriptioncartCount = cartItemsSubscription.length;
}

// Fetch wallet and user status details
const wall = await knex('users')
  .select('wallet', 'activate_deactivate_status', 'referral_code')
  .where('id', user_id)
  .first();

const wallet = wall ? wall.wallet : 0;
const userStatus = wall ? wall.activate_deactivate_status : null;
const referralCode = wall ? wall.referral_code : null;

// Calculate reserve amount
const reserveAmt = await knex('orders')
  .innerJoin('subscription_order', 'subscription_order.cart_id', '=', 'orders.cart_id')
  .select('orders.reserve_amount')
  .where('orders.is_subscription', 1)
  .where('orders.user_id', user_id)
  .groupBy('orders.order_id');

let totalReserveAmt = 0;
reserveAmt.forEach(item => {
  totalReserveAmt += parseFloat(item.reserve_amount);
});

const totalWallet = (wallet - totalReserveAmt).toFixed(2);

const customizedProduct = {
  dailycartCount: dailycartCount,
  dailytotalPrice: dailysum1,
  dailydiscountOnMrp: dailydiscountOnMrp,
  subscriptioncartCount: subscriptioncartCount,
  subscriptiontotalPrice: subscriptionsum1,
  subscriptiondiscountOnMrp: subscriptiondiscountOnMrp,
  userwallet:totalWallet,
};

return customizedProduct;



};

const getOccasionalCatSearch = async  (appDetatils) => {
  await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))');
    const {byname,store_id,min_price,max_price,stock, min_discount,max_discount,min_rating,max_rating,sort,sortname,sortprice,cat_id, sub_cat_id,page,perpage,keyword} = appDetatils;
    const storeId = store_id;
    if(appDetatils.user_id != "null" ){
      user_id = appDetatils.user_id
  }else{
      user_id = appDetatils.device_id
  }
    const pageFilter = page; // You can adjust the page number dynamically
    const perPage = 200;
       //Varient Product variables
       var visFavourite='';
       var vnotifyMe='';
       var vcartQty=0;
       var vavgrating=0;
       var vcountrating=0
       var vdiscountper=0;
       var bynames = byname.toLowerCase();
       //var bynames = (byname.toLowerCase() == 'fresh food') ? "Fresh Picks" : byname;
       //var bynames = (byname.toLowerCase() != 'fresh food' && byname.toLowerCase() =='') ? "DIWALI" : bynames;
     const currentDate = new Date().toISOString().split('T')[0];
       //return byname
      const additionalcat = knex('occasional_category')
                            .where('from_date', '<=', currentDate)
                            .andWhere('to_date', '>=', currentDate);
      //if (cat_id) {
      if (cat_id !== "null") {
      additionalcat.where('id', cat_id);
      }
      if(byname){
       // additionalcat.where('title', byname);
       additionalcat.where('title', 'like', `%${bynames}%`)
        //additionalcat.whereLike('title', byname);
      }
      const result = await additionalcat.select('*').orderBy('id'); // Replace 'id' with the actual column you want to order by
      const results = result;
      const customizedData = [];
      for (let i = 0; i < results.length; i++) {
        const item = results[i];
        const product_id=item.product_id;
        const product_ids = product_id.split(',');
        const productDetail_s =knex('product')
        .select(
          'store_products.stock',
          'product_varient.varient_image',
          'product_varient.quantity',
          'product_varient.unit',
          'store_products.price',
          'store_products.mrp',
          'product_varient.description',
          'product.product_name',
          'product.product_image',
          'product.thumbnail',
          'product_varient.varient_id',
          'product.product_id',
          'product.type',
          'tbl_country.country_icon',
          'product.percentage',
          'product.availability',
          knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper')
        )
        .from('product')
        .innerJoin('product_varient', 'product.product_id', 'product_varient.product_id')
        .innerJoin('store_products', 'product_varient.varient_id', 'store_products.varient_id')
        .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
        .leftJoin('add_occproduct_order', 'add_occproduct_order.product_id', '=', 'product.product_id')
        .whereIn('product.product_id', product_ids)
        .andWhere('product.hide', '=', 0)
        .where('product.is_delete', 0)
        .orderBy('add_occproduct_order.orders', 'asc');
      const productDetails = await productDetail_s.offset((pageFilter - 1) * perPage)
      .limit(perPage);
      const productDetail = productDetails.filter((product, index, self) => {
      return index === self.findIndex((p) => p.product_id === product.product_id);
      });
       const customizedProductData = [];
         for (let i = 0; i < productDetail.length; i++) {
          var isFavourite='';
          var notifyMe='';
          var cartQty=0;
           const ProductList = productDetail[i];
           const currentDate = new Date();
           const deal = await knex('deal_product')
           .where('varient_id', ProductList.varient_id)
           .where('store_id', store_id)
           .where('deal_product.valid_from', '<=', currentDate)
           .where('deal_product.valid_to', '>', currentDate)
           .first();
           let price=0;
          if (deal) {
          price = deal.deal_price;
          } else {
          const sp = await knex('store_products')
          .where('varient_id', ProductList.varient_id)
          .where('store_id', store_id)
          .first();
          price = sp.price;
         }
         if(user_id){
           // Wishlist check
            const wishList = await knex('wishlist')
           .select('*')
           .where('varient_id',ProductList.varient_id)
           .where('user_id',user_id);
           isFavourite = wishList.length > 0 ? 'true' : 'false';
           // cart qty check
           const CartQtyList = await knex('store_orders')
           .where('varient_id',ProductList.varient_id)
           .where('store_approval',user_id)
           .where('order_cart_id','incart')
           .where('store_id',store_id)
           .whereNull('subscription_flag')
           .first();
           cartQty = CartQtyList ? CartQtyList.qty : 0;
           const cnotify_me = await knex('product_notify_me')
           .where('varient_id', ProductList.varient_id)
           .where('user_id', user_id);
            notifyMe = cnotify_me.length > 0 ? 'true' : 'false';
            const subprod = await knex('store_orders')
            .select('store_orders.percentage')
            .where('store_orders.varient_id',ProductList.varient_id)
            .where('store_approval',user_id)
            .where('store_orders.subscription_flag',1)
            .where('store_orders.order_cart_id', "incart")
            .first();
            if(subprod){
              isSubscription = 'true'
            }else{
              isSubscription = 'false'
            }
           }else{
            notifyMe='false';
            isFavourite='false';
            cartQty=0;
            isSubscription = 'false'
           }
           const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
           const finalsubprice =  ProductList.mrp - sub_price;
           const subscription_price = parseFloat(finalsubprice.toFixed(2));
           const baseurl =  process.env.BUNNY_NET_IMAGE;
             if(ProductList.country_icon == null){
                countryicon = null
             }else{
                countryicon =  baseurl + ProductList.country_icon
             }

            if (Number.isInteger(price)) {
            priceval = price + '.001'
            }else{
            priceval = price
            }
            if (Number.isInteger(ProductList.mrp)) {
            mrpval = ProductList.mrp + '.001'
            }else{
            mrpval = ProductList.mrp
            }

           const customizedProduct = {
               stock: ProductList.stock,
               varient_id: ProductList.varient_id,
               product_id: ProductList.product_id,
               product_name: ProductList.product_name,
               product_image: baseurl + ProductList.product_image,
               thumbnail: baseurl + ProductList.thumbnail,
               description:ProductList.description,
               price: parseFloat(priceval),
               mrp: parseFloat(mrpval),
               unit: ProductList.unit,
               quantity: ProductList.quantity,
               type: ProductList.type,
               percentage: ProductList.percentage,
               isSubscription:isSubscription,
               subscription_price:subscription_price,
                availability:ProductList.availability,
              // discountper: ProductList.discountper,
               discountper:0,
               avgrating:0,
               notify_me: notifyMe,
               isFavourite: isFavourite,
               cart_qty: cartQty,
               countrating:0,
               country_icon : countryicon,
               varients:null
               // Add or modify properties as needed
               };
             customizedProductData.push(customizedProduct);
         }
         return customizedProductData
      const customizedItem = {
      id: item.id,
      title: item.title,
      sub_title: item.sub_title,
      color1: item.color1,
      color2: item.color2,
      product_details:customizedProductData
      // Add or modify properties as needed
      };
      customizedData.push(customizedItem);
      }
    return customizedData;
};

module.exports = {
getTopSelling,
getWhatsNew,
getRecentSelling,
getDealProduct,
getAdditionalCatSearch,
appinformation,
UpdateproductDetails,
getOccasionalCatSearch
};
