const { application } = require('express');
const knex = require('../db'); // Import your Knex instance
const math = require('mathjs');  // If using a third-party math library

const getrecentSearch = async (appDetatils) => {
  const user_id = appDetatils.user_id;
  const device_id = appDetatils.device_id;
  if(user_id){
    return await knex ('recent_search')
    .where('user_id', user_id)
    .orderBy('id','DESC')
    .limit(5)
  }else{
    return await knex ('recent_search')
    .where('device_id', device_id)
    .orderBy('id','DESC')
    .limit(5)
  }
   
}

const gettrenproducts = async (appDetatils) => {
  const store_id = appDetatils.store_id;
 
  if(appDetatils.user_id != "null" ){
    user_id = appDetatils.user_id
  }else{
      user_id = appDetatils.device_id
  }
  const baseurl =  process.env.BUNNY_NET_IMAGE;
  await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
        trendsearch = await knex('trending_search')
                .join ('store_products', 'trending_search.varient_id', '=', 'store_products.varient_id')
                .join ('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
			          .join ('product', 'product_varient.product_id', '=', 'product.product_id')
                .leftJoin ('deal_product', 'product_varient.varient_id', '=', 'deal_product.varient_id')
                .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
                .join('store', 'store_products.store_id', '=', 'store.id')
                .select('product.percentage','product.availability', 'tbl_country.country_icon','store_products.stock','store_products.store_id','product_varient.varient_id','product.product_id','product.product_name',
                knex.raw(`CONCAT('${baseurl}', product.product_image) as product_image`),
                knex.raw(`CONCAT('${baseurl}', product.thumbnail) as thumbnail`),
                 'product_varient.description', 'store_products.price', 'store_products.mrp',
                knex.raw(`CONCAT('${baseurl}', product_varient.varient_image) as varient_image`),
                knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
                'product_varient.unit','product_varient.quantity','product.type')
                .groupBy('store_products.stock','store_products.store_id','product_varient.varient_id','product.product_id','product.product_name', 'product.product_image', 'product_varient.description', 'store_products.price', 'store_products.mrp', 'product_varient.varient_image','product_varient.unit','product_varient.quantity','product.type')    
                .where('store_products.store_id', store_id);
                const customizedProductData = [];
                for (let i = 0; i < trendsearch.length; i++) {
                  const ProductList = trendsearch[i];
                  const currentDate = new Date();
                  const deal = await knex('deal_product')
                  .where('varient_id', ProductList.varient_id)
                  .where('store_id', store_id)
                  .where('deal_product.valid_from', '<=', currentDate)
                  .where('deal_product.valid_to', '>', currentDate)
                  .first();
                 
                  let price=0;
                  if (deal) {
                  price = deal.deal_price;
                  } else {
                  const sp = await knex('store_products')
                  .where('varient_id', ProductList.varient_id)
                  .where('store_id', store_id)
                  .first();
                  price = sp.price;
                  }
                  if(user_id){ 
                        // Wishlist check 
                        // Wishlist check 
                        var isFavourite='';
                        var notifyMe='';
                        var cartQty=0;
                        const wishList = await knex('wishlist')
                        .select('*')
                        .where('varient_id',ProductList.varient_id)
                        .where('user_id',user_id);

                        isFavourite = wishList.length > 0 ? 'true' : 'false';
                
                        // cart qty check 
                        const CartQtyList = await knex('store_orders')
                        .where('varient_id',ProductList.varient_id)
                        .where('store_approval',user_id)
                        .where('order_cart_id','incart')
                        .whereNull('subscription_flag')
                        .where('store_id',store_id)
                        .first();
                        cartQty = CartQtyList ? CartQtyList.qty : 0;
                        

                        const cnotify_me = await knex('product_notify_me')
                        .where('varient_id', ProductList.varient_id)
                        .where('user_id', user_id);
                        notifyMe = cnotify_me.length > 0 ? 'true' : 'false';

                        const subprod = await knex('store_orders')
                        .select('store_orders.percentage')
                        .where('store_orders.varient_id',ProductList.varient_id)
                        .where('store_approval',user_id)
                        .where('store_orders.subscription_flag',1)
                        .where('store_orders.order_cart_id', "incart")
                        .first();
                
                        if(subprod){
                          isSubscription = 'true'
                        }else{
                          isSubscription = 'false'
                          
                        }


                    }else{
                          notifyMe='false';
                          isFavourite='false';
                          cartQty=0;
                          isSubscription = 'false';
                    }

                    const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
                    const finalsubprice =  ProductList.mrp - sub_price;
                    const subscription_price = parseFloat(finalsubprice.toFixed(2));
                    
                       if(ProductList.country_icon == null){
                          countryicon = null
                       }else{
                          countryicon =  baseurl + ProductList.country_icon
                       }

                    if (Number.isInteger(price)) {
                    priceval = price + '.001'
                    }else{
                    priceval = price
                    }
                    if (Number.isInteger(ProductList.mrp)) {
                    mrpval = ProductList.mrp + '.001'
                    }else{
                    mrpval = ProductList.mrp
                    }

                    const customizedProduct = {
                      stock: ProductList.stock,      
                      store_id: store_id,
                      varient_id: ProductList.varient_id,
                      product_id: ProductList.product_id,
                      product_name: ProductList.product_name,
                      product_image: ProductList.product_image+"?width=200&height=200&quality=100",
                      thumbnail: ProductList.thumbnail,
                      description:ProductList.description,
                      price: parseFloat(priceval),
                      mrp: parseFloat(mrpval),
                      varient_image: ProductList.varient_image,
                      discountper: ProductList.discountper,
                      avgrating:0,
                      notify_me: notifyMe,
                      isFavourite: isFavourite,
                      cart_qty: cartQty,
                      unit: ProductList.unit,
                      quantity: ProductList.quantity,
                      type: ProductList.type,
                      percentage: ProductList.percentage,
                      isSubscription:isSubscription,
                      subscription_price:subscription_price,
                      availability:ProductList.availability,
                      country_icon :countryicon
                      // Add or modify properties as needed
                      };

                      customizedProductData.push(customizedProduct);  
                }

                return customizedProductData;
}

const getUniversalSearch = async (appDetatils) => {
   
    await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
   

    const store_id = appDetatils.store_id
    const keyword = appDetatils.keyword
   // const user_id = appDetatils.user_id
    if(appDetatils.user_id != "null" ){
      user_id = appDetatils.user_id
    }else{
        user_id = appDetatils.device_id
    }
    const device_id = appDetatils.device_id
    const byname  = appDetatils.byname
    const subcatid = appDetatils.sub_cat_id
    const cat_id = appDetatils.cat_id


    const pageFilter = appDetatils.page; // You can adjust the page number dynamically
    const perPage = appDetatils.perpage;
    
    const minprice = parseFloat(appDetatils.min_price)
    const  maxprice = parseFloat(appDetatils.max_price)
    const  mindiscount = parseFloat(appDetatils.min_discount)
    const  maxdiscount = parseFloat(appDetatils.max_discount)
   
   
    let categoryarray;
    if (cat_id !== "null") {
    categoryarray = await knex('categories').where('parent', cat_id).pluck('cat_id');
    }
    
   
 
      const topsellingsQuery = knex('store_products')
      .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
      .join('product', 'product_varient.product_id', '=', 'product.product_id')
      .leftJoin('deal_product', 'product_varient.varient_id', '=', 'deal_product.varient_id')
      .select(
        'store_products.stock',
        'product_varient.varient_id',
        'product_varient.description',
        'product.product_id',
        'product.product_name',
        'product.product_image',
        'product.thumbnail',
        'store_products.price',
        'store_products.mrp',
        'product_varient.unit',
        'product_varient.quantity',
        'product.type',
        'product.percentage',
        'product.availability',
        knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
        knex.raw('100-((deal_product.deal_price*100)/store_products.mrp) as discountper1'),
       )
      .groupBy(
        'store_products.store_id',
        'product_varient.varient_id',
        'product.product_id'
      )
      .where('store_products.store_id', store_id)
      .where('product.hide', 0)
      .where('product.is_delete', 0);
   
     
      //if (cat_id !== "null") {
      //if (categoryarray.length > 0)  {
      if (categoryarray)  {
      topsellingsQuery.whereIn('product.cat_id', categoryarray);
      }
    
      if (subcatid !== "null") {
      topsellingsQuery.where('product.cat_id', subcatid);
      }
      
      if(keyword){
        // additionalcat.where('title', byname);
        topsellingsQuery.where('product.product_name', 'like', `%${keyword}%`)
         //additionalcat.whereLike('title', byname);
       }
      
       if (byname) {
        topsellingsQuery.orderBy('product.product_name', 'byname');
      }

     // return topsellingsQuery
      if ((minprice === 0 || minprice) && maxprice) {
      topsellingsQuery.whereBetween('store_products.price', [minprice, maxprice]);
      }
     
  if (mindiscount && maxdiscount) {
    topsellingsQuery.havingRaw('(discountper BETWEEN ? AND ?) OR (discountper1 BETWEEN ? AND ?)', [
      mindiscount,
      maxdiscount,
      mindiscount,
      maxdiscount,
    ]);
  }
  
//   if (sortprice === 'ltoh') {
//     topsellingsQuery.orderBy('store_products.price', 'ASC');
//   }
  
//   if (sortprice === 'htol') {
//     topsellingsQuery.orderBy('store_products.price', 'DESC');
//   }
  
//   if (sortname === 'atoz') {
//     topsellingsQuery.orderBy('product.product_name', 'ASC');
//   }
  
//   if (sortname === 'ztoa') {
//     topsellingsQuery.orderBy('product.product_name', 'DESC');
//   }
  

  const productDetail = await topsellingsQuery.offset((pageFilter - 1) * perPage)
  .limit(perPage);
  
     
     const customizedProductData = [];
       for (let i = 0; i < productDetail.length; i++) {
         const ProductList = productDetail[i];
         const currentDate = new Date();
         const deal = await knex('deal_product')
         .where('varient_id', ProductList.varient_id)
         .where('store_id', store_id)
         .where('deal_product.valid_from', '<=', currentDate)
         .where('deal_product.valid_to', '>', currentDate)
         .first();
        
         let price=0;
        if (deal) {
        price = deal.deal_price;
        } else {
        const sp = await knex('store_products')
        .where('varient_id', ProductList.varient_id)
        .where('store_id', store_id)
        .first();
        price = sp.price;
       }
       //for deviceid
       if(device_id){
                check=await knex('recent_search')
                .where('device_id',device_id);
                
                checkww=await knex('recent_search')
                .where('device_id',device_id)
                .first();   

                deletesame=await knex('recent_search')
                .where('keyword',keyword)
                .delete(); 
                
                if(check.length>=10){
                    chec=await knex('recent_search')
                    .where('id',checkww.id)
                    .delete();  
                }        
                add = await knex('recent_search')
                .insert({
                  device_id:device_id,
                    keyword:keyword
                });

       }

       if(user_id){ 

        check=await knex('recent_search')
        .where('user_id',user_id);
        
        checkww=await knex('recent_search')
        .where('user_id',user_id)
        .first();   

        deletesame=await knex('recent_search')
        .where('keyword',keyword)
        .delete(); 
        
        if(check.length>=10){
            chec=await knex('recent_search')
            .where('id',checkww.id)
            .delete();  
        }        
        add = await knex('recent_search')
        .insert({
            user_id:user_id,
            keyword:keyword
        });




        
         // Wishlist check 
          // Wishlist check 
          var isFavourite='';
          var notifyMe='';
          var cartQty=0;
          const wishList = await knex('wishlist')
         .select('*')
         .where('varient_id',ProductList.varient_id)
         .where('user_id',user_id);

         isFavourite = wishList.length > 0 ? 'true' : 'false';
  
         // cart qty check 
         const CartQtyList = await knex('store_orders')
         .where('varient_id',ProductList.varient_id)
         .where('store_approval',user_id)
         .where('order_cart_id','incart')
         .whereNull('subscription_flag')
         .where('store_id',store_id)
         .first();
         cartQty = CartQtyList ? CartQtyList.qty : 0;
         
 
         const cnotify_me = await knex('product_notify_me')
         .where('varient_id', ProductList.varient_id)
         .where('user_id', user_id);
          notifyMe = cnotify_me.length > 0 ? 'true' : 'false';

          const subprod = await knex('store_orders')
          .select('store_orders.percentage')
          .where('store_orders.varient_id',ProductList.varient_id)
          .where('store_approval',user_id)
          .where('store_orders.subscription_flag',1)
          .where('store_orders.order_cart_id', "incart")
          .first();
  
          if(subprod){
            isSubscription = 'true'
          }else{
            isSubscription = 'false'
            
          }
 
 
         }else{
          notifyMe='false';
          isFavourite='false';
          cartQty=0;
           isSubscription = 'false'
         }

         const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
         const finalsubprice =  ProductList.mrp - sub_price;
         const subscription_price = parseFloat(finalsubprice.toFixed(2));

         const baseurl =  process.env.BUNNY_NET_IMAGE;
         const customizedProduct = {
             stock: ProductList.stock,        
             varient_id: ProductList.varient_id,
             product_id: ProductList.product_id,
             product_name: ProductList.product_name,
             product_image: baseurl + ProductList.product_image+"?width=200&height=200&quality=100",
             thumbnail: ProductList.thumbnail,
             description:ProductList.description,
             price: price,
             mrp: ProductList.mrp,
             unit: ProductList.unit,
             quantity: ProductList.quantity,
             type: ProductList.type,
             discountper: ProductList.discountper,
             avgrating:0,
             notify_me: notifyMe,
             isFavourite: isFavourite,
             cart_qty: cartQty,
             percentage: ProductList.percentage,
             isSubscription:isSubscription,
             subscription_price:subscription_price,
              availability:ProductList.availability,
             countrating:0,
             varients:null
             // Add or modify properties as needed
             };
         
           customizedProductData.push(customizedProduct);  
     
       }
 
     return customizedProductData;
   };

   const getSearchbybannerold = async (appDetatils) => {
    await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
        const store_id = appDetatils.store_id
        const keyword = appDetatils.keyword
        //const user_id = appDetatils.user_id
        if(appDetatils.user_id != "null" ){
          user_id = appDetatils.user_id
      }else{
          user_id = appDetatils.device_id
      }
        const device_id = appDetatils.device_id
        const byname  = appDetatils.byname
        const subcatid = appDetatils.sub_cat_id
        const cat_id = appDetatils.cat_id
        const sortprice = appDetatils.sortprice
        const sortname = appDetatils.sortname
    
        const pageFilter = appDetatils.page; // You can adjust the page number dynamically
        const perPage = appDetatils.perpage;
        
        const minprice = parseFloat(appDetatils.min_price)
        const  maxprice = parseFloat(appDetatils.max_price)
        const  mindiscount = parseFloat(appDetatils.min_discount)
        const  maxdiscount = parseFloat(appDetatils.max_discount)
        // let words = 0;
        //  if(appDetatils.keyword != "All"){
        //   const inputString = keyword;
        //   let words = inputString.split(/\s+/).filter(word => word.length > 3);
        //  }
         
          let words = [];
        if (appDetatils.keyword !== 'All') {
          words = keyword.split(/\s+/).filter(word => word.length > 3);
        }
    
        stock = appDetatils.stock;
        if(stock == 'out'){
            stock="<";
            by=1;
           
        }else
        if(stock == 'all' || stock == "null"){
             stock="!=";
             by="null";
        }
        else
        {
          stock=">"; 
          by=0;
        }    
       
        //let categoryarray1 = [];
        let categoryarray;
        if (cat_id !== "null") {
        categoryarray = await knex('categories').where('parent', cat_id).pluck('cat_id');
        }
        //const categoryarray = categoryarray1.push(cat_id); 
        const topsellingsQuery = knex('store_products')
        .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
        .join('product', 'product_varient.product_id', '=', 'product.product_id')
         .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
         .leftJoin('deal_product', 'product_varient.varient_id', '=', 'deal_product.varient_id')
        .select(
          'store_products.stock',
          'product_varient.varient_id',
          'product_varient.description',
          'product.product_id',
          'product.product_name',
          'product.product_image',
          'product.thumbnail',
          'store_products.price',
          'store_products.mrp',
          'product_varient.unit',
          'product_varient.quantity',
          'product.type',
          'tbl_country.country_icon',
          'product.percentage',
          'product.availability',
          knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
          knex.raw('100-((deal_product.deal_price*100)/store_products.mrp) as discountper1'),
         )
        .groupBy(
          'store_products.store_id',
          'product_varient.varient_id',
          'product.product_id'
        )
        .where('store_products.store_id', store_id)
        .where('product.hide', 0)
        .where('product.is_delete', 0);
     
       
      

        //if (cat_id !== "null") {
        //if (categoryarray.length > 0)  {
        if (categoryarray)  {
        topsellingsQuery.whereIn('product.cat_id', categoryarray);
        }
       
        if (subcatid !== "null") {
        topsellingsQuery.where('product.cat_id', subcatid);
        }
        
     
         
        // if( words.length > 0 && keyword != "All"){
       
        //   //const patterns = ['Milk', 'bannana', 'Combo'];
        //   const patterns = words
        //     topsellingsQuery.where(builder => {
        //       patterns.forEach(pattern => {
        //         builder.orWhere('product.product_name', 'like', `%${pattern}%`);
        //       });
        //     });
        //      //additionalcat.whereLike('title', byname);
        //  }
         
         if(stock){
            topsellingsQuery.where('store_products.stock',stock,by)
         }
         if (byname) {
          topsellingsQuery.orderBy('product.product_name', 'byname');
        }
    
       // return topsellingsQuery
        if ((minprice === 0 || minprice) && maxprice) {
        topsellingsQuery.whereBetween('store_products.price', [minprice, maxprice]);
        }
       
        if (mindiscount && maxdiscount) {
        topsellingsQuery.havingRaw('(discountper BETWEEN ? AND ?) OR (discountper1 BETWEEN ? AND ?)', [
            mindiscount,
            maxdiscount,
            mindiscount,
            maxdiscount,
        ]);
        }
    
          if (sortprice === 'ltoh') {
                topsellingsQuery.orderBy('store_products.price', 'ASC');
            }
            
            if (sortprice === 'htol') {
                topsellingsQuery.orderBy('store_products.price', 'DESC');
            }
            
            if (sortname === 'atoz') {
                topsellingsQuery.orderBy('product.product_name', 'ASC');
            }
            
            if (sortname === 'ztoa') {
                topsellingsQuery.orderBy('product.product_name', 'DESC');
            }
    
            if (words.length > 0 && keyword !== 'All') {
              topsellingsQuery.where(builder => {
                words.forEach(pattern => {
                  builder.orWhere('product.product_name', 'like', `%${pattern}%`);
                });
              });
            }
            const productDetail = await topsellingsQuery.offset((pageFilter - 1) * perPage)
            .limit(perPage);
            
               
               const customizedProductData = [];
                 for (let i = 0; i < productDetail.length; i++) {
                   const ProductList = productDetail[i];
                   const currentDate = new Date();
                   const deal = await knex('deal_product')
                   .where('varient_id', ProductList.varient_id)
                   .where('store_id', store_id)
                   .where('deal_product.valid_from', '<=', currentDate)
                   .where('deal_product.valid_to', '>', currentDate)
                   .first();
                  
                   let price=0;
                  if (deal) {
                  price = deal.deal_price;
                  } else {
                  const sp = await knex('store_products')
                  .where('varient_id', ProductList.varient_id)
                  .where('store_id', store_id)
                  .first();
                  price = sp.price;
                 }
           
                   //for deviceid
               if(device_id){
                
                    check=await knex('recent_search')
                    .where('device_id',device_id);
                    
                    checkww=await knex('recent_search')
                    .where('device_id',device_id)
                    .first();   
    
                    deletesame=await knex('recent_search')
                    .where('keyword',keyword)
                    .delete(); 
                      
                    if(check.length>=10){
                        chec=await knex('recent_search')
                        .where('id',checkww.id)
                        .delete();  
                    }    
                    
                   
                   add = await knex('recent_search')
                    .insert({
                        device_id:device_id,
                        keyword:keyword
                    });
                      
                        
        
               }
           
                 if(user_id){ 
          
          
                  check=await knex('recent_search')
                  .where('user_id',user_id);
                  
                  checkww=await knex('recent_search')
                  .where('user_id',user_id)
                  .first();   
          
                  deletesame=await knex('recent_search')
                  .where('keyword',keyword)
                  .delete(); 
                  
                  if(check.length>=10){
                      chec=await knex('recent_search')
                      .where('id',checkww.id)
                      .delete();  
                  }        
                  add = await knex('recent_search')
                  .insert({
                      user_id:user_id,
                      keyword:keyword
                  });
          
          
          
          
                  
                   // Wishlist check 
                    // Wishlist check 
                    var isFavourite='';
              var notifyMe='';
              var cartQty=0;
                    const wishList = await knex('wishlist')
                   .select('*')
                   .where('varient_id',ProductList.varient_id)
                   .where('user_id',user_id);
          
                   isFavourite = wishList.length > 0 ? 'true' : 'false';
            
                   // cart qty check 
                   const CartQtyList = await knex('store_orders')
                   .where('varient_id',ProductList.varient_id)
                   .where('store_approval',user_id)
                   .where('order_cart_id','incart')
                   .whereNull('subscription_flag')
                   .where('store_id',store_id)
                   .first();
                   cartQty = CartQtyList ? CartQtyList.qty : 0;
                   
           
                   const cnotify_me = await knex('product_notify_me')
                   .where('varient_id', ProductList.varient_id)
                   .where('user_id', user_id);
                    notifyMe = cnotify_me.length > 0 ? 'true' : 'false';

                    const subprod = await knex('store_orders')
                    .select('store_orders.percentage')
                    .where('store_orders.varient_id',ProductList.varient_id)
                    .where('store_approval',user_id)
                    .where('store_orders.subscription_flag',1)
                    .where('store_orders.order_cart_id', "incart")
                    .first();
            
                    if(subprod){
                      isSubscription = 'true'
                    }else{
                      isSubscription = 'false'
                      
                    }
           
           
                   }else{
                    notifyMe='false';
                    isFavourite='false';
                    cartQty=0;
                    isSubscription = 'false';
                   }

                   const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
                   const finalsubprice =  ProductList.mrp - sub_price;
                   const subscription_price = parseFloat(finalsubprice.toFixed(2));

                   const baseurl =  process.env.BUNNY_NET_IMAGE;
                   
                     if(ProductList.country_icon == null){
                          countryicon = null
                       }else{
                          countryicon =  baseurl + ProductList.country_icon
                       }
                       
                   const customizedProduct = {
                       stock: ProductList.stock,        
                       varient_id: ProductList.varient_id,
                       product_id: ProductList.product_id,
                       product_name: ProductList.product_name,
                       product_image: baseurl + ProductList.product_image+"?width=200&height=200&quality=100",
                       thumbnail: ProductList.thumbnail,
                       description:ProductList.description,
                       price: price,
                       mrp: ProductList.mrp,
                       unit: ProductList.unit,
                       quantity: ProductList.quantity,
                       type: ProductList.type,
                       percentage: ProductList.percentage,
                       isSubscription:isSubscription,
                       subscription_price:subscription_price,
                        availability:ProductList.availability,
                       //discountper: ProductList.discountper,
                       discountper:0,
                       avgrating:0,
                       notify_me: notifyMe,
                       isFavourite: isFavourite,
                       cart_qty: cartQty,
                       countrating:0,
                       country_icon : countryicon, 
                       varients:null
                       // Add or modify properties as needed
                       };
                   
                     customizedProductData.push(customizedProduct);  
               
                 }
           
               return customizedProductData;
    }
    
    const getSearchbybanner = async (appDetatils) => {
    await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
        const store_id = appDetatils.store_id
        const keyword = appDetatils.keyword
        //const user_id = appDetatils.user_id

        // If no product found for the keyword, return early
        if (!keyword) {
        return "No products found for the given keyword";
        }

      if(appDetatils.user_id != "null" ){
          user_id = appDetatils.user_id
      }else{
          user_id = appDetatils.device_id
      }

        const device_id = appDetatils.device_id
        const byname  = appDetatils.byname
        const subcatid = appDetatils.sub_cat_id
        const cat_id = appDetatils.cat_id
        const brand_id = appDetatils.brand_id
        const sortprice = appDetatils.sortprice
        const sortname = appDetatils.sortname
    
        const pageFilter = 1; // You can adjust the page number dynamically
        const perPage = 50;
        
        const minprice = parseFloat(appDetatils.min_price)
        const  maxprice = parseFloat(appDetatils.max_price)
        const  mindiscount = parseFloat(appDetatils.min_discount)
        const  maxdiscount = parseFloat(appDetatils.max_discount)
        // let words = 0;
        //  if(appDetatils.keyword != "All"){
        //   const inputString = keyword;
        //   let words = inputString.split(/\s+/).filter(word => word.length > 3);
        //  }
         
          let words = [];
        if (appDetatils.keyword !== 'All') {
          words = keyword.split(/\s+/).filter(word => word.length > 3);
        }
        
    
        stock = appDetatils.stock;
        if(stock == 'out'){
            stock="<";
            by=1;
           
        }else
        if(stock == 'all' || stock == "null"){
             stock="!=";
             by="null";
        }
        else
        {
          stock=">"; 
          by=0;
        }    

        const topsellingsQuery = knex('store_products')
        .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
        .join('product', 'product_varient.product_id', '=', 'product.product_id')
         .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
         .leftJoin('deal_product', 'product_varient.varient_id', '=', 'deal_product.varient_id')
        .select(
          'store_products.stock',
          'product_varient.varient_id',
          'product_varient.description',
          'product.product_id',
          'product.product_name',
          'product.product_image',
          'product.thumbnail',
          'store_products.price',
          'store_products.mrp',
          'product_varient.unit',
          'product_varient.quantity',
          'product.type',
          'tbl_country.country_icon',
          'product.percentage',
          'product.availability',
          'product.brand_id',
          'product.cat_id',
          knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
          knex.raw('100-((deal_product.deal_price*100)/store_products.mrp) as discountper1'),
         )
        .groupBy(
          'store_products.store_id',
          'product_varient.varient_id',
          'product.product_id'
        )
        .where('product.hide', 0)
        .where('product.is_delete', 0);
     
       
        if(brand_id && brand_id != ' ')
        {
        var cleanedKeyword = keyword.trim().replace(/\s+/g, ' ');  
        var categoryID = await knex('sec_banner').where('sec_banner.banner_name', 'like', `%${cleanedKeyword}%`).first();
        categoryarray = await knex('categories').where('parent',categoryID.cat_id).pluck('cat_id');
        topsellingsQuery.whereIn('product.cat_id', categoryarray);
        }else
        {
        var cleanedKeyword = keyword.trim().replace(/\s+/g, ' ');    
        var categoryID = await knex('store_banner').where('store_banner.banner_name', 'like', `%${cleanedKeyword}%`).first(); 
        topsellingsQuery.where('product.cat_id', categoryID.cat_id);
        }
       
        if (subcatid !== "null") {
        topsellingsQuery.where('product.cat_id', subcatid);
        }
        
         if(stock){
            // topsellingsQuery.where('store_products.stock',stock,by)
         }

       // return topsellingsQuery
        if ((minprice === 0 || minprice) && maxprice) {
        topsellingsQuery.whereBetween('store_products.price', [minprice, maxprice]);
        }
       
        if (mindiscount && maxdiscount) {
        topsellingsQuery.havingRaw('(discountper BETWEEN ? AND ?) OR (discountper1 BETWEEN ? AND ?)', [
            mindiscount,
            maxdiscount,
            mindiscount,
            maxdiscount,
        ]);
        }
    
          if (sortprice === 'ltoh') {
                topsellingsQuery.orderBy('store_products.price', 'ASC');
            }
            
            if (sortprice === 'htol') {
                topsellingsQuery.orderBy('store_products.price', 'DESC');
            }
            
            if (sortname === 'atoz') {
                topsellingsQuery.orderBy('product.product_name', 'ASC');
            }
            
            if (sortname === 'ztoa') {
                topsellingsQuery.orderBy('product.product_name', 'DESC');
            }
    
            const productDetail = await topsellingsQuery.offset((pageFilter - 1) * perPage)
            .limit(perPage);
                       
               const customizedProductData = [];
                 for (let i = 0; i < productDetail.length; i++) {
                   const ProductList = productDetail[i];
                   const currentDate = new Date();
                   const deal = await knex('deal_product')
                   .where('varient_id', ProductList.varient_id)
                   .where('store_id', store_id)
                   .where('deal_product.valid_from', '<=', currentDate)
                   .where('deal_product.valid_to', '>', currentDate)
                   .first();
                  
                   let price=0;
                  if (deal) {
                  price = deal.deal_price;
                  } else {
                  const sp = await knex('store_products')
                  .where('varient_id', ProductList.varient_id)
                  .where('store_id', store_id)
                  .first();
                  price = sp.price;
                 }
           
                 if(user_id){ 
          
          
                  check=await knex('recent_search')
                  .where('user_id',user_id);
                  
                  checkww=await knex('recent_search')
                  .where('user_id',user_id)
                  .first();   
          
                  deletesame=await knex('recent_search')
                  .where('keyword',keyword)
                  .delete(); 
                  
                  if(check.length>=10){
                      chec=await knex('recent_search')
                      .where('id',checkww.id)
                      .delete();  
                  }        
                  add = await knex('recent_search')
                  .insert({
                      user_id:user_id,
                      keyword:keyword
                  });
          
          
          
          
                  
                   // Wishlist check 
                    // Wishlist check 
                    var isFavourite='';
              var notifyMe='';
              var cartQty=0;
                    const wishList = await knex('wishlist')
                   .select('*')
                   .where('varient_id',ProductList.varient_id)
                   .where('user_id',user_id);
          
                   isFavourite = wishList.length > 0 ? 'true' : 'false';
            
                   // cart qty check 
                   const CartQtyList = await knex('store_orders')
                   .where('varient_id',ProductList.varient_id)
                   .where('store_approval',user_id)
                   .where('order_cart_id','incart')
                   .whereNull('subscription_flag')
                   .where('store_id',store_id)
                   .first();
                   cartQty = CartQtyList ? CartQtyList.qty : 0;
                   
           
                   const cnotify_me = await knex('product_notify_me')
                   .where('varient_id', ProductList.varient_id)
                   .where('user_id', user_id);
                    notifyMe = cnotify_me.length > 0 ? 'true' : 'false';

                    const subprod = await knex('store_orders')
                    .select('store_orders.percentage')
                    .where('store_orders.varient_id',ProductList.varient_id)
                    .where('store_approval',user_id)
                    .where('store_orders.subscription_flag',1)
                    .where('store_orders.order_cart_id', "incart")
                    .first();
            
                    if(subprod){
                      isSubscription = 'true'
                    }else{
                      isSubscription = 'false'
                      
                    }
           
           
                   }else{
                    notifyMe='false';
                    isFavourite='false';
                    cartQty=0;
                    isSubscription = 'false';
                   }

                   const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
                   const finalsubprice =  ProductList.mrp - sub_price;
                   const subscription_price = parseFloat(finalsubprice.toFixed(2));

                   const baseurl =  process.env.BUNNY_NET_IMAGE;
                      if(ProductList.country_icon == null){
                          countryicon = null
                       }else{
                          countryicon =  baseurl + ProductList.country_icon
                       }
                   
                      if (Number.isInteger(price)) {
                      priceval = price + '.001'
                      }else{
                      priceval = price
                      }
                      if (Number.isInteger(ProductList.mrp)) {
                      mrpval = ProductList.mrp + '.001'
                      }else{
                      mrpval = ProductList.mrp
                      }

                   const customizedProduct = {
                       stock: ProductList.stock, 
                       cat_id:ProductList.cat_id,
                       varient_id: ProductList.varient_id,
                       product_id: ProductList.product_id,
                       brand_id: ProductList.brand_id,
                       product_name: ProductList.product_name,
                       product_image: baseurl + ProductList.product_image+"?width=200&height=200&quality=100",
                       thumbnail: ProductList.thumbnail,
                       description:ProductList.description,
                       price: parseFloat(priceval),
                       mrp: parseFloat(mrpval),
                       unit: ProductList.unit,
                       quantity: ProductList.quantity,
                       type: ProductList.type,
                       percentage: ProductList.percentage,
                       isSubscription:isSubscription,
                       subscription_price:subscription_price,
                        availability:ProductList.availability,
                       //discountper: ProductList.discountper,
                       discountper:0,
                       avgrating:0,
                       notify_me: notifyMe,
                       isFavourite: isFavourite,
                       cart_qty: cartQty,
                       countrating:0,
                       country_icon : countryicon, 
                       varients:null
                       // Add or modify properties as needed
                       };
                   
                     customizedProductData.push(customizedProduct);  
               
                 }
           
               return customizedProductData;
    }
    
const getSearchbystore = async (appDetatils) => {
        await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
        const store_id = appDetatils.store_id
        const keyword = appDetatils.keyword
      // const user_id = appDetatils.user_id
      if(appDetatils.user_id != "null" ){
        user_id = appDetatils.user_id
        }else{
            user_id = appDetatils.device_id
        }
        const device_id = appDetatils.device_id
        const byname  = appDetatils.byname
        const subcatid = appDetatils.sub_cat_id
        const cat_id = appDetatils.cat_id
        const sortprice = appDetatils.sortprice
        const sortname = appDetatils.sortname

        const pageFilter = appDetatils.page; // You can adjust the page number dynamically
        const perPage = appDetatils.perpage;
        
        const minprice = parseFloat(appDetatils.min_price)
        const  maxprice = parseFloat(appDetatils.max_price)
        const  mindiscount = parseFloat(appDetatils.min_discount)
        const  maxdiscount = parseFloat(appDetatils.max_discount)

        stock = appDetatils.stock;
        if(stock == 'out'){
            stock="<";
            by=1;
          
        }else
        if(stock == 'all' || stock == "null"){
            stock="!=";
            by="null";
        }
        else
        {
          stock=">"; 
          by=0;
        }    
      
        //let categoryarray1 = [];
        let categoryarray;
        if (cat_id !== "null") {
        categoryarray = await knex('categories').where('parent', cat_id).pluck('cat_id');
        }
        //const categoryarray = categoryarray1.push(cat_id); 
        const topsellingsQuery = knex('store_products')
        .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
        .join('product', 'product_varient.product_id', '=', 'product.product_id')
        .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
        .leftJoin('deal_product', 'product_varient.varient_id', '=', 'deal_product.varient_id')
        .select(
          'store_products.stock',
          'product_varient.varient_id',
          'product_varient.description',
          'product.product_id',
          'product.product_name',
          'product.product_image',
          'product.thumbnail',
          'store_products.price',
          'store_products.mrp',
          'product_varient.unit',
          'product_varient.quantity',
          'product.type',
          'tbl_country.country_icon',
          'product.percentage',
          'product.availability',
          knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
          knex.raw('100-((deal_product.deal_price*100)/store_products.mrp) as discountper1'),
        )
        .groupBy(
          'store_products.store_id',
          'product_varient.varient_id',
          'product.product_id'
        )
        .where('store_products.store_id', store_id)
        .where('product.hide', 0)
        .where('product.is_delete', 0);

        if(keyword == 'daily')
        {
        // List of IDs
        const ids = [122,2,3,16,23,149,21,55,56,57,58,59,72,94,150,9,20,132,37,48,50,99,101,102,147,180,47,49,91,100,146,148,179];  
        topsellingsQuery.whereIn('product.availability', ['quick','all']);
        topsellingsQuery.whereIn('product.cat_id', ids) // Filter by these IDs
        topsellingsQuery.orderByRaw(`FIELD(product.cat_id, ${ids.join(',')})`); // Maintain the custom order  
        }

        if(keyword == 'subscription')
        {
        // List of IDs
        const ids = [122,2,3,16,23,149,37,48,50,99,101,102,147,180,47,49,91,100,146,148,179,9,20,132,21,55,56,57,58,59,72,94,150];
        topsellingsQuery.whereIn('product.availability', ['subscription','all']);  
        topsellingsQuery.whereIn('product.cat_id', ids) // Filter by these IDs
        topsellingsQuery.orderByRaw(`FIELD(product.cat_id, ${ids.join(',')})`); // Maintain the custom order
  
        }
       
        //if (cat_id !== "null") {
        //if (categoryarray.length > 0)  {
        if (categoryarray)  {
        topsellingsQuery.whereIn('product.cat_id', categoryarray);
        }
      
        if (subcatid !== "null") {
        topsellingsQuery.where('product.cat_id', subcatid);
        }
        
        if(keyword != 'daily' && keyword != 'subscription'){
          // additionalcat.where('title', byname);
          topsellingsQuery.where('product.product_name', 'like', `%${keyword}%`)
          //additionalcat.whereLike('title', byname);
        }
        if(stock){
            // topsellingsQuery.where('store_products.stock',stock,by)
        }
        if (byname) {
          // topsellingsQuery.orderBy('product.product_name', 'byname');
        }

      // return topsellingsQuery
        if ((minprice === 0 || minprice) && maxprice) {
        topsellingsQuery.whereBetween('store_products.price', [minprice, maxprice]);
        }
      
        if (mindiscount && maxdiscount) {
        topsellingsQuery.havingRaw('(discountper BETWEEN ? AND ?) OR (discountper1 BETWEEN ? AND ?)', [
            mindiscount,
            maxdiscount,
            mindiscount,
            maxdiscount,
        ]);
        }

          if (sortprice === 'ltoh') {
                topsellingsQuery.orderBy('store_products.price', 'ASC');
            }
            
            if (sortprice === 'htol') {
                topsellingsQuery.orderBy('store_products.price', 'DESC');
            }
            
            if (sortname === 'atoz') {
                topsellingsQuery.orderBy('product.product_name', 'ASC');
            }
            
            if (sortname === 'ztoa') {
                topsellingsQuery.orderBy('product.product_name', 'DESC');
            }


            const productDetail = await topsellingsQuery.offset((pageFilter - 1) * perPage)
            .limit(perPage);
            
              
              const customizedProductData = [];
                for (let i = 0; i < productDetail.length; i++) {
                  const ProductList = productDetail[i];
                  const currentDate = new Date();
                  const deal = await knex('deal_product')
                  .where('varient_id', ProductList.varient_id)
                  .where('store_id', store_id)
                  .where('deal_product.valid_from', '<=', currentDate)
                  .where('deal_product.valid_to', '>', currentDate)
                  .first();
                  
                  let price=0;
                  if (deal) {
                  price = deal.deal_price;
                  } else {
                  const sp = await knex('store_products')
                  .where('varient_id', ProductList.varient_id)
                  .where('store_id', store_id)
                  .first();
                  price = sp.price;
                }
                
                //for device_id
          if(device_id){

                  try {
                      check=await knex('recent_search')
                      .where('device_id',device_id);
                      
                      checkww=await knex('recent_search')
                      .where('device_id',device_id)
                      .first();   

                      deletesame=await knex('recent_search')
                      .where('keyword',keyword)
                      .delete(); 
                      
                      if(check.length>=10){
                          chec=await knex('recent_search')
                          .where('id',checkww.id)
                          .delete();  
                      }        
                      add = await knex('recent_search')
                      .insert({
                        device_id:device_id,
                          keyword:keyword
                      });
                    } catch (error) {

                    } finally {
      
                    }

              }
          
                if(user_id){ 
          

                  try {
                  // Check recent searches for the user
                  const check = await knex('recent_search')
                  .where('user_id', user_id);

                  // Get the most recent search entry for the user
                  const checkww = await knex('recent_search')
                  .where('user_id', user_id)
                  .first();

                  // Delete entries with the same keyword
                  const deletesame = await knex('recent_search')
                  .where('keyword', keyword)
                  .delete();

                  // Check if there are 10 or more recent searches
                  if (check.length >= 10) {
                  if (checkww) {
                  // Delete the oldest entry (the one with the id from checkww)
                  await knex('recent_search')
                  .where('id', checkww.id)
                  .delete();
                  }
                  }
                  // Add the new search entry
                  const add = await knex('recent_search')
                  .insert({
                  user_id: user_id,
                  keyword: keyword
                  });

                  } catch (error) {

                  } finally {

                  }
      
                  // Wishlist check 
                    // Wishlist check 
                    var isFavourite='';
              var notifyMe='';
              var cartQty=0;
                if (user_id) {
                const wishList = await knex('wishlist')
                .select('*')
                .where('varient_id',ProductList.varient_id)
                .where('user_id',user_id);
                isFavourite = wishList.length > 0 ? 'true' : 'false';
                }else
                {
                isFavourite='false'; 
                }
            
                  // cart qty check 
                  if(user_id){
                  const CartQtyList = await knex('store_orders')
                  .where('varient_id',ProductList.varient_id)
                  .where('store_approval',user_id)
                  .where('order_cart_id','incart')
                  .whereNull('subscription_flag')
                  .where('store_id',store_id)
                  .first();
                  cartQty = CartQtyList ? CartQtyList.qty : 0;
                  }else
                  {
                  cartQty=0; 
                  }
                  
                  if (user_id) {
                  const cnotify_me = await knex('product_notify_me')
                  .where('varient_id', ProductList.varient_id)
                  .where('user_id', user_id);
                    notifyMe = cnotify_me.length > 0 ? 'true' : 'false';
                  }else
                  {
                    notifyMe = 'false';
                  }
                  isSubscription='false';
                  }else{
                    notifyMe='false';
                    isFavourite='false';
                    cartQty=0;
                    isSubscription = 'false';
                  }
                  const baseurl =  process.env.BUNNY_NET_IMAGE;
                  const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
                  const finalsubprice =  ProductList.mrp - sub_price;
                  const subscription_price = parseFloat(finalsubprice.toFixed(2));
                  
                  
                          if(ProductList.country_icon == null){
                              countryicon = null
                          }else{
                              countryicon =  baseurl + ProductList.country_icon
                          }

                    if (Number.isInteger(price)) {
                    priceval = price + '.001'
                    }else{
                    priceval = price
                    }
                    if (Number.isInteger(ProductList.mrp)) {
                    mrpval = ProductList.mrp + '.001'
                    }else{
                    mrpval = ProductList.mrp
                    }
                          
                  const customizedProduct = {
                      stock: ProductList.stock,        
                      varient_id: ProductList.varient_id,
                      product_id: ProductList.product_id,
                      product_name: ProductList.product_name,
                      product_image: baseurl + ProductList.product_image+"?width=200&height=200&quality=100",
                      thumbnail: ProductList.thumbnail,
                      description:ProductList.description,
                      price: parseFloat(priceval),
                      mrp: parseFloat(mrpval),
                      unit: ProductList.unit,
                      quantity: ProductList.quantity,
                      type: ProductList.type,
                      discountper: ProductList.discountper,
                      avgrating:0,
                      notify_me: notifyMe,
                      isFavourite: isFavourite,
                      cart_qty: cartQty,
                      countrating:0,
                      percentage: ProductList.percentage,
                      isSubscription:isSubscription,
                      subscription_price:subscription_price,
                      availability:ProductList.availability,
                      country_icon : countryicon, 
                      varients:null
                      // Add or modify properties as needed
                      };
                  
                    customizedProductData.push(customizedProduct);  
              
                }
          
              return customizedProductData;
}

const getSearchbyBrands = async (appDetatils) => {
  await knex.raw('SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))'); 
  const store_id = appDetatils.store_id
  const keyword = appDetatils.keyword
  if(appDetatils.user_id != "null" ){
  user_id = appDetatils.user_id
  }else{
  user_id = appDetatils.device_id
  }
  const device_id = appDetatils.device_id
  const byname  = appDetatils.byname
  const subcatid = appDetatils.sub_cat_id
  const cat_id = appDetatils.cat_id
  const sortprice = appDetatils.sortprice
  const sortname = appDetatils.sortname
  const brand_id = appDetatils.brand_id

  const pageFilter = appDetatils.page; // You can adjust the page number dynamically
  const perPage = 50;

  const minprice = parseFloat(appDetatils.min_price)
  const  maxprice = parseFloat(appDetatils.max_price)
  const  mindiscount = parseFloat(appDetatils.min_discount)
  const  maxdiscount = parseFloat(appDetatils.max_discount)
  stock = appDetatils.stock;

  const topsellingsQuery = knex('store_products')
  .join('product_varient', 'store_products.varient_id', '=', 'product_varient.varient_id')
  .join('product', 'product_varient.product_id', '=', 'product.product_id')
  .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
  .leftJoin('deal_product', 'product_varient.varient_id', '=', 'deal_product.varient_id')
  .select(
  'store_products.stock',
  'product_varient.varient_id',
  'product_varient.description',
  'product.product_id',
  'product.product_name',
  'product.brand_id',
  'product.product_image',
  'product.thumbnail',
  'store_products.price',
  'store_products.mrp',
  'product_varient.unit',
  'product_varient.quantity',
  'product.type',
  'tbl_country.country_icon',
  'product.percentage',
  'product.availability',
  knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'),
  knex.raw('100-((deal_product.deal_price*100)/store_products.mrp) as discountper1'),
  )
  .groupBy(
  'store_products.store_id',
  'product_varient.varient_id',
  'product.product_id'
  )
  .where('product.brand_id', brand_id)
  .where('product.hide', 0)
  .where('product.is_delete', 0);

  if ((minprice === 0 || minprice) && maxprice) {
  topsellingsQuery.whereBetween('store_products.price', [minprice, maxprice]);
  }

  if (mindiscount && maxdiscount) {
  topsellingsQuery.havingRaw('(discountper BETWEEN ? AND ?) OR (discountper1 BETWEEN ? AND ?)', [
  mindiscount,
  maxdiscount,
  mindiscount,
  maxdiscount,
  ]);
  }

  if (sortprice === 'ltoh') {
  topsellingsQuery.orderBy('store_products.price', 'ASC');
  }

  if (sortprice === 'htol') {
  topsellingsQuery.orderBy('store_products.price', 'DESC');
  }

  if (sortname === 'atoz') {
  topsellingsQuery.orderBy('product.product_name', 'ASC');
  }

  if (sortname === 'ztoa') {
  topsellingsQuery.orderBy('product.product_name', 'DESC');
  }

  const productDetail = await topsellingsQuery.offset((pageFilter - 1) * perPage)
  .limit(perPage);

  const customizedProductData = [];
  for (let i = 0; i < productDetail.length; i++) {
    const ProductList = productDetail[i];
    const currentDate = new Date();
    const deal = await knex('deal_product')
    .where('varient_id', ProductList.varient_id)
    .where('store_id', store_id)
    .where('deal_product.valid_from', '<=', currentDate)
    .where('deal_product.valid_to', '>', currentDate)
    .first();
    
    let price=0;
    if (deal) {
    price = deal.deal_price;
    } else {
    const sp = await knex('store_products')
    .where('varient_id', ProductList.varient_id)
    .where('store_id', store_id)
    .first();
    price = sp.price;
  }

  //for device_id
  if(device_id){

    try {
        check=await knex('recent_search')
        .where('device_id',device_id);
        
        checkww=await knex('recent_search')
        .where('device_id',device_id)
        .first();   

        deletesame=await knex('recent_search')
        .where('keyword',keyword)
        .delete(); 
        
        if(check.length>=10){
            chec=await knex('recent_search')
            .where('id',checkww.id)
            .delete();  
        }        
        add = await knex('recent_search')
        .insert({
          device_id:device_id,
            keyword:keyword
        });
      } catch (error) {

      } finally {

      }

  }

  if(user_id){ 


    try {
    // Check recent searches for the user
    const check = await knex('recent_search')
    .where('user_id', user_id);

    // Get the most recent search entry for the user
    const checkww = await knex('recent_search')
    .where('user_id', user_id)
    .first();

    // Delete entries with the same keyword
    const deletesame = await knex('recent_search')
    .where('keyword', keyword)
    .delete();

    // Check if there are 10 or more recent searches
    if (check.length >= 10) {
    if (checkww) {
    // Delete the oldest entry (the one with the id from checkww)
    await knex('recent_search')
    .where('id', checkww.id)
    .delete();
    }
    }
    // Add the new search entry
    const add = await knex('recent_search')
    .insert({
    user_id: user_id,
    keyword: keyword
    });

    } catch (error) {

    } finally {

    }

    // Wishlist check 
      // Wishlist check 
      var isFavourite='';
  var notifyMe='';
  var cartQty=0;
  if (user_id) {
  const wishList = await knex('wishlist')
  .select('*')
  .where('varient_id',ProductList.varient_id)
  .where('user_id',user_id);
  isFavourite = wishList.length > 0 ? 'true' : 'false';
  }else
  {
  isFavourite='false'; 
  }

    // cart qty check 
    if(user_id){
    const CartQtyList = await knex('store_orders')
    .where('varient_id',ProductList.varient_id)
    .where('store_approval',user_id)
    .where('order_cart_id','incart')
    .whereNull('subscription_flag')
    .where('store_id',store_id)
    .first();
    cartQty = CartQtyList ? CartQtyList.qty : 0;
    }else
    {
    cartQty=0; 
    }
    
    if (user_id) {
    const cnotify_me = await knex('product_notify_me')
    .where('varient_id', ProductList.varient_id)
    .where('user_id', user_id);
      notifyMe = cnotify_me.length > 0 ? 'true' : 'false';
    }else
    {
      notifyMe = 'false';
    }
      
    
        isSubscription='false';
      

    


    }else{
      notifyMe='false';
      isFavourite='false';
      cartQty=0;
      isSubscription = 'false';
    }
    const baseurl =  process.env.BUNNY_NET_IMAGE;
    const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
    const finalsubprice =  ProductList.mrp - sub_price;
    const subscription_price = parseFloat(finalsubprice.toFixed(2));
  
    if(ProductList.country_icon == null){
        countryicon = null
    }else{
        countryicon =  baseurl + ProductList.country_icon
    }

    if (Number.isInteger(price)) {
    priceval = price + '.001'
    }else{
    priceval = price
    }
    if (Number.isInteger(ProductList.mrp)) {
    mrpval = ProductList.mrp + '.001'
    }else{
    mrpval = ProductList.mrp
    }
            
    const customizedProduct = {
        stock: ProductList.stock,        
        varient_id: ProductList.varient_id,
        product_id: ProductList.product_id,
        brand_id: ProductList.brand_id,
        product_name: ProductList.product_name,
        product_image: baseurl + ProductList.product_image+"?width=200&height=200&quality=100",
        thumbnail: ProductList.thumbnail,
        description:ProductList.description,
        price: parseFloat(priceval),
        mrp: parseFloat(mrpval),
        unit: ProductList.unit,
        quantity: ProductList.quantity,
        type: ProductList.type,
        discountper: ProductList.discountper,
        avgrating:0,
        notify_me: notifyMe,
        isFavourite: isFavourite,
        cart_qty: cartQty,
        countrating:0,
        percentage: ProductList.percentage,
        isSubscription:isSubscription,
        subscription_price:subscription_price,
        availability:ProductList.availability,
        country_icon : countryicon, 
        varients:null
        // Add or modify properties as needed
        };
    customizedProductData.push(customizedProduct);  
  }

  return customizedProductData;
  }

module.exports = {
getUniversalSearch,
getSearchbystore,
getrecentSearch,
gettrenproducts,
getSearchbybanner,
getSearchbyBrands
};