const { application } = require('express');
const knex = require('../db'); // Import your Knex instance
const math = require('mathjs');  // If using a third-party math library
const axios = require('axios');



const trailPackList = async (appDetatils) => {
const { trail_id} = appDetatils;
const baseurl = process.env.BUNNY_NET_IMAGE;
// Fetch all products in one go
return await knex('tbl_trail_pack_basic')
.select('id','title',knex.raw(`CONCAT('${baseurl}', image) as image`),'tbl_trail_pack_basic.description')
.where('tbl_trail_pack_basic.status', 0)
.where('tbl_trail_pack_basic.is_delete', 0);
};


const trailPackDetails = async (appDetails) => {
    const { trail_id } = appDetails;
    const baseurl = process.env.BUNNY_NET_IMAGE;
  
    // Fetch basic trail pack details
    const basicDetails = await knex('tbl_trail_pack_basic')
      .select(
        'id',
        'title',
        knex.raw(`CONCAT('${baseurl}', image) as image`),
        'description'
      )
      .where('status', 0)
      .andWhere('is_delete', 0)
      .andWhere('id', trail_id)
      .first();
  
    // Fetch product details within the trail pack
    const productDetails = await knex('tbl_trail_pack_deatils as tpd')
      .distinct('p.product_id', 'p.product_name')
      .select(
        knex.raw(`CONCAT('${baseurl}', p.product_image) as product_image`),
        'sp.mrp',
        'sp.price',
        'tpb.discount_percentage',
        knex.raw('ROUND(sp.price * (1 - tpb.discount_percentage / 100), 2) as discounted_price')
      )
      .join('tbl_trail_pack_basic as tpb', 'tpd.trail_id', 'tpb.id')
      .join('product as p', 'p.product_id', 'tpd.product_id')
      .join('product_varient as pv', 'pv.product_id', 'p.product_id')
      .join('store_products as sp', 'pv.varient_id', 'sp.varient_id')
      .where('tpd.trail_id', trail_id);
  
    // Calculate total discounted price for all products in the trail pack
    const totalDiscountedPrice = await knex('tbl_trail_pack_deatils as tpd')
      .join('tbl_trail_pack_basic as tpb', 'tpd.trail_id', 'tpb.id')
      .join('product as p', 'p.product_id', 'tpd.product_id')
      .join('product_varient as pv', 'pv.product_id', 'p.product_id')
      .join('store_products as sp', 'pv.varient_id', 'sp.varient_id')
      .where('tpd.trail_id', trail_id)
      .sum({ total_discounted_price: knex.raw('ROUND(sp.price * (1 - tpb.discount_percentage / 100), 2)') })
      .first();
  
    return {
      id: basicDetails.id,
      title: basicDetails.title,
      image: basicDetails.image,
      description: basicDetails.description,
      total_discounted_price: totalDiscountedPrice.total_discounted_price,
      product_details: productDetails,
    };
  };
  

module.exports = {
trailPackList,
trailPackDetails,
};