// models/userModel.js
const knex = require('../db'); // Import your Knex instance
const speakeasy = require('speakeasy'); 
const bcrypt = require('bcryptjs');
const sgMail = require('@sendgrid/mail');
const ejs = require('ejs');
const fs = require('fs');
const fetch = (...args) => import('node-fetch').then(({ default: fetch }) => fetch(...args));
const { welcomeMessage } = require('../whatappnotification');
const { welcomeMail } = require('../sendGridService');
const crypto = require('crypto');



const createUser = async (user) => {
    const { name, email } = user;
  
    // Check if the email already exists
    const existingUser = await knex('users').where({ email }).first();
  
    if (existingUser) {
      throw new Error('Email already exists');
    }
  
    // If not, insert the new user
    return await knex('users').insert({ name, email });
  };

const getSendemail = async () => {
  //const baseurl =  process.env.BUNNY_NET_IMAGE;
  sgMail.setApiKey(process.env.SENDGRID_API_KEY);


  const data = {
    storelink: 'https://snehal.com/store',
    store_name: 'Example Store',
    password: 'temporary-password',
    user_email: 'snehal.more@evonix.co'
  };
  
  // Read and render the EJS template


  // Read and render the EJS template
      fs.readFile('views/storecreation.ejs', 'utf8', (err, template) => {
        if (err) {
          console.error('Error reading template file:', err);
          return;
        }

        const message = ejs.render(template, data);

        // Define the email options
        const msg = {
          to: data.user_email,
          from: 'info@quickart.ae',
          subject: 'Welcome to Your New Store',
          html: message,
        };

        // Send the email
        sgMail
          .send(msg)
          
      });


};
const getUsers = async () => {
  return await knex('users').select('*');
};

const sendOtp  = async (userdata) => {

  user_id=userdata.user_id; 
  change_type=userdata.change_type;
  new_info=userdata.new_info;
   country_code = userdata.country_code; 
  dial_code = userdata.dial_code;
  let date_ob = new Date();
  
    // Generate a TOTP code using the secret key 
    // const code = speakeasy.totp({ 
    // secret: secret.base32, 
    // encoding: 'base32'
    // });

    // Ensure the code is 4 digits
    const code = Math.floor(1000 + Math.random() * 9000);
    // const code = 1234
  
  delete_data = await knex('tbl_mobile_email_update_info')
  .where('user_id',user_id)
  .where('change_type',change_type)
  .where('status','pending')
  .delete();

  user_details = await knex('users')
  .select('*')
  .where('id',user_id)
  .first();
  
  user_detail = await knex('users')
  .select('*')
  .where('email',new_info);

  if(change_type == 'email'){
   
    user_detail = await knex('users')
    .select('*')
    .where('email',new_info);
    
   if(user_detail.length == 0){
    //$this->otpupdateemail($otpval,$new_info);
  
    

    const insertId = await knex('tbl_mobile_email_update_info').insert({
      user_id: user_id,
      change_type: change_type,
      old_info: user_details.email,
      new_info: new_info,
      otp: code,
      status: 'pending',
      created_date: date_ob
    });
    data={'lastid':insertId[0],'otp':code};

    return data;

    }else
    {
     
      throw new Error('Email address already registerd');
    
    }
    
    
    }else{

      user_detail = await knex('users')
      .select('*')
      .where('user_phone',new_info)
      .where('country_code',country_code); 
      
      if(user_detail.length == 0){    
          //$this->otpupdatemobileno($otpval,$new_info); 
          
          const insertId = await knex('tbl_mobile_email_update_info').insert({
            user_id: user_id,
            change_type: change_type ,
            old_info: user_details.user_phone,
            new_info: new_info,
            otp: code,
            status: 'pending',
            created_date: date_ob
          }, 'id'); 

    
          data={'lastid':insertId[0],'otp':code};
          return data;
          
      }else
      {
        throw new Error('Mobile No already registerd');
      
      }




    }
 
  

}

const verifyOtpupdate = async (userdata) => {

  lastid=userdata.lastid;
  otp=userdata.otp;
  
    user_detail = await knex('tbl_mobile_email_update_info')
    .select('*')
    .where('id',lastid)
    .where('otp',otp)
    
    user_details = await knex('tbl_mobile_email_update_info')
    .select('*')
    .where('id',lastid)
    .first();
    
    if(user_detail.length == 0)
    {
      throw new Error('OTP is invalid.');
    
    } else {
        
    if(user_details.change_type == 'email'){    
        update_user = await knex('users')
        .where('id',user_details.user_id)
        .update({'email':user_details.new_info});
        
        update_status =  await knex('tbl_mobile_email_update_info')
        .where('id',lastid)
        .update({'status':'completed'});
        
        return 1
       // throw new Error('Email updated successfully');

    }else
    {
       // return 890
        update =  await knex('users')
        .where('id',user_details.user_id)
        .update({'user_phone':user_details.new_info});
        
        update_status = await knex('tbl_mobile_email_update_info')
        .where('id',lastid)
        .update({'status':'completed'});
        
     //   throw new Error('Mobile no updated successfully');
        return 2
    }
    
    } 


}

const userDeactivate = async (userdata) => {
  activate_deactivate_status =   userdata.activate_deactivate_status;
  deactivate_by = userdata.deactivate_by;
  user_id =  userdata.user_id;
  deactivate_datetime = new Date();

  return account_deactivate = await knex('users')
      .where('id', user_id)
      .update({activate_deactivate_status: activate_deactivate_status , deactivate_datetime:deactivate_datetime ,deactivate_by:deactivate_by});
}


const getUsersforLogin = async (userdata) => {
   const imageurl =  process.env.image_url;
  let user =  await knex('users').where('user_phone', userdata.user_phone)
  .where('country_code', userdata.country_code)
  .select('id','name','email','user_phone','dial_code','otp_value','status','wallet','rewards','is_verified','app_update','referral_code','noti_popup'
  ,'country_code','activate_deactivate_status','referral_amount','referral_return_amount',knex.raw(`CONCAT('${imageurl}', user_image) as user_image`))
  .first();

  // user.is_whatapp_msg_unable = true
  // user.is_terms_cond_unable = true

  return user;
};

const updateUser = async (id, updatedUser) => {
  return await knex('users').where({ id }).update(updatedUser);
};

const deleteUser = async (id) => {
  return await knex('users').where({ id }).del();
};

const bankDetails = async (appDetatils) => {
  user_id = appDetatils.user_id;
        users_acc_details =   await knex('tbl_user_bank_details')
        .select('*')
        .where('user_id', user_id)
        .where('is_delete','!=','1')
        .where('bank_type','totalpay')
      // return users_acc_details
        const usersdetails = [];
        for (let j = 0; j < users_acc_details.length; j++) 
        {
          const ProductList = users_acc_details[j];
          const first = ProductList.card_no.substr(0, 2)
          const end = ProductList.card_no.substr(-4)
          const customizedProduct={
            id: ProductList.id,
            user_id:ProductList.user_id,
            account_no:ProductList.card_no,
            first:ProductList.card_no.substr(0, 2),
            end :ProductList.card_no.substr(-4),
            card_no:first +"**********"+ end,
            si_sub_ref_no:ProductList.si_sub_ref_no,
            };

            usersdetails.push(customizedProduct); 

        }
       

  return usersdetails;


}

const register = async (userdata) => {
  const uuid=userdata.uuid;
  const existingUser = await knex('users')
  .where('user_phone', userdata.user_phone)
  .where('country_code', userdata.country_code)
  .where('is_verified',1)
  .first();

  const existingUserDevice = await knex('users')
  .where('uuid',uuid)
  .where('is_verified',0)
  .first();
  
  const UpdateUserPhoneNumber = await knex('users')
  .where('user_phone',userdata.user_phone)
  .where('is_verified',0)
  .update({'user_phone':''});

  const hash = crypto.createHash('md5').update(String(Date.now())).digest('hex');
  const hashSubstring = hash.substring(0, 2); // Adjust substring length as needed
  const referralCode = generateRandomLetters(6) + generateRandomDigits(2) + hashSubstring;
  let userId;
  var code = Math.floor(1000 + Math.random() * 9000);
  
  if (existingUser) {
    //return existingUser.is_verified
    if(existingUser.is_verified == 1){
      throw new Error('Registered');
    }
    else if(existingUser.activate_deactivate_status === 'deactivate')
    {
      throw new Error('deactivate');
    }else{
      throw new Error('Already exist');
    }
  }else{
      
     // const hash = bcrypt.hashSync(userdata.password, 10);
      let date_ob = new Date();
      const secret = speakeasy.generateSecret({ length: 20 }); 
                
     // Generate a TOTP code using the secret key 
     // const code = speakeasy.totp({ 
     //     secret: secret.base32, 
     //     encoding: 'base32'
     // });
        // Ensure the code is 4 digits
        //code = code.slice(0, 4);
      
        if(existingUserDevice && uuid){
 
          let date_ob = new Date();
           const secret = speakeasy.generateSecret({ length: 20 }); 
                    
          // Generate a TOTP code using the secret key 
          // const code = speakeasy.totp({ 
          //     secret: secret.base32, 
          //     encoding: 'base32'
          // });
             // Ensure the code is 4 digits
          //  const code = 1234
            update_app_open =  await knex('users')
            .where('id',existingUserDevice.id)
            .update({
            "email": userdata.user_email,
            "user_phone": userdata.user_phone,
            "country_code": userdata.country_code,
            "name": userdata.name,
            "referral_code": referralCode,
            "is_terms_cond_unable": userdata.is_terms_cond_unable,
            "is_whatapp_msg_unable" :userdata.is_whatapp_msg_unable,
            "reg_date": date_ob,
            "dial_code":userdata.dial_code,
            "otp_value": code,
            "actual_device_id":userdata.actual_device_id,
            "device_id":userdata.device_id
            }); 

            userId = existingUserDevice.id;
                    
        }else
        {


      
      const user = await knex('users').insert({
       user_phone: userdata.user_phone,
       email: userdata.user_email,
       country_code: userdata.country_code,
       name: userdata.name,
       referral_code: referralCode,
       is_terms_cond_unable: userdata.is_terms_cond_unable,
       is_whatapp_msg_unable :userdata.is_whatapp_msg_unable,
       reg_date: date_ob,
       dial_code:userdata.dial_code,
       otp_value:code,
       actual_device_id:userdata.actual_device_id,
       device_id:userdata.device_id,
       uuid: knex.raw('UUID()'),
     })
      
      userId = user[0];
     await knex('notificationby').insert({
      user_id : userId,
      sms : 1,
      app : 1,
      email : 1
    });
   }

    if(userdata.referral_code){
        const UserDetails = await knex('users')
        .where('referral_code',userdata.referral_code)
        .first();  
        
        const insertReferral = await knex('tbl_referral')
        .insert({
        user_id: userId,
        referral_by: UserDetails.id,
        referral_code:userdata.referral_code,
        referral_amount:UserDetails.referral_amount,
        created_at:new Date()
        });
        const UpdateUser = await knex('users')
        .where('id', userId)
        .update({'wallet':UserDetails.referral_amount});
        
        await knex('wallet_history').insert({
        user_id: userId,
        amount: UserDetails.referral_amount,
        resource: 'referral',
        type:'Add',
        group_id:"",
        cart_id:""
        });
    
    }




  }
  
  const phone_with_country_code=`${userdata.country_code}${userdata.user_phone}`;   
  const getUserup = await knex('users').where('user_phone', userdata.user_phone).where('country_code', userdata.country_code).update({otp_value: code });
  const url = 'https://apisocial.telebu.com/whatsapp-api/v1.0/customer/96345/bot/6748075e65d94186/template';
  const headers = {
    'Authorization': 'Basic 1072eb29-af12-4a65-ab5b-a5a8bfb9ff09-HwOnAFh',
    'Content-Type': 'application/json'
  };

  const data = {
    payload: {
      name: "otp13aug",
      language: {
        code: "en"
      },
      components: [
        {
          type: "body",
          parameters: [
            {
              type: "text",
              text:code
            }
          ]
        },
        {
          type: "button",
          sub_type: "url",
          index: "0",
          parameters: [
            {
              type: "text",
              text: "CopyOTP"
            }
          ]
        }
      ]
    },
    phoneNumber:phone_with_country_code
  };
  try {
    const response = await fetch(url, {
      method: 'POST',
      headers: headers,
      body: JSON.stringify(data)
    });
    const responseData = await response.json();
    // console.log('Response:', responseData);
    // return responseData
  } catch (error) {
    // console.error('Error:', error.message);
    // return error.message;
  }
 
};

const findUser = async (userdata) => {
 const existingUser = await knex('users').where('user_phone', userdata.user_phone).where('country_code', userdata.country_code).first();
 //const existingUser = await knex('users').where('user_phone', userdata.user_phone).first();
 if(existingUser){
      
        if(userdata.user_phone == '541234567'){
        var code = 1234;
        }else
        {
        var code = Math.floor(1000 + Math.random() * 9000);
        }

        if (existingUser.is_verified == 1) {
        if(existingUser.activate_deactivate_status === 'deactivate'){
        throw new Error('deactivate');
        }else{
        const secret = speakeasy.generateSecret({ length: 20 }); 
          
            // Generate a TOTP code using the secret key 
            // const code = speakeasy.totp({ 
            //     secret: secret.base32, 
            //     encoding: 'base32'
            // });
              // Ensure the code is 4 digits
            
            // const code = 1234
        //await knex('users').where('user_phone', userdata.user_phone).update({device_id: userdata.device_id});
         await knex('users').where('user_phone', userdata.user_phone)
        .where('country_code', userdata.country_code)
        .update({otp_value: code});
        }
        }else{
        if(existingUser.is_verified == 0){
        const secret = speakeasy.generateSecret({ length: 20 }); 
          
        // Generate a TOTP code using the secret key 
        // const code = speakeasy.totp({ 
        //     secret: secret.base32, 
        //     encoding: 'base32'
        // });
        // Ensure the code is 4 digits

        // const code = 1234
        const updatevalue = await knex('users').where('user_phone', userdata.user_phone).where('country_code', userdata.country_code)
        .update({otp_value: code});
        }
        }

        const phone_with_country_code=`${userdata.country_code}${userdata.user_phone}`;   
        const getUserup = await knex('users').where('user_phone', userdata.user_phone).where('country_code', userdata.country_code).update({otp_value: code });
        const url = 'https://apisocial.telebu.com/whatsapp-api/v1.0/customer/96345/bot/6748075e65d94186/template';
        const headers = {
          'Authorization': 'Basic 1072eb29-af12-4a65-ab5b-a5a8bfb9ff09-HwOnAFh',
          'Content-Type': 'application/json'
        };
      
        const data = {
          payload: {
            name: "otp13aug",
            language: {
              code: "en"
            },
            components: [
              {
                type: "body",
                parameters: [
                  {
                    type: "text",
                    text:code
                  }
                ]
              },
              {
                type: "button",
                sub_type: "url",
                index: "0",
                parameters: [
                  {
                    type: "text",
                    text: "CopyOTP"
                  }
                ]
              }
            ]
          },
          phoneNumber:phone_with_country_code
        };
        try {
          const response = await fetch(url, {
            method: 'POST',
            headers: headers,
            body: JSON.stringify(data)
          });
          const responseData = await response.json();
          // console.log('Response:', responseData);
          // return responseData
        } catch (error) {
          // console.error('Error:', error.message);
          // return error.message;
        }
        return await knex('users').where('user_phone', userdata.user_phone).where('country_code', userdata.country_code).first();

  }
  else{
     await knex('users').where('user_phone', userdata.user_phone).where('country_code', userdata.country_code).where('is_verified', 0).del();
     let date_ob = new Date();

    
//      const [userId] =   await knex('users').insert({
//       user_phone: userdata.user_phone,
//       country_code:userdata.country_code,
//       name: "User",
//       is_verified: 0,
//       reg_date: date_ob,
//       dial_code:userdata.dial_code,
//       user_type: "guest"
//      })
//      .returning('id');

//   await knex('notificationby').insert({
//           user_id : userId,
//           sms : 1,
//           app : 1,
//           email : 1
//       });
   throw new Error('Register');


  }

}

const verifyOtp  = async (userdata) => {
  const uuid=userdata.uuid;
  const existingUser = await knex('users').where('user_phone', userdata.user_phone).where('country_code', userdata.country_code).first();
  if(existingUser){
    
    if(existingUser.otp_value == userdata.otp){
    if(existingUser.is_verified != 1)
    {
    const phone_with_country_code=`${existingUser.country_code}${userdata.user_phone}`;  
    const whatappmessage=await welcomeMessage(phone_with_country_code);
        // Email Send Welcome 
        const logo = await knex('tbl_web_setting').first();
        const app_name = logo ? logo.name : null;
        // Fetching the first record from the 'currency' table
        const currency = await knex('currency').first();
        const currency_sign = currency ? currency.currency_sign : null;
        const templateData = {
        baseurl: process.env.base_url,
        user_name: existingUser.name,
        user_email: existingUser.email,
        app_name:app_name,
        currency_sign:currency_sign,
        //totalcal:totalcal
        };
        const subject = 'Welcome to QuicKart'
        // Trigger the email after order is placed
        abcd = await welcomeMail(existingUser.email, templateData,subject);
        const referralCodeDetails = await knex('tbl_referral').where('user_id', existingUser.id).first();
        if(referralCodeDetails){
        if(referralCodeDetails.referral_code == 'QKFIVE')
        {
          const url = 'https://apisocial.telebu.com/whatsapp-api/v1.0/customer/96345/bot/6748075e65d94186/template';
          const headers = {
          'Authorization': 'Basic 1072eb29-af12-4a65-ab5b-a5a8bfb9ff09-HwOnAFh',
          'Content-Type': 'application/json'
          };
          const data = {
            payload: {
              name: 'referral',
              components: [],
              language: {
                code: 'en_US',
                policy: 'deterministic'
              },
              namespace: 'a95f9847_fb73_48ca_bed5_b5c5b3fbc1bc'
            },
            phoneNumber: phone_with_country_code // Pass the receiver's phone number
          };

          try {
          const response = await fetch(url, {
          method: 'POST',
          headers: headers,
          body: JSON.stringify(data)
          });

          const responseData = await response.json();
          // console.log('Response:', responseData);
          // return responseData
          } catch (error) {
          // console.error('Error:', error.message);
          // return error.message;
          }

        }
      }

    }
    await knex('users').where('user_phone', userdata.user_phone).update({is_verified:1});
    
    var addressDetails =""; 
    var userBankDetails = ""; 
    var ordersDetails="";
    var subscriptionOrderDetails="";
    const userDetails = await knex('users').where('uuid',uuid).first(); 
    if(userDetails){
    addressDetails = await knex('address').where('user_id',userDetails.id).first(); 
    userBankDetails = await knex('tbl_user_bank_details').where('user_id',userDetails.id).first(); 
    ordersDetails = await knex('orders').where('user_id',userDetails.id).first();
    subscriptionOrderDetails = await knex('subscription_order').where('order_status','Pending').where('user_id',userDetails.id).first();
    }
    
    const addressDetail=(addressDetails)?'true':'false';
    const userBankDetail=(userBankDetails)?'true':'false';
    const ordersDetail=(ordersDetails)?'true':'false';
    const subscriptionOrderDetail=(subscriptionOrderDetails)?'true':'false';
    const ErrorMessage=(subscriptionOrderDetail == 'true') ? "Click Yes to transfer the guest data to your account":"Would you like to transfer the guest data to your account? Click Yes to transfer, or No to decline. Guest data will not be accessible to you once you click No";
    const customizedProduct = {
    appuserid: (userDetails) ? userDetails.id :"",
    appuuid: userdata.uuid, 
    serveruserid: existingUser.id,
    serveruuid: existingUser.uuid,  
    addressdetail:addressDetail,
    userbankdetail:userBankDetail,
    ordersdetail:ordersDetail,
    subscriptionOrderDetail:subscriptionOrderDetail,
    message:ErrorMessage
    };
    return customizedProduct;
    }else{
      throw new Error('Wrong OTP');
    }
  }else{
    throw new Error('User not registered');
  }
};

const resendOtp  = async (userdata) => {
  //return userdata
 const user_phone = userdata.user_phone
 const country_code = userdata.country_code
 const isotptype = userdata.isotptype
 const firebase = await knex('firebase').first();
 const smsby = await knex('smsby').first();
               
 const existingUser = await knex('users').where('user_phone', user_phone).where('country_code', userdata.country_code).first();
 if(existingUser){
  
  const secret = speakeasy.generateSecret({ length: 20 }); 
  var otp = Math.floor(1000 + Math.random() * 9000);

  const phone_with_country_code=`${country_code}${user_phone}`;   
  const getUserup = await knex('users').where('user_phone', userdata.user_phone).where('country_code', userdata.country_code).update({otp_value: otp });
  const url = 'https://apisocial.telebu.com/whatsapp-api/v1.0/customer/96345/bot/6748075e65d94186/template';
  const headers = {
    'Authorization': 'Basic 1072eb29-af12-4a65-ab5b-a5a8bfb9ff09-HwOnAFh',
    'Content-Type': 'application/json'
  };

  const data = {
    payload: {
      name: "otp13aug",
      language: {
        code: "en"
      },
      components: [
        {
          type: "body",
          parameters: [
            {
              type: "text",
              text:otp
            }
          ]
        },
        {
          type: "button",
          sub_type: "url",
          index: "0",
          parameters: [
            {
              type: "text",
              text: "CopyOTP"
            }
          ]
        }
      ]
    },
    phoneNumber:phone_with_country_code
  };

  try {
    const response = await fetch(url, {
      method: 'POST',
      headers: headers,
      body: JSON.stringify(data)
    });

    const responseData = await response.json();
    // console.log('Response:', responseData);
    // return responseData
  } catch (error) {
    // console.error('Error:', error.message);
    // return error.message;
  }


  if(firebase.status == 1){
    //return 444
     const getUserup  = await knex('users').where('user_phone', userdata.user_phone).where('country_code', userdata.country_code).update({otp_value: NULL });
    return getUserup            
  }
  else if(smsby.status == 1){
    //return 456
      const getUserup = await knex('users').where('user_phone', userdata.user_phone).where('country_code', userdata.country_code).update({otp_value: otp });
      return getUserup  
  }else{
    // throw new Error('Otp Off');
  }

 } else{
  throw new Error('User not found');
 }
}
const editprofile = async (appDetatils) => {
  const user_id = appDetatils.user_id
  const user_name = appDetatils.user_name
  const user_city = appDetatils.user_city
  const user_area = appDetatils.user_area
  const user_email = appDetatils.user_email
  const user_phone = appDetatils.user_phone
  const user_image = appDetatils.user_image
  const device_id = appDetatils.device_id
  const uu = await knex('users')
    	    .where('id', user_id)
    	    .first();
    if($uu.user_phone == "9999999999"){
      throw new Error('You can not change the details for demo account');
    }

}

const myprofile = async (appDetatils) => {
  const user_id = appDetatils.user_id
  const user = await knex('users')
  .join('city','users.user_city','=','city.city_id')
  .join('society','users.user_area','=','society.society_id')
  .select('users.*','city.city_name','society.society_name')
  .where('users.id', user_id )
  .first();
  const order= await knex('orders')
  .join('store','orders.store_id','=','store.id')
  .join('users','orders.user_id','=','users.id')
  .join('address','orders.address_id','=','address.address_id')
  .where('orders.user_id',user_id)
  .whereNotNull('orders.order_status')
  .whereNotNull('orders.payment_method')
  .count();  
  const orderspent= await knex('orders')
  .where('order_status','!=','Cancelled')
  .whereNotNull('orders.order_status')
  .whereNotNull('orders.payment_method')
  .where('payment_method','!=','COD')
  .where('payment_method','!=','cod')
  .where('user_id', $user_id ) 
  .sum('total_price');   
  const ordersaved=await knex('orders')
  .select(knex.raw('SUM(total_products_mrp)- SUM(price_without_delivery)+SUM(coupon_discount) as overalldiscount'))
  .where('order_status','!=','Cancelled')
  .where('order_status','!=',NULL)
  .where('payment_method','!=',NULL)
  .where('payment_method','!=','COD')
  .where('payment_method','!=','cod')
  .where('user_id', user_id ) 
  .first();  
  return 123;
  if(user){
    return ordersaved;
  }
}

const createImage = async (imageData) => {
 // return 777;

  user_id = imageData.user_id
  user_phone = imageData.user_phone
  country_code = imageData.country_code
  device_id = imageData.device_id
  user_name = imageData.user_name
  image =  imageData.path
  
  
  const uu = await knex('users')
  .where('id', user_id)
  .first();
 
  if(image){
    filePath = image;
  }
    else{
      filePath = uu.user_image;
  }
 
  if(uu.user_phone == "9999999999"){
    throw new Error('You can not change the details for demo account');
  }else{

    checkUser = await knex('users')
    .where('user_phone', user_phone)
    .where('country_code', country_code)
    .where('id','!=', user_id)
    .first();
    
    // if(checkUser && checkUser.is_verified==1){
    
    //   throw new Error('not avilable');
    // }else{
      
      await knex('users')
      .where('user_phone', user_phone)
      .where('country_code', country_code)
      .update({user_image:filePath});
     
     const imgurl =  process.env.image_url;
      user =  await knex('users')
      .where('id', user_id)
      .select('*',knex.raw(`CONCAT('${imgurl}', user_image) as user_image`),)
      .first();
      return user
    //}

  }

 // return knex('images').insert(imageData).returning('*');
};


const getFaqsList = async (userdata) => {
  const imageurl =  process.env.image_url;
 let faqslist =  await knex('tbl_faqs')
 .select('id','question','answer');
 return faqslist;
};

// Generate random letters, digits, and hash substring
const generateRandomLetters = (length) => {
  const chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
  let result = "";
  for (let i = 0; i < length; i++) {
      result += chars.charAt(Math.floor(Math.random() * chars.length));
  }
  return result;
};

const generateRandomDigits = (length) => {
  const chars = "0123456789";
  let result = "";
  for (let i = 0; i < length; i++) {
      result += chars.charAt(Math.floor(Math.random() * chars.length));
  }
  return result;
};

const getShowProfile = async (userdata) => {
  const user_id =  userdata.user_id;
  let userlist = await knex('users')
  .select('*')
  .select(knex.raw(`CONCAT('https://quickart.b-cdn.net/', user_image) AS user_image`)) // Concatenate URL in the query
  .where('id', user_id)
  .first();
 return userlist;
};

const verifyDetails = async (appDetails) => {
  const { transfertype,appuuid,serveruuid,appuserid,serveruserid} = appDetails;
  
  // Helper function for conditional updates
  const updateUserReferences = async (oldUserId, newUserId) => {
    return Promise.all([
      knex('tbl_user_bank_details').where('user_id', oldUserId).update({ "user_id": newUserId }),
      knex('orders').where('user_id', oldUserId).update({ "user_id": newUserId }),
      knex('store_orders').where('store_approval', oldUserId).update({ "store_approval": newUserId }),
      knex('subscription_order').where('user_id', oldUserId).update({ "user_id": newUserId }),
      knex('address').where('user_id', oldUserId).update({ "user_id": newUserId,"type": "Others"})
    ]);
  };

  // Verify UUIDs and transfer type
  if (appuuid === serveruuid) {
    if (transfertype === 'no') {
    const userDetails = await knex('users').where('uuid',appuuid).first(); 
      // Insert new user with generated UUID
      const [userId] = await knex('users')
        .insert({
          uuid: knex.raw('UUID()'),
          user_phone: userDetails.user_phone,
          email: userDetails.email,
          country_code: userDetails.country_code,
          name: userDetails.name,
          referral_code: userDetails.referral_code,
          is_terms_cond_unable: userDetails.is_terms_cond_unable,
          is_whatapp_msg_unable: userDetails.is_whatapp_msg_unable,
          reg_date: userDetails.reg_date,
          dial_code: userDetails.dial_code,
          otp_value: userDetails.otp_value,
          actual_device_id: userDetails.actual_device_id,
          device_id: userDetails.device_id
        })
        .returning('id');
      
      // Update the existing user's status
      await knex('users')
        .where('id', appuserid)
        .update({
          "name":null,
          "is_verified": 0,
          "user_phone": null,
          "email": null,
          "referral_code":null
        });
      const userDetail = await knex('users').where('id',userId).first(); 
      return { user_id: userId, uuid: userDetail.uuid };

    } else {
      return { user_id: serveruserid, uuid: serveruuid };
    }

  } else {
    if (transfertype == 'yes') {
      // Update references if transfertype is 'yes'
      await updateUserReferences(appuserid, serveruserid);
    }
    return { user_id: serveruserid, uuid: serveruuid };
  }
};


module.exports = {
createUser,
getUsers,
updateUser,
deleteUser,
findUser,
getUsersforLogin,
verifyOtp,
register,
myprofile,
resendOtp,
editprofile,
userDeactivate,
bankDetails,
createImage,
sendOtp,
verifyOtpupdate,
getSendemail,
getFaqsList,
getShowProfile,
verifyDetails
};
