const { application } = require('express');
const knex = require('../db'); // Import your Knex instance
const math = require('mathjs');  // If using a third-party math library

const addtoWishlist = async(appDetatils) => {
 
  const varient_id = appDetatils.varient_id
  const store_id = appDetatils.store_id
  //const user_id = appDetatils.user_id
  
    if(appDetatils.user_id != "null" ){
      user_id = appDetatils.user_id
  }else{
      user_id = appDetatils.device_id
  }

  let date_ob = new Date();
  
  let p = await knex('store_products')
  .join('product_varient','store_products.varient_id','=','product_varient.varient_id')
 .join('product','product_varient.product_id','=','product.product_id')
.leftJoin('deal_product','product_varient.varient_id','=','deal_product.varient_id')
.where('store_products.varient_id',varient_id)
.where('store_products.store_id',store_id)
.first();




if(p.deal_price != null &&  p.valid_from < date_ob && p.valid_to > date_ob){

    price= p.deal_price;    
}else{
    price = p.price;
} 


mrpprice = p.mrp;
price2= price;
price5= mrpprice;

var_image = p.product_image;
n =p.product_name;



  const check = await knex('wishlist')
              .where('varient_id',varient_id)
              .where('user_id', user_id)
              .where('store_id', store_id)
              .first();
              
  
     
  if(check){
    //remove from wishlist
    const del = await knex('wishlist')
            .where('varient_id',varient_id)
            .where('user_id', user_id)
            .where('store_id', store_id)
            .delete();
            
         if(del){
          count =await knex('wishlist')
             .where('user_id', user_id)
             .where('store_id', store_id)
              .count();
       
   
        }

        return 'Removed from Wishlist'

  }else{
    //insert to wishlist

    const addwishlist = await knex('wishlist').insert({
              store_id: store_id,
              varient_id: varient_id,
              product_name: n,
              varient_image: var_image,
              quantity: p.quantity,
              unit: p.unit,
              mrp: price5,
              description:p.description,
              user_id: user_id,
              created_at:date_ob,
              updated_at:date_ob,
              price:price2
            })
    
    return 'Added to Wishlist'

  }

}


const getWishlist = async(appDetatils) => {
    //const is_subscription = appDetatils.is_subscription
    const store_id = appDetatils.store_id
    //const user_id = appDetatils.user_id
        
      if(appDetatils.user_id != "null" ){
          user_id = appDetatils.user_id
      }else{
          user_id = appDetatils.device_id
      }
    if(appDetatils.min_rating){
        const min_rating = appDetatils.min_rating
    }else{
        const min_rating = 0;
    }

    if(appDetatils.max_rating){
        const max_rating = appDetatils.max_rating
    }else{
        const max_rating = 5;
    }
   
    if(appDetatils.min_price){
        const min_price = appDetatils.min_price
    }else{
        const min_price = 0
    }
    
       // const prod = await knex('store_products')
   const price1 = await knex('wishlist')
   .join('store_products','wishlist.varient_id','=', 'store_products.varient_id')
      .join('product_varient','store_products.varient_id','=','product_varient.varient_id')
    .join('product','product_varient.product_id','=','product.product_id')
   .select('store_products.price')
    .where('wishlist.user_id',user_id)
    .where('wishlist.store_id', store_id)
   // .where('product.is_subscription',is_subscription)
    .where('product.approved',1)
    .orderBy('store_products.price','desc')
    .first()
   price = price1.price;

    if(appDetatils.max_price){
        const max_price = appDetatils.max_price
    }else{
        const max_price = price
    }
    
    let prodsssss = await knex('wishlist')
    .join('store_products','wishlist.varient_id','=', 'store_products.varient_id')
       .join('product_varient','store_products.varient_id','=','product_varient.varient_id')
     .join('product','product_varient.product_id','=','product.product_id')
     .leftJoin('tbl_country', 'tbl_country.id', '=', 'product.country_id')
     //.Leftjoin('product_rating', 'store_products.varient_id', '=', 'product_rating.varient_id')
     .select( 'product.percentage', 'product.availability','tbl_country.country_icon','store_products.store_id','store_products.stock','store_products.varient_id','product.product_id','product.product_name', 'product.product_image','product.thumbnail','product_varient.description', 'store_products.price', 'store_products.mrp', 'product_varient.varient_image','product_varient.unit','product_varient.quantity','product.type', knex.raw('100-((store_products.price*100)/store_products.mrp) as discountper'))
   .groupBy('store_products.store_id','store_products.stock','store_products.varient_id','product.product_id','product.product_name', 'product.product_image', 'product_varient.description', 'store_products.price', 'store_products.mrp', 'product_varient.varient_image','product_varient.unit','product_varient.quantity','product.type')
     .where('wishlist.user_id',user_id)
     .where('wishlist.store_id', store_id)
     //.where('product.is_subscription',is_subscription)
     .where('product.approved',1)
   
     const customizedProductData = [];
     for (let i = 0; i < prodsssss.length; i++) {
      
        const ProductList = prodsssss[i];
        const currentDate = new Date();
        const deal = await knex('deal_product')
        .where('varient_id', ProductList.varient_id)
        .where('store_id', store_id)
        .where('deal_product.valid_from', '<=', currentDate)
        .where('deal_product.valid_to', '>', currentDate)
        .first();
      
        
        if (deal) {
          price = deal.deal_price;
        } else {
        const sp = await knex('store_products')
        .where('varient_id', ProductList.varient_id)
        .where('store_id', store_id)
        .first();
        price = sp.price;
        }
       // return 234;
        if(user_id){ 
          // Wishlist check 
           var isFavourite='';
          var notifyMe='';
          var cartQty=0;
           const wishList = await knex('wishlist')
          .select('*')
          .where('varient_id',ProductList.varient_id)
          .where('user_id',appDetatils.user_id);
  
          isFavourite = wishList.length > 0 ? 'true' : 'false';
   
          // cart qty check 
          const CartQtyList = await knex('store_orders')
          .where('varient_id',ProductList.varient_id)
          .where('store_approval',appDetatils.user_id)
          .where('order_cart_id','incart')
          .where('store_id',appDetatils.store_id)
          .first();
          cartQty = CartQtyList ? CartQtyList.qty : 0;
          
  
          const cnotify_me = await knex('product_notify_me')
          .where('varient_id', ProductList.varient_id)
          .where('user_id', appDetatils.user_id);
          notifyMe = cnotify_me.length > 0 ? 'true' : 'false';

          const subprod = await knex('store_orders')
          .select('store_orders.percentage')
          .where('store_orders.varient_id',ProductList.varient_id)
          .where('store_approval',user_id)
          .where('store_orders.subscription_flag',1)
          .where('store_orders.order_cart_id', "incart")
          .first();
  
          if(subprod){
            isSubscription = 'true'
          }else{
            isSubscription = 'false'
            
          }
  
  
          }else{
            notifyMe='false';
            isFavourite='false';
            cartQty=0;
             isSubscription = 'false'
          }

          const sub_price = (ProductList.mrp * ProductList.percentage) / 100;
          const finalsubprice =  ProductList.mrp - sub_price;
          const subscription_price = parseFloat(finalsubprice.toFixed(2));
          
 
          const baseurl =  process.env.BUNNY_NET_IMAGE;
          
            if(ProductList.country_icon == null){
              countryicon = null
           }else{
              countryicon =  baseurl + ProductList.country_icon
           }
 
          if (Number.isInteger(price)) {
          priceval = price + '.001'
          }else{
          priceval = price
          }
          if (Number.isInteger(ProductList.mrp)) {
          mrpval = ProductList.mrp + '.001'
          }else{
          mrpval = ProductList.mrp
          }

          const customizedProduct = {
            stock: ProductList.stock,        
            varient_id: ProductList.varient_id,
            product_id: ProductList.product_id,
            product_name: ProductList.product_name,
            product_image: baseurl + ProductList.product_image+"?width=200&height=200&quality=100",
            thumbnail: baseurl + ProductList.thumbnail,
            description:ProductList.description,
            price: parseFloat(priceval),
            mrp: parseFloat(mrpval),
            unit: ProductList.unit,
            quantity: ProductList.quantity,
            type: ProductList.type,
           // discountper: ProductList.discountper,
            discountper:0,
            avgrating:0,
            notify_me: notifyMe,
            isFavourite: isFavourite,
            cart_qty: cartQty,
            countrating:0,
            percentage: ProductList.percentage,
            isSubscription:isSubscription,
            subscription_price:subscription_price,
             availability:ProductList.availability,
            country_icon : countryicon,  
            varients:null
            // Add or modify properties as needed
            };
        
          customizedProductData.push(customizedProduct);  
     }
     //prod.varient =  customizedProductData;
 
     //return prod;
     return customizedProductData;

}

module.exports = {
    getWishlist,
    addtoWishlist
    };