// routes/users.js
const express = require('express');
const router = express.Router();
const userController = require('../controllers/userController');
const categoryController = require('../controllers/categoryController');
const orderController = require('../controllers/orderController');
const productlistController = require('../controllers/productlistController');
const wishlistController = require('../controllers/wishlistController');
const cartController = require('../controllers/cartController');
const searchController = require('../controllers/searchController');
const walletController = require('../controllers/walletController');
const addressController =  require('../controllers/addressController');
const timeslotController =  require('../controllers/timeslotController');
const sneakyController =  require('../controllers/sneakyController');
const checkoutController =  require('../controllers/checkoutController');
const notificationController =  require('../controllers/notificationController');
const couponController =  require('../controllers/couponController');
const paymentController =  require('../controllers/paymentController');
const guestController =  require('../controllers/guestController');
const cardController =  require('../controllers/cardController');
const notifymeController =  require('../controllers/notifymeController');
const trailpackController =  require('../controllers/trailpackController');
const ratingController =  require('../controllers/ratingController');






router.post('/nodejsapp/api/users/', userController.createUser);
router.get('/nodejsapp/api/users/', userController.getUsers);
router.put('/nodejsapp/api/users/:id', userController.updateUser);
router.delete('/nodejsapp/api/users/:id', userController.deleteUser);
//router.get('/nodejsapp/api/users/city', userController.getCity);

//Login API
router.post('/nodejsapp/api/login/', userController.login);
router.post('/nodejsapp/api/verify_otp/', userController.verify_otp);
router.post('/nodejsapp/api/resend_otp/', userController.resend_otp);
router.post('/nodejsapp/api/register_details/', userController.register_details);
router.post('/nodejsapp/api/user_deactivate/', userController.user_deactivate);
router.post('/nodejsapp/api/user_bank_details/', userController.user_bank_details);
router.post('/nodejsapp/api/send_otp/', userController.send_otp);
router.post('/nodejsapp/api/verify_otp_update/', userController.verify_otp_update);
router.post('/nodejsapp/api/verify_details/', userController.verify_details);



//user profile

router.post('/nodejsapp/api/myprofile/', userController.myprofile);
router.post('/nodejsapp/api/profile_edit/', userController.profile_edit);
router.post('/nodejsapp/api/faqslist/', userController.faqslist);
router.post('/nodejsapp/api/show_profile', userController.showprofile);

//App Home page API
router.post('/nodejsapp/api/oneapi/', categoryController.oneapi);
router.post('/nodejsapp/api/app_info/', categoryController.appinfo);
router.post('/nodejsapp/api/updateproductdetails/', categoryController.updateproductdetails);


//Catee API
router.post('/nodejsapp/api/catee/', categoryController.catee);
router.post('/nodejsapp/api/subcatee/', categoryController.subcatee);
router.post('/nodejsapp/api/cat_product/', categoryController.cat_product);
router.get('/nodejsapp/api/brand_list/', categoryController.brand_list);
router.get('/nodejsapp/api/appaboutus/', categoryController.aboutus);
router.get('/nodejsapp/api/appterms/', categoryController.terms);


//My Orders API
router.post('/nodejsapp/api/my_orders/', orderController.my_orders);
router.post('/nodejsapp/api/my_dailyorders/', orderController.my_dailyorders);
router.post('/nodejsapp/api/repeat_orders/', orderController.repeat_orders);
router.post('/nodejsapp/api/my_orders_subscription/', orderController.ongoing_sub);
router.post('/nodejsapp/api/orders_subscription_product/', orderController.product_ongoing_sub);
router.post('/nodejsapp/api/my_orders_sub/', orderController.my_orders_sub)
router.get('/nodejsapp/api/cancelorderreason/', orderController.cancelorderreason)
router.post('/nodejsapp/api/my_subscription_pause_order/', orderController.my_subscription_pause_order)
router.post('/nodejsapp/api/my_subscription_resume_order/', orderController.my_subscription_resume_order)
router.post('/nodejsapp/api/place_repeated_order/', orderController.place_repeated_order)
router.post('/nodejsapp/api/can_orders/', orderController.can_orders)
router.post('/nodejsapp/api/cancelledproductorder/', orderController.cancelledproductorder)
router.post('/nodejsapp/api/cancelledquickorder/', orderController.cancelledquickorder)
router.post('/nodejsapp/api/cancelledquickorderprod/', orderController.cancelledquickorderprod)
router.post('/nodejsapp/api/quick_place_repeated_order/', orderController.quick_place_repeated_order)
router.post('/nodejsapp/api/my_orders_subscription_list/', orderController.ongoing_sub_list);


//Orders Details API
router.post('/nodejsapp/api/orders_details/', orderController.orders_details);
router.get('/nodejsapp/api/total_deliveries/', orderController.total_deliveries)
router.post('/nodejsapp/api/groupwise_order/', orderController.groupwise_order);

//Product Listing API
router.post('/nodejsapp/api/product_det/', categoryController.product_det);
router.post('/nodejsapp/api/top_selling/', productlistController.top_selling);
router.post('/nodejsapp/api/whatsnew/', productlistController.whatsnew);
router.post('/nodejsapp/api/recentselling/', productlistController.recentselling);
router.post('/nodejsapp/api/dealproduct/', productlistController.dealproduct);
router.post('/nodejsapp/api/additionalcat_search/', productlistController.additionalcat_search);
router.post('/nodejsapp/api/occasionalcat_search/', productlistController.occasionalcat_search);


//wishlist
router.post('/nodejsapp/api/show_wishlist/', wishlistController.show_wishlist);
router.post('/nodejsapp/api/add_rem_wishlist/', wishlistController.add_rem_wishlist);

//wallet
router.post('/nodejsapp/api/wallet_recharge_history/', walletController.walletrechargehistory);
router.post('/nodejsapp/api/wallet_recharge/', walletController.walletrecharge);
router.post('/nodejsapp/api/order_card_changes/', walletController.order_card_changes);

//cart
router.post('/nodejsapp/api/add_to_cart/', cartController.add_to_cart);
router.post('/nodejsapp/api/show_cart/', cartController.show_cart);

//subcart
router.post('/nodejsapp/api/add_to_subcart/', cartController.add_to_subcart);
router.post('/nodejsapp/api/showsub_cart/', cartController.showsub_cart);
router.post('/nodejsapp/api/show_spcatcart/', cartController.show_spcatcart);


//search 
router.post('/nodejsapp/api/universal_search/', searchController.universal_search);
router.post('/nodejsapp/api/searchbystore/', searchController.searchbystore);
router.post('/nodejsapp/api/searchbystoreproduct/', searchController.searchbystore);
router.post('/nodejsapp/api/recent_search/', searchController.recentSearch);
router.post('/nodejsapp/api/trensearchproducts/', searchController.trensearchproducts);
router.post('/nodejsapp/api/searchbybanner/', searchController.searchbybanner);
router.post('/nodejsapp/api/searchbybrands/', searchController.searchbybrands);

//address
router.post('/nodejsapp/api/add_address/', addressController.add_address);
router.post('/nodejsapp/api/show_address/', addressController.show_address);
router.post('/nodejsapp/api/remove_address/', addressController.remove_address);
router.post('/nodejsapp/api/edit_address/', addressController.edit_add);
router.get('/nodejsapp/api/city/', addressController.city);
router.post('/nodejsapp/api/society/', addressController.society);

//timeslot
router.post('/nodejsapp/api/timeslot/', timeslotController.timeslot);
router.post('/nodejsapp/api/quickord_timeslot/', timeslotController.quickord_timeslot);
router.post('/nodejsapp/api/resumeord_timeslot/', timeslotController.resumeord_timeslot);
router.post('/nodejsapp/api/upquickorder_timeslot/', timeslotController.upquickorder_timeslot);


//sneakycontroller
router.post('/nodejsapp/api/sneaky_productlist/', sneakyController.sneaky_productlist);

//notification
router.post('/nodejsapp/api/notificationlist/', notificationController.notificationlist);
router.post('/nodejsapp/api/paymentnotification/', notificationController.paymentnotification);
// router.post('/nodejsapp/api/success/', notificationController.success);
router.get('/nodejsapp/api/success/', notificationController.success);
router.post('/nodejsapp/api/successfirst/', notificationController.successfirst);
router.get('/nodejsapp/api/successfirst/', notificationController.successfirst);
router.post('/nodejsapp/api/failure/', notificationController.failure);
router.post('/nodejsapp/api/seo_source/', notificationController.seosource);


//coupons
router.post('/nodejsapp/api/couponlist/', couponController.couponlist);
router.post('/nodejsapp/api/apply_coupon/', couponController.apply_coupon);

//checkout
router.post('/nodejsapp/api/checkout_subcribtionorder/', checkoutController.checkout_subcribtionorder)
router.post('/nodejsapp/api/checkout_quickorder/', checkoutController.checkout_quickorder)

//edit profile
router.post('/nodejsapp/api/edit_profile', userController.upload.single('image'), userController.uploadImage);

//city Listing API
//router.get('/nodejsapp/api/city/', userController.getCity);
//test email
router.get('/nodejsapp/api/sendemail/', userController.sendemail);
router.post('/nodejsapp/api/payment/', paymentController.payment);
router.post('/nodejsapp/api/subpayment/', paymentController.subpayment);

//Guest Controller
router.post('/nodejsapp/api/guestlogin/', guestController.guestlogin);

//Card Controller
router.post('/nodejsapp/api/savecard/', cardController.savecard);
router.post('/nodejsapp/api/savesuccess/', cardController.success);
router.get('/nodejsapp/api/savesuccess/', cardController.success);
router.post('/nodejsapp/api/savefailure/', cardController.failure);
router.post('/nodejsapp/api/deletecard/', cardController.deletecard);
//router.get('/nodejsapp/api/sendemail/', userController.sendemail);
router.get('/nodejsapp/api/sendnotification/', userController.sendemail);


//Notify Me Controller
router.post('/nodejsapp/api/shownotifyme/', notifymeController.shownotifyme);
router.post('/nodejsapp/api/addnotifyme/', notifymeController.addnotifyme);
router.post('/nodejsapp/api/deletenotifyme/', notifymeController.deletenotifyme);


//Trail Pack Controller
router.post('/nodejsapp/api/trailpacklist/', trailpackController.trailpacklist);
router.post('/nodejsapp/api/trailpackdetails/', trailpackController.trailpackdetails);


//rating controller
router.post('/nodejsapp/api/review_on_delivery/', ratingController.review_on_delivery);
router.post('/nodejsapp/api/add_product_rating/', ratingController.add_product_rating);
router.post('/nodejsapp/api/product_review_list/', ratingController.product_review_list);


module.exports = router;
